//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include "emule.h"
#include "SharedFilesCtrl.h"
#include "otherfunctions.h"
#include "CommentDialog.h"
#include "FileInfoDialog.h"
#include "MetaDataDlg.h"
#include "ResizableLib/ResizableSheet.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif



//////////////////////////////////////////////////////////////////////////////
// CSharedFileDetailsSheet

class CSharedFileDetailsSheet : public CResizableSheet
{
	DECLARE_DYNAMIC(CSharedFileDetailsSheet)

public:
	CSharedFileDetailsSheet(CKnownFile* file);
	virtual ~CSharedFileDetailsSheet();

protected:
	CKnownFile* m_file;
	CFileInfoDialog m_wndMediaInfo;
	CMetaDataDlg m_wndMetaData;

	static int sm_iLastActivePage;

	virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()
	afx_msg void OnDestroy();
};

int CSharedFileDetailsSheet::sm_iLastActivePage;

IMPLEMENT_DYNAMIC(CSharedFileDetailsSheet, CResizableSheet)

BEGIN_MESSAGE_MAP(CSharedFileDetailsSheet, CResizableSheet)
	ON_WM_DESTROY()
END_MESSAGE_MAP()

CSharedFileDetailsSheet::CSharedFileDetailsSheet(CKnownFile* file)
{
	m_file = file;
	m_psh.dwFlags &= ~PSH_HASHELP;
	m_psh.dwFlags |= PSH_NOAPPLYNOW;
	
	m_wndMediaInfo.m_psp.dwFlags &= ~PSP_HASHELP;
	m_wndMetaData.m_psp.dwFlags &= ~PSP_HASHELP;

	m_wndMediaInfo.SetMyfile(file);
	if (theApp.glob_prefs->IsExtControlsEnabled())
		m_wndMetaData.SetFile(file);

	AddPage(&m_wndMediaInfo);
	if (theApp.glob_prefs->IsExtControlsEnabled())
		AddPage(&m_wndMetaData);
}

CSharedFileDetailsSheet::~CSharedFileDetailsSheet()
{
}

void CSharedFileDetailsSheet::OnDestroy()
{
	sm_iLastActivePage = GetActiveIndex();
	CResizableSheet::OnDestroy();
}

BOOL CSharedFileDetailsSheet::OnInitDialog()
{		
	EnableStackedTabs(FALSE);
	BOOL bResult = CResizableSheet::OnInitDialog();
	InitWindowStyles(this);
	EnableSaveRestore(_T("SharedFileDetailsSheet")); // call this after(!) OnInitDialog
	SetWindowText(GetResString(IDS_DETAILS) + _T(": ") + m_file->GetFileName());
	if (sm_iLastActivePage < GetPageCount())
		SetActivePage(sm_iLastActivePage);
	return bResult;
}


//////////////////////////////////////////////////////////////////////////////
// CSharedFilesCtrl

IMPLEMENT_DYNAMIC(CSharedFilesCtrl, CMuleListCtrl)
CSharedFilesCtrl::CSharedFilesCtrl() {
   sflist = 0;                // i_a 
   memset(&sortstat, 0, sizeof(sortstat));  // i_a 
}

CSharedFilesCtrl::~CSharedFilesCtrl(){
}

void CSharedFilesCtrl::Init(){
	CImageList ilDummyImageList; //dummy list for getting the proper height of listview entries
	ilDummyImageList.Create(1, theApp.GetSmallSytemIconSize().cy,theApp.m_iDfltImageListColorFlags|ILC_MASK, 1, 1); 
	SetImageList(&ilDummyImageList, LVSIL_SMALL);
	ASSERT( (GetStyle() & LVS_SHAREIMAGELISTS) == 0 );
	ilDummyImageList.Detach();

	SetExtendedStyle(LVS_EX_FULLROWSELECT);
	ModifyStyle(LVS_SINGLESEL,0);
	InsertColumn(0, GetResString(IDS_DL_FILENAME) ,LVCFMT_LEFT,250,0);
	InsertColumn(1,GetResString(IDS_DL_SIZE),LVCFMT_LEFT,100,1);
	InsertColumn(2,GetResString(IDS_TYPE),LVCFMT_LEFT,50,2);
	InsertColumn(3,GetResString(IDS_PRIORITY),LVCFMT_LEFT,70,3);
	InsertColumn(4,GetResString(IDS_PERMISSION),LVCFMT_LEFT,100,4);
	InsertColumn(5,GetResString(IDS_FILEID),LVCFMT_LEFT,220,5);
	InsertColumn(6,GetResString(IDS_SF_REQUESTS),LVCFMT_LEFT,100,6);
	InsertColumn(7,GetResString(IDS_SF_ACCEPTS),LVCFMT_LEFT,100,7);
	InsertColumn(8,GetResString(IDS_SF_TRANSFERRED),LVCFMT_LEFT,120,8);
	InsertColumn(9,GetResString(IDS_UPSTATUS),LVCFMT_LEFT,100,9);
	InsertColumn(10,GetResString(IDS_FOLDER),LVCFMT_LEFT,200,10);
	InsertColumn(11,GetResString(IDS_COMPLSOURCES),LVCFMT_LEFT,100,11);

	CreateMenues();

	LoadSettings(CPreferences::tableShared);

	// Barry - Use preferred sort order from preferences
	int sortItem = theApp.glob_prefs->GetColumnSortItem(CPreferences::tableShared);
	bool sortAscending = theApp.glob_prefs->GetColumnSortAscending(CPreferences::tableShared);
	SetSortArrow(sortItem, sortAscending);
	SortItems(SortProc, sortItem + (sortAscending ? 0:20));
}

void CSharedFilesCtrl::Localize() {
	CHeaderCtrl* pHeaderCtrl = GetHeaderCtrl();
	HDITEM hdi;
	hdi.mask = HDI_TEXT;
	CString strRes;

	strRes = GetResString(IDS_DL_FILENAME);
	hdi.pszText = strRes.GetBuffer();
	pHeaderCtrl->SetItem(0, &hdi);
	strRes.ReleaseBuffer();

	strRes = GetResString(IDS_DL_SIZE);
	hdi.pszText = strRes.GetBuffer();
	pHeaderCtrl->SetItem(1, &hdi);
	strRes.ReleaseBuffer();

	strRes = GetResString(IDS_TYPE);
	hdi.pszText = strRes.GetBuffer();
	pHeaderCtrl->SetItem(2, &hdi);
	strRes.ReleaseBuffer();

	strRes = GetResString(IDS_PRIORITY);
	hdi.pszText = strRes.GetBuffer();
	pHeaderCtrl->SetItem(3, &hdi);
	strRes.ReleaseBuffer();

	strRes = GetResString(IDS_PERMISSION);
	hdi.pszText = strRes.GetBuffer();
	pHeaderCtrl->SetItem(4, &hdi);
	strRes.ReleaseBuffer();

	strRes = GetResString(IDS_FILEID);
	hdi.pszText = strRes.GetBuffer();
	pHeaderCtrl->SetItem(5, &hdi);
	strRes.ReleaseBuffer();

	strRes = GetResString(IDS_SF_REQUESTS);
	hdi.pszText = strRes.GetBuffer();
	pHeaderCtrl->SetItem(6, &hdi);
	strRes.ReleaseBuffer();

	strRes = GetResString(IDS_SF_ACCEPTS);
	hdi.pszText = strRes.GetBuffer();
	pHeaderCtrl->SetItem(7, &hdi);
	strRes.ReleaseBuffer();

	strRes = GetResString(IDS_SF_TRANSFERRED);
	hdi.pszText = strRes.GetBuffer();
	pHeaderCtrl->SetItem(8, &hdi);
	strRes.ReleaseBuffer();

	strRes = GetResString(IDS_UPSTATUS);
	hdi.pszText = strRes.GetBuffer();
	pHeaderCtrl->SetItem(9, &hdi);
	strRes.ReleaseBuffer();

	strRes = GetResString(IDS_FOLDER);
	hdi.pszText = strRes.GetBuffer();
	pHeaderCtrl->SetItem(10, &hdi);
	strRes.ReleaseBuffer();

	// #zegzav:completesrc
	strRes = GetResString(IDS_COMPLSOURCES);
	hdi.pszText = strRes.GetBuffer();
	pHeaderCtrl->SetItem(11, &hdi);
	strRes.ReleaseBuffer();
	// #zegzav:completesrc END

	CreateMenues();
}

void CSharedFilesCtrl::ShowFileList(CSharedFileList* in_sflist){
	DeleteAllItems();
	sflist = in_sflist;
	CCKey bufKey;
	CKnownFile* cur_file;
	for (POSITION pos = sflist->m_Files_map.GetStartPosition();pos != 0;){
		sflist->m_Files_map.GetNextAssoc(pos,bufKey,cur_file);
		ShowFile(cur_file);
	}
	ShowFilesCount();
}

#define DLC_DT_TEXT (DT_LEFT|DT_SINGLELINE|DT_VCENTER|DT_NOPREFIX|DT_END_ELLIPSIS)

void CSharedFilesCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct){
	if( !theApp.emuledlg->IsRunning() )
		return;
	if( !lpDrawItemStruct->itemData)
		return;
	CDC* odc = CDC::FromHandle(lpDrawItemStruct->hDC);
	BOOL bCtrlFocused = ((GetFocus() == this ) || (GetStyle() & LVS_SHOWSELALWAYS));
	if( odc && (lpDrawItemStruct->itemAction | ODA_SELECT) && (lpDrawItemStruct->itemState & ODS_SELECTED )){
		if(bCtrlFocused)
			odc->SetBkColor(m_crHighlight);
		else
			odc->SetBkColor(m_crNoHighlight);
	}
	else
		odc->SetBkColor(GetBkColor());

	CKnownFile* file = (CKnownFile*)lpDrawItemStruct->itemData;
	CMemDC dc(CDC::FromHandle(lpDrawItemStruct->hDC),&CRect(lpDrawItemStruct->rcItem));
	CFont* pOldFont = dc.SelectObject(GetFont());
	RECT cur_rec;
	memcpy(&cur_rec,&lpDrawItemStruct->rcItem,sizeof(RECT));
	COLORREF crOldTextColor = dc.SetTextColor(m_crWindowText);

	CString buffer;

	CHeaderCtrl *pHeaderCtrl = GetHeaderCtrl();
	int iCount = pHeaderCtrl->GetItemCount();
	const int iMarginX = 4;
	cur_rec.right = cur_rec.left - iMarginX*2;
	cur_rec.left += iMarginX;

	int iIconDrawWidth = theApp.GetSmallSytemIconSize().cx + 3;
	for(int iCurrent = 0; iCurrent < iCount; iCurrent++){
		int iColumn = pHeaderCtrl->OrderToIndex(iCurrent);
		if( !IsColumnHidden(iColumn) ){
			UINT uDTFlags = DLC_DT_TEXT;
			cur_rec.right += GetColumnWidth(iColumn);
			switch(iColumn){
				case 0:{
					int iImage = theApp.GetFileTypeSystemImageIdx(file->GetFileName());
					if (theApp.GetSystemImageList() != NULL)
						::ImageList_Draw(theApp.GetSystemImageList(), iImage, dc->GetSafeHdc(), cur_rec.left, cur_rec.top, ILD_NORMAL|ILD_TRANSPARENT);
					cur_rec.left += iIconDrawWidth;
					buffer = file->GetFileName();
					break;
				}
				case 1:
					buffer = CastItoXBytes(file->GetFileSize());
					uDTFlags |= DT_RIGHT;
					break;
				case 2:
					buffer = file->GetFileType();
					break;
				case 3:{
					switch (file->GetUpPriority()) {
						case PR_VERYLOW :
                            if( file->GetPowerShared() )
                                buffer = GetResString(IDS_POWERSHARE_PREFIX) + " " + GetResString(IDS_PRIOVERYLOW);
                            else
							    buffer = GetResString(IDS_PRIOVERYLOW);
							break;
						case PR_LOW :
							if( file->IsAutoUpPriority() )
								buffer = GetResString(IDS_PRIOAUTOLOW);
                            else if( file->GetPowerShared() )
                                buffer = GetResString(IDS_POWERSHARE_PREFIX) + " " + GetResString(IDS_PRIOLOW);
							else
								buffer = GetResString(IDS_PRIOLOW);
							break;
						case PR_NORMAL :
							if( file->IsAutoUpPriority() )
								buffer = GetResString(IDS_PRIOAUTONORMAL);
                            else if( file->GetPowerShared() )
                                buffer = GetResString(IDS_POWERSHARE_PREFIX) + " " + GetResString(IDS_PRIONORMAL);
							else
								buffer = GetResString(IDS_PRIONORMAL);
							break;
						case PR_HIGH :
							if( file->IsAutoUpPriority() )
								buffer = GetResString(IDS_PRIOAUTOHIGH);
                            else if( file->GetPowerShared() )
                                buffer = GetResString(IDS_POWERSHARE_PREFIX) + " " + GetResString(IDS_PRIOHIGH);
							else
								buffer = GetResString(IDS_PRIOHIGH);
							break;
						case PR_VERYHIGH :
                            if( file->GetPowerShared() )
                                buffer = GetResString(IDS_POWERSHARE_PREFIX) + " " + GetResString(IDS_PRIORELEASE);
                            else
							    buffer = GetResString(IDS_PRIORELEASE);
							break;
						default:
							buffer.Empty();
					}
					break;
				}
				case 4:
					buffer = GetResString(IDS_FSTATUS_PUBLIC);
					break;
				case 5:
					buffer = md4str(file->GetFileHash());
					break;
				case 6:
                    buffer.Format("%u (%u)",file->statistic.GetRequests(),file->statistic.GetAllTimeRequests());
					break;
				case 7:
                    buffer.Format("%u (%u)",file->statistic.GetAccepts(),file->statistic.GetAllTimeAccepts());
					break;
				case 8:
					buffer.Format("%s (%s)",CastItoXBytes(file->statistic.GetTransferred()), CastItoXBytes(file->statistic.GetAllTimeTransferred()));
					break;
				case 9:
					if( file->GetPartCount()){
						cur_rec.bottom--;
						cur_rec.top++;
						if(!file->IsPartFile())
							file->DrawShareStatusBar(dc,&cur_rec,false,theApp.glob_prefs->UseFlatBar());
						else
							((CPartFile*)file)->DrawShareStatusBar(dc,&cur_rec,false,theApp.glob_prefs->UseFlatBar());
						cur_rec.bottom++;
						cur_rec.top--;
					}
					break;
				case 10:
					buffer = file->GetPath();
					PathRemoveBackslash(buffer.GetBuffer());
					buffer.ReleaseBuffer();
					break;
				case 11:
				{
					if (file->m_nCompleteSourcesCountLo == 0)
					{
						if (file->m_nCompleteSourcesCountHi == 0)
						{
							buffer= "?";
						}
						else
						{
							buffer.Format("< %u", file->m_nCompleteSourcesCountHi);
						}
					}
					else if (file->m_nCompleteSourcesCountLo == file->m_nCompleteSourcesCountHi)
					{
						buffer.Format("%u", file->m_nCompleteSourcesCountLo);
					}
					else
					{
						buffer.Format("%u - %u", file->m_nCompleteSourcesCountLo, file->m_nCompleteSourcesCountHi);
					}
					break;
				}
			}

			if( iColumn != 9 )
				dc->DrawText(buffer, buffer.GetLength(),&cur_rec,uDTFlags);
			if( iColumn == 0 )
				cur_rec.left -= iIconDrawWidth;
			cur_rec.left += GetColumnWidth(iColumn);
		}
	}
	ShowFilesCount();
	if ((lpDrawItemStruct->itemAction | ODA_SELECT) && (lpDrawItemStruct->itemState & ODS_SELECTED))
	{
		RECT outline_rec;
		memcpy(&outline_rec,&lpDrawItemStruct->rcItem,sizeof(RECT));

		outline_rec.top--;
		outline_rec.bottom++;
		dc->FrameRect(&outline_rec, &CBrush(GetBkColor()));
		outline_rec.top++;
		outline_rec.bottom--;
		outline_rec.left++;
		outline_rec.right--;

		if(bCtrlFocused)
			dc->FrameRect(&outline_rec, &CBrush(m_crFocusLine));
		else
			dc->FrameRect(&outline_rec, &CBrush(m_crNoFocusLine));
	}
	dc.SelectObject(pOldFont);
	dc.SetTextColor(crOldTextColor);
}

void CSharedFilesCtrl::ShowFile(CKnownFile* file){
	uint32 itemnr = GetItemCount();
	itemnr = InsertItem(LVIF_TEXT|LVIF_PARAM,itemnr,LPSTR_TEXTCALLBACK,0,0,0,(LPARAM)file);
	UpdateFile(file);
}

void CSharedFilesCtrl::RemoveFile(CKnownFile *toRemove) {
	LVFINDINFO info;
	info.flags = LVFI_PARAM;
	info.lParam = (LPARAM)toRemove;
	int nItem = FindItem(&info);
	if(nItem != -1)
		DeleteItem(nItem);
	ShowFilesCount();
}

BEGIN_MESSAGE_MAP(CSharedFilesCtrl, CMuleListCtrl)
	ON_WM_CONTEXTMENU()
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnClick)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnNMDblclk)
	ON_NOTIFY_REFLECT(LVN_GETDISPINFO, OnGetDispInfo)
END_MESSAGE_MAP()



// CSharedFilesCtrl message handlers
void CSharedFilesCtrl::OnContextMenu(CWnd* pWnd, CPoint point)
{
	m_PrioMenu.EnableMenuItem(MP_PRIOAUTO, MF_ENABLED);
	// itsonlyme: hostnameSource
	if (!CString(theApp.glob_prefs->GetYourHostname()).IsEmpty() &&
		CString(theApp.glob_prefs->GetYourHostname()).Find(".") != -1)
		m_SharedFilesMenu.EnableMenuItem(MP_GETHOSTNAMESOURCEED2KLINK, MF_ENABLED);
	else
		m_SharedFilesMenu.EnableMenuItem(MP_GETHOSTNAMESOURCEED2KLINK, MF_GRAYED);
	// itsonlyme: hostnameSource
	int counter;
	CMenu m_Web;
	m_Web.CreateMenu();
	UpdateURLMenu(m_Web,counter);
	UINT flag2;
	flag2=(counter==0) ? MF_GRAYED:MF_STRING;
	m_SharedFilesMenu.AppendMenu(flag2|MF_POPUP,(UINT_PTR)m_Web.m_hMenu, GetResString(IDS_WEBSERVICES) );

	CKnownFile* file = NULL;
	if (GetSelectionMark()!=-1) file=(CKnownFile*)GetItemData(GetSelectionMark());
	m_SharedFilesMenu.EnableMenuItem(MP_OPEN, (file!=NULL && !file->IsPartFile())?MF_ENABLED:MF_GRAYED);

	m_SharedFilesMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON,point.x,point.y,this);

	m_SharedFilesMenu.RemoveMenu(m_SharedFilesMenu.GetMenuItemCount()-1,MF_BYPOSITION);
	VERIFY( m_Web.DestroyMenu() );

}

BOOL CSharedFilesCtrl::OnCommand(WPARAM wParam, LPARAM lParam)
{
	UINT selectedCount = this->GetSelectedCount(); 
	int iSel = GetSelectionMark();

	if (selectedCount>0){
		CKnownFile* file = (CKnownFile*)GetItemData(iSel);
		if (wParam>=MP_WEBURL && wParam<=MP_WEBURL+256) {
			RunURL(file, theApp.webservices.GetAt(wParam-MP_WEBURL) );
		}

		switch (wParam){
			case Irc_SetSendLink:
			{
				theApp.emuledlg->ircwnd.SetSendFileString(theApp.CreateED2kLink(file));
				break;
			}
			case MP_GETED2KLINK:{
				if(selectedCount > 1)
				{
					CString str;
					POSITION pos = this->GetFirstSelectedItemPosition();
					while( pos != NULL )
					{
						file = (CKnownFile*)this->GetItemData(GetNextSelectedItem(pos));
						str.Append(theApp.CreateED2kLink(file) + "\n");
					}

					theApp.CopyTextToClipboard(str);
					//AfxMessageBox(GetResString(IDS_COPIED2CB) + str);
					break; 
				}
				theApp.CopyTextToClipboard(theApp.CreateED2kLink(file));
				break;
			}
			case MP_GETHTMLED2KLINK:
				if(selectedCount > 1)
				{
					CString str;
					POSITION pos = this->GetFirstSelectedItemPosition();
					while( pos != NULL )
					{
						file = (CKnownFile*)this->GetItemData(GetNextSelectedItem(pos));
						str += theApp.CreateHTMLED2kLink(file) + "\n"; 
					}
					theApp.CopyTextToClipboard(str);
					//AfxMessageBox(GetResString(IDS_COPIED2CB) + str);
					break; 
				} 
				theApp.CopyTextToClipboard(theApp.CreateHTMLED2kLink(file));
				break;
			case MP_GETSOURCEED2KLINK:
			{
				if(selectedCount > 1)
				{
					CString str;
					POSITION pos = this->GetFirstSelectedItemPosition();
					while( pos != NULL )
					{
						file = (CKnownFile*)this->GetItemData(GetNextSelectedItem(pos));
						str += theApp.CreateED2kSourceLink(file) + "\n"; 
					}
					theApp.CopyTextToClipboard(str);
					//AfxMessageBox(GetResString(IDS_COPIED2CB) + str);
					break; 
				} 
				CString strLink = theApp.CreateED2kSourceLink(file);
				if (!strLink.IsEmpty())
					theApp.CopyTextToClipboard(strLink);
				break;
			}
			// itsonlyme: hostnameSource
			case MP_GETHOSTNAMESOURCEED2KLINK:
			{
				if(selectedCount > 1)
				{
					CString str;
					POSITION pos = this->GetFirstSelectedItemPosition();
					while( pos != NULL )
					{
						file = (CKnownFile*)this->GetItemData(GetNextSelectedItem(pos));
						str += theApp.CreateED2kHostnameSourceLink(file) + "\n"; 
					}
					theApp.CopyTextToClipboard(str);
					//AfxMessageBox(GetResString(IDS_COPIED2CB) + str);
					break; 
				} 
				CString strLink = theApp.CreateED2kHostnameSourceLink(file);
				if (!strLink.IsEmpty())
					theApp.CopyTextToClipboard(strLink);
				break;
			}
			// itsonlyme: hostnameSource
			case MP_OPEN:
				OpenFile(file);
				break; 
			//For Comments 
			case MP_CMT: 
            { 
				ShowComments(iSel);
                break; 
            } 
            //*END Comments*//
			case MPG_ALTENTER:
			case MP_DETAIL:
				if (file){
					CSharedFileDetailsSheet sheet(file);
					sheet.DoModal();
				}
				break;

			case MP_PRIOVERYLOW:
			case MP_PRIOLOW:
			case MP_PRIONORMAL:
			case MP_PRIOHIGH:
			case MP_PRIOVERYHIGH:
            case MP_PRIO_POWERSHARE_VERYLOW:
			case MP_PRIO_POWERSHARE_LOW:
			case MP_PRIO_POWERSHARE_NORMAL:
			case MP_PRIO_POWERSHARE_HIGH:
			case MP_PRIO_POWERSHARE_VERYHIGH:
			case MP_PRIOAUTO:
				{
					POSITION pos = this->GetFirstSelectedItemPosition();
					while( pos != NULL )
					{
						int iSel=this->GetNextSelectedItem(pos);
						file = (CKnownFile*)this->GetItemData(iSel);
						switch (wParam) {
							case MP_PRIOVERYLOW:
								{	file->SetAutoUpPriority(false);file->SetPowerShared(false);file->SetUpPriority(PR_VERYLOW);SetItemText(iSel,3,GetResString(IDS_PRIOVERYLOW ));break;	}
							case MP_PRIOLOW:
								{	file->SetAutoUpPriority(false);file->SetPowerShared(false);file->SetUpPriority(PR_LOW);SetItemText(iSel,3,GetResString(IDS_PRIOLOW ));break;	}
							case MP_PRIONORMAL:
								{	file->SetAutoUpPriority(false);file->SetPowerShared(false);file->SetUpPriority(PR_NORMAL);SetItemText(iSel,3,GetResString(IDS_PRIONORMAL ));break;	}
							case MP_PRIOHIGH:
								{	file->SetAutoUpPriority(false);file->SetPowerShared(false);file->SetUpPriority(PR_HIGH);SetItemText(iSel,3,GetResString(IDS_PRIOHIGH ));break;	}
							case MP_PRIOVERYHIGH:
								{	file->SetAutoUpPriority(false);file->SetPowerShared(false);file->SetUpPriority(PR_VERYHIGH);SetItemText(iSel,3,GetResString(IDS_PRIORELEASE ));break;	}//Hunter

							case MP_PRIO_POWERSHARE_VERYLOW:
								{	file->SetAutoUpPriority(false);file->SetPowerShared(true);file->SetUpPriority(PR_VERYLOW);SetItemText(iSel,3,GetResString(IDS_POWERSHARE_PREFIX) + " " + GetResString(IDS_PRIOVERYLOW ));break;	}
							case MP_PRIO_POWERSHARE_LOW:
								{	file->SetAutoUpPriority(false);file->SetPowerShared(true);file->SetUpPriority(PR_LOW);SetItemText(iSel,3,GetResString(IDS_POWERSHARE_PREFIX) + " " + GetResString(IDS_PRIOLOW ));break;	}
							case MP_PRIO_POWERSHARE_NORMAL:
								{	file->SetAutoUpPriority(false);file->SetPowerShared(true);file->SetUpPriority(PR_NORMAL);SetItemText(iSel,3,GetResString(IDS_POWERSHARE_PREFIX) + " " + GetResString(IDS_PRIONORMAL ));break;	}
							case MP_PRIO_POWERSHARE_HIGH:
								{	file->SetAutoUpPriority(false);file->SetPowerShared(true);file->SetUpPriority(PR_HIGH);SetItemText(iSel,3,GetResString(IDS_POWERSHARE_PREFIX) + " " + GetResString(IDS_PRIOHIGH ));break;	}
							case MP_PRIO_POWERSHARE_VERYHIGH:
								{	file->SetAutoUpPriority(false);file->SetPowerShared(true);file->SetUpPriority(PR_VERYHIGH);SetItemText(iSel,3,GetResString(IDS_POWERSHARE_PREFIX) + " " + GetResString(IDS_PRIORELEASE ));break;	}//Hunter
                            
                            case MP_PRIOAUTO:
								{	file->SetAutoUpPriority(true);file->SetPowerShared(false);file->UpdateAutoUpPriority();UpdateFile(file); break;	}//Hunter
						}
					}
					break;
				}
     //       case MP_POWERSHARE_ON:
     //       case MP_POWERSHARE_OFF:
     //           {
					//POSITION pos = this->GetFirstSelectedItemPosition();
					//while( pos != NULL )
					//{
					//	int iSel=this->GetNextSelectedItem(pos);
					//	file = (CKnownFile*)this->GetItemData(iSel);
					//	switch (wParam) {
					//		case MP_POWERSHARE_ON:
					//			{	file->SetPowerShared(true);/*SetItemText(iSel,11,GetResString(IDS_POWERSHARE_ON_LABEL ))*/;break;	}
					//		case MP_POWERSHARE_OFF:
					//			{	file->SetPowerShared(false);/*SetItemText(iSel,11,GetResString(IDS_POWERSHARE_OFF_LABEL ))*/;break;	}
					//	}
					//}
     //               break;
     //           }
			case MP_PERMNONE:
				{
				POSITION pos = this->GetFirstSelectedItemPosition();
				while( pos != NULL ) {
					int iSel=this->GetNextSelectedItem(pos);
					file = (CKnownFile*)this->GetItemData(iSel);

					if (((CPartFile*)file)->IsPartFile())
						AddLogLine(true,GetResString(IDS_ERR_NOPRIMCHANGE));
					else
					{	
						file->SetPermissions(PERM_NOONE);
						SetItemText(iSel,4,GetResString(IDS_HIDDEN));
					}
				}
				break;
				}
			case MP_PERMFRIENDS:
				{
					POSITION pos = this->GetFirstSelectedItemPosition();
					while( pos != NULL ) {
						int iSel=this->GetNextSelectedItem(pos);
						file = (CKnownFile*)this->GetItemData(iSel);

						if (((CPartFile*)file)->IsPartFile())
							AddLogLine(true,GetResString(IDS_ERR_NOPRIMCHANGE));
						else
						{	
							file->SetPermissions(PERM_FRIENDS);
							SetItemText(iSel,4,GetResString(IDS_FSTATUS_FRIENDSONLY ));	
						}
					}
					break;
				}
			case MP_PERMALL:
				POSITION pos = this->GetFirstSelectedItemPosition();
				while( pos != NULL ) {
					int iSel=this->GetNextSelectedItem(pos);
					file = (CKnownFile*)this->GetItemData(iSel);				
					file->SetPermissions(PERM_ALL);SetItemText(iSel,4,GetResString(IDS_FSTATUS_PUBLIC));
				}
				break;
		}
	}
	return true;
}


void CSharedFilesCtrl::OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult){
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	// Barry - Store sort order in preferences
	// Determine ascending based on whether already sorted on this column
	int sortItem = theApp.glob_prefs->GetColumnSortItem(CPreferences::tableShared);
	bool m_oldSortAscending = theApp.glob_prefs->GetColumnSortAscending(CPreferences::tableShared);
	bool sortAscending = (sortItem != pNMListView->iSubItem) ? true : !m_oldSortAscending;

	// Item is column clicked
	sortItem = pNMListView->iSubItem;

	// Save new preferences
	theApp.glob_prefs->SetColumnSortItem(CPreferences::tableShared, sortItem);
	theApp.glob_prefs->SetColumnSortAscending(CPreferences::tableShared, sortAscending);

	// Ornis 4-way-sorting
	int adder=0;
	if (pNMListView->iSubItem>5 && pNMListView->iSubItem<9) {
		if (!sortAscending) sortstat[pNMListView->iSubItem-6]=!sortstat[pNMListView->iSubItem-6];
		adder=sortstat[pNMListView->iSubItem-6] ? 0:100;
	}

	// Sort table
	if (adder==0)	
		SetSortArrow(sortItem, sortAscending); 
	else
		SetSortArrow(sortItem, sortAscending ? arrowDoubleUp : arrowDoubleDown);
	SortItems(SortProc, sortItem + adder + (sortAscending ? 0:20));

	*pResult = 0;
}

int CSharedFilesCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort){
	CKnownFile* item1 = (CKnownFile*)lParam1;
	CKnownFile* item2 = (CKnownFile*)lParam2;	
	switch(lParamSort){
		case 0: //filename asc
			return _tcsicmp(item1->GetFileName(),item2->GetFileName());
		case 20: //filename desc
			return _tcsicmp(item2->GetFileName(),item1->GetFileName());

		case 1: //filesize asc
			return item1->GetFileSize()==item2->GetFileSize()?0:(item1->GetFileSize()>item2->GetFileSize()?1:-1);

		case 21: //filesize desc
			return item1->GetFileSize()==item2->GetFileSize()?0:(item2->GetFileSize()>item1->GetFileSize()?1:-1);


		case 2: //filetype asc
			return item1->GetFileType().CompareNoCase(item2->GetFileType());
		case 22: //filetype desc
			return item2->GetFileType().CompareNoCase(item1->GetFileType());

		case 3: //prio asc
		case 23: //prio desc
            {
                int result = 0;

                if(item1->GetPowerShared() == item2->GetPowerShared()) {
                    int file1prio = item1->GetUpPriority();
                    if(file1prio == PR_VERYLOW) {
                        file1prio = -1;
                    }

                    int file2prio = item2->GetUpPriority();
                    if(file2prio == PR_VERYLOW) {
                        file2prio = -1;
                    }

			        result =  file1prio-file2prio;
                } else if(item1->GetPowerShared()) {
                    // item1 is larger
                    result = 1;
                } else {
                    // item2 is larger
                    result = -1;
                }

                switch(lParamSort) {
                    case 3: return result; break;
                    case 23: return -result; break;
                }
            }

		case 4: //permission asc
			return item2->GetPermissions()-item1->GetPermissions();
		case 24: //permission desc
			return item1->GetPermissions()-item2->GetPermissions();

		case 5: //fileID asc
			return memcmp(item1->GetFileHash(), item2->GetFileHash(), 16);
		case 25: //fileID desc
			return memcmp(item2->GetFileHash(), item1->GetFileHash(), 16);

		case 6: //requests asc
			return item1->statistic.GetRequests() - item2->statistic.GetRequests();
		case 26: //requests desc
			return item2->statistic.GetRequests() - item1->statistic.GetRequests();
		case 7: //acc requests asc
			return item1->statistic.GetAccepts() - item2->statistic.GetAccepts();
		case 27: //acc requests desc
			return item2->statistic.GetAccepts() - item1->statistic.GetAccepts();
		case 8: //all transferred asc
			return item1->statistic.GetTransferred()==item2->statistic.GetTransferred()?0:(item1->statistic.GetTransferred()>item2->statistic.GetTransferred()?1:-1);
		case 28: //all transferred desc
			return item1->statistic.GetTransferred()==item2->statistic.GetTransferred()?0:(item2->statistic.GetTransferred()>item1->statistic.GetTransferred()?1:-1);

		case 10: //folder asc
			return _tcsicmp(item1->GetPath(),item2->GetPath());
		case 30: //folder desc
			return _tcsicmp(item2->GetPath(),item1->GetPath());

		// #zegzav:completesrc
		case 11: //complete sources asc
			return CompareUnsigned(item1->m_nCompleteSourcesCount, item2->m_nCompleteSourcesCount);
		case 31: //complete sources desc
			return CompareUnsigned(item2->m_nCompleteSourcesCount, item1->m_nCompleteSourcesCount);
		// #zegzav:completesrc END

		case 106: //all requests asc
			return item1->statistic.GetAllTimeRequests() - item2->statistic.GetAllTimeRequests();
		case 126: //all requests desc
			return item2->statistic.GetAllTimeRequests() - item1->statistic.GetAllTimeRequests();
		case 107: //all acc requests asc
			return item1->statistic.GetAllTimeAccepts() - item2->statistic.GetAllTimeAccepts();
		case 127: //all acc requests desc
			return item2->statistic.GetAllTimeAccepts() - item1->statistic.GetAllTimeAccepts();
		case 108: //all transferred asc
			return item1->statistic.GetAllTimeTransferred()==item2->statistic.GetAllTimeTransferred()?0:(item1->statistic.GetAllTimeTransferred()>item2->statistic.GetAllTimeTransferred()?1:-1);
		case 128: //all transferred desc
			return item1->statistic.GetAllTimeTransferred()==item2->statistic.GetAllTimeTransferred()?0:(item2->statistic.GetAllTimeTransferred()>item1->statistic.GetAllTimeTransferred()?1:-1);

		default: 
			return 0;
	}
}

void CSharedFilesCtrl::UpdateFile(CKnownFile* toupdate){
	if( !theApp.emuledlg->IsRunning())
		return;
	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)toupdate;
	sint16 result = FindItem(&find);
	if (result != -1) {
		Update(result) ;   // Added by Tarod to real time refresh - DonGato - 11/11/2002
		theApp.emuledlg->sharedfileswnd.Check4StatUpdate(toupdate);
	}
}

void CSharedFilesCtrl::ShowFilesCount() {
	CString counter;
	// SLUGFILLER: SafeHash - hashing counter
	if (theApp.sharedfiles->GetHashingCount())
		counter.Format(_T(" (%i, hashing %i)"), theApp.sharedfiles->GetCount(), theApp.sharedfiles->GetHashingCount());
	else
		counter.Format(_T(" (%i)"), theApp.sharedfiles->GetCount());
	// SLUGFILLER: SafeHash
	theApp.emuledlg->sharedfileswnd.GetDlgItem(IDC_TRAFFIC_TEXT)->SetWindowText(GetResString(IDS_SF_FILES)+counter  );
}

void CSharedFilesCtrl::OpenFile(CKnownFile* file){
	char* buffer = new char[MAX_PATH];
	_snprintf(buffer,MAX_PATH,"%s\\%s",file->GetPath(),file->GetFileName());
	AddLogLine( false, "%s\\%s",file->GetPath(),file->GetFileName());
	ShellOpenFile(buffer, NULL);
	delete[] buffer;
}

void CSharedFilesCtrl::OnNMDblclk(NMHDR *pNMHDR, LRESULT *pResult)
{
	int iSel = GetSelectionMark();
	if (iSel != -1) {
		CKnownFile* file = (CKnownFile*)GetItemData(iSel);
		if (file){
			if (GetKeyState(VK_MENU) & 0x8000){
				CSharedFileDetailsSheet sheet(file);
				sheet.DoModal();
			}
			else
				OpenFile(file);
		}
	}
	*pResult = 0;
}

void CSharedFilesCtrl::CreateMenues() {
	
    //if (m_PowershareMenu) VERIFY( m_PowershareMenu.DestroyMenu() );
	if (m_PrioMenu) VERIFY( m_PrioMenu.DestroyMenu() );
	if (m_PermMenu) VERIFY( m_PermMenu.DestroyMenu() );
	if (m_SharedFilesMenu) VERIFY( m_SharedFilesMenu.DestroyMenu() );

 //   // add powershare switcher
 //   m_PowershareMenu.CreateMenu();
	//m_PowershareMenu.AppendMenu(MF_STRING,MP_POWERSHARE_ON,GetResString(IDS_POWERSHARE_ON));
	//m_PowershareMenu.AppendMenu(MF_STRING,MP_POWERSHARE_OFF,GetResString(IDS_POWERSHARE_OFF));

	// add priority switcher
	m_PrioMenu.CreateMenu();
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIOVERYLOW,GetResString(IDS_PRIOVERYLOW));
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIOLOW,GetResString(IDS_PRIOLOW));
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIONORMAL,GetResString(IDS_PRIONORMAL));
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIOHIGH, GetResString(IDS_PRIOHIGH));
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIOVERYHIGH, GetResString(IDS_PRIORELEASE));

    m_PrioMenu.AppendMenu(MF_STRING,MP_PRIO_POWERSHARE_VERYLOW,GetResString(IDS_POWERSHARE) + " " + GetResString(IDS_PRIOVERYLOW));
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIO_POWERSHARE_LOW,GetResString(IDS_POWERSHARE) + " " + GetResString(IDS_PRIOLOW));
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIO_POWERSHARE_NORMAL,GetResString(IDS_POWERSHARE) + " " + GetResString(IDS_PRIONORMAL));
	m_PrioMenu.AppendMenu(MF_STRING,MP_PRIO_POWERSHARE_HIGH, GetResString(IDS_POWERSHARE) + " " + GetResString(IDS_PRIOHIGH));
    m_PrioMenu.AppendMenu(MF_STRING,MP_PRIO_POWERSHARE_VERYHIGH, GetResString(IDS_POWERSHARE) + " " + GetResString(IDS_PRIORELEASE));

    m_PrioMenu.AppendMenu(MF_STRING,MP_PRIOAUTO, GetResString(IDS_PRIOAUTO));//UAP

	// add permission switcher
	m_PermMenu.CreateMenu();
	m_PermMenu.AppendMenu(MF_STRING,MP_PERMNONE,	GetResString(IDS_FSTATUS_LOCKED));
	m_PermMenu.AppendMenu(MF_STRING,MP_PERMFRIENDS,	GetResString(IDS_FSTATUS_FRIENDSONLY));
	m_PermMenu.AppendMenu(MF_STRING,MP_PERMALL,		GetResString(IDS_FSTATUS_PUBLIC));

	m_SharedFilesMenu.CreatePopupMenu();
	m_SharedFilesMenu.AddMenuTitle(GetResString(IDS_SHAREDFILES));
	// todo enable when it works
	//m_SharedFilesMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_PermMenu.m_hMenu, GetResString(IDS_PERMISSION));
    //m_SharedFilesMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_PowershareMenu.m_hMenu, GetResString(IDS_POWERSHARE));
	m_SharedFilesMenu.AppendMenu(MF_STRING|MF_POPUP,(UINT_PTR)m_PrioMenu.m_hMenu, GetResString(IDS_PRIORITY) );
	m_SharedFilesMenu.AppendMenu(MF_STRING|MF_SEPARATOR);
	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_OPEN, GetResString(IDS_OPENFILE));
	
	//***Comments 11/27/03**// 
	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_CMT, GetResString(IDS_CMT_ADD)); 
	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_DETAIL, GetResString(IDS_SHOWDETAILS));
	m_SharedFilesMenu.AppendMenu(MF_STRING|MF_SEPARATOR); 
	//****end  comments***//

	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_GETED2KLINK, GetResString(IDS_DL_LINK1));
	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_GETHTMLED2KLINK, GetResString(IDS_DL_LINK2));
	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_GETSOURCEED2KLINK, GetResString(IDS_CREATESOURCELINK));
	m_SharedFilesMenu.AppendMenu(MF_STRING,MP_GETHOSTNAMESOURCEED2KLINK, GetResString(IDS_CREATEHOSTNAMESRCLINK));	// itsonlyme: hostnameSource
	m_SharedFilesMenu.AppendMenu(MF_STRING|MF_SEPARATOR); 
	
	//This menu option is is for testing..
	if(theApp.emuledlg->ircwnd.IsConnected()){
		m_SharedFilesMenu.AppendMenu(MF_STRING,Irc_SetSendLink,GetResString(IDS_IRC_ADDLINKTOIRC));
		m_SharedFilesMenu.AppendMenu(MF_STRING|MF_SEPARATOR); 
	}
}

void CSharedFilesCtrl::ShowComments(int index) {
	CKnownFile* file = (CKnownFile*)GetItemData(index);
    CCommentDialog dialog(file); 
    dialog.DoModal(); 
}

void CSharedFilesCtrl::OnGetDispInfo(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVDISPINFO *pDispInfo = reinterpret_cast<NMLVDISPINFO*>(pNMHDR);

	if (theApp.emuledlg->IsRunning()){
		// Although we have an owner drawn listview control we store the text for the primary item in the listview, to be
		// capable of quick searching those items via the keyboard. Because our listview items may change their contents,
		// we do this via a text callback function. The listview control will send us the LVN_DISPINFO notification if
		// it needs to know the contents of the primary item.
		//
		// But, the listview control sends this notification all the time, even if we do not search for an item. At least
		// this notification is only sent for the visible items and not for all items in the list. Though, because this
		// function is invoked *very* often, no *NOT* put any time consuming code here in.

		if (pDispInfo->item.mask & LVIF_TEXT){
			const CKnownFile* pFile = reinterpret_cast<CKnownFile*>(pDispInfo->item.lParam);
			if (pFile != NULL){
				switch (pDispInfo->item.iSubItem){
					case 0:
						if (pDispInfo->item.cchTextMax > 0){
							_tcsncpy(pDispInfo->item.pszText, pFile->GetFileName(), pDispInfo->item.cchTextMax);
							pDispInfo->item.pszText[pDispInfo->item.cchTextMax-1] = _T('\0');
						}
						break;
					default:
						// shouldn't happen
						pDispInfo->item.pszText[0] = _T('\0');
						break;
				}
			}
		}
	}
	*pResult = 0;
}