// PPgDirectories.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "PPgDirectories.h"
#include "otherfunctions.h"
#include "InputBox.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


// CPPgDirectories dialog

IMPLEMENT_DYNAMIC(CPPgDirectories, CPropertyPage)
CPPgDirectories::CPPgDirectories()
	: CPropertyPage(CPPgDirectories::IDD)
{
	
}

CPPgDirectories::~CPPgDirectories()
{
}

void CPPgDirectories::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SHARESELECTOR, m_ShareSelector);
}


BEGIN_MESSAGE_MAP(CPPgDirectories, CPropertyPage)
	ON_BN_CLICKED(IDC_SELTEMPDIR, OnBnClickedSeltempdir)
	ON_BN_CLICKED(IDC_SELINCDIR,OnBnClickedSelincdir)
	ON_EN_CHANGE(IDC_INCFILES,	OnSettingsChange)
	ON_EN_CHANGE(IDC_TEMPFILES, OnSettingsChange)
	ON_BN_CLICKED(IDC_UNCADD,	OnBnClickedAddUNC)
	ON_BN_CLICKED(IDC_UNCREM,	OnBnClickedRemUNC)
END_MESSAGE_MAP()


// CPPgDirectories message handlers

BOOL CPPgDirectories::OnInitDialog()
{
	CWaitCursor curWait; // initialization of that dialog may take a while..
	CPropertyPage::OnInitDialog();
	InitWindowStyles(this);
	m_ShareSelector.Init();	

	((CEdit*)GetDlgItem(IDC_INCFILES))->SetLimitText(509);
	((CEdit*)GetDlgItem(IDC_TEMPFILES))->SetLimitText(509);
	m_uncfolders=(CListCtrl*)GetDlgItem(IDC_UNCLIST);
	m_uncfolders->InsertColumn(0, GetResString(IDS_UNCFOLDERS), LVCFMT_LEFT, 280, -1); 

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgDirectories::LoadSettings(void)
{
	GetDlgItem(IDC_INCFILES)->SetWindowText(app_prefs->prefs->incomingdir);
	GetDlgItem(IDC_TEMPFILES)->SetWindowText(app_prefs->prefs->tempdir);
	m_ShareSelector.SetSharedDirectories(&app_prefs->shareddir_list);
	FillUncList();
}

void CPPgDirectories::OnBnClickedSelincdir()
{
	TCHAR buffer[MAX_PATH] = {0};
	GetDlgItemText(IDC_INCFILES, buffer, ARRSIZE(buffer));
	if(SelectDir(GetSafeHwnd(),buffer,GetResString(IDS_SELECT_INCOMINGDIR)))
		GetDlgItem(IDC_INCFILES)->SetWindowText(buffer);
}

void CPPgDirectories::OnBnClickedSeltempdir()
{
	TCHAR buffer[MAX_PATH] = {0};
	GetDlgItemText(IDC_TEMPFILES, buffer, ARRSIZE(buffer));
	if(SelectDir(GetSafeHwnd(),buffer,GetResString(IDS_SELECT_TEMPDIR)))
		GetDlgItem(IDC_TEMPFILES)->SetWindowText(buffer);
}

BOOL CPPgDirectories::OnApply()
{
	CString testdirchanged=app_prefs->GetTempDir();

	CString strIncomingDir;
	GetDlgItemText(IDC_INCFILES, strIncomingDir);
	if (app_prefs->IsInstallationDirectory(strIncomingDir)){
		AfxMessageBox(GetResString(IDS_WRN_INCFILE_RESERVED));
		return FALSE;
	}
	
	CString strTempDir;
	GetDlgItemText(IDC_TEMPFILES, strTempDir);
	if (app_prefs->IsInstallationDirectory(strTempDir)){
		AfxMessageBox(GetResString(IDS_WRN_TEMPFILES_RESERVED));
		return FALSE;
	}

	if (CompareDirectories(strIncomingDir, strTempDir)==0){
		AfxMessageBox(GetResString(IDS_WRN_INCTEMP_SAME));
		return FALSE;
	}

	_sntprintf(app_prefs->prefs->incomingdir, ARRSIZE(app_prefs->prefs->incomingdir), _T("%s"), strIncomingDir);
	MakeFoldername(app_prefs->prefs->incomingdir);
	sprintf(app_prefs->GetCategory(0)->incomingpath,"%s",app_prefs->prefs->incomingdir);

	_sntprintf(app_prefs->prefs->tempdir, ARRSIZE(app_prefs->prefs->tempdir), _T("%s"), strTempDir);
	MakeFoldername(app_prefs->prefs->tempdir);

	app_prefs->shareddir_list.RemoveAll();

	m_ShareSelector.GetSharedDirectories(&app_prefs->shareddir_list);
	for (int i=0;i<m_uncfolders->GetItemCount();++i){
		CString unc;
		unc=m_uncfolders->GetItemText(i,0);
		app_prefs->shareddir_list.AddTail(unc);
	}

	// check shared directories for reserved folder names
	POSITION pos = app_prefs->shareddir_list.GetHeadPosition();
	while (pos){
		POSITION posLast = pos;
		const CString& rstrDir = app_prefs->shareddir_list.GetNext(pos);
		if (app_prefs->IsInstallationDirectory(rstrDir))
			app_prefs->shareddir_list.RemoveAt(posLast);
	}

	theApp.sharedfiles->Reload();

	if (testdirchanged.CompareNoCase(app_prefs->GetTempDir())!=0)
		AfxMessageBox(GetResString(IDS_SETTINGCHANGED_RESTART));
	
	SetModified(0);
	return CPropertyPage::OnApply();
}

BOOL CPPgDirectories::OnCommand(WPARAM wParam, LPARAM lParam)
{
//	if(wParam == USRMSG_ITEMSTATECHANGED)
//		SetModified();	
	return CPropertyPage::OnCommand(wParam, lParam);
}

void CPPgDirectories::Localize(void)
{
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_PW_DIR));

		GetDlgItem(IDC_INCOMING_FRM)->SetWindowText(GetResString(IDS_PW_INCOMING));
		GetDlgItem(IDC_TEMP_FRM)->SetWindowText(GetResString(IDS_PW_TEMP));
		GetDlgItem(IDC_SELINCDIR)->SetWindowText(GetResString(IDS_PW_BROWSE));
		GetDlgItem(IDC_SELTEMPDIR)->SetWindowText(GetResString(IDS_PW_BROWSE));
		GetDlgItem(IDC_SHARED_FRM)->SetWindowText(GetResString(IDS_PW_SHARED));
	}
}

void CPPgDirectories::FillUncList(void) {
	m_uncfolders->DeleteAllItems();

	for (POSITION pos = app_prefs->shareddir_list.GetHeadPosition();pos != 0;app_prefs->shareddir_list.GetNext(pos)){
		CString folder=app_prefs->shareddir_list.GetAt(pos);
		if (folder.Left(2)=="\\\\") {
			m_uncfolders->InsertItem(0,folder);
		}
	}
}

void CPPgDirectories::OnBnClickedAddUNC()
{
	InputBox inputbox;
	
	inputbox.SetLabels(GetResString(IDS_UNCFOLDERS),GetResString(IDS_UNCFOLDERS),"\\\\HOST\\path");
	if (inputbox.DoModal() != IDOK)
		return;
	CString unc=inputbox.GetInput();

	// basic unc-check 
	if ( unc.GetLength()<5 || unc.Left(2)!="\\\\") {
		AfxMessageBox(GetResString(IDS_ERR_BADUNC), MB_ICONERROR);
		return;
	}

	if (unc.Right(1)=="\\") unc.Delete(unc.GetLength()-1,1);

	CString test;
	for (POSITION pos = app_prefs->shareddir_list.GetHeadPosition();pos != 0;app_prefs->shareddir_list.GetNext(pos)){
		test=app_prefs->shareddir_list.GetAt(pos);
		if (unc.CompareNoCase(test)==0) return;
	}
	for (int posi = 0; posi<m_uncfolders->GetItemCount();++posi){
		test=m_uncfolders->GetItemText(posi,0);
		if (unc.CompareNoCase(test)==0) return;
	}

	m_uncfolders->InsertItem(m_uncfolders->GetItemCount(),unc);
}

void CPPgDirectories::OnBnClickedRemUNC()
{
	int index=m_uncfolders->GetSelectionMark();
	if (index==-1 || m_uncfolders->GetSelectedCount()==0 ) return;

	m_uncfolders->DeleteItem(index);
}
