/* soapC.cpp
   Generated by gSOAP 2.2.3b from JigleService-1.0.h
   Copyright (C) 2001-2003 Genivia inc.
   All Rights Reserved.
*/
#include "stdafx.h"
#include "soapH.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#pragma warning(disable:4060) // switch statement contains no 'case' or 'default' labels

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.2.3b 2003-09-05 09:45:55 GMT")

#ifndef WITH_NOGLOBAL

SOAP_FMAC1 void SOAP_FMAC2 soap_serializeheader(struct soap *soap)
{
	soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->is_in_header = 1;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->is_in_header = 0;
	}
	return SOAP_OK;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_getheader(struct soap *soap)
{
	soap->is_in_header = 1;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->is_in_header = 0;
	return soap->header == NULL;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serializefault(struct soap *soap)
{
	soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_putfault(struct soap *soap)
{
	return soap_out_SOAP_ENV__Fault(soap, "SOAP-ENV:Fault", 0, soap->fault, NULL);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_in_SOAP_ENV__Fault(soap, "SOAP-ENV:Fault", NULL, NULL)) == NULL;
}

SOAP_FMAC1 const char ** SOAP_FMAC2 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC1 const char ** SOAP_FMAC2 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC1 const char ** SOAP_FMAC2 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Detail;
	return (const char**)&soap->fault->detail;
}

#endif

SOAP_FMAC1 int SOAP_FMAC2 soap_getindependent(struct soap *soap)
{
	for (;;)
	{	if (soap_peek_element(soap))
			break;
		switch (soap_lookup_type(soap, soap->id))
		{
		case SOAP_TYPE_byte:
			soap_in_byte(soap, NULL, NULL, "");
			break;
		case SOAP_TYPE_xsd__int:
			soap_in_xsd__int(soap, NULL, NULL, "xsd:int");
			break;
		case SOAP_TYPE_int:
			soap_in_int(soap, NULL, NULL, "");
			break;
		case SOAP_TYPE_xsd__long:
			soap_in_xsd__long(soap, NULL, NULL, "xsd:long");
			break;
		case SOAP_TYPE_LONG64:
			soap_in_LONG64(soap, NULL, NULL, "");
			break;
		case SOAP_TYPE_api__Filename:
			soap_in_api__Filename(soap, NULL, NULL, "api:Filename");
			break;
		case SOAP_TYPE_api__searchResponse:
			soap_in_api__searchResponse(soap, NULL, NULL, "api:searchResponse");
			break;
		case SOAP_TYPE_api__searchFileResponse:
			soap_in_api__searchFileResponse(soap, NULL, NULL, "api:searchFileResponse");
			break;
		case SOAP_TYPE_FileArray:
			soap_in_FileArray(soap, NULL, NULL, "api:File");
			break;
		case SOAP_TYPE_api__SearchResult:
			soap_in_api__SearchResult(soap, NULL, NULL, "api:SearchResult");
			break;
		case SOAP_TYPE_StringArray:
			soap_in_StringArray(soap, NULL, NULL, "xsd:string");
			break;
		case SOAP_TYPE_FilenameArray:
			soap_in_FilenameArray(soap, NULL, NULL, "api:Filename");
			break;
		case SOAP_TYPE_api__File:
			soap_in_api__File(soap, NULL, NULL, "api:File");
			break;
		case SOAP_TYPE_api__versionResponse:
			soap_in_api__versionResponse(soap, NULL, NULL, "api:versionResponse");
			break;
		case SOAP_TYPE_api__search:
			soap_in_api__search(soap, NULL, NULL, "api:search");
			break;
		case SOAP_TYPE_api__searchFile:
			soap_in_api__searchFile(soap, NULL, NULL, "api:searchFile");
			break;
		case SOAP_TYPE_api__version:
			soap_in_api__version(soap, NULL, NULL, "api:version");
			break;
		case SOAP_TYPE_PointerToapi__searchResponse:
			soap_in_PointerToapi__searchResponse(soap, NULL, NULL, "api:searchResponse");
			break;
		case SOAP_TYPE_PointerToapi__searchFileResponse:
			soap_in_PointerToapi__searchFileResponse(soap, NULL, NULL, "api:searchFileResponse");
			break;
		case SOAP_TYPE_PointerToapi__versionResponse:
			soap_in_PointerToapi__versionResponse(soap, NULL, NULL, "api:versionResponse");
			break;
		case SOAP_TYPE_PointerToapi__Filename:
			soap_in_PointerToapi__Filename(soap, NULL, NULL, "api:Filename");
			break;
		case SOAP_TYPE_PointerToapi__SearchResult:
			soap_in_PointerToapi__SearchResult(soap, NULL, NULL, "api:SearchResult");
			break;
		case SOAP_TYPE_PointerToapi__File:
			soap_in_PointerToapi__File(soap, NULL, NULL, "api:File");
			break;
		case SOAP_TYPE_PointerToFileArray:
			soap_in_PointerToFileArray(soap, NULL, NULL, "api:File");
			break;
		case SOAP_TYPE_PointerToxsd__string:
			soap_in_PointerToxsd__string(soap, NULL, NULL, "xsd:string");
			break;
		case SOAP_TYPE_PointerToStringArray:
			soap_in_PointerToStringArray(soap, NULL, NULL, "xsd:string");
			break;
		case SOAP_TYPE_PointerToFilenameArray:
			soap_in_PointerToFilenameArray(soap, NULL, NULL, "api:Filename");
			break;
		case SOAP_TYPE_xsd__string:
			soap_in_xsd__string(soap, NULL, NULL, "xsd:string");
			break;
		case SOAP_TYPE_string:
			soap_in_string(soap, NULL, NULL, "");
			break;
		default:
			if (!*soap->id)
			{	if (soap_ignore_element(soap))
					break;
				else
					continue;
			}
			soap_in_byte(soap, NULL, NULL, "xsd:byte");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_xsd__int(soap, NULL, NULL, "xsd:int");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_int(soap, NULL, NULL, "xsd:int");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_xsd__long(soap, NULL, NULL, "xsd:long");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_LONG64(soap, NULL, NULL, "xsd:long");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_api__Filename(soap, NULL, NULL, "api:Filename");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_api__searchResponse(soap, NULL, NULL, "api:searchResponse");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_api__searchFileResponse(soap, NULL, NULL, "api:searchFileResponse");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_FileArray(soap, NULL, NULL, "api:File");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_api__SearchResult(soap, NULL, NULL, "api:SearchResult");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_StringArray(soap, NULL, NULL, "xsd:string");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_FilenameArray(soap, NULL, NULL, "api:Filename");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_api__File(soap, NULL, NULL, "api:File");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_api__versionResponse(soap, NULL, NULL, "api:versionResponse");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_api__search(soap, NULL, NULL, "api:search");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_api__searchFile(soap, NULL, NULL, "api:searchFile");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_api__version(soap, NULL, NULL, "api:version");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_xsd__string(soap, NULL, NULL, "xsd:string");
			if (soap->error == SOAP_TYPE_MISMATCH && soap->level == 2)
				soap_in_string(soap, NULL, NULL, "xsd:string");
			if (soap->error)
			{	soap->peeked = 1;
				soap_ignore_element(soap);
			}
		}
		if (soap->error)
			break;
	}
	if (soap->error == SOAP_NO_TAG)
		soap->error = SOAP_OK;
	return soap->error;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version != 1 || (soap->mode & SOAP_XML_GRAPH) || (soap->mode & SOAP_XML_TREE))
		return SOAP_OK;
	for (i = 0; i < SOAP_PTRHASH; i++)
		for (pp = soap->pht[i]; pp; pp = pp->next)
			if ((soap->mode & SOAP_IO_LENGTH) ? pp->mark1 == 2 : pp->mark2 == 2)
				switch (pp->type)
				{
				case SOAP_TYPE_byte:
					soap_out_byte(soap, "id", pp->id, (const char *)pp->ptr, "xsd:byte");
					break;
				case SOAP_TYPE_xsd__int:
					soap_out_xsd__int(soap, "id", pp->id, (const int *)pp->ptr, "xsd:int");
					break;
				case SOAP_TYPE_int:
					soap_out_int(soap, "id", pp->id, (const int *)pp->ptr, "xsd:int");
					break;
				case SOAP_TYPE_xsd__long:
					soap_out_xsd__long(soap, "id", pp->id, (const LONG64 *)pp->ptr, "xsd:long");
					break;
				case SOAP_TYPE_LONG64:
					soap_out_LONG64(soap, "id", pp->id, (const LONG64 *)pp->ptr, "xsd:long");
					break;
				case SOAP_TYPE_api__Filename:
					((api__Filename *)pp->ptr)->soap_out(soap, "id", pp->id, "api:Filename");
					break;
				case SOAP_TYPE_api__searchResponse:
					((api__searchResponse *)pp->ptr)->soap_out(soap, "id", pp->id, "api:searchResponse");
					break;
				case SOAP_TYPE_api__searchFileResponse:
					((api__searchFileResponse *)pp->ptr)->soap_out(soap, "id", pp->id, "api:searchFileResponse");
					break;
				case SOAP_TYPE_FileArray:
					((FileArray *)pp->ptr)->soap_out(soap, "id", pp->id, "api:File");
					break;
				case SOAP_TYPE_api__SearchResult:
					((api__SearchResult *)pp->ptr)->soap_out(soap, "id", pp->id, "api:SearchResult");
					break;
				case SOAP_TYPE_StringArray:
					((StringArray *)pp->ptr)->soap_out(soap, "id", pp->id, "xsd:string");
					break;
				case SOAP_TYPE_FilenameArray:
					((FilenameArray *)pp->ptr)->soap_out(soap, "id", pp->id, "api:Filename");
					break;
				case SOAP_TYPE_api__File:
					((api__File *)pp->ptr)->soap_out(soap, "id", pp->id, "api:File");
					break;
				case SOAP_TYPE_api__versionResponse:
					((api__versionResponse *)pp->ptr)->soap_out(soap, "id", pp->id, "api:versionResponse");
					break;
				case SOAP_TYPE_api__search:
					soap_out_api__search(soap, "id", pp->id, (const struct api__search *)pp->ptr, "api:search");
					break;
				case SOAP_TYPE_api__searchFile:
					soap_out_api__searchFile(soap, "id", pp->id, (const struct api__searchFile *)pp->ptr, "api:searchFile");
					break;
				case SOAP_TYPE_api__version:
					soap_out_api__version(soap, "id", pp->id, (const struct api__version *)pp->ptr, "api:version");
					break;
				case SOAP_TYPE_PointerToapi__searchResponse:
					soap_out_PointerToapi__searchResponse(soap, "id", pp->id, (api__searchResponse *const*)pp->ptr, "api:searchResponse");
					break;
				case SOAP_TYPE_PointerToapi__searchFileResponse:
					soap_out_PointerToapi__searchFileResponse(soap, "id", pp->id, (api__searchFileResponse *const*)pp->ptr, "api:searchFileResponse");
					break;
				case SOAP_TYPE_PointerToapi__versionResponse:
					soap_out_PointerToapi__versionResponse(soap, "id", pp->id, (api__versionResponse *const*)pp->ptr, "api:versionResponse");
					break;
				case SOAP_TYPE_PointerToapi__Filename:
					soap_out_PointerToapi__Filename(soap, "id", pp->id, (api__Filename *const*)pp->ptr, "api:Filename");
					break;
				case SOAP_TYPE_PointerToapi__SearchResult:
					soap_out_PointerToapi__SearchResult(soap, "id", pp->id, (api__SearchResult *const*)pp->ptr, "api:SearchResult");
					break;
				case SOAP_TYPE_PointerToapi__File:
					soap_out_PointerToapi__File(soap, "id", pp->id, (api__File *const*)pp->ptr, "api:File");
					break;
				case SOAP_TYPE_PointerToFileArray:
					soap_out_PointerToFileArray(soap, "id", pp->id, (FileArray *const*)pp->ptr, "api:File");
					break;
				case SOAP_TYPE_PointerToxsd__string:
					soap_out_PointerToxsd__string(soap, "id", pp->id, (char **const*)pp->ptr, "xsd:string");
					break;
				case SOAP_TYPE_PointerToStringArray:
					soap_out_PointerToStringArray(soap, "id", pp->id, (StringArray *const*)pp->ptr, "xsd:string");
					break;
				case SOAP_TYPE_PointerToFilenameArray:
					soap_out_PointerToFilenameArray(soap, "id", pp->id, (FilenameArray *const*)pp->ptr, "api:Filename");
					break;
				case SOAP_TYPE_xsd__string:
					soap_out_string(soap, "id", pp->id, (char**)&pp->ptr, "xsd:string");
					break;
				case SOAP_TYPE_string:
					soap_out_string(soap, "id", pp->id, (char**)&pp->ptr, "xsd:string");
					break;
				}
		
	return SOAP_OK;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_getattachments(struct soap *soap)
{
	if (!(soap->mode & SOAP_ENC_DIME))
		return SOAP_OK;
	while (soap->dime_flags & SOAP_DIME_CF)
	{	if (soap_getdimehdr(soap))
			return soap->error;
		if (soap_move(soap, soap->dime_size))
			return soap->error = SOAP_EOF;
	}
	if (soap_move(soap, ((soap->dime_size+3)&-4)-soap_tell(soap)))
		return soap->error = SOAP_EOF;
	for (;;)
	{	if (soap_getdime(soap) || !soap->dime_id)
			break;
		switch (soap_lookup_type(soap, soap->dime_id))
		{
		case SOAP_TYPE_xsd__string:
		{	char ** a;
			a = (char **)soap_id_enter(soap, soap->dime_id, NULL, SOAP_TYPE_xsd__string, sizeof(char *), 0);
			if (a)
				*a = soap->dime_ptr;
			break;
		}
		case SOAP_TYPE_string:
		{	char ** a;
			a = (char **)soap_id_enter(soap, soap->dime_id, NULL, SOAP_TYPE_string, sizeof(char *), 0);
			if (a)
				*a = soap->dime_ptr;
			break;
		}
		default:
			soap->error = SOAP_DIME_ERROR;
		}
		if (soap->error)
			break;
	}
	if (soap->error == SOAP_EOD)
		soap->error = SOAP_OK;
	return soap->error;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_putattachments(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (!(soap->mode & SOAP_ENC_DIME))
		return SOAP_OK;
	if (soap_send_raw(soap, "\0\0\0", -(int)soap->count&3))
		return soap->error;
	for (i = 0; i < SOAP_PTRHASH; i++)
		for (pp = soap->pht[i]; pp; pp = pp->next)
			if (pp->mark2 == 3)
				switch (pp->type)
				{
				}
		
	return SOAP_OK;
}

SOAP_FMAC1 void * SOAP_FMAC2 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType)
{
	switch (t)
	{
	case SOAP_TYPE_api__versionResponse:
		return (void*)soap_instantiate_api__versionResponse(soap, -1, type, arrayType);
	case SOAP_TYPE_api__File:
		return (void*)soap_instantiate_api__File(soap, -1, type, arrayType);
	case SOAP_TYPE_FilenameArray:
		return (void*)soap_instantiate_FilenameArray(soap, -1, type, arrayType);
	case SOAP_TYPE_StringArray:
		return (void*)soap_instantiate_StringArray(soap, -1, type, arrayType);
	case SOAP_TYPE_api__SearchResult:
		return (void*)soap_instantiate_api__SearchResult(soap, -1, type, arrayType);
	case SOAP_TYPE_FileArray:
		return (void*)soap_instantiate_FileArray(soap, -1, type, arrayType);
	case SOAP_TYPE_api__searchFileResponse:
		return (void*)soap_instantiate_api__searchFileResponse(soap, -1, type, arrayType);
	case SOAP_TYPE_api__searchResponse:
		return (void*)soap_instantiate_api__searchResponse(soap, -1, type, arrayType);
	case SOAP_TYPE_api__Filename:
		return (void*)soap_instantiate_api__Filename(soap, -1, type, arrayType);
	}
	return NULL;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_delete(struct soap *soap, void *p)
{
	struct soap_clist **cp;
	cp = &soap->clist;
	while (*cp)
	{	if (!p || p == (*cp)->ptr)
		{	struct soap_clist *q = *cp;
			*cp = q->next;
			switch (q->type)
			{
			case SOAP_TYPE_api__versionResponse:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_delete(api__versionResponse, %d)\n", q->size));
				if (q->size < 0)
					delete (api__versionResponse*)q->ptr;
				else
					delete[] (api__versionResponse*)q->ptr;
				break;
			case SOAP_TYPE_api__File:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_delete(api__File, %d)\n", q->size));
				if (q->size < 0)
					delete (api__File*)q->ptr;
				else
					delete[] (api__File*)q->ptr;
				break;
			case SOAP_TYPE_FilenameArray:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_delete(FilenameArray, %d)\n", q->size));
				if (q->size < 0)
					delete (FilenameArray*)q->ptr;
				else
					delete[] (FilenameArray*)q->ptr;
				break;
			case SOAP_TYPE_StringArray:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_delete(StringArray, %d)\n", q->size));
				if (q->size < 0)
					delete (StringArray*)q->ptr;
				else
					delete[] (StringArray*)q->ptr;
				break;
			case SOAP_TYPE_api__SearchResult:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_delete(api__SearchResult, %d)\n", q->size));
				if (q->size < 0)
					delete (api__SearchResult*)q->ptr;
				else
					delete[] (api__SearchResult*)q->ptr;
				break;
			case SOAP_TYPE_FileArray:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_delete(FileArray, %d)\n", q->size));
				if (q->size < 0)
					delete (FileArray*)q->ptr;
				else
					delete[] (FileArray*)q->ptr;
				break;
			case SOAP_TYPE_api__searchFileResponse:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_delete(api__searchFileResponse, %d)\n", q->size));
				if (q->size < 0)
					delete (api__searchFileResponse*)q->ptr;
				else
					delete[] (api__searchFileResponse*)q->ptr;
				break;
			case SOAP_TYPE_api__searchResponse:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_delete(api__searchResponse, %d)\n", q->size));
				if (q->size < 0)
					delete (api__searchResponse*)q->ptr;
				else
					delete[] (api__searchResponse*)q->ptr;
				break;
			case SOAP_TYPE_api__Filename:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_delete(api__Filename, %d)\n", q->size));
				if (q->size < 0)
					delete (api__Filename*)q->ptr;
				else
					delete[] (api__Filename*)q->ptr;
				break;
			}
			free(q);
			if (p)
				return;
			cp = &soap->clist;
		}
		else
			cp = &(*cp)->next;
	}
}

SOAP_FMAC1 void* SOAP_FMAC2 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, const char *type, const char *arrayType)
{	struct soap_ilist *ip;
	DBGLOG(TEST,SOAP_MESSAGE(fdebug, "Class id enter id='%s' t=%d loc=%p type='%s' arrayType='%s'\n", id, t, p, type?type:"", arrayType?arrayType:""));
	soap->alloced = 0;
	if (*id == '\0')
	{	if (!p)
			return soap_instantiate(soap, t, type, arrayType);
		else
			return p;
	}
	ip = soap_lookup(soap, id);
	if (!ip)
	{	ip = soap_enter(soap, id);
		ip->link = NULL;
		ip->copy = NULL;
		if (!p)
			p = soap_instantiate(soap, t, type, arrayType);
		ip->ptr = p;
		ip->level = 0;
	}
	else if (ip->ptr)
	{	if (p)
		{	soap->error = SOAP_MULTI_ID;
			return NULL;
		}
	}
	else
	{	if (!p)
			p = soap_instantiate(soap, t, type, arrayType);
		ip->ptr = p;
		ip->level = 0;
		if (!soap->blist)
			soap_resolve_ptr(ip);
	}
	return ip->ptr;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_byte(struct soap *soap, char *a)
{
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_byte(struct soap *soap, char const*a)
{
	soap_reference(soap, a, SOAP_TYPE_byte);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_byte(struct soap *soap, char *a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_byte, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_byte(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_byte(soap, tag, i, a, type);
		}
	else
		soap_out_byte(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC1 char * SOAP_FMAC2 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 char * SOAP_FMAC2 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_xsd__int(struct soap *soap, int *a)
{
#ifdef SOAP_DEFAULT_xsd__int
	*a = SOAP_DEFAULT_xsd__int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_xsd__int(struct soap *soap, int const*a)
{
	soap_reference(soap, a, SOAP_TYPE_xsd__int);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_xsd__int(struct soap *soap, int *a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_xsd__int, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_xsd__int(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_xsd__int(soap, tag, i, a, type);
		}
	else
		soap_out_xsd__int(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_xsd__int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_xsd__int);
}

SOAP_FMAC1 int * SOAP_FMAC2 soap_get_xsd__int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 int * SOAP_FMAC2 soap_in_xsd__int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_xsd__int);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_int(struct soap *soap, int *a)
{
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_int(struct soap *soap, int const*a)
{
	soap_reference(soap, a, SOAP_TYPE_int);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_int(struct soap *soap, int *a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_int, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_int(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_int(soap, tag, i, a, type);
		}
	else
		soap_out_int(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC1 int * SOAP_FMAC2 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 int * SOAP_FMAC2 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_xsd__long(struct soap *soap, LONG64 *a)
{
#ifdef SOAP_DEFAULT_xsd__long
	*a = SOAP_DEFAULT_xsd__long;
#else
	*a = (LONG64)0;
#endif
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_xsd__long(struct soap *soap, LONG64 const*a)
{
	soap_reference(soap, a, SOAP_TYPE_xsd__long);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_xsd__long(struct soap *soap, LONG64 *a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_xsd__long, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_xsd__long(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_xsd__long(soap, tag, i, a, type);
		}
	else
		soap_out_xsd__long(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_xsd__long(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_xsd__long);
}

SOAP_FMAC1 LONG64 * SOAP_FMAC2 soap_get_xsd__long(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__long(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 LONG64 * SOAP_FMAC2 soap_in_xsd__long(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{
	return soap_inLONG64(soap, tag, a, type, SOAP_TYPE_xsd__long);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_LONG64(struct soap *soap, LONG64 *a)
{
#ifdef SOAP_DEFAULT_LONG64
	*a = SOAP_DEFAULT_LONG64;
#else
	*a = (LONG64)0;
#endif
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_LONG64(struct soap *soap, LONG64 const*a)
{
	soap_reference(soap, a, SOAP_TYPE_LONG64);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_LONG64(struct soap *soap, LONG64 *a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_LONG64, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_LONG64(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_LONG64(soap, tag, i, a, type);
		}
	else
		soap_out_LONG64(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_LONG64(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC1 LONG64 * SOAP_FMAC2 soap_get_LONG64(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_LONG64(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 LONG64 * SOAP_FMAC2 soap_in_LONG64(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{
	return soap_inLONG64(soap, tag, a, type, SOAP_TYPE_LONG64);
}

void api__Filename::soap_serialize(struct soap *soap) const
{
	if (!soap_reference(soap, this, SOAP_TYPE_api__Filename))
		this->soap_mark(soap);
}

void api__Filename::soap_mark(struct soap *soap) const
{
	soap_embedded(soap, &((api__Filename*)this)->t, SOAP_TYPE_xsd__string);
	soap_mark_xsd__string(soap, &((api__Filename*)this)->t);
	soap_embedded(soap, &((api__Filename*)this)->a, SOAP_TYPE_xsd__int);
}

void api__Filename::soap_default(struct soap *soap)
{
	static api__Filename a;
	memcpy(this, &a, sizeof(api__Filename));
	soap_default_xsd__string(soap, &((api__Filename*)this)->t);
	soap_default_xsd__int(soap, &((api__Filename*)this)->a);
}

int api__Filename::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, this, SOAP_TYPE_api__Filename, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			this->soap_out(soap, tag, 0, type);
		else
		{
			soap_set_embedded(soap, pp);
			this->soap_out(soap, tag, i, type);
		}
	else
		this->soap_out(soap, tag, 0, type);
	return soap_putindependent(soap);
}

int api__Filename::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_api__Filename(soap, tag, id, this, type);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_api__Filename(struct soap *soap, const char *tag, int id, const api__Filename *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_api__Filename), "api:Filename");
	soap_out_xsd__string(soap, "t", -1, &(((api__Filename*)a)->t), "xsd:string");
	soap_out_xsd__int(soap, "a", -1, &(((api__Filename*)a)->a), "xsd:int");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *api__Filename::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_api__Filename(soap, this, tag, type);
}

SOAP_FMAC1 api__Filename * SOAP_FMAC2 soap_get_api__Filename(struct soap *soap, api__Filename *p, const char *tag, const char *type)
{
	if ((p = soap_in_api__Filename(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *api__Filename::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_api__Filename(soap, tag, this, type);
}

SOAP_FMAC1 api__Filename * SOAP_FMAC2 soap_in_api__Filename(struct soap *soap, const char *tag, api__Filename *a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
		if (soap->mode & SOAP_XML_NIL)
		{	soap->error = SOAP_NULL;
			return NULL;
		}	else
			return a;
	if (!*soap->href)
	{	if (!(a = (api__Filename *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_api__Filename, soap->type, soap->arrayType)))
		{	soap->error = SOAP_TAG_MISMATCH;
			return NULL;
		}
		if (soap->alloced)
		{	a->soap_default(soap);
			if (soap->clist->type != SOAP_TYPE_api__Filename)
			{	soap_revert(soap);
				*soap->id = '\0';
				return (api__Filename *)a->soap_in(soap, tag, type);
			}
		}
		short soap_flag_t1 = 1, soap_flag_a1 = 1;
		if (soap->body)
		{	for (;;)
			{
			soap->error = SOAP_TAG_MISMATCH;

			if (soap_flag_t1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__string(soap, "t", &(((api__Filename*)a)->t), "xsd:string"))
				{	soap_flag_t1 = 0;
					continue;
				}

			if (soap_flag_a1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "a", &(((api__Filename*)a)->a), "xsd:int"))
				{	soap_flag_a1 = 0;
					continue;
				}

			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (api__Filename *)soap_id_forward(soap, soap->href, (void**)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_api__Filename, soap->type, soap->arrayType), SOAP_TYPE_api__Filename, sizeof(api__Filename));
		if (soap->alloced)
			a->soap_default(soap);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 api__Filename * SOAP_FMAC2 soap_instantiate_api__Filename(struct soap *soap, int n, const char *type, const char *arrayType)
{
DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_api__Filename(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	soap->alloced = 1;
	struct soap_clist *cp = (struct soap_clist*)malloc(sizeof(struct soap_clist));
	if (!cp)
		return NULL;
	cp->next = soap->clist;
	cp->type = SOAP_TYPE_api__Filename;
	cp->size = n; 
	soap->clist = cp;
	if (n < 0)
	{	cp->ptr = (void*)new api__Filename;
	}
	else
	{	cp->ptr = (void*)new api__Filename[n];
	}
	return (api__Filename*)cp->ptr;
}

void api__searchResponse::soap_serialize(struct soap *soap) const
{
	if (!soap_reference(soap, this, SOAP_TYPE_api__searchResponse))
		this->soap_mark(soap);
}

void api__searchResponse::soap_mark(struct soap *soap) const
{
	soap_embedded(soap, &((api__searchResponse*)this)->_r, SOAP_TYPE_PointerToapi__SearchResult);
	soap_mark_PointerToapi__SearchResult(soap, &((api__searchResponse*)this)->_r);
}

void api__searchResponse::soap_default(struct soap *soap)
{
	static api__searchResponse a;
	memcpy(this, &a, sizeof(api__searchResponse));
	soap_default_PointerToapi__SearchResult(soap, &((api__searchResponse*)this)->_r);
}

int api__searchResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, this, SOAP_TYPE_api__searchResponse, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			this->soap_out(soap, tag, 0, type);
		else
		{
			soap_set_embedded(soap, pp);
			this->soap_out(soap, tag, i, type);
		}
	else
		this->soap_out(soap, tag, 0, type);
	return soap_putindependent(soap);
}

int api__searchResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_api__searchResponse(soap, tag, id, this, type);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_api__searchResponse(struct soap *soap, const char *tag, int id, const api__searchResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_api__searchResponse), "api:searchResponse");
	soap_out_PointerToapi__SearchResult(soap, "r", -1, &(((api__searchResponse*)a)->_r), "api:SearchResult");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *api__searchResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_api__searchResponse(soap, this, tag, type);
}

SOAP_FMAC1 api__searchResponse * SOAP_FMAC2 soap_get_api__searchResponse(struct soap *soap, api__searchResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_api__searchResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *api__searchResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_api__searchResponse(soap, tag, this, type);
}

SOAP_FMAC1 api__searchResponse * SOAP_FMAC2 soap_in_api__searchResponse(struct soap *soap, const char *tag, api__searchResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
		if (soap->mode & SOAP_XML_NIL)
		{	soap->error = SOAP_NULL;
			return NULL;
		}	else
			return a;
	if (!*soap->href)
	{	if (!(a = (api__searchResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_api__searchResponse, soap->type, soap->arrayType)))
		{	soap->error = SOAP_TAG_MISMATCH;
			return NULL;
		}
		if (soap->alloced)
		{	a->soap_default(soap);
			if (soap->clist->type != SOAP_TYPE_api__searchResponse)
			{	soap_revert(soap);
				*soap->id = '\0';
				return (api__searchResponse *)a->soap_in(soap, tag, type);
			}
		}
		short soap_flag__r1 = 1;
		if (soap->body)
		{	for (;;)
			{
			soap->error = SOAP_TAG_MISMATCH;

			if (soap_flag__r1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToapi__SearchResult(soap, NULL, &(((api__searchResponse*)a)->_r), "api:SearchResult"))
				{	soap_flag__r1 = 0;
					continue;
				}

			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (api__searchResponse *)soap_id_forward(soap, soap->href, (void**)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_api__searchResponse, soap->type, soap->arrayType), SOAP_TYPE_api__searchResponse, sizeof(api__searchResponse));
		if (soap->alloced)
			a->soap_default(soap);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 api__searchResponse * SOAP_FMAC2 soap_instantiate_api__searchResponse(struct soap *soap, int n, const char *type, const char *arrayType)
{
DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_api__searchResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	soap->alloced = 1;
	struct soap_clist *cp = (struct soap_clist*)malloc(sizeof(struct soap_clist));
	if (!cp)
		return NULL;
	cp->next = soap->clist;
	cp->type = SOAP_TYPE_api__searchResponse;
	cp->size = n; 
	soap->clist = cp;
	if (n < 0)
	{	cp->ptr = (void*)new api__searchResponse;
	}
	else
	{	cp->ptr = (void*)new api__searchResponse[n];
	}
	return (api__searchResponse*)cp->ptr;
}

void api__searchFileResponse::soap_serialize(struct soap *soap) const
{
	if (!soap_reference(soap, this, SOAP_TYPE_api__searchFileResponse))
		this->soap_mark(soap);
}

void api__searchFileResponse::soap_mark(struct soap *soap) const
{
	soap_embedded(soap, &((api__searchFileResponse*)this)->_r, SOAP_TYPE_PointerToapi__File);
	soap_mark_PointerToapi__File(soap, &((api__searchFileResponse*)this)->_r);
}

void api__searchFileResponse::soap_default(struct soap *soap)
{
	static api__searchFileResponse a;
	memcpy(this, &a, sizeof(api__searchFileResponse));
	soap_default_PointerToapi__File(soap, &((api__searchFileResponse*)this)->_r);
}

int api__searchFileResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, this, SOAP_TYPE_api__searchFileResponse, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			this->soap_out(soap, tag, 0, type);
		else
		{
			soap_set_embedded(soap, pp);
			this->soap_out(soap, tag, i, type);
		}
	else
		this->soap_out(soap, tag, 0, type);
	return soap_putindependent(soap);
}

int api__searchFileResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_api__searchFileResponse(soap, tag, id, this, type);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_api__searchFileResponse(struct soap *soap, const char *tag, int id, const api__searchFileResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_api__searchFileResponse), "api:searchFileResponse");
	soap_out_PointerToapi__File(soap, "r", -1, &(((api__searchFileResponse*)a)->_r), "api:File");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *api__searchFileResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_api__searchFileResponse(soap, this, tag, type);
}

SOAP_FMAC1 api__searchFileResponse * SOAP_FMAC2 soap_get_api__searchFileResponse(struct soap *soap, api__searchFileResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_api__searchFileResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *api__searchFileResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_api__searchFileResponse(soap, tag, this, type);
}

SOAP_FMAC1 api__searchFileResponse * SOAP_FMAC2 soap_in_api__searchFileResponse(struct soap *soap, const char *tag, api__searchFileResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
		if (soap->mode & SOAP_XML_NIL)
		{	soap->error = SOAP_NULL;
			return NULL;
		}	else
			return a;
	if (!*soap->href)
	{	if (!(a = (api__searchFileResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_api__searchFileResponse, soap->type, soap->arrayType)))
		{	soap->error = SOAP_TAG_MISMATCH;
			return NULL;
		}
		if (soap->alloced)
		{	a->soap_default(soap);
			if (soap->clist->type != SOAP_TYPE_api__searchFileResponse)
			{	soap_revert(soap);
				*soap->id = '\0';
				return (api__searchFileResponse *)a->soap_in(soap, tag, type);
			}
		}
		short soap_flag__r1 = 1;
		if (soap->body)
		{	for (;;)
			{
			soap->error = SOAP_TAG_MISMATCH;

			if (soap_flag__r1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToapi__File(soap, NULL, &(((api__searchFileResponse*)a)->_r), "api:File"))
				{	soap_flag__r1 = 0;
					continue;
				}

			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (api__searchFileResponse *)soap_id_forward(soap, soap->href, (void**)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_api__searchFileResponse, soap->type, soap->arrayType), SOAP_TYPE_api__searchFileResponse, sizeof(api__searchFileResponse));
		if (soap->alloced)
			a->soap_default(soap);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 api__searchFileResponse * SOAP_FMAC2 soap_instantiate_api__searchFileResponse(struct soap *soap, int n, const char *type, const char *arrayType)
{
DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_api__searchFileResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	soap->alloced = 1;
	struct soap_clist *cp = (struct soap_clist*)malloc(sizeof(struct soap_clist));
	if (!cp)
		return NULL;
	cp->next = soap->clist;
	cp->type = SOAP_TYPE_api__searchFileResponse;
	cp->size = n; 
	soap->clist = cp;
	if (n < 0)
	{	cp->ptr = (void*)new api__searchFileResponse;
	}
	else
	{	cp->ptr = (void*)new api__searchFileResponse[n];
	}
	return (api__searchFileResponse*)cp->ptr;
}

void FileArray::soap_serialize(struct soap *soap) const
{
	this->soap_mark(soap);
}

void FileArray::soap_mark(struct soap *soap) const
{
	int i;
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, this->__size, SOAP_TYPE_FileArray))
		for (i = 0; i < this->__size; i++)
		{	soap_embedded(soap, this->__ptr + i, SOAP_TYPE_api__File);
			this->__ptr[i].soap_mark(soap);
		}
}

void FileArray::soap_default(struct soap *soap)
{
	static FileArray a;
	memcpy(this, &a, sizeof(FileArray));
	this->__size = 0;
	this->__ptr = NULL;
	this->__offset = 0;
}

int FileArray::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_array_pointer_lookup(soap, this, (struct soap_array*)&this->__ptr, this->__size, SOAP_TYPE_FileArray, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			this->soap_out(soap, tag, 0, type);
		else
		{
			soap_set_embedded(soap, pp);
			this->soap_out(soap, tag, i, type);
		}
	else
		this->soap_out(soap, tag, 0, type);
	return soap_putindependent(soap);
}

int FileArray::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_FileArray(soap, tag, id, this, type);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_FileArray(struct soap *soap, const char *tag, int id, const FileArray *a, const char *type)
{
	int i;
	struct soap_plist *pp;
	int n = a->__size;
	char *t = soap_putsize(soap, "api:File", n + a->__offset);
	i = soap_array_pointer_lookup(soap, a, (struct soap_array*)&a->__ptr, n, SOAP_TYPE_FileArray, &pp);
	if (!a->__ptr)
	{	soap_element_null(soap, tag, i, t);
		return SOAP_OK;
	}
	if (id <= 0 && i)
	{	if (soap_is_embedded(soap, pp))
		{	soap_element_ref(soap, tag, 0, i);
			return SOAP_OK;
		}
		if (soap_is_single(soap, pp))
			i = 0;
	}
	else if (id > 0)
		i = id;
	soap_array_begin_out(soap, tag, i, t, soap_putoffset(soap, a->__offset));
	if (i)
		soap_set_embedded(soap, pp);
	for (i = 0; i < n; i++)
	{
		a->__ptr[i].soap_out(soap, "item", -1, "api:File");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *FileArray::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_FileArray(soap, this, tag, type);
}

SOAP_FMAC1 FileArray * SOAP_FMAC2 soap_get_FileArray(struct soap *soap, FileArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_FileArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *FileArray::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_FileArray(soap, tag, this, type);
}

SOAP_FMAC1 FileArray * SOAP_FMAC2 soap_in_FileArray(struct soap *soap, const char *tag, FileArray *a, const char *type)
{	int i, j;
	api__File *p;
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE_MISMATCH;
		soap_revert(soap);
		return NULL;
	}
	if (soap->null)
	{	if ((a = (FileArray *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_FileArray, soap->type, soap->arrayType)))
			a->soap_default(soap);
			if (soap->body && soap_element_end_in(soap, tag))
				return NULL;
	}
	else if (!*soap->href)
	{	if (!(a = (FileArray *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_FileArray, soap->type, soap->arrayType)))
			return NULL;
		if (soap->alloced)
			a->soap_default(soap);
		if (soap->body)
		{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		a->__offset = j;
		if (j >= 0 && a->__size >= 0)
		{	a->__ptr = soap_instantiate_api__File(soap, a->__size, NULL, NULL);
			for (i = 0; i < a->__size; i++)
				(a->__ptr+i)->api__File::soap_default(soap);
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
					return NULL;
					}
				}
				if (!soap_in_api__File(soap, NULL, a->__ptr+i, "api:File"))
				{	if (soap->error == SOAP_NO_TAG)
					{	soap->error = SOAP_OK;
						break;
					}
					else
						return NULL;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (api__File *)soap_push_block(soap, sizeof(api__File));
				if (!p)
					return NULL;
				p->api__File::soap_default(soap);
				if (!soap_in_api__File(soap, NULL, p, "api:File"))
				{	if (soap->error == SOAP_NO_TAG)
					{	soap->error = SOAP_OK;
						break;
					}
					else
						return NULL;
				}
			}
			soap_pop_block(soap);
			if (soap->blist->size)
				a->__ptr = soap_instantiate_api__File(soap, soap->blist->size/sizeof(api__File), NULL, NULL);
			else
				a->__ptr = NULL;
			soap_store_block(soap, (char*)a->__ptr);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (FileArray *)soap_id_forward(soap, soap->href, (void**)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_FileArray, soap->type, soap->arrayType), SOAP_TYPE_FileArray, sizeof(FileArray));
		if (soap->alloced)
			a->soap_default(soap);
		if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	}
	return a;
}

SOAP_FMAC1 FileArray * SOAP_FMAC2 soap_instantiate_FileArray(struct soap *soap, int n, const char *type, const char *arrayType)
{
DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_FileArray(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	soap->alloced = 1;
	struct soap_clist *cp = (struct soap_clist*)malloc(sizeof(struct soap_clist));
	if (!cp)
		return NULL;
	cp->next = soap->clist;
	cp->type = SOAP_TYPE_FileArray;
	cp->size = n; 
	soap->clist = cp;
	if (n < 0)
	{	cp->ptr = (void*)new FileArray;
	}
	else
	{	cp->ptr = (void*)new FileArray[n];
	}
	return (FileArray*)cp->ptr;
}

void api__SearchResult::soap_serialize(struct soap *soap) const
{
	if (!soap_reference(soap, this, SOAP_TYPE_api__SearchResult))
		this->soap_mark(soap);
}

void api__SearchResult::soap_mark(struct soap *soap) const
{
	soap_embedded(soap, &((api__SearchResult*)this)->t, SOAP_TYPE_xsd__int);
	soap_embedded(soap, &((api__SearchResult*)this)->o, SOAP_TYPE_xsd__int);
	soap_embedded(soap, &((api__SearchResult*)this)->m, SOAP_TYPE_PointerToFileArray);
	soap_mark_PointerToFileArray(soap, &((api__SearchResult*)this)->m);
}

void api__SearchResult::soap_default(struct soap *soap)
{
	static api__SearchResult a;
	memcpy(this, &a, sizeof(api__SearchResult));
	soap_default_xsd__int(soap, &((api__SearchResult*)this)->t);
	soap_default_xsd__int(soap, &((api__SearchResult*)this)->o);
	soap_default_PointerToFileArray(soap, &((api__SearchResult*)this)->m);
}

int api__SearchResult::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, this, SOAP_TYPE_api__SearchResult, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			this->soap_out(soap, tag, 0, type);
		else
		{
			soap_set_embedded(soap, pp);
			this->soap_out(soap, tag, i, type);
		}
	else
		this->soap_out(soap, tag, 0, type);
	return soap_putindependent(soap);
}

int api__SearchResult::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_api__SearchResult(soap, tag, id, this, type);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_api__SearchResult(struct soap *soap, const char *tag, int id, const api__SearchResult *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_api__SearchResult), "api:SearchResult");
	soap_out_xsd__int(soap, "t", -1, &(((api__SearchResult*)a)->t), "xsd:int");
	soap_out_xsd__int(soap, "o", -1, &(((api__SearchResult*)a)->o), "xsd:int");
	soap_out_PointerToFileArray(soap, "m", -1, &(((api__SearchResult*)a)->m), "api:File");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *api__SearchResult::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_api__SearchResult(soap, this, tag, type);
}

SOAP_FMAC1 api__SearchResult * SOAP_FMAC2 soap_get_api__SearchResult(struct soap *soap, api__SearchResult *p, const char *tag, const char *type)
{
	if ((p = soap_in_api__SearchResult(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *api__SearchResult::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_api__SearchResult(soap, tag, this, type);
}

SOAP_FMAC1 api__SearchResult * SOAP_FMAC2 soap_in_api__SearchResult(struct soap *soap, const char *tag, api__SearchResult *a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
		if (soap->mode & SOAP_XML_NIL)
		{	soap->error = SOAP_NULL;
			return NULL;
		}	else
			return a;
	if (!*soap->href)
	{	if (!(a = (api__SearchResult *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_api__SearchResult, soap->type, soap->arrayType)))
		{	soap->error = SOAP_TAG_MISMATCH;
			return NULL;
		}
		if (soap->alloced)
		{	a->soap_default(soap);
			if (soap->clist->type != SOAP_TYPE_api__SearchResult)
			{	soap_revert(soap);
				*soap->id = '\0';
				return (api__SearchResult *)a->soap_in(soap, tag, type);
			}
		}
		short soap_flag_t1 = 1, soap_flag_o1 = 1, soap_flag_m1 = 1;
		if (soap->body)
		{	for (;;)
			{
			soap->error = SOAP_TAG_MISMATCH;

			if (soap_flag_t1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "t", &(((api__SearchResult*)a)->t), "xsd:int"))
				{	soap_flag_t1 = 0;
					continue;
				}

			if (soap_flag_o1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "o", &(((api__SearchResult*)a)->o), "xsd:int"))
				{	soap_flag_o1 = 0;
					continue;
				}

			if (soap_flag_m1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToFileArray(soap, "m", &(((api__SearchResult*)a)->m), "api:File"))
				{	soap_flag_m1 = 0;
					continue;
				}

			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (api__SearchResult *)soap_id_forward(soap, soap->href, (void**)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_api__SearchResult, soap->type, soap->arrayType), SOAP_TYPE_api__SearchResult, sizeof(api__SearchResult));
		if (soap->alloced)
			a->soap_default(soap);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 api__SearchResult * SOAP_FMAC2 soap_instantiate_api__SearchResult(struct soap *soap, int n, const char *type, const char *arrayType)
{
DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_api__SearchResult(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	soap->alloced = 1;
	struct soap_clist *cp = (struct soap_clist*)malloc(sizeof(struct soap_clist));
	if (!cp)
		return NULL;
	cp->next = soap->clist;
	cp->type = SOAP_TYPE_api__SearchResult;
	cp->size = n; 
	soap->clist = cp;
	if (n < 0)
	{	cp->ptr = (void*)new api__SearchResult;
	}
	else
	{	cp->ptr = (void*)new api__SearchResult[n];
	}
	return (api__SearchResult*)cp->ptr;
}

void StringArray::soap_serialize(struct soap *soap) const
{
	this->soap_mark(soap);
}

void StringArray::soap_mark(struct soap *soap) const
{
	int i;
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, this->__size, SOAP_TYPE_StringArray))
		for (i = 0; i < this->__size; i++)
		{	soap_embedded(soap, this->__ptr + i, SOAP_TYPE_xsd__string);
			soap_mark_xsd__string(soap, this->__ptr + i);
		}
}

void StringArray::soap_default(struct soap *soap)
{
	static StringArray a;
	memcpy(this, &a, sizeof(StringArray));
	this->__size = 0;
	this->__ptr = NULL;
	this->__offset = 0;
}

int StringArray::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_array_pointer_lookup(soap, this, (struct soap_array*)&this->__ptr, this->__size, SOAP_TYPE_StringArray, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			this->soap_out(soap, tag, 0, type);
		else
		{
			soap_set_embedded(soap, pp);
			this->soap_out(soap, tag, i, type);
		}
	else
		this->soap_out(soap, tag, 0, type);
	return soap_putindependent(soap);
}

int StringArray::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_StringArray(soap, tag, id, this, type);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_StringArray(struct soap *soap, const char *tag, int id, const StringArray *a, const char *type)
{
	int i;
	struct soap_plist *pp;
	int n = a->__size;
	char *t = soap_putsize(soap, "xsd:string", n + a->__offset);
	i = soap_array_pointer_lookup(soap, a, (struct soap_array*)&a->__ptr, n, SOAP_TYPE_StringArray, &pp);
	if (!a->__ptr)
	{	soap_element_null(soap, tag, i, t);
		return SOAP_OK;
	}
	if (id <= 0 && i)
	{	if (soap_is_embedded(soap, pp))
		{	soap_element_ref(soap, tag, 0, i);
			return SOAP_OK;
		}
		if (soap_is_single(soap, pp))
			i = 0;
	}
	else if (id > 0)
		i = id;
	soap_array_begin_out(soap, tag, i, t, soap_putoffset(soap, a->__offset));
	if (i)
		soap_set_embedded(soap, pp);
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_xsd__string(soap, "item", 0, &a->__ptr[i], "xsd:string");
	}
	soap->position = 0;
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *StringArray::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_StringArray(soap, this, tag, type);
}

SOAP_FMAC1 StringArray * SOAP_FMAC2 soap_get_StringArray(struct soap *soap, StringArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_StringArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *StringArray::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_StringArray(soap, tag, this, type);
}

SOAP_FMAC1 StringArray * SOAP_FMAC2 soap_in_StringArray(struct soap *soap, const char *tag, StringArray *a, const char *type)
{	int i, j;
	char **p;
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE_MISMATCH;
		soap_revert(soap);
		return NULL;
	}
	if (soap->null)
	{	if ((a = (StringArray *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_StringArray, soap->type, soap->arrayType)))
			a->soap_default(soap);
			if (soap->body && soap_element_end_in(soap, tag))
				return NULL;
	}
	else if (!*soap->href)
	{	if (!(a = (StringArray *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_StringArray, soap->type, soap->arrayType)))
			return NULL;
		if (soap->alloced)
			a->soap_default(soap);
		if (soap->body)
		{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		a->__offset = j;
		if (j >= 0 && a->__size >= 0)
		{	a->__ptr = (char **)soap_malloc(soap, sizeof(char *) * a->__size);
			for (i = 0; i < a->__size; i++)
				soap_default_xsd__string(soap, a->__ptr+i);
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
					return NULL;
					}
				}
				if (!soap_in_xsd__string(soap, NULL, a->__ptr+i, "xsd:string"))
				{	if (soap->error == SOAP_NO_TAG)
					{	soap->error = SOAP_OK;
						break;
					}
					else
						return NULL;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (char **)soap_push_block(soap, sizeof(char *));
				if (!p)
					return NULL;
				soap_default_xsd__string(soap, p);
				if (!soap_in_xsd__string(soap, NULL, p, "xsd:string"))
				{	if (soap->error == SOAP_NO_TAG)
					{	soap->error = SOAP_OK;
						break;
					}
					else
						return NULL;
				}
			}
			soap_pop_block(soap);
			a->__ptr = (char **)soap_malloc(soap, soap->blist->size);
			soap_store_block(soap, (char*)a->__ptr);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (StringArray *)soap_id_forward(soap, soap->href, (void**)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_StringArray, soap->type, soap->arrayType), SOAP_TYPE_StringArray, sizeof(StringArray));
		if (soap->alloced)
			a->soap_default(soap);
		if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	}
	return a;
}

SOAP_FMAC1 StringArray * SOAP_FMAC2 soap_instantiate_StringArray(struct soap *soap, int n, const char *type, const char *arrayType)
{
DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_StringArray(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	soap->alloced = 1;
	struct soap_clist *cp = (struct soap_clist*)malloc(sizeof(struct soap_clist));
	if (!cp)
		return NULL;
	cp->next = soap->clist;
	cp->type = SOAP_TYPE_StringArray;
	cp->size = n; 
	soap->clist = cp;
	if (n < 0)
	{	cp->ptr = (void*)new StringArray;
	}
	else
	{	cp->ptr = (void*)new StringArray[n];
	}
	return (StringArray*)cp->ptr;
}

void FilenameArray::soap_serialize(struct soap *soap) const
{
	this->soap_mark(soap);
}

void FilenameArray::soap_mark(struct soap *soap) const
{
	int i;
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, this->__size, SOAP_TYPE_FilenameArray))
		for (i = 0; i < this->__size; i++)
		{	soap_embedded(soap, this->__ptr + i, SOAP_TYPE_api__Filename);
			this->__ptr[i].soap_mark(soap);
		}
}

void FilenameArray::soap_default(struct soap *soap)
{
	static FilenameArray a;
	memcpy(this, &a, sizeof(FilenameArray));
	this->__size = 0;
	this->__ptr = NULL;
	this->__offset = 0;
}

int FilenameArray::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_array_pointer_lookup(soap, this, (struct soap_array*)&this->__ptr, this->__size, SOAP_TYPE_FilenameArray, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			this->soap_out(soap, tag, 0, type);
		else
		{
			soap_set_embedded(soap, pp);
			this->soap_out(soap, tag, i, type);
		}
	else
		this->soap_out(soap, tag, 0, type);
	return soap_putindependent(soap);
}

int FilenameArray::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_FilenameArray(soap, tag, id, this, type);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_FilenameArray(struct soap *soap, const char *tag, int id, const FilenameArray *a, const char *type)
{
	int i;
	struct soap_plist *pp;
	int n = a->__size;
	char *t = soap_putsize(soap, "api:Filename", n + a->__offset);
	i = soap_array_pointer_lookup(soap, a, (struct soap_array*)&a->__ptr, n, SOAP_TYPE_FilenameArray, &pp);
	if (!a->__ptr)
	{	soap_element_null(soap, tag, i, t);
		return SOAP_OK;
	}
	if (id <= 0 && i)
	{	if (soap_is_embedded(soap, pp))
		{	soap_element_ref(soap, tag, 0, i);
			return SOAP_OK;
		}
		if (soap_is_single(soap, pp))
			i = 0;
	}
	else if (id > 0)
		i = id;
	soap_array_begin_out(soap, tag, i, t, soap_putoffset(soap, a->__offset));
	if (i)
		soap_set_embedded(soap, pp);
	for (i = 0; i < n; i++)
	{
		a->__ptr[i].soap_out(soap, "item", -1, "api:Filename");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *FilenameArray::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_FilenameArray(soap, this, tag, type);
}

SOAP_FMAC1 FilenameArray * SOAP_FMAC2 soap_get_FilenameArray(struct soap *soap, FilenameArray *p, const char *tag, const char *type)
{
	if ((p = soap_in_FilenameArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *FilenameArray::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_FilenameArray(soap, tag, this, type);
}

SOAP_FMAC1 FilenameArray * SOAP_FMAC2 soap_in_FilenameArray(struct soap *soap, const char *tag, FilenameArray *a, const char *type)
{	int i, j;
	api__Filename *p;
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE_MISMATCH;
		soap_revert(soap);
		return NULL;
	}
	if (soap->null)
	{	if ((a = (FilenameArray *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_FilenameArray, soap->type, soap->arrayType)))
			a->soap_default(soap);
			if (soap->body && soap_element_end_in(soap, tag))
				return NULL;
	}
	else if (!*soap->href)
	{	if (!(a = (FilenameArray *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_FilenameArray, soap->type, soap->arrayType)))
			return NULL;
		if (soap->alloced)
			a->soap_default(soap);
		if (soap->body)
		{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		a->__offset = j;
		if (j >= 0 && a->__size >= 0)
		{	a->__ptr = soap_instantiate_api__Filename(soap, a->__size, NULL, NULL);
			for (i = 0; i < a->__size; i++)
				(a->__ptr+i)->api__Filename::soap_default(soap);
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
					return NULL;
					}
				}
				if (!soap_in_api__Filename(soap, NULL, a->__ptr+i, "api:Filename"))
				{	if (soap->error == SOAP_NO_TAG)
					{	soap->error = SOAP_OK;
						break;
					}
					else
						return NULL;
				}
			}
		}
		else
		{	soap_new_block(soap);
			for (a->__size = 0; ; a->__size++)
			{	p = (api__Filename *)soap_push_block(soap, sizeof(api__Filename));
				if (!p)
					return NULL;
				p->api__Filename::soap_default(soap);
				if (!soap_in_api__Filename(soap, NULL, p, "api:Filename"))
				{	if (soap->error == SOAP_NO_TAG)
					{	soap->error = SOAP_OK;
						break;
					}
					else
						return NULL;
				}
			}
			soap_pop_block(soap);
			if (soap->blist->size)
				a->__ptr = soap_instantiate_api__Filename(soap, soap->blist->size/sizeof(api__Filename), NULL, NULL);
			else
				a->__ptr = NULL;
			soap_store_block(soap, (char*)a->__ptr);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (FilenameArray *)soap_id_forward(soap, soap->href, (void**)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_FilenameArray, soap->type, soap->arrayType), SOAP_TYPE_FilenameArray, sizeof(FilenameArray));
		if (soap->alloced)
			a->soap_default(soap);
		if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	}
	return a;
}

SOAP_FMAC1 FilenameArray * SOAP_FMAC2 soap_instantiate_FilenameArray(struct soap *soap, int n, const char *type, const char *arrayType)
{
DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_FilenameArray(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	soap->alloced = 1;
	struct soap_clist *cp = (struct soap_clist*)malloc(sizeof(struct soap_clist));
	if (!cp)
		return NULL;
	cp->next = soap->clist;
	cp->type = SOAP_TYPE_FilenameArray;
	cp->size = n; 
	soap->clist = cp;
	if (n < 0)
	{	cp->ptr = (void*)new FilenameArray;
	}
	else
	{	cp->ptr = (void*)new FilenameArray[n];
	}
	return (FilenameArray*)cp->ptr;
}

void api__File::soap_serialize(struct soap *soap) const
{
	if (!soap_reference(soap, this, SOAP_TYPE_api__File))
		this->soap_mark(soap);
}

void api__File::soap_mark(struct soap *soap) const
{
	soap_embedded(soap, &((api__File*)this)->s, SOAP_TYPE_xsd__long);
	soap_embedded(soap, &((api__File*)this)->h, SOAP_TYPE_xsd__string);
	soap_mark_xsd__string(soap, &((api__File*)this)->h);
	soap_embedded(soap, &((api__File*)this)->a, SOAP_TYPE_xsd__int);
	soap_embedded(soap, &((api__File*)this)->t, SOAP_TYPE_xsd__int);
	soap_embedded(soap, &((api__File*)this)->r, SOAP_TYPE_xsd__int);
	soap_embedded(soap, &((api__File*)this)->n, SOAP_TYPE_PointerToFilenameArray);
	soap_mark_PointerToFilenameArray(soap, &((api__File*)this)->n);
	soap_embedded(soap, &((api__File*)this)->v, SOAP_TYPE_PointerToStringArray);
	soap_mark_PointerToStringArray(soap, &((api__File*)this)->v);
}

void api__File::soap_default(struct soap *soap)
{
	static api__File a;
	memcpy(this, &a, sizeof(api__File));
	soap_default_xsd__long(soap, &((api__File*)this)->s);
	soap_default_xsd__string(soap, &((api__File*)this)->h);
	soap_default_xsd__int(soap, &((api__File*)this)->a);
	soap_default_xsd__int(soap, &((api__File*)this)->t);
	soap_default_xsd__int(soap, &((api__File*)this)->r);
	soap_default_PointerToFilenameArray(soap, &((api__File*)this)->n);
	soap_default_PointerToStringArray(soap, &((api__File*)this)->v);
}

int api__File::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, this, SOAP_TYPE_api__File, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			this->soap_out(soap, tag, 0, type);
		else
		{
			soap_set_embedded(soap, pp);
			this->soap_out(soap, tag, i, type);
		}
	else
		this->soap_out(soap, tag, 0, type);
	return soap_putindependent(soap);
}

int api__File::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_api__File(soap, tag, id, this, type);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_api__File(struct soap *soap, const char *tag, int id, const api__File *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_api__File), "api:File");
	soap_out_xsd__long(soap, "s", -1, &(((api__File*)a)->s), "xsd:long");
	soap_out_xsd__string(soap, "h", -1, &(((api__File*)a)->h), "xsd:string");
	soap_out_xsd__int(soap, "a", -1, &(((api__File*)a)->a), "xsd:int");
	soap_out_xsd__int(soap, "t", -1, &(((api__File*)a)->t), "xsd:int");
	soap_out_xsd__int(soap, "r", -1, &(((api__File*)a)->r), "xsd:int");
	soap_out_PointerToFilenameArray(soap, "n", -1, &(((api__File*)a)->n), "api:Filename");
	soap_out_PointerToStringArray(soap, "v", -1, &(((api__File*)a)->v), "xsd:string");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *api__File::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_api__File(soap, this, tag, type);
}

SOAP_FMAC1 api__File * SOAP_FMAC2 soap_get_api__File(struct soap *soap, api__File *p, const char *tag, const char *type)
{
	if ((p = soap_in_api__File(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *api__File::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_api__File(soap, tag, this, type);
}

SOAP_FMAC1 api__File * SOAP_FMAC2 soap_in_api__File(struct soap *soap, const char *tag, api__File *a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
		if (soap->mode & SOAP_XML_NIL)
		{	soap->error = SOAP_NULL;
			return NULL;
		}	else
			return a;
	if (!*soap->href)
	{	if (!(a = (api__File *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_api__File, soap->type, soap->arrayType)))
		{	soap->error = SOAP_TAG_MISMATCH;
			return NULL;
		}
		if (soap->alloced)
		{	a->soap_default(soap);
			if (soap->clist->type != SOAP_TYPE_api__File)
			{	soap_revert(soap);
				*soap->id = '\0';
				return (api__File *)a->soap_in(soap, tag, type);
			}
		}
		short soap_flag_s1 = 1, soap_flag_h1 = 1, soap_flag_a1 = 1, soap_flag_t1 = 1, soap_flag_r1 = 1, soap_flag_n1 = 1, soap_flag_v1 = 1;
		if (soap->body)
		{	for (;;)
			{
			soap->error = SOAP_TAG_MISMATCH;

			if (soap_flag_s1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__long(soap, "s", &(((api__File*)a)->s), "xsd:long"))
				{	soap_flag_s1 = 0;
					continue;
				}

			if (soap_flag_h1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__string(soap, "h", &(((api__File*)a)->h), "xsd:string"))
				{	soap_flag_h1 = 0;
					continue;
				}

			if (soap_flag_a1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "a", &(((api__File*)a)->a), "xsd:int"))
				{	soap_flag_a1 = 0;
					continue;
				}

			if (soap_flag_t1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "t", &(((api__File*)a)->t), "xsd:int"))
				{	soap_flag_t1 = 0;
					continue;
				}

			if (soap_flag_r1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "r", &(((api__File*)a)->r), "xsd:int"))
				{	soap_flag_r1 = 0;
					continue;
				}

			if (soap_flag_n1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToFilenameArray(soap, "n", &(((api__File*)a)->n), "api:Filename"))
				{	soap_flag_n1 = 0;
					continue;
				}

			if (soap_flag_v1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToStringArray(soap, "v", &(((api__File*)a)->v), "xsd:string"))
				{	soap_flag_v1 = 0;
					continue;
				}

			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (api__File *)soap_id_forward(soap, soap->href, (void**)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_api__File, soap->type, soap->arrayType), SOAP_TYPE_api__File, sizeof(api__File));
		if (soap->alloced)
			a->soap_default(soap);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 api__File * SOAP_FMAC2 soap_instantiate_api__File(struct soap *soap, int n, const char *type, const char *arrayType)
{
DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_api__File(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	soap->alloced = 1;
	struct soap_clist *cp = (struct soap_clist*)malloc(sizeof(struct soap_clist));
	if (!cp)
		return NULL;
	cp->next = soap->clist;
	cp->type = SOAP_TYPE_api__File;
	cp->size = n; 
	soap->clist = cp;
	if (n < 0)
	{	cp->ptr = (void*)new api__File;
	}
	else
	{	cp->ptr = (void*)new api__File[n];
	}
	return (api__File*)cp->ptr;
}

void api__versionResponse::soap_serialize(struct soap *soap) const
{
	if (!soap_reference(soap, this, SOAP_TYPE_api__versionResponse))
		this->soap_mark(soap);
}

void api__versionResponse::soap_mark(struct soap *soap) const
{
	soap_embedded(soap, &((api__versionResponse*)this)->_r, SOAP_TYPE_xsd__string);
	soap_mark_xsd__string(soap, &((api__versionResponse*)this)->_r);
}

void api__versionResponse::soap_default(struct soap *soap)
{
	static api__versionResponse a;
	memcpy(this, &a, sizeof(api__versionResponse));
	soap_default_xsd__string(soap, &((api__versionResponse*)this)->_r);
}

int api__versionResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, this, SOAP_TYPE_api__versionResponse, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			this->soap_out(soap, tag, 0, type);
		else
		{
			soap_set_embedded(soap, pp);
			this->soap_out(soap, tag, i, type);
		}
	else
		this->soap_out(soap, tag, 0, type);
	return soap_putindependent(soap);
}

int api__versionResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_api__versionResponse(soap, tag, id, this, type);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_api__versionResponse(struct soap *soap, const char *tag, int id, const api__versionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_api__versionResponse), "api:versionResponse");
	soap_out_xsd__string(soap, "r", -1, &(((api__versionResponse*)a)->_r), "xsd:string");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

void *api__versionResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_api__versionResponse(soap, this, tag, type);
}

SOAP_FMAC1 api__versionResponse * SOAP_FMAC2 soap_get_api__versionResponse(struct soap *soap, api__versionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_api__versionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

void *api__versionResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_api__versionResponse(soap, tag, this, type);
}

SOAP_FMAC1 api__versionResponse * SOAP_FMAC2 soap_in_api__versionResponse(struct soap *soap, const char *tag, api__versionResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
		if (soap->mode & SOAP_XML_NIL)
		{	soap->error = SOAP_NULL;
			return NULL;
		}	else
			return a;
	if (!*soap->href)
	{	if (!(a = (api__versionResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_api__versionResponse, soap->type, soap->arrayType)))
		{	soap->error = SOAP_TAG_MISMATCH;
			return NULL;
		}
		if (soap->alloced)
		{	a->soap_default(soap);
			if (soap->clist->type != SOAP_TYPE_api__versionResponse)
			{	soap_revert(soap);
				*soap->id = '\0';
				return (api__versionResponse *)a->soap_in(soap, tag, type);
			}
		}
		short soap_flag__r1 = 1;
		if (soap->body)
		{	for (;;)
			{
			soap->error = SOAP_TAG_MISMATCH;

			if (soap_flag__r1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__string(soap, NULL, &(((api__versionResponse*)a)->_r), "xsd:string"))
				{	soap_flag__r1 = 0;
					continue;
				}

			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
			return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (api__versionResponse *)soap_id_forward(soap, soap->href, (void**)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_api__versionResponse, soap->type, soap->arrayType), SOAP_TYPE_api__versionResponse, sizeof(api__versionResponse));
		if (soap->alloced)
			a->soap_default(soap);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 api__versionResponse * SOAP_FMAC2 soap_instantiate_api__versionResponse(struct soap *soap, int n, const char *type, const char *arrayType)
{
DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_api__versionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	soap->alloced = 1;
	struct soap_clist *cp = (struct soap_clist*)malloc(sizeof(struct soap_clist));
	if (!cp)
		return NULL;
	cp->next = soap->clist;
	cp->type = SOAP_TYPE_api__versionResponse;
	cp->size = n; 
	soap->clist = cp;
	if (n < 0)
	{	cp->ptr = (void*)new api__versionResponse;
	}
	else
	{	cp->ptr = (void*)new api__versionResponse[n];
	}
	return (api__versionResponse*)cp->ptr;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_SOAP_ENV__Fault))
		soap_mark_SOAP_ENV__Fault(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	soap_embedded(soap, &a->faultcode, SOAP_TYPE_string);
	soap_mark_string(soap, &a->faultcode);
	soap_embedded(soap, &a->faultstring, SOAP_TYPE_string);
	soap_mark_string(soap, &a->faultstring);
	soap_embedded(soap, &a->faultactor, SOAP_TYPE_string);
	soap_mark_string(soap, &a->faultactor);
	soap_embedded(soap, &a->detail, SOAP_TYPE_string);
	soap_mark_string(soap, &a->detail);
	soap_embedded(soap, &a->SOAP_ENV__Code, SOAP_TYPE_PointerToSOAP_ENV__Code);
	soap_mark_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_embedded(soap, &a->SOAP_ENV__Reason, SOAP_TYPE_string);
	soap_mark_string(soap, &a->SOAP_ENV__Reason);
	soap_embedded(soap, &a->SOAP_ENV__Detail, SOAP_TYPE_string);
	soap_mark_string(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	soap_default_string(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	soap_default_string(soap, &a->detail);
	soap_default_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_default_string(soap, &a->SOAP_ENV__Reason);
	soap_default_string(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_SOAP_ENV__Fault, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_SOAP_ENV__Fault(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_SOAP_ENV__Fault(soap, tag, i, a, type);
		}
	else
		soap_out_SOAP_ENV__Fault(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out_string(soap, "faultcode", -1, &a->faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_string(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_string(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC1 struct SOAP_ENV__Fault * SOAP_FMAC2 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Fault * SOAP_FMAC2 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE_MISMATCH;
		soap_revert(soap);
		return NULL;
	}
	if (soap->null)
	{	if (soap->mode & SOAP_XML_NIL)
		{	soap->error = SOAP_NULL;
			return NULL;
		}
		else
			return a;
	}
	if (!*soap->href)
	{	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0);
		if (!a)
			return NULL;
		if (soap->alloced)
			soap_default_SOAP_ENV__Fault(soap, a);
		if (soap->body)
		{	for (;;)
			{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode = 0;
					continue;
				}
			if (soap_flag_faultstring && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "faultstring", &a->faultstring, ""))
				{	soap_flag_faultstring = 0;
					continue;
				}
			if (soap_flag_faultactor && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "faultactor", &a->faultactor, ""))
				{	soap_flag_faultactor = 0;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "detail", &a->detail, ""))
				{	soap_flag_detail = 0;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code = 0;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason = 0;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail = 0;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
			{	return NULL;
			}
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0), SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault));
		if (soap->alloced)
			soap_default_SOAP_ENV__Fault(soap, a);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_SOAP_ENV__Code))
		soap_mark_SOAP_ENV__Code(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	soap_embedded(soap, &a->SOAP_ENV__Value, SOAP_TYPE_string);
	soap_mark_string(soap, &a->SOAP_ENV__Value);
	soap_embedded(soap, &a->SOAP_ENV__Node, SOAP_TYPE_string);
	soap_mark_string(soap, &a->SOAP_ENV__Node);
	soap_embedded(soap, &a->SOAP_ENV__Role, SOAP_TYPE_string);
	soap_mark_string(soap, &a->SOAP_ENV__Role);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	soap_default_string(soap, &a->SOAP_ENV__Value);
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_SOAP_ENV__Code, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_SOAP_ENV__Code(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_SOAP_ENV__Code(soap, tag, i, a, type);
		}
	else
		soap_out_SOAP_ENV__Code(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out_string(soap, "SOAP-ENV:Value", -1, &a->SOAP_ENV__Value, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC1 struct SOAP_ENV__Code * SOAP_FMAC2 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Code * SOAP_FMAC2 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1;
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE_MISMATCH;
		soap_revert(soap);
		return NULL;
	}
	if (soap->null)
	{	if (soap->mode & SOAP_XML_NIL)
		{	soap->error = SOAP_NULL;
			return NULL;
		}
		else
			return a;
	}
	if (!*soap->href)
	{	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (!a)
			return NULL;
		if (soap->alloced)
			soap_default_SOAP_ENV__Code(soap, a);
		if (soap->body)
		{	for (;;)
			{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value = 0;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, ""))
				{	soap_flag_SOAP_ENV__Node = 0;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, ""))
				{	soap_flag_SOAP_ENV__Role = 0;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
			{	return NULL;
			}
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0), SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code));
		if (soap->alloced)
			soap_default_SOAP_ENV__Code(soap, a);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_SOAP_ENV__Header))
		soap_mark_SOAP_ENV__Header(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	/* transient dummy skipped */
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	/* transient dummy skipped */
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_SOAP_ENV__Header, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_SOAP_ENV__Header(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_SOAP_ENV__Header(soap, tag, i, a, type);
		}
	else
		soap_out_SOAP_ENV__Header(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);
	/* transient dummy skipped */
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC1 struct SOAP_ENV__Header * SOAP_FMAC2 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Header * SOAP_FMAC2 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE_MISMATCH;
		soap_revert(soap);
		return NULL;
	}
	if (soap->null)
	{	if (soap->mode & SOAP_XML_NIL)
		{	soap->error = SOAP_NULL;
			return NULL;
		}
		else
			return a;
	}
	if (!*soap->href)
	{	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0);
		if (!a)
			return NULL;
		if (soap->alloced)
			soap_default_SOAP_ENV__Header(soap, a);
		if (soap->body)
		{	for (;;)
			{	soap->error = SOAP_TAG_MISMATCH;
		/* transient dummy skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
			{	return NULL;
			}
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0), SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header));
		if (soap->alloced)
			soap_default_SOAP_ENV__Header(soap, a);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_api__search(struct soap *soap, struct api__search const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_api__search))
		soap_mark_api__search(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_api__search(struct soap *soap, const struct api__search *a)
{
	soap_embedded(soap, &a->p, SOAP_TYPE_xsd__string);
	soap_mark_xsd__string(soap, &a->p);
	soap_embedded(soap, &a->e, SOAP_TYPE_xsd__string);
	soap_mark_xsd__string(soap, &a->e);
	soap_embedded(soap, &a->a, SOAP_TYPE_xsd__int);
	soap_embedded(soap, &a->l, SOAP_TYPE_xsd__long);
	soap_embedded(soap, &a->u, SOAP_TYPE_xsd__long);
	soap_embedded(soap, &a->f, SOAP_TYPE_xsd__int);
	soap_embedded(soap, &a->m, SOAP_TYPE_xsd__int);
	soap_embedded(soap, &a->o, SOAP_TYPE_xsd__int);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_api__search(struct soap *soap, struct api__search *a)
{
	soap_default_xsd__string(soap, &a->p);
	soap_default_xsd__string(soap, &a->e);
	soap_default_xsd__int(soap, &a->a);
	soap_default_xsd__long(soap, &a->l);
	soap_default_xsd__long(soap, &a->u);
	soap_default_xsd__int(soap, &a->f);
	soap_default_xsd__int(soap, &a->m);
	soap_default_xsd__int(soap, &a->o);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_api__search(struct soap *soap, struct api__search *a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_api__search, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_api__search(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_api__search(soap, tag, i, a, type);
		}
	else
		soap_out_api__search(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_api__search(struct soap *soap, const char *tag, int id, const struct api__search *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_api__search), type);
	soap_out_xsd__string(soap, "p", -1, &a->p, "xsd:string");
	soap_out_xsd__string(soap, "e", -1, &a->e, "xsd:string");
	soap_out_xsd__int(soap, "a", -1, &a->a, "xsd:int");
	soap_out_xsd__long(soap, "l", -1, &a->l, "xsd:long");
	soap_out_xsd__long(soap, "u", -1, &a->u, "xsd:long");
	soap_out_xsd__int(soap, "f", -1, &a->f, "xsd:int");
	soap_out_xsd__int(soap, "m", -1, &a->m, "xsd:int");
	soap_out_xsd__int(soap, "o", -1, &a->o, "xsd:int");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC1 struct api__search * SOAP_FMAC2 soap_get_api__search(struct soap *soap, struct api__search *p, const char *tag, const char *type)
{
	if ((p = soap_in_api__search(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 struct api__search * SOAP_FMAC2 soap_in_api__search(struct soap *soap, const char *tag, struct api__search *a, const char *type)
{
	short soap_flag_p = 1, soap_flag_e = 1, soap_flag_a = 1, soap_flag_l = 1, soap_flag_u = 1, soap_flag_f = 1, soap_flag_m = 1, soap_flag_o = 1;
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE_MISMATCH;
		soap_revert(soap);
		return NULL;
	}
	if (soap->null)
	{	if (soap->mode & SOAP_XML_NIL)
		{	soap->error = SOAP_NULL;
			return NULL;
		}
		else
			return a;
	}
	if (!*soap->href)
	{	a = (struct api__search *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_api__search, sizeof(struct api__search), 0);
		if (!a)
			return NULL;
		if (soap->alloced)
			soap_default_api__search(soap, a);
		if (soap->body)
		{	for (;;)
			{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_p && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__string(soap, "p", &a->p, "xsd:string"))
				{	soap_flag_p = 0;
					continue;
				}
			if (soap_flag_e && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__string(soap, "e", &a->e, "xsd:string"))
				{	soap_flag_e = 0;
					continue;
				}
			if (soap_flag_a && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "a", &a->a, "xsd:int"))
				{	soap_flag_a = 0;
					continue;
				}
			if (soap_flag_l && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__long(soap, "l", &a->l, "xsd:long"))
				{	soap_flag_l = 0;
					continue;
				}
			if (soap_flag_u && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__long(soap, "u", &a->u, "xsd:long"))
				{	soap_flag_u = 0;
					continue;
				}
			if (soap_flag_f && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "f", &a->f, "xsd:int"))
				{	soap_flag_f = 0;
					continue;
				}
			if (soap_flag_m && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "m", &a->m, "xsd:int"))
				{	soap_flag_m = 0;
					continue;
				}
			if (soap_flag_o && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "o", &a->o, "xsd:int"))
				{	soap_flag_o = 0;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
			{	return NULL;
			}
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (struct api__search *)soap_id_forward(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_api__search, sizeof(struct api__search), 0), SOAP_TYPE_api__search, sizeof(struct api__search));
		if (soap->alloced)
			soap_default_api__search(soap, a);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_api__searchFile(struct soap *soap, struct api__searchFile const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_api__searchFile))
		soap_mark_api__searchFile(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_api__searchFile(struct soap *soap, const struct api__searchFile *a)
{
	soap_embedded(soap, &a->s, SOAP_TYPE_xsd__long);
	soap_embedded(soap, &a->h, SOAP_TYPE_xsd__string);
	soap_mark_xsd__string(soap, &a->h);
	soap_embedded(soap, &a->o, SOAP_TYPE_xsd__int);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_api__searchFile(struct soap *soap, struct api__searchFile *a)
{
	soap_default_xsd__long(soap, &a->s);
	soap_default_xsd__string(soap, &a->h);
	soap_default_xsd__int(soap, &a->o);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_api__searchFile(struct soap *soap, struct api__searchFile *a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_api__searchFile, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_api__searchFile(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_api__searchFile(soap, tag, i, a, type);
		}
	else
		soap_out_api__searchFile(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_api__searchFile(struct soap *soap, const char *tag, int id, const struct api__searchFile *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_api__searchFile), type);
	soap_out_xsd__long(soap, "s", -1, &a->s, "xsd:long");
	soap_out_xsd__string(soap, "h", -1, &a->h, "xsd:string");
	soap_out_xsd__int(soap, "o", -1, &a->o, "xsd:int");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC1 struct api__searchFile * SOAP_FMAC2 soap_get_api__searchFile(struct soap *soap, struct api__searchFile *p, const char *tag, const char *type)
{
	if ((p = soap_in_api__searchFile(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 struct api__searchFile * SOAP_FMAC2 soap_in_api__searchFile(struct soap *soap, const char *tag, struct api__searchFile *a, const char *type)
{
	short soap_flag_s = 1, soap_flag_h = 1, soap_flag_o = 1;
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE_MISMATCH;
		soap_revert(soap);
		return NULL;
	}
	if (soap->null)
	{	if (soap->mode & SOAP_XML_NIL)
		{	soap->error = SOAP_NULL;
			return NULL;
		}
		else
			return a;
	}
	if (!*soap->href)
	{	a = (struct api__searchFile *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_api__searchFile, sizeof(struct api__searchFile), 0);
		if (!a)
			return NULL;
		if (soap->alloced)
			soap_default_api__searchFile(soap, a);
		if (soap->body)
		{	for (;;)
			{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_s && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__long(soap, "s", &a->s, "xsd:long"))
				{	soap_flag_s = 0;
					continue;
				}
			if (soap_flag_h && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__string(soap, "h", &a->h, "xsd:string"))
				{	soap_flag_h = 0;
					continue;
				}
			if (soap_flag_o && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__int(soap, "o", &a->o, "xsd:int"))
				{	soap_flag_o = 0;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
			{	return NULL;
			}
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (struct api__searchFile *)soap_id_forward(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_api__searchFile, sizeof(struct api__searchFile), 0), SOAP_TYPE_api__searchFile, sizeof(struct api__searchFile));
		if (soap->alloced)
			soap_default_api__searchFile(soap, a);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_api__version(struct soap *soap, struct api__version const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_api__version))
		soap_mark_api__version(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_api__version(struct soap *soap, const struct api__version *a)
{
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_api__version(struct soap *soap, struct api__version *a)
{
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_api__version(struct soap *soap, struct api__version *a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_api__version, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_api__version(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_api__version(soap, tag, i, a, type);
		}
	else
		soap_out_api__version(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_api__version(struct soap *soap, const char *tag, int id, const struct api__version *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_api__version), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC1 struct api__version * SOAP_FMAC2 soap_get_api__version(struct soap *soap, struct api__version *p, const char *tag, const char *type)
{
	if ((p = soap_in_api__version(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 struct api__version * SOAP_FMAC2 soap_in_api__version(struct soap *soap, const char *tag, struct api__version *a, const char *type)
{;
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type))
	{	soap->error = SOAP_TYPE_MISMATCH;
		soap_revert(soap);
		return NULL;
	}
	if (soap->null)
	{	if (soap->mode & SOAP_XML_NIL)
		{	soap->error = SOAP_NULL;
			return NULL;
		}
		else
			return a;
	}
	if (!*soap->href)
	{	a = (struct api__version *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_api__version, sizeof(struct api__version), 0);
		if (!a)
			return NULL;
		if (soap->alloced)
			soap_default_api__version(soap, a);
		if (soap->body)
		{	for (;;)
			{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
			{	return NULL;
			}
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
		}
	}
	else
	{	a = (struct api__version *)soap_id_forward(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_api__version, sizeof(struct api__version), 0), SOAP_TYPE_api__version, sizeof(struct api__version));
		if (soap->alloced)
			soap_default_api__version(soap, a);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_PointerToSOAP_ENV__Code))
		soap_mark_PointerToSOAP_ENV__Code(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_mark_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **a)
{
	*a = NULL;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_PointerToSOAP_ENV__Code, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_PointerToSOAP_ENV__Code(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_PointerToSOAP_ENV__Code(soap, tag, i, a, type);
		}
	else
		soap_out_PointerToSOAP_ENV__Code(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_embedded_id(soap, id, a, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (!*a)
		soap_element_null(soap, tag, id, type);
	else
	{	struct soap_plist *pp;
		int i = soap_pointer_lookup(soap, *a, SOAP_TYPE_SOAP_ENV__Code, &pp);
		if (i)
			if (soap_is_embedded(soap, pp))
				soap_element_ref(soap, tag, id, i);
			else if (soap_is_single(soap, pp))
				soap_out_SOAP_ENV__Code(soap, tag, 0, *a, type);
			else
			{	soap_set_embedded(soap, pp);
				soap_out_SOAP_ENV__Code(soap, tag, i, *a, type);
			}
		else
			soap_out_SOAP_ENV__Code(soap, tag, soap_pointer_enter(soap, *a, SOAP_TYPE_SOAP_ENV__Code, &pp), *a, type);
	}
	return SOAP_OK;
}

SOAP_FMAC1 struct SOAP_ENV__Code ** SOAP_FMAC2 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Code ** SOAP_FMAC2 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	struct SOAP_ENV__Code *p;
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
	{	a = (struct SOAP_ENV__Code **)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToSOAP_ENV__Code, sizeof(struct SOAP_ENV__Code *), 1);
		if (a)
			*a = NULL;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	else if (!*soap->href)
	{	soap_revert(soap);
		if (a)
		{	if ((p = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
				*a = p;
			else
				a = NULL;
		}
		else if ((p = soap_in_SOAP_ENV__Code(soap, tag, NULL, type)))
		{	a = (struct SOAP_ENV__Code **)soap_id_enter(soap, "", NULL, SOAP_TYPE_PointerToSOAP_ENV__Code, sizeof(struct SOAP_ENV__Code *), 0);
			if (a)
				*a = p;
		}
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToSOAP_ENV__Code, sizeof(struct SOAP_ENV__Code *), 1), SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_PointerToapi__searchResponse(struct soap *soap, api__searchResponse *const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_PointerToapi__searchResponse))
		soap_mark_PointerToapi__searchResponse(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_PointerToapi__searchResponse(struct soap *soap, api__searchResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_api__searchResponse))
		(*a)->soap_mark(soap);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_PointerToapi__searchResponse(struct soap *soap, api__searchResponse **a)
{
	*a = NULL;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_PointerToapi__searchResponse(struct soap *soap, api__searchResponse **a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_PointerToapi__searchResponse, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_PointerToapi__searchResponse(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_PointerToapi__searchResponse(soap, tag, i, a, type);
		}
	else
		soap_out_PointerToapi__searchResponse(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_PointerToapi__searchResponse(struct soap *soap, const char *tag, int id, api__searchResponse *const*a, const char *type)
{
	id = soap_embedded_id(soap, id, a, SOAP_TYPE_PointerToapi__searchResponse);
	if (!*a)
		soap_element_null(soap, tag, id, type);
	else
	{	struct soap_plist *pp;
		int i = soap_pointer_lookup(soap, *a, SOAP_TYPE_api__searchResponse, &pp);
		if (i)
			if (soap_is_embedded(soap, pp))
				soap_element_ref(soap, tag, id, i);
			else if (soap_is_single(soap, pp))
				(*a)->soap_out(soap, tag, 0, type);
			else
			{	soap_set_embedded(soap, pp);
				(*a)->soap_out(soap, tag, i, type);
			}
		else
			(*a)->soap_out(soap, tag, soap_pointer_enter(soap, *a, SOAP_TYPE_api__searchResponse, &pp), type);
	}
	return SOAP_OK;
}

SOAP_FMAC1 api__searchResponse ** SOAP_FMAC2 soap_get_PointerToapi__searchResponse(struct soap *soap, api__searchResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToapi__searchResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 api__searchResponse ** SOAP_FMAC2 soap_in_PointerToapi__searchResponse(struct soap *soap, const char *tag, api__searchResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
	{	a = (api__searchResponse **)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToapi__searchResponse, sizeof(api__searchResponse *), 1);
		if (a)
			*a = NULL;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	else if (!*soap->href)
	{	soap_revert(soap);
		a = (api__searchResponse **)soap_id_enter(soap, "", a, SOAP_TYPE_PointerToapi__searchResponse, sizeof(api__searchResponse *), 0);
		if (a)
		{	if (soap->alloced || !*a)
				*a = (api__searchResponse *)soap_instantiate_api__searchResponse(soap, -1, soap->type, soap->arrayType);
			if (!*a)
				a = NULL;
			else
			{	(*a)->soap_default(soap);
				if (!(*a)->soap_in(soap, tag, NULL))
					a = NULL;
			}
		}
	}
	else
	{	a = (api__searchResponse **)soap_id_lookup(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToapi__searchResponse, sizeof(api__searchResponse *), 1), SOAP_TYPE_api__searchResponse, sizeof(api__searchResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_PointerToapi__searchFileResponse(struct soap *soap, api__searchFileResponse *const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_PointerToapi__searchFileResponse))
		soap_mark_PointerToapi__searchFileResponse(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_PointerToapi__searchFileResponse(struct soap *soap, api__searchFileResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_api__searchFileResponse))
		(*a)->soap_mark(soap);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_PointerToapi__searchFileResponse(struct soap *soap, api__searchFileResponse **a)
{
	*a = NULL;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_PointerToapi__searchFileResponse(struct soap *soap, api__searchFileResponse **a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_PointerToapi__searchFileResponse, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_PointerToapi__searchFileResponse(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_PointerToapi__searchFileResponse(soap, tag, i, a, type);
		}
	else
		soap_out_PointerToapi__searchFileResponse(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_PointerToapi__searchFileResponse(struct soap *soap, const char *tag, int id, api__searchFileResponse *const*a, const char *type)
{
	id = soap_embedded_id(soap, id, a, SOAP_TYPE_PointerToapi__searchFileResponse);
	if (!*a)
		soap_element_null(soap, tag, id, type);
	else
	{	struct soap_plist *pp;
		int i = soap_pointer_lookup(soap, *a, SOAP_TYPE_api__searchFileResponse, &pp);
		if (i)
			if (soap_is_embedded(soap, pp))
				soap_element_ref(soap, tag, id, i);
			else if (soap_is_single(soap, pp))
				(*a)->soap_out(soap, tag, 0, type);
			else
			{	soap_set_embedded(soap, pp);
				(*a)->soap_out(soap, tag, i, type);
			}
		else
			(*a)->soap_out(soap, tag, soap_pointer_enter(soap, *a, SOAP_TYPE_api__searchFileResponse, &pp), type);
	}
	return SOAP_OK;
}

SOAP_FMAC1 api__searchFileResponse ** SOAP_FMAC2 soap_get_PointerToapi__searchFileResponse(struct soap *soap, api__searchFileResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToapi__searchFileResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 api__searchFileResponse ** SOAP_FMAC2 soap_in_PointerToapi__searchFileResponse(struct soap *soap, const char *tag, api__searchFileResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
	{	a = (api__searchFileResponse **)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToapi__searchFileResponse, sizeof(api__searchFileResponse *), 1);
		if (a)
			*a = NULL;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	else if (!*soap->href)
	{	soap_revert(soap);
		a = (api__searchFileResponse **)soap_id_enter(soap, "", a, SOAP_TYPE_PointerToapi__searchFileResponse, sizeof(api__searchFileResponse *), 0);
		if (a)
		{	if (soap->alloced || !*a)
				*a = (api__searchFileResponse *)soap_instantiate_api__searchFileResponse(soap, -1, soap->type, soap->arrayType);
			if (!*a)
				a = NULL;
			else
			{	(*a)->soap_default(soap);
				if (!(*a)->soap_in(soap, tag, NULL))
					a = NULL;
			}
		}
	}
	else
	{	a = (api__searchFileResponse **)soap_id_lookup(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToapi__searchFileResponse, sizeof(api__searchFileResponse *), 1), SOAP_TYPE_api__searchFileResponse, sizeof(api__searchFileResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_PointerToapi__versionResponse(struct soap *soap, api__versionResponse *const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_PointerToapi__versionResponse))
		soap_mark_PointerToapi__versionResponse(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_PointerToapi__versionResponse(struct soap *soap, api__versionResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_api__versionResponse))
		(*a)->soap_mark(soap);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_PointerToapi__versionResponse(struct soap *soap, api__versionResponse **a)
{
	*a = NULL;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_PointerToapi__versionResponse(struct soap *soap, api__versionResponse **a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_PointerToapi__versionResponse, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_PointerToapi__versionResponse(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_PointerToapi__versionResponse(soap, tag, i, a, type);
		}
	else
		soap_out_PointerToapi__versionResponse(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_PointerToapi__versionResponse(struct soap *soap, const char *tag, int id, api__versionResponse *const*a, const char *type)
{
	id = soap_embedded_id(soap, id, a, SOAP_TYPE_PointerToapi__versionResponse);
	if (!*a)
		soap_element_null(soap, tag, id, type);
	else
	{	struct soap_plist *pp;
		int i = soap_pointer_lookup(soap, *a, SOAP_TYPE_api__versionResponse, &pp);
		if (i)
			if (soap_is_embedded(soap, pp))
				soap_element_ref(soap, tag, id, i);
			else if (soap_is_single(soap, pp))
				(*a)->soap_out(soap, tag, 0, type);
			else
			{	soap_set_embedded(soap, pp);
				(*a)->soap_out(soap, tag, i, type);
			}
		else
			(*a)->soap_out(soap, tag, soap_pointer_enter(soap, *a, SOAP_TYPE_api__versionResponse, &pp), type);
	}
	return SOAP_OK;
}

SOAP_FMAC1 api__versionResponse ** SOAP_FMAC2 soap_get_PointerToapi__versionResponse(struct soap *soap, api__versionResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToapi__versionResponse(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 api__versionResponse ** SOAP_FMAC2 soap_in_PointerToapi__versionResponse(struct soap *soap, const char *tag, api__versionResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
	{	a = (api__versionResponse **)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToapi__versionResponse, sizeof(api__versionResponse *), 1);
		if (a)
			*a = NULL;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	else if (!*soap->href)
	{	soap_revert(soap);
		a = (api__versionResponse **)soap_id_enter(soap, "", a, SOAP_TYPE_PointerToapi__versionResponse, sizeof(api__versionResponse *), 0);
		if (a)
		{	if (soap->alloced || !*a)
				*a = (api__versionResponse *)soap_instantiate_api__versionResponse(soap, -1, soap->type, soap->arrayType);
			if (!*a)
				a = NULL;
			else
			{	(*a)->soap_default(soap);
				if (!(*a)->soap_in(soap, tag, NULL))
					a = NULL;
			}
		}
	}
	else
	{	a = (api__versionResponse **)soap_id_lookup(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToapi__versionResponse, sizeof(api__versionResponse *), 1), SOAP_TYPE_api__versionResponse, sizeof(api__versionResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_PointerToapi__Filename(struct soap *soap, api__Filename *const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_PointerToapi__Filename))
		soap_mark_PointerToapi__Filename(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_PointerToapi__Filename(struct soap *soap, api__Filename *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_api__Filename))
		(*a)->soap_mark(soap);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_PointerToapi__Filename(struct soap *soap, api__Filename **a)
{
	*a = NULL;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_PointerToapi__Filename(struct soap *soap, api__Filename **a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_PointerToapi__Filename, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_PointerToapi__Filename(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_PointerToapi__Filename(soap, tag, i, a, type);
		}
	else
		soap_out_PointerToapi__Filename(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_PointerToapi__Filename(struct soap *soap, const char *tag, int id, api__Filename *const*a, const char *type)
{
	id = soap_embedded_id(soap, id, a, SOAP_TYPE_PointerToapi__Filename);
	if (!*a)
		soap_element_null(soap, tag, id, type);
	else
	{	struct soap_plist *pp;
		int i = soap_pointer_lookup(soap, *a, SOAP_TYPE_api__Filename, &pp);
		if (i)
			if (soap_is_embedded(soap, pp))
				soap_element_ref(soap, tag, id, i);
			else if (soap_is_single(soap, pp))
				(*a)->soap_out(soap, tag, 0, type);
			else
			{	soap_set_embedded(soap, pp);
				(*a)->soap_out(soap, tag, i, type);
			}
		else
			(*a)->soap_out(soap, tag, soap_pointer_enter(soap, *a, SOAP_TYPE_api__Filename, &pp), type);
	}
	return SOAP_OK;
}

SOAP_FMAC1 api__Filename ** SOAP_FMAC2 soap_get_PointerToapi__Filename(struct soap *soap, api__Filename **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToapi__Filename(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 api__Filename ** SOAP_FMAC2 soap_in_PointerToapi__Filename(struct soap *soap, const char *tag, api__Filename **a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
	{	a = (api__Filename **)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToapi__Filename, sizeof(api__Filename *), 1);
		if (a)
			*a = NULL;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	else if (!*soap->href)
	{	soap_revert(soap);
		a = (api__Filename **)soap_id_enter(soap, "", a, SOAP_TYPE_PointerToapi__Filename, sizeof(api__Filename *), 0);
		if (a)
		{	if (soap->alloced || !*a)
				*a = (api__Filename *)soap_instantiate_api__Filename(soap, -1, soap->type, soap->arrayType);
			if (!*a)
				a = NULL;
			else
			{	(*a)->soap_default(soap);
				if (!(*a)->soap_in(soap, tag, NULL))
					a = NULL;
			}
		}
	}
	else
	{	a = (api__Filename **)soap_id_lookup(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToapi__Filename, sizeof(api__Filename *), 1), SOAP_TYPE_api__Filename, sizeof(api__Filename), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_PointerToapi__SearchResult(struct soap *soap, api__SearchResult *const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_PointerToapi__SearchResult))
		soap_mark_PointerToapi__SearchResult(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_PointerToapi__SearchResult(struct soap *soap, api__SearchResult *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_api__SearchResult))
		(*a)->soap_mark(soap);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_PointerToapi__SearchResult(struct soap *soap, api__SearchResult **a)
{
	*a = NULL;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_PointerToapi__SearchResult(struct soap *soap, api__SearchResult **a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_PointerToapi__SearchResult, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_PointerToapi__SearchResult(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_PointerToapi__SearchResult(soap, tag, i, a, type);
		}
	else
		soap_out_PointerToapi__SearchResult(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_PointerToapi__SearchResult(struct soap *soap, const char *tag, int id, api__SearchResult *const*a, const char *type)
{
	id = soap_embedded_id(soap, id, a, SOAP_TYPE_PointerToapi__SearchResult);
	if (!*a)
		soap_element_null(soap, tag, id, type);
	else
	{	struct soap_plist *pp;
		int i = soap_pointer_lookup(soap, *a, SOAP_TYPE_api__SearchResult, &pp);
		if (i)
			if (soap_is_embedded(soap, pp))
				soap_element_ref(soap, tag, id, i);
			else if (soap_is_single(soap, pp))
				(*a)->soap_out(soap, tag, 0, type);
			else
			{	soap_set_embedded(soap, pp);
				(*a)->soap_out(soap, tag, i, type);
			}
		else
			(*a)->soap_out(soap, tag, soap_pointer_enter(soap, *a, SOAP_TYPE_api__SearchResult, &pp), type);
	}
	return SOAP_OK;
}

SOAP_FMAC1 api__SearchResult ** SOAP_FMAC2 soap_get_PointerToapi__SearchResult(struct soap *soap, api__SearchResult **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToapi__SearchResult(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 api__SearchResult ** SOAP_FMAC2 soap_in_PointerToapi__SearchResult(struct soap *soap, const char *tag, api__SearchResult **a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
	{	a = (api__SearchResult **)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToapi__SearchResult, sizeof(api__SearchResult *), 1);
		if (a)
			*a = NULL;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	else if (!*soap->href)
	{	soap_revert(soap);
		a = (api__SearchResult **)soap_id_enter(soap, "", a, SOAP_TYPE_PointerToapi__SearchResult, sizeof(api__SearchResult *), 0);
		if (a)
		{	if (soap->alloced || !*a)
				*a = (api__SearchResult *)soap_instantiate_api__SearchResult(soap, -1, soap->type, soap->arrayType);
			if (!*a)
				a = NULL;
			else
			{	(*a)->soap_default(soap);
				if (!(*a)->soap_in(soap, tag, NULL))
					a = NULL;
			}
		}
	}
	else
	{	a = (api__SearchResult **)soap_id_lookup(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToapi__SearchResult, sizeof(api__SearchResult *), 1), SOAP_TYPE_api__SearchResult, sizeof(api__SearchResult), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_PointerToapi__File(struct soap *soap, api__File *const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_PointerToapi__File))
		soap_mark_PointerToapi__File(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_PointerToapi__File(struct soap *soap, api__File *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_api__File))
		(*a)->soap_mark(soap);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_PointerToapi__File(struct soap *soap, api__File **a)
{
	*a = NULL;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_PointerToapi__File(struct soap *soap, api__File **a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_PointerToapi__File, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_PointerToapi__File(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_PointerToapi__File(soap, tag, i, a, type);
		}
	else
		soap_out_PointerToapi__File(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_PointerToapi__File(struct soap *soap, const char *tag, int id, api__File *const*a, const char *type)
{
	id = soap_embedded_id(soap, id, a, SOAP_TYPE_PointerToapi__File);
	if (!*a)
		soap_element_null(soap, tag, id, type);
	else
	{	struct soap_plist *pp;
		int i = soap_pointer_lookup(soap, *a, SOAP_TYPE_api__File, &pp);
		if (i)
			if (soap_is_embedded(soap, pp))
				soap_element_ref(soap, tag, id, i);
			else if (soap_is_single(soap, pp))
				(*a)->soap_out(soap, tag, 0, type);
			else
			{	soap_set_embedded(soap, pp);
				(*a)->soap_out(soap, tag, i, type);
			}
		else
			(*a)->soap_out(soap, tag, soap_pointer_enter(soap, *a, SOAP_TYPE_api__File, &pp), type);
	}
	return SOAP_OK;
}

SOAP_FMAC1 api__File ** SOAP_FMAC2 soap_get_PointerToapi__File(struct soap *soap, api__File **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToapi__File(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 api__File ** SOAP_FMAC2 soap_in_PointerToapi__File(struct soap *soap, const char *tag, api__File **a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
	{	a = (api__File **)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToapi__File, sizeof(api__File *), 1);
		if (a)
			*a = NULL;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	else if (!*soap->href)
	{	soap_revert(soap);
		a = (api__File **)soap_id_enter(soap, "", a, SOAP_TYPE_PointerToapi__File, sizeof(api__File *), 0);
		if (a)
		{	if (soap->alloced || !*a)
				*a = (api__File *)soap_instantiate_api__File(soap, -1, soap->type, soap->arrayType);
			if (!*a)
				a = NULL;
			else
			{	(*a)->soap_default(soap);
				if (!(*a)->soap_in(soap, tag, NULL))
					a = NULL;
			}
		}
	}
	else
	{	a = (api__File **)soap_id_lookup(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToapi__File, sizeof(api__File *), 1), SOAP_TYPE_api__File, sizeof(api__File), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_PointerToFileArray(struct soap *soap, FileArray *const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_PointerToFileArray))
		soap_mark_PointerToFileArray(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_PointerToFileArray(struct soap *soap, FileArray *const*a)
{
	if (*a && !soap_array_reference(soap, *a, (struct soap_array*)&(*a)->__ptr, (*a)->__size, SOAP_TYPE_FileArray))
		(*a)->soap_mark(soap);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_PointerToFileArray(struct soap *soap, FileArray **a)
{
	*a = NULL;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_PointerToFileArray(struct soap *soap, FileArray **a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_PointerToFileArray, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_PointerToFileArray(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_PointerToFileArray(soap, tag, i, a, type);
		}
	else
		soap_out_PointerToFileArray(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_PointerToFileArray(struct soap *soap, const char *tag, int id, FileArray *const*a, const char *type)
{
	id = soap_embedded_id(soap, id, a, SOAP_TYPE_PointerToFileArray);
	if (!*a)
		soap_element_null(soap, tag, id, type);
	else
	{	struct soap_plist *pp;
		int i = soap_array_pointer_lookup(soap, *a, (struct soap_array*)&(*a)->__ptr, (*a)->__size, SOAP_TYPE_FileArray, &pp);
		if (i)
			if (soap_is_embedded(soap, pp))
				soap_element_ref(soap, tag, id, i);
			else if (soap_is_single(soap, pp))
				(*a)->soap_out(soap, tag, 0, type);
			else
			{	soap_set_embedded(soap, pp);
				(*a)->soap_out(soap, tag, i, type);
			}
		else
			(*a)->soap_out(soap, tag, soap_pointer_enter(soap, *a, SOAP_TYPE_FileArray, &pp), type);
	}
	return SOAP_OK;
}

SOAP_FMAC1 FileArray ** SOAP_FMAC2 soap_get_PointerToFileArray(struct soap *soap, FileArray **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToFileArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 FileArray ** SOAP_FMAC2 soap_in_PointerToFileArray(struct soap *soap, const char *tag, FileArray **a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
	{	a = (FileArray **)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToFileArray, sizeof(FileArray *), 1);
		if (a)
			*a = NULL;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	else if (!*soap->href)
	{	soap_revert(soap);
		a = (FileArray **)soap_id_enter(soap, "", a, SOAP_TYPE_PointerToFileArray, sizeof(FileArray *), 0);
		if (a)
		{	if (soap->alloced || !*a)
				*a = (FileArray *)soap_instantiate_FileArray(soap, -1, soap->type, soap->arrayType);
			if (!*a)
				a = NULL;
			else
			{	(*a)->soap_default(soap);
				if (!(*a)->soap_in(soap, tag, NULL))
					a = NULL;
			}
		}
	}
	else
	{	a = (FileArray **)soap_id_lookup(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToFileArray, sizeof(FileArray *), 1), SOAP_TYPE_FileArray, sizeof(FileArray), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_PointerToxsd__string(struct soap *soap, char **const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_PointerToxsd__string))
		soap_mark_PointerToxsd__string(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_PointerToxsd__string(struct soap *soap, char **const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_xsd__string))
		soap_mark_xsd__string(soap, *a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_PointerToxsd__string(struct soap *soap, char ***a)
{
	*a = NULL;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_PointerToxsd__string(struct soap *soap, char ***a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_PointerToxsd__string, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_PointerToxsd__string(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_PointerToxsd__string(soap, tag, i, a, type);
		}
	else
		soap_out_PointerToxsd__string(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_PointerToxsd__string(struct soap *soap, const char *tag, int id, char **const*a, const char *type)
{
	id = soap_embedded_id(soap, id, a, SOAP_TYPE_PointerToxsd__string);
	if (!*a)
		soap_element_null(soap, tag, id, type);
	else
	{	struct soap_plist *pp;
		int i = soap_pointer_lookup(soap, *a, SOAP_TYPE_xsd__string, &pp);
		if (i)
			if (soap_is_embedded(soap, pp))
				soap_element_ref(soap, tag, id, i);
			else if (soap_is_single(soap, pp))
				soap_out_xsd__string(soap, tag, 0, *a, type);
			else
			{	soap_set_embedded(soap, pp);
				soap_out_xsd__string(soap, tag, i, *a, type);
			}
		else
			soap_out_xsd__string(soap, tag, soap_pointer_enter(soap, *a, SOAP_TYPE_xsd__string, &pp), *a, type);
	}
	return SOAP_OK;
}

SOAP_FMAC1 char *** SOAP_FMAC2 soap_get_PointerToxsd__string(struct soap *soap, char ***p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToxsd__string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 char *** SOAP_FMAC2 soap_in_PointerToxsd__string(struct soap *soap, const char *tag, char ***a, const char *type)
{
	char **p;
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
	{	a = (char ***)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToxsd__string, sizeof(char **), 2);
		if (a)
			*a = NULL;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	else if (!*soap->href)
	{	soap_revert(soap);
		if (a)
		{	if ((p = soap_in_xsd__string(soap, tag, *a, type)))
				*a = p;
			else
				a = NULL;
		}
		else if ((p = soap_in_xsd__string(soap, tag, NULL, type)))
		{	a = (char ***)soap_id_enter(soap, "", NULL, SOAP_TYPE_PointerToxsd__string, sizeof(char **), 0);
			if (a)
				*a = p;
		}
	}
	else
	{	a = (char ***)soap_id_lookup(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToxsd__string, sizeof(char **), 2), SOAP_TYPE_xsd__string, sizeof(char *), 1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_PointerToStringArray(struct soap *soap, StringArray *const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_PointerToStringArray))
		soap_mark_PointerToStringArray(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_PointerToStringArray(struct soap *soap, StringArray *const*a)
{
	if (*a && !soap_array_reference(soap, *a, (struct soap_array*)&(*a)->__ptr, (*a)->__size, SOAP_TYPE_StringArray))
		(*a)->soap_mark(soap);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_PointerToStringArray(struct soap *soap, StringArray **a)
{
	*a = NULL;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_PointerToStringArray(struct soap *soap, StringArray **a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_PointerToStringArray, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_PointerToStringArray(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_PointerToStringArray(soap, tag, i, a, type);
		}
	else
		soap_out_PointerToStringArray(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_PointerToStringArray(struct soap *soap, const char *tag, int id, StringArray *const*a, const char *type)
{
	id = soap_embedded_id(soap, id, a, SOAP_TYPE_PointerToStringArray);
	if (!*a)
		soap_element_null(soap, tag, id, type);
	else
	{	struct soap_plist *pp;
		int i = soap_array_pointer_lookup(soap, *a, (struct soap_array*)&(*a)->__ptr, (*a)->__size, SOAP_TYPE_StringArray, &pp);
		if (i)
			if (soap_is_embedded(soap, pp))
				soap_element_ref(soap, tag, id, i);
			else if (soap_is_single(soap, pp))
				(*a)->soap_out(soap, tag, 0, type);
			else
			{	soap_set_embedded(soap, pp);
				(*a)->soap_out(soap, tag, i, type);
			}
		else
			(*a)->soap_out(soap, tag, soap_pointer_enter(soap, *a, SOAP_TYPE_StringArray, &pp), type);
	}
	return SOAP_OK;
}

SOAP_FMAC1 StringArray ** SOAP_FMAC2 soap_get_PointerToStringArray(struct soap *soap, StringArray **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToStringArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 StringArray ** SOAP_FMAC2 soap_in_PointerToStringArray(struct soap *soap, const char *tag, StringArray **a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
	{	a = (StringArray **)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToStringArray, sizeof(StringArray *), 1);
		if (a)
			*a = NULL;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	else if (!*soap->href)
	{	soap_revert(soap);
		a = (StringArray **)soap_id_enter(soap, "", a, SOAP_TYPE_PointerToStringArray, sizeof(StringArray *), 0);
		if (a)
		{	if (soap->alloced || !*a)
				*a = (StringArray *)soap_instantiate_StringArray(soap, -1, soap->type, soap->arrayType);
			if (!*a)
				a = NULL;
			else
			{	(*a)->soap_default(soap);
				if (!(*a)->soap_in(soap, tag, NULL))
					a = NULL;
			}
		}
	}
	else
	{	a = (StringArray **)soap_id_lookup(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToStringArray, sizeof(StringArray *), 1), SOAP_TYPE_StringArray, sizeof(StringArray), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_PointerToFilenameArray(struct soap *soap, FilenameArray *const*a)
{
	if (!soap_reference(soap, a, SOAP_TYPE_PointerToFilenameArray))
		soap_mark_PointerToFilenameArray(soap, a);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_PointerToFilenameArray(struct soap *soap, FilenameArray *const*a)
{
	if (*a && !soap_array_reference(soap, *a, (struct soap_array*)&(*a)->__ptr, (*a)->__size, SOAP_TYPE_FilenameArray))
		(*a)->soap_mark(soap);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_PointerToFilenameArray(struct soap *soap, FilenameArray **a)
{
	*a = NULL;
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_PointerToFilenameArray(struct soap *soap, FilenameArray **a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_PointerToFilenameArray, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_PointerToFilenameArray(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_PointerToFilenameArray(soap, tag, i, a, type);
		}
	else
		soap_out_PointerToFilenameArray(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_PointerToFilenameArray(struct soap *soap, const char *tag, int id, FilenameArray *const*a, const char *type)
{
	id = soap_embedded_id(soap, id, a, SOAP_TYPE_PointerToFilenameArray);
	if (!*a)
		soap_element_null(soap, tag, id, type);
	else
	{	struct soap_plist *pp;
		int i = soap_array_pointer_lookup(soap, *a, (struct soap_array*)&(*a)->__ptr, (*a)->__size, SOAP_TYPE_FilenameArray, &pp);
		if (i)
			if (soap_is_embedded(soap, pp))
				soap_element_ref(soap, tag, id, i);
			else if (soap_is_single(soap, pp))
				(*a)->soap_out(soap, tag, 0, type);
			else
			{	soap_set_embedded(soap, pp);
				(*a)->soap_out(soap, tag, i, type);
			}
		else
			(*a)->soap_out(soap, tag, soap_pointer_enter(soap, *a, SOAP_TYPE_FilenameArray, &pp), type);
	}
	return SOAP_OK;
}

SOAP_FMAC1 FilenameArray ** SOAP_FMAC2 soap_get_PointerToFilenameArray(struct soap *soap, FilenameArray **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToFilenameArray(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 FilenameArray ** SOAP_FMAC2 soap_in_PointerToFilenameArray(struct soap *soap, const char *tag, FilenameArray **a, const char *type)
{
	if (soap_element_begin_in(soap, tag))
		return NULL;
	if (soap->null)
	{	a = (FilenameArray **)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToFilenameArray, sizeof(FilenameArray *), 1);
		if (a)
			*a = NULL;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	else if (!*soap->href)
	{	soap_revert(soap);
		a = (FilenameArray **)soap_id_enter(soap, "", a, SOAP_TYPE_PointerToFilenameArray, sizeof(FilenameArray *), 0);
		if (a)
		{	if (soap->alloced || !*a)
				*a = (FilenameArray *)soap_instantiate_FilenameArray(soap, -1, soap->type, soap->arrayType);
			if (!*a)
				a = NULL;
			else
			{	(*a)->soap_default(soap);
				if (!(*a)->soap_in(soap, tag, NULL))
					a = NULL;
			}
		}
	}
	else
	{	a = (FilenameArray **)soap_id_lookup(soap, soap->href, (void**)soap_id_enter(soap, soap->id, a, SOAP_TYPE_PointerToFilenameArray, sizeof(FilenameArray *), 1), SOAP_TYPE_FilenameArray, sizeof(FilenameArray), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_xsd__string(struct soap *soap, char **a)
{
#ifdef SOAP_DEFAULT_xsd__string
	*a = SOAP_DEFAULT_xsd__string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_xsd__string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_xsd__string);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_xsd__string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_xsd__string);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_xsd__string(struct soap *soap, char **a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_xsd__string, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_xsd__string(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_xsd__string(soap, tag, i, a, type);
		}
	else
		soap_out_xsd__string(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_xsd__string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_xsd__string);
}

SOAP_FMAC1 char ** SOAP_FMAC2 soap_get_xsd__string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 char * * SOAP_FMAC2 soap_in_xsd__string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_xsd__string, 1);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_default_string(struct soap *soap, char **a)
{
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC1 void SOAP_FMAC2 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC1 void SOAP_FMAC2 soap_mark_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_put_string(struct soap *soap, char **a, const char *tag, const char *type)
{
	int i;
	struct soap_plist *pp;
	if ((i = soap_pointer_lookup(soap, a, SOAP_TYPE_string, &pp)))
		if (soap_is_embedded(soap, pp))
			soap_element_ref(soap, tag, 0, i);
		else if (soap_is_single(soap, pp))
			soap_out_string(soap, tag, 0, a, type);
		else
		{
			soap_set_embedded(soap, pp);
			soap_out_string(soap, tag, i, a, type);
		}
	else
		soap_out_string(soap, tag, 0, a, type);
	return soap_putindependent(soap);
}

SOAP_FMAC1 int SOAP_FMAC2 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC1 char ** SOAP_FMAC2 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		soap_getindependent(soap);
	return p;
}

SOAP_FMAC1 char * * SOAP_FMAC2 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	return soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1);
}

/* end of soapC.cpp */
