//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// emuleDlg.h : Headerdatei
//
#pragma once
#include "sockets.h"
#include "afxcmn.h"
#include "afxwin.h"
#include "serverlistctrl.h"
#include "knownfilelist.h"
#include "TransferWnd.h"
#include "ServerWnd.h"
#include "Preferencesdlg.h"
#include "SharedFilesWnd.h"
#include "SearchDlg.h"
#include "ChatWnd.h"
#include "traydialog.h"
#include "BtnST.h"
#include "StatisticsDlg.h"
#include "MeterIcon.h"
#include "IrcWnd.h"
#include "TaskbarNotifier.h"
#include "MuleToolBarCtrl.h"
#include "MuleStatusBarCtrl.h"

#define MP_RESTORE		4001
#define MP_CONNECT		4002
#define MP_DISCONNECT	4003
#define MP_EXIT			4004

enum APPState {APP_STATE_RUNNING=0,
			   APP_STATE_SHUTINGDOWN,
			   APP_STATE_DONE
};

class CKnownFileList; 
// CemuleDlg Dialogfeld
class CemuleDlg : public CTrayDialog
{
// Konstruktion
public:
	CemuleDlg(CWnd* pParent = NULL);	// Standardkonstruktor
	~CemuleDlg();
	enum { IDD = IDD_EMULE_DIALOG };

	void			AddDebugLogLine(bool addtostatusbar,CString line,...);
	void			AddLogLine(bool addtostatusbar,CString line,...);
	void			AddServerMessageLine(char* line,...);
	void			ShowConnectionState();
	void			ShowConnectionState(bool connected);
	void			ShowConnectionState(bool connected,CString server,bool iconOnly=false);
	void			ShowNotifier(CString Text, int MsgType, bool ForceSoundOFF = false); 
	void			ShowUserCount(uint32 user_toshow, uint32 file_toshow);
	void			ShowMessageState(uint8 iconnr);
	void			SetActiveDialog(CDialog* dlg);
	void			ShowTransferRate(bool forceAll=false);
	void			ShowStatistics();
	void			Localize();
	void			ResetLog();
	void			ResetDebugLog();
	void			OnCancel();
	void			StopTimer();
	// Barry - To find out if app is running or shutting/shut down
	bool			IsRunning();
	void			DoVersioncheck(bool manual);
	CString			GetLastLogEntry();
	CString			GetLastDebugLogEntry();
	CString			GetAllLogEntries();
	CString			GetAllDebugLogEntries();

	CTransferWnd	transferwnd;
	CServerWnd		serverwnd;
	CPreferencesDlg	preferenceswnd;
	CSharedFilesWnd	sharedfileswnd;
	CSearchDlg		searchwnd;
	CChatWnd		chatwnd;
	CMuleStatusBarCtrl  statusbar;
	CDialog*		activewnd;
	CStatisticsDlg  statisticswnd;
	CIrcWnd			ircwnd;
	CTaskbarNotifier m_wndTaskbarNotifier;
	CMuleToolbarCtrl toolbar;
	APPState		m_app_state;
	uint8			status;
	HICON sourceTrayIcon;
protected:
	HICON m_hIcon;
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual BOOL OnInitDialog();
	virtual void OnTrayRButtonDown(CPoint pt);
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	BOOL OnQueryEndSession();

	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnBnClickedButton2();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);

	// quick-speed changer -- based on xrmb
	afx_msg void QuickSpeedUpload(UINT nID);
	afx_msg void QuickSpeedDownload(UINT nID);
	afx_msg void QuickSpeedOther(UINT nID);
	// end of quick-speed changer
	
	afx_msg LRESULT OnTaskbarNotifierClicked(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnWMData(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnFileHashed(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnAreYouEmule(WPARAM, LPARAM);

	//Webserver [kuchin]
	afx_msg LRESULT OnWebServerConnect(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnWebServerRemove(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnWebSharedFilesReload(WPARAM wParam, LPARAM lParam);


	virtual void OnSize(UINT nType,int cx,int cy);
	void		 OnOK()			{}
	void		 OnClose();
	void		 DisConnect();

	DECLARE_MESSAGE_MAP()
private:
	bool			ready,startUpMinimized;
	HICON			connicons[3];
	HICON			transicons[4];
	HICON			imicons[3];
	HICON			mytrayIcon;
	HICON			usericon;

	CMeterIcon trayIcon;

	HICON sourceTrayIconGrey;
	HICON sourceTrayIconLow;

	uint32			lastuprate;
	uint32			lastdownrate;
	CImageList		imagelist;
	CTitleMenu		trayPopup;

	UINT_PTR m_hTimer;
	static void CALLBACK StartupTimer(HWND hwnd, UINT uiMsg, UINT idEvent, DWORD dwTime);

	void StartConnection();
	void CloseConnection();
	void RestoreWindow();
	void UpdateTrayIcon(int procent);
	void AddSpeedSelectorSys(CMenu* addToMenu);
	int  GetRecMaxUpload();
	int	 IsNewVersionAvailable();
	void LoadNotifier(CString configuration); //<<--enkeyDEV(kei-kun) -TaskbarNotifier-
	bool notifierenabled;					  //<<-- enkeyDEV(kei-kun) -Quick disable/enable notifier-

public:
	afx_msg void OnBnClickedHotmenu();
	afx_msg LRESULT OnMenuChar(UINT nChar, UINT nFlags, CMenu* pMenu);
};


// ALL emuledlg WM_USER messages are to be declared here!!
enum EEmuleUserMsgs
{
	// Do *NOT* use any WM_USER messages in the range WM_USER - WM_USER+0x100!

	// Taskbar
	WM_TASKBARNOTIFIERCLICKED = WM_USER + 0x101,
	WM_TRAY_ICON_NOTIFY_MESSAGE,

	// Webserver
	WEB_CONNECT_TO_SERVER,
	WEB_REMOVE_SERVER,
	WEB_SHARED_FILES_RELOAD
};

enum EEmlueAppMsgs
{
	//thread messages
	TM_FINISHEDHASHING = WM_APP + 10
};

