//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"
#include "emuleDlg.h"
#include "knownfilelist.h"
#include "preferences.h"
#include "sockets.h"
#include "serverlist.h"
#include "sharedfilelist.h"
#include "searchlist.h"
#include "listensocket.h"
#include "uploadqueue.h"
#include "downloadqueue.h"
#include "clientlist.h"
#include "clientcredits.h"
#include "friendlist.h"
#include "clientudpsocket.h"
#include "IPFilter.h"
#include <afxmt.h>
#include "Webserver.h"
#include "Scheduler.h"
#include "UploadBandwidthThrottler.h"

#define MAX_NICK_LENGTH 49 // max. length of nick without trailing NUL char

class CSearchList;
class CUploadQueue;
class CListenSocket;
class CDownloadQueue;

class CemuleApp : public CWinApp
{
public:
	CemuleApp(LPCTSTR lpszAppName = NULL);
    UploadBandwidthThrottler* uploadBandwidthThrottler;
    CemuleDlg*			emuledlg;
	CClientList*		clientlist;
	CKnownFileList*		knownfiles;
	CPreferences*		glob_prefs;
	CServerConnect*		serverconnect;
	CServerList*		serverlist;	
	CSharedFileList*	sharedfiles;
	CSearchList*		searchlist;
	CListenSocket*		listensocket;
	CUploadQueue*		uploadqueue;
	CDownloadQueue*		downloadqueue;
	CClientCreditsList*	clientcredits;
	CFriendList*		friendlist;
	CClientUDPSocket*	clientudp;
	CMutex				hashing_mut;
	virtual BOOL		InitInstance();
	CString*			pendinglink;
	tagCOPYDATASTRUCT  sendstruct; //added by Cax2 28/10/02 
	CIPFilter*			ipfilter;
	CWebServer*			webserver; // Webserver [kuchin]
	CScheduler*			scheduler;

	uint64				stat_sessionReceivedBytes;
	uint64				stat_sessionSentBytes;
	uint64				stat_sessionSentBytesToFriend;
	uint16				stat_reconnects;
	DWORD				stat_transferStarttime;
	DWORD				stat_serverConnectTime;
	DWORD				stat_starttime;
	HANDLE				m_hMutexOneInstance;
	uint16				stat_filteredclients;
	DWORD				m_dwCommCtrlMjr;
	DWORD				m_dwCommCtrlMin;
	int					m_iDfltImageListColorFlags;

	CArray<CString,CString> webservices;

// Implementierung
	// ed2k link functions
	CString		StripInvalidFilenameChars(CString strText, bool bKeepSpaces = true);
	CString		CreateED2kLink( CAbstractFile* f );
	CString		CreateED2kSourceLink( CAbstractFile* f );
	CString		CreateHTMLED2kLink( CAbstractFile* f );
	bool		CopyTextToClipboard( CString strText );
	CString		CopyTextFromClipboard();
	void		OnlineSig(); 
	void		UpdateReceivedBytes(int32 bytesToAdd);
	void		UpdateSentBytes(int32 bytesToAdd, bool sentToFriend = false);
	int			GetFileTypeSystemImageIdx(LPCTSTR pszFilePath, int iLength = -1);
	HIMAGELIST	GetSystemImageList() { return m_hSystemImageList; }
	CSize		GetSmallSytemIconSize() { return m_sizSmallSystemIcon; }

	DECLARE_MESSAGE_MAP()
protected:
	bool ProcessCommandline();
	void SetTimeOnTransfer();
	static BOOL CALLBACK SearchEmuleWindow(HWND hWnd, LPARAM lParam);
	void OnHelp();

	HIMAGELIST m_hSystemImageList;
	CMapStringToPtr m_aExtToSysImgIdx;
	CSize m_sizSmallSystemIcon;
};
extern CemuleApp theApp;
