//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// ListenSocket.cpp : implementation file

#include "stdafx.h"
#include "emule.h"
#include "clientlist.h"

bool CClientList::VerifyUpload(uint32 clientip,uint16 port){
	CUpDownClient* tocheck = FindClientByIP(clientip,port);
	if (tocheck && ( (tocheck->GetDownloadState() == DS_DOWNLOADING && tocheck->GetDatarate() > 1000) || ( tocheck->GetTransferedDown() > 400000 ) ))
		return true;
	return false;
}

CUpDownClient* CClientList::VUGetRandomClient(){
	CTypedPtrList<CPtrList, CUpDownClient*> templist;
	for (POSITION pos = list.GetHeadPosition();pos != 0;list.GetNext(pos)){
		CUpDownClient* cur_client = list.GetAt(pos);
		if (cur_client->socket && cur_client->socket->IsConnected() && cur_client->GetMuleVersion() >= 0x20 && (cur_client->GetTransferedUp() > 400000) ){
			templist.AddTail(cur_client);
		}
	}
	if (templist.IsEmpty())
		return 0;
	uint16 randomness = (uint16)ROUND(((float)rand()/RAND_MAX)*(templist.GetCount()-1));
	ASSERT ( templist.FindIndex(randomness) != NULL);
	return templist.GetAt(templist.FindIndex(randomness));
}

