//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#pragma once
#include "server.h"
#include "packets.h"

#define WM_DNSLOOKUPDONE	(WM_USER+0x101)

// Client to Server communication
class CServerConnect;

class CUDPSocketWnd : public CWnd {

// Construction
public:
	CUDPSocketWnd();
	CUDPSocket* m_pOwner;
protected:
	DECLARE_MESSAGE_MAP()
	afx_msg LRESULT OnDNSLookupDone(WPARAM wParam,LPARAM lParam);
private:
	
};


class CUDPSocket : public CAsyncSocket
{
	friend class CServerConnect;
public:
	CUDPSocket(CServerConnect* in_serverconnect);
	~CUDPSocket();
	bool	Create();
	void	SendPacket(Packet* packet,CServer* host);
	void	DnsLookupDone(WPARAM wp, LPARAM lp);
protected:
	void	AsyncResolveDNS(LPCTSTR lpszHostAddress, UINT nHostPort);
	HANDLE	DnsTaskHandle;					// dns lookup handle
	
	virtual void OnReceive(int nErrorCode);
private:
	LPCTSTR m_lpszHostAddress;
	UINT m_nHostPort;
	HWND m_hWndResolveMessage;	// where to send WM_DNSRESOLVED
	SOCKADDR_IN m_SaveAddr;
	CUDPSocketWnd m_udpwnd;

	void SendBuffer();
	bool	ProcessPacket(char* packet, int16 size, int8 opcode, LPCTSTR host, uint16 nUDPPort);
	bool	ProcessExtPacket(char* packet, int16 size, int8 opcode, LPCTSTR host, uint16 nUDPPort);
	CServerConnect*	serverconnect;
	char*	sendbuffer;
	uint32	sendblen;
	CServer* cur_server;
	char	DnsHostBuffer[MAXGETHOSTSTRUCT];	// dns lookup structure
};