//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once
#include "opcodes.h"
#include "emule.h"
#include "types.h"
#include "preferences.h"
#include "KnownFile.h"
#include "packets.h"
#include "searchlistctrl.h"
#include "otherfunctions.h"

class SearchList;

class CSearchFile : public CAbstractFile {
	friend class CPartFile;
public:
	//CSearchFile() {};
	CSearchFile(CFile* in_data, uint32 nSearchID, uint32 nServerIP=0, uint16 nServerPort=0, LPCTSTR pszDirectory = NULL);
	~CSearchFile();
	uint32	GetIntTagValue(uint8 tagname);
	char*	GetStrTagValue(uint8 tagname);
	uint32	AddSources(uint32 count);
	uint32	GetSourceCount();
	uint32	GetSearchID() {return m_nSearchID;}
	LPCTSTR GetDirectory() { return m_pszDirectory; }
	const CArray<CTag*,CTag*>& GetTags() const { return taglist; }

	uint32	GetClientID() { return *((uint32*)clientip); }
	void	SetClientID(uint32 nClientID) { *((uint32*)clientip) = nClientID; }
	uint16	GetClientPort() { return clientport; }
	void	SetClientPort(uint16 uPort) { clientport = uPort; }
	uint32	GetClientServerIP() { return m_nClientServerIP; }
	void	SetClientServerIP(uint32 uIP) { m_nClientServerIP = uIP; }
	uint16	GetClientServerPort() { return m_nClientServerPort; }
	void	SetClientServerPort(uint16 uPort) { m_nClientServerPort = uPort; }
	int		GetClientsCount() { return ((GetClientID() && GetClientPort()) ? 1 : 0) + m_aClients.GetSize(); }

	struct SClient {
		SClient() {
			nIP = nPort = nServerIP = nServerPort = 0;
		}
		uint32 nIP;
		uint16 nPort;
		uint32 nServerIP;
		uint16 nServerPort;
	};
	void AddClient(SClient& client) { m_aClients.Add(client); }
	const CSimpleArray<SClient>& GetClients() { return m_aClients; }
private:
	uint8	clientip[4];
	uint16	clientport;
	uint32	m_nSearchID;
	CArray<CTag*,CTag*> taglist;
	uint32	m_nClientServerIP;
	uint16	m_nClientServerPort;
	CSimpleArray<SClient> m_aClients;
	LPSTR m_pszDirectory;
};

class CSearchList
{
friend class CSearchListCtrl;
public:
	CSearchList();
	~CSearchList();
	void	Clear();
	void	NewSearch(CSearchListCtrl* in_wnd, CString resTypes, uint16 nSearchID);
	uint16	ProcessSearchanswer(char* packet, uint32 size, CUpDownClient* Sender, LPCTSTR pszDirectory = NULL);
	uint16	ProcessSearchanswer(char* packet, uint32 size, uint32 nServerIP, uint16 nServerPort);
	uint16	ProcessUDPSearchanswer(char* packet, uint32 size, uint32 nServerIP, uint16 nServerPort);
	uint16	GetResultCount();
	uint16	GetResultCount(uint32 nSearchID);
	void	SetOutputWnd(CSearchListCtrl* in_wnd)		{outputwnd = in_wnd;}
	void	RemoveResults(  uint32 nSearchID );
	void	RemoveResults( CSearchFile* todel );
	void	ShowResults(uint32 nSearchID);
	CString GetWebList(CString linePattern);
	void	AddFileToDownloadByHash(uchar* hash)		{AddFileToDownloadByHash(hash,0);}
	void	AddFileToDownloadByHash(uchar* hash, uint8 cat);

	uint16	GetFoundFiles(uint32 searchID) {
		uint16 returnVal=0;
		VERIFY( foundFilesCount.Lookup(searchID,returnVal) );
		return returnVal;
	}

private:
	bool AddToList(CSearchFile* toadd, bool bClientResponse = false);
	CTypedPtrList<CPtrList, CSearchFile*> list;
	CMap<uint32, uint32, uint16, uint16> foundFilesCount;

	CString myHashList;
	CSearchListCtrl*	outputwnd;
	CString resultType;
	uint32	m_nCurrentSearch;
};
