//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once
#include "types.h"
#include "listensocket.h"
#include "ini2.h"

struct Schedule_Struct{
   CString			title;
   bool				enabled;
   uint8			day;
   uint32			time;
   uint32			time2;
   CString			values[16];
   int				actions[16];
   void ResetActions()	{for (uint8 index=0;index<16;index++) {actions[index]=0;values[index]="";}}
   ~Schedule_Struct() {  }
};

class CScheduler
{
public:
	CScheduler();
	~CScheduler();
	uint8	AddSchedule(Schedule_Struct* schedule);

	void	UpdateSchedule(uint8 index,Schedule_Struct* schedule) {if (index<schedulelist.GetCount())schedulelist.SetAt(index,schedule);}

	Schedule_Struct* GetSchedule(uint8 index) {if (index<schedulelist.GetCount()) return schedulelist.GetAt(index); else return NULL; }
	void	RemoveSchedule(uint8 index);
	void	RemoveAll();
	int		LoadFromFile();
	void	SaveToFile();
	int		Check(bool forcecheck=false);
	uint8	GetCount()		{ return schedulelist.GetCount();}
	void	SaveOriginals();
	void	RestoreOriginals();
	void	ActivateSchedule(uint8 index);
	
	uint16	original_upload;
	uint16	original_download;
	uint16	original_connections;
	uint16	original_cons5s;
	uint16	original_sources;

private:
	CArray<Schedule_Struct*,Schedule_Struct*> schedulelist;
	uint8	m_iLastCheckedMinute;
};

