// PgTweaks.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "PPgTweaks.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


// CPPgTweaks dialog

IMPLEMENT_DYNAMIC(CPPgTweaks, CPropertyPage)
CPPgTweaks::CPPgTweaks()
	: CPropertyPage(CPPgTweaks::IDD)
{
}

CPPgTweaks::~CPPgTweaks()
{
}

void CPPgTweaks::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgTweaks, CPropertyPage)
	ON_EN_CHANGE(IDC_MAXCON5SEC, OnSettingsChange)
	ON_BN_CLICKED(IDC_VERBOSE, OnSettingsChange)
	ON_BN_CLICKED(IDC_AUTOTAKEED2KLINKS, OnSettingsChange)
	ON_BN_CLICKED(IDC_USECREDITSYSTEM, OnSettingsChange)
	ON_BN_CLICKED(IDC_DEBUG_SOURCE_EXCHANGE, OnSettingsChange) //Sony April 23. 2003, button to keep the source exchange msgs out of the verbose log
	ON_BN_CLICKED(IDC_LOG2DISK, OnSettingsChange)
	ON_BN_CLICKED(IDC_DEBUG2DISK, OnSettingsChange)
	ON_WM_HSCROLL()	
END_MESSAGE_MAP()


// CPPgTweaks message handlers


BOOL CPPgTweaks::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	LoadSettings();
	Localize();


	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgTweaks::LoadSettings(void)
{
	if(m_hWnd)
	{
		CString strBuffer;

		strBuffer.Format("%d", app_prefs->GetMaxConperFive());
		GetDlgItem(IDC_MAXCON5SEC)->SetWindowText(strBuffer);
	}
	if(app_prefs->prefs->m_bVerbose)
		CheckDlgButton(IDC_VERBOSE,1);
	else
		CheckDlgButton(IDC_VERBOSE,0);

	if(app_prefs->prefs->m_bDebugSourceExchange)
		CheckDlgButton(IDC_DEBUG_SOURCE_EXCHANGE,1);
	else
		CheckDlgButton(IDC_DEBUG_SOURCE_EXCHANGE,0);

	if(app_prefs->prefs->log2disk)
		CheckDlgButton(IDC_LOG2DISK,1);
	else
		CheckDlgButton(IDC_LOG2DISK,0);
	if(app_prefs->prefs->debug2disk)
		CheckDlgButton(IDC_DEBUG2DISK,1);
	else
		CheckDlgButton(IDC_DEBUG2DISK,0);

	if(app_prefs->prefs->m_bCreditSystem)
		CheckDlgButton(IDC_USECREDITSYSTEM,1);
	else
		CheckDlgButton(IDC_USECREDITSYSTEM,0);

	// Barry
	if(app_prefs->prefs->autotakeed2klinks)
		CheckDlgButton(IDC_AUTOTAKEED2KLINKS,1);
	else
		CheckDlgButton(IDC_AUTOTAKEED2KLINKS,0);
	((CSliderCtrl*)GetDlgItem(IDC_FILEBUFFERSIZE))->SetRange(1,100,true);
	((CSliderCtrl*)GetDlgItem(IDC_FILEBUFFERSIZE))->SetPos(app_prefs->prefs->m_iFileBufferSize);
	m_iFileBufferSize = app_prefs->prefs->m_iFileBufferSize;
	((CSliderCtrl*)GetDlgItem(IDC_QUEUESIZE))->SetRange(20,100,true);
	((CSliderCtrl*)GetDlgItem(IDC_QUEUESIZE))->SetPos(app_prefs->prefs->m_iQueueSize);
	m_iQueueSize = app_prefs->prefs->m_iQueueSize;
	GetDlgItem(IDC_DEBUG_SOURCE_EXCHANGE)->EnableWindow(IsDlgButtonChecked(IDC_VERBOSE));
}

BOOL CPPgTweaks::OnApply()
{
	char buffer[510];
	if(GetDlgItem(IDC_MAXCON5SEC)->GetWindowTextLength())
	{
		GetDlgItem(IDC_MAXCON5SEC)->GetWindowText(buffer,20);
		app_prefs->SetMaxConsPerFive((atoi(buffer)) ?
			atoi(buffer) : 20);
		theApp.scheduler->original_cons5s=app_prefs->GetMaxConperFive();
	}

	if(IsDlgButtonChecked(IDC_VERBOSE))
		app_prefs->prefs->m_bVerbose = true;
	else
		app_prefs->prefs->m_bVerbose = false;

	if(IsDlgButtonChecked(IDC_DEBUG_SOURCE_EXCHANGE))
		app_prefs->prefs->m_bDebugSourceExchange = true;
	else
		app_prefs->prefs->m_bDebugSourceExchange = false;

	// Barry
	bool be4=app_prefs->prefs->autotakeed2klinks;
	app_prefs->prefs->autotakeed2klinks = (int8)IsDlgButtonChecked(IDC_AUTOTAKEED2KLINKS);
	app_prefs->prefs->log2disk = (int8)IsDlgButtonChecked(IDC_LOG2DISK);
	app_prefs->prefs->debug2disk = (int8)IsDlgButtonChecked(IDC_DEBUG2DISK);

	if ((int8)be4!=app_prefs->prefs->autotakeed2klinks) RevertReg();

	app_prefs->prefs->m_iFileBufferSize = m_iFileBufferSize;
	app_prefs->prefs->m_iQueueSize = m_iQueueSize;

	if(IsDlgButtonChecked(IDC_USECREDITSYSTEM))
		app_prefs->prefs->m_bCreditSystem = true;
	else
		app_prefs->prefs->m_bCreditSystem = false;

	LoadSettings();
	SetModified(FALSE);
	theApp.emuledlg->serverwnd.ToggleDebugWindow();
	theApp.emuledlg->serverwnd.UpdateLogTabSelection();

	return CPropertyPage::OnApply();
}

void CPPgTweaks::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SetModified(TRUE);
	
	CSliderCtrl* slider =(CSliderCtrl*)pScrollBar;
	CString temp;
	if (pScrollBar==GetDlgItem(IDC_FILEBUFFERSIZE)) {
		m_iFileBufferSize = slider->GetPos();
		temp.Format( GetResString(IDS_FILEBUFFERSIZE), m_iFileBufferSize*15000 );
		GetDlgItem(IDC_FILEBUFFERSIZE_STATIC)->SetWindowText(temp);
	}
	else if (pScrollBar==GetDlgItem(IDC_QUEUESIZE)) {
		m_iQueueSize = slider->GetPos();
		temp.Format( GetResString(IDS_QUEUESIZE), m_iQueueSize*100 );
		GetDlgItem(IDC_QUEUESIZE_STATIC)->SetWindowText(temp);
	}
}

void CPPgTweaks::Localize(void)
{	
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_PW_TWEAK));
		GetDlgItem(IDC_MAXCON5SECLABEL )->SetWindowText(GetResString(IDS_MAXCON5SECLABEL));
		GetDlgItem(IDC_WARNING)->SetWindowText(GetResString(IDS_WARNING));
		GetDlgItem(IDC_AUTOTAKEED2KLINKS)->SetWindowText(GetResString(IDS_AUTOTAKEED2KLINKS));
		GetDlgItem(IDC_VERBOSE)->SetWindowText(GetResString(IDS_VERBOSE));
		GetDlgItem(IDC_DEBUG_SOURCE_EXCHANGE)->SetWindowText(GetResString(IDS_DEBUG_SOURCE_EXCHANGE));

		GetDlgItem(IDC_LOG2DISKFRAME)->SetWindowText(GetResString(IDS_LOG2DISKFRAME));
		GetDlgItem(IDC_LOG2DISK)->SetWindowText(GetResString(IDS_LOG2DISK));
		GetDlgItem(IDC_DEBUG2DISK)->SetWindowText(GetResString(IDS_DEBUG2DISK));
		GetDlgItem(IDC_USECREDITSYSTEM)->SetWindowText(GetResString(IDS_USECREDITSYSTEM));

		CString temp;
		temp.Format( GetResString(IDS_FILEBUFFERSIZE), m_iFileBufferSize*15000 );
		GetDlgItem(IDC_FILEBUFFERSIZE_STATIC)->SetWindowText(temp);
		temp.Format( GetResString(IDS_QUEUESIZE), m_iQueueSize*100 );
		GetDlgItem(IDC_QUEUESIZE_STATIC)->SetWindowText(temp);
	}
}
