#pragma once

// CPPgScheduler dialog

#include "preferences.h"
#include "Scheduler.h"

#define ACTION_SETUPL		1
#define ACTION_SETDOWNL		2
#define ACTION_SOURCESL		3
#define ACTION_CON5SEC		4
#define ACTION_CONS			5
#define ACTION_CATSTOP		6
#define ACTION_CATRESUME	7

#define DAY_DAYLY		0
#define DAY_MO			1
#define DAY_DI			2
#define DAY_MI			3
#define DAY_DO			4
#define DAY_FR			5
#define DAY_SA			6
#define DAY_SO			7
#define DAY_MO_FR		8
#define DAY_MO_SA		9 
#define DAY_SA_SO		10

class CPPgScheduler : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgScheduler)

public:
	CPPgScheduler();
	virtual ~CPPgScheduler();

	void SetPrefs(CPreferences* in_prefs) {	app_prefs = in_prefs; }


	enum { IDD = IDD_PPG_SCHEDULER };

	CPreferences *app_prefs;

	void Localize(void);

	virtual BOOL OnInitDialog();
	
// Dialog Data
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
private:
	CString GetActionLabel(uint8 index);
	CString GetDayLabel(uint8 index);
	void LoadSchedule(uint8 index);
	void RecheckSchedules();
	void FillScheduleList();
	CComboBox m_timesel;
	CDateTimeCtrl m_time;
	CDateTimeCtrl m_timeTo;
	CListCtrl m_list;
	CListCtrl m_actions;
public:
	virtual BOOL OnApply();
	afx_msg void OnNMDblclkList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedAdd();
	afx_msg void OnBnClickedApply();
	afx_msg void OnBnClickedRemove();
	afx_msg void OnSettingsChange() {SetModified();}
	afx_msg void OnEnableChange();
	afx_msg void OnNMDblclkActionlist(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMRclickActionlist(NMHDR *pNMHDR, LRESULT *pResult);

};
