// PPgDisplay.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "PPgDisplay.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


// CPPgDisplay dialog

IMPLEMENT_DYNAMIC(CPPgDisplay, CPropertyPage)
CPPgDisplay::CPPgDisplay()
	: CPropertyPage(CPPgDisplay::IDD)
{
}

CPPgDisplay::~CPPgDisplay()
{
}

void CPPgDisplay::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CPPgDisplay, CPropertyPage)
	ON_BN_CLICKED(IDC_MINTRAY, OnSettingsChange)
	ON_BN_CLICKED(IDC_DBLCLICK, OnSettingsChange)
	ON_EN_CHANGE(IDC_TOOLTIPDELAY, OnSettingsChange)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_UPDATEQUEUE, OnSettingsChange)
	ON_BN_CLICKED(IDC_SHOWRATEONTITLE, OnSettingsChange)
	ON_BN_CLICKED(IDC_INDICATERATINGS , OnSettingsChange)
	ON_BN_CLICKED(IDC_DISABLEKNOWNLIST, OnSettingsChange)
	ON_BN_CLICKED(IDC_DISABLEQUEUELIST, OnSettingsChange)
	ON_BN_CLICKED(IDC_SHOWCATINFO, OnSettingsChange)
	ON_BN_CLICKED(IDC_REPAINT,OnSettingsChange)
END_MESSAGE_MAP()

void CPPgDisplay::LoadSettings(void)
{
	if(app_prefs->prefs->mintotray)
		CheckDlgButton(IDC_MINTRAY,1);
	else
		CheckDlgButton(IDC_MINTRAY,0);

	if(app_prefs->prefs->transferDoubleclick)
		CheckDlgButton(IDC_DBLCLICK,1);
	else
		CheckDlgButton(IDC_DBLCLICK,0);

	if(app_prefs->prefs->indicateratings)
		CheckDlgButton(IDC_INDICATERATINGS,1);
	else
		CheckDlgButton(IDC_INDICATERATINGS,0);

	if(app_prefs->prefs->showRatesInTitle)
		CheckDlgButton(IDC_SHOWRATEONTITLE,1);
	else
		CheckDlgButton(IDC_SHOWRATEONTITLE,0);

	if(app_prefs->prefs->m_bupdatequeuelist)
		CheckDlgButton(IDC_UPDATEQUEUE,0);
	else
		CheckDlgButton(IDC_UPDATEQUEUE,1);

	if(app_prefs->prefs->m_bDisableKnownClientList)
		CheckDlgButton(IDC_DISABLEKNOWNLIST,1);
	else
		CheckDlgButton(IDC_DISABLEKNOWNLIST,0);

	if(app_prefs->prefs->m_bDisableQueueList)
		CheckDlgButton(IDC_DISABLEQUEUELIST,1);
	else
		CheckDlgButton(IDC_DISABLEQUEUELIST,0);

	CheckDlgButton(IDC_SHOWCATINFO,(UINT)theApp.glob_prefs->ShowCatTabInfos());
	CheckDlgButton(IDC_REPAINT,(UINT)theApp.glob_prefs->IsGraphRecreateDisabled() );

	CString strBuffer;
	strBuffer.Format("%d", app_prefs->prefs->m_iToolDelayTime);
	GetDlgItem(IDC_TOOLTIPDELAY)->SetWindowText(strBuffer);
}

BOOL CPPgDisplay::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	// Barry - Controls depth of 3d colour shading
	CSliderCtrl *slider3D = (CSliderCtrl*)GetDlgItem(IDC_3DDEPTH);
	slider3D->SetRange(0, 5, true);
	slider3D->SetPos(app_prefs->Get3DDepth());

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPgDisplay::OnApply()
{
	char buffer[510];
	
	int8 mintotray_old= app_prefs->prefs->mintotray;
	app_prefs->prefs->mintotray = (int8)IsDlgButtonChecked(IDC_MINTRAY);
	app_prefs->prefs->transferDoubleclick= (int8)IsDlgButtonChecked(IDC_DBLCLICK);
	app_prefs->prefs->depth3D = ((CSliderCtrl*)GetDlgItem(IDC_3DDEPTH))->GetPos();
	app_prefs->prefs->indicateratings= (int8)IsDlgButtonChecked(IDC_INDICATERATINGS);
	app_prefs->prefs->dontRecreateGraphs=(int8)IsDlgButtonChecked(IDC_REPAINT);

	if(IsDlgButtonChecked(IDC_UPDATEQUEUE))
		app_prefs->prefs->m_bupdatequeuelist = false;
	else
		app_prefs->prefs->m_bupdatequeuelist = true;

	if(IsDlgButtonChecked(IDC_SHOWRATEONTITLE))
		app_prefs->prefs->showRatesInTitle= true;
	else
		app_prefs->prefs->showRatesInTitle= false;

	bool flag = app_prefs->prefs->m_bDisableKnownClientList;

	if(IsDlgButtonChecked(IDC_DISABLEKNOWNLIST))
		app_prefs->prefs->m_bDisableKnownClientList = true;
	else
		app_prefs->prefs->m_bDisableKnownClientList = false;

	theApp.glob_prefs->ShowCatTabInfos(IsDlgButtonChecked(IDC_SHOWCATINFO));
	if (!theApp.glob_prefs->ShowCatTabInfos()) theApp.emuledlg->transferwnd.UpdateCatTabTitles();

	if( flag != app_prefs->prefs->m_bDisableKnownClientList){
		if( !flag )
			theApp.emuledlg->transferwnd.clientlistctrl.DeleteAllItems();
		else
			theApp.emuledlg->transferwnd.clientlistctrl.ShowKnownClients();
	}

	flag = app_prefs->prefs->m_bDisableQueueList;

	if(IsDlgButtonChecked(IDC_DISABLEQUEUELIST))
		app_prefs->prefs->m_bDisableQueueList = true;
	else
		app_prefs->prefs->m_bDisableQueueList = false;

	if( flag != app_prefs->prefs->m_bDisableQueueList){
		if( !flag )
			theApp.emuledlg->transferwnd.queuelistctrl.DeleteAllItems();
		else
			theApp.emuledlg->transferwnd.queuelistctrl.ShowQueueClients();
	}

	GetDlgItem(IDC_TOOLTIPDELAY)->GetWindowText(buffer,20);
	if(atoi(buffer) > 32)
		app_prefs->prefs->m_iToolDelayTime = 32;
	else
		app_prefs->prefs->m_iToolDelayTime = atoi(buffer);
	
	((CemuleDlg*)AfxGetMainWnd())->transferwnd.m_ttip.SetDelayTime(TTDT_INITIAL, theApp.glob_prefs->GetToolTipDelay()*1000);
	
	theApp.emuledlg->transferwnd.downloadlistctrl.SetStyle();
	LoadSettings();

	if (mintotray_old != app_prefs->prefs->mintotray)
		theApp.emuledlg->TrayMinimizeToTrayChange();
	if (!theApp.glob_prefs->ShowRatesOnTitle()) {
		sprintf(buffer,"eMule v%s",CURRENT_VERSION_LONG);
		theApp.emuledlg->SetWindowText(buffer);
	}

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgDisplay::Localize(void)
{
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_PW_DISPLAY));
		GetDlgItem(IDC_MINTRAY)->SetWindowText(GetResString(IDS_PW_TRAY));
		GetDlgItem(IDC_DBLCLICK)->SetWindowText(GetResString(IDS_PW_DBLCLICK));
		GetDlgItem(IDC_TOOLTIPDELAY_LBL)->SetWindowText(GetResString(IDS_PW_TOOL));
		GetDlgItem(IDC_3DDEP)->SetWindowText(GetResString(IDS_3DDEP));
		GetDlgItem(IDC_FLAT)->SetWindowText(GetResString(IDS_FLAT));
		GetDlgItem(IDC_ROUND)->SetWindowText(GetResString(IDS_ROUND));
		GetDlgItem(IDC_UPDATEQUEUE)->SetWindowText(GetResString(IDS_UPDATEQUEUE));
		GetDlgItem(IDC_SHOWRATEONTITLE)->SetWindowText(GetResString(IDS_SHOWRATEONTITLE));
		GetDlgItem(IDC_INDICATERATINGS)->SetWindowText(GetResString(IDS_INDICATERATINGS));
		GetDlgItem(IDC_DISABLEKNOWNLIST)->SetWindowText(GetResString(IDS_DISABLEKNOWNLIST));
		GetDlgItem(IDC_DISABLEQUEUELIST)->SetWindowText(GetResString(IDS_DISABLEQUEUELIST));
		GetDlgItem(IDC_STATIC_CPUMEM)->SetWindowText(GetResString(IDS_STATIC_CPUMEM));
		GetDlgItem(IDC_SHOWCATINFO)->SetWindowText(GetResString(IDS_SHOWCATINFO));
		GetDlgItem(IDC_REPAINT)->SetWindowText(GetResString(IDS_REPAINTGRAPHS));
	}
}

void CPPgDisplay::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SetModified(TRUE);

	UpdateData(false); 
	CPropertyPage::OnHScroll(nSBCode, nPos, pScrollBar);
}
