#pragma once

class CLogListCtrl : public CListCtrl
{
	DECLARE_DYNAMIC(CLogListCtrl)
public:
	CLogListCtrl();
	virtual ~CLogListCtrl();

	void Init(LPCTSTR pszTitle);
	void Localize();

	void AddEntry(LPCTSTR pszMsg);
	void Reset();
	CString GetLastLogEntry();
	CString GetAllLogEntries();

protected:
	CTitleMenu m_LogMenu;
	int m_iMaxLogMessages;
	bool m_bAutoScroll;
	CStringArray m_astrBuff;

	void AddListItem(LPCTSTR pszMsg);
	void SelectAllItems();
	void CopySelectedItems();
	int GetMaxSize();

	DECLARE_MESSAGE_MAP()
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	afx_msg void OnLvnDeleteallitems(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
};
