//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include "IrcSocket.h"
#include "packets.h"
#include "opcodes.h"
#include "ircmain.h"
#include "emule.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


CIrcSocket::CIrcSocket(CIrcMain* pIrcMain) : CAsyncSocket()
{
	m_pIrcMain = pIrcMain;
}

CIrcSocket::~CIrcSocket()
{
}


#if 0
BEGIN_MESSAGE_MAP(CIrcSocket, CAsyncSocket)
END_MESSAGE_MAP()
#endif

void CIrcSocket::Connect()
{
	CAsyncSocket::Connect(theApp.glob_prefs->GetIRCServer(), 6667);
}

void CIrcSocket::OnReceive(int nErrorCode) 
{
	char buffer[256];
	int length = this->Receive(buffer, sizeof(buffer)-1);	
	buffer[length] = '\0';
	theApp.downloadqueue->AddDownDataOverheadOther(length*8);
	m_pIrcMain->PreParseMessage( buffer );
}

void CIrcSocket::OnConnect(int nErrorCode)
{
	m_pIrcMain->SetConnectStatus(true);
	m_pIrcMain->SendLogin();
}
void CIrcSocket::OnClose(int nErrorCode)
{
	m_pIrcMain->SetConnectStatus(false);
	CAsyncSocket::Close();
}

int CIrcSocket::SendString(CString message){
	message += "\r\n";
	int size = message.GetLength();
	theApp.uploadqueue->AddUpDataOverheadOther(size*8);
	return this->Send(message, size);
}