
#include "stdafx.h" 
#include "emule.h"
#include "CommentDialogLst.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


IMPLEMENT_DYNAMIC(CCommentDialogLst, CDialog) 
CCommentDialogLst::CCommentDialogLst(CPartFile* file) 
   : CResizableDialog(CCommentDialogLst::IDD, 0) 
{ 
   m_file = file; 
} 

CCommentDialogLst::~CCommentDialogLst() 
{ 
} 

void CCommentDialogLst::DoDataExchange(CDataExchange* pDX) 
{ 
   CDialog::DoDataExchange(pDX); 
   DDX_Control(pDX, IDC_LST, pmyListCtrl);
} 

BEGIN_MESSAGE_MAP(CCommentDialogLst, CResizableDialog) 
   ON_BN_CLICKED(IDCOK, OnBnClickedApply) 
   ON_BN_CLICKED(IDCREF, OnBnClickedRefresh) 
   ON_NOTIFY(NM_DBLCLK, IDC_LST, OnNMDblclkLst)
END_MESSAGE_MAP() 



void CCommentDialogLst::OnBnClickedApply() 
{ 
   CDialog::OnOK(); 
} 

void CCommentDialogLst::OnBnClickedRefresh() 
{ 
   CompleteList(); 
} 

BOOL CCommentDialogLst::OnInitDialog(){ 
   CResizableDialog::OnInitDialog(); 

   SetIcon(theApp.emuledlg->sourceTrayIcon,FALSE);

   AddAnchor(IDC_LST,TOP_LEFT,BOTTOM_RIGHT);
   AddAnchor(IDCOK,BOTTOM_RIGHT);
   AddAnchor(IDCREF,BOTTOM_RIGHT);
   AddAnchor(IDC_CMSTATUS,BOTTOM_LEFT);

   pmyListCtrl.InsertColumn(0, GetResString(IDS_CD_UNAME), LVCFMT_LEFT, 130, -1); 
   pmyListCtrl.InsertColumn(1, GetResString(IDS_DL_FILENAME), LVCFMT_LEFT, 130, -1); 
   pmyListCtrl.InsertColumn(2, GetResString(IDS_QL_RATING), LVCFMT_LEFT, 80, 1); 
   pmyListCtrl.InsertColumn(3, GetResString(IDS_COMMENT), LVCFMT_LEFT, 340, 1); 

   Localize(); 
   CompleteList(); 

   return TRUE; 
} 

void CCommentDialogLst::Localize(void){ 
   GetDlgItem(IDCOK)->SetWindowText(GetResString(IDS_CW_CLOSE)); 
   GetDlgItem(IDCREF)->SetWindowText(GetResString(IDS_CMT_REFRESH)); 
   SetWindowText(GetResString(IDS_CMT_READALL)+" ("+ m_file->GetFileName() +")"); 
} 

void CCommentDialogLst::CompleteList () { 
   POSITION pos1,pos2; 
   CUpDownClient* cur_src; 
   int count=0; 

   pmyListCtrl.DeleteAllItems();
   
   for (int sl=0;sl<SOURCESSLOTS;sl++) if (!m_file->srclists[sl].IsEmpty())
   for (pos1 = m_file->srclists[sl].GetHeadPosition(); (pos2 = pos1) != NULL;) { 
      m_file->srclists[sl].GetNext(pos1); 
      cur_src = m_file->srclists[sl].GetAt(pos2); 

	  if (cur_src->GetFileComment().GetLength()>0 || cur_src->GetFileRate()>0) {
//			pmyListCtrl.InsertItem(count, cur_src->GetUserName()); 
			pmyListCtrl.InsertItem(LVIF_TEXT|LVIF_PARAM,count,cur_src->GetUserName(),0,0,1,(LPARAM)cur_src);
			pmyListCtrl.SetItemText(count, 1, cur_src->GetClientFilename()); 
			pmyListCtrl.SetItemText(count, 2, GetRateString(cur_src->GetFileRate())); 
			pmyListCtrl.SetItemText(count, 3, cur_src->GetFileComment()); 
			count++;
	  } 
   } 
   CString info="";
   if (count==0) info="("+GetResString(IDS_CMT_NONE)+")";
   GetDlgItem(IDC_CMSTATUS)->SetWindowText(info);
   m_file->UpdateFileRatingCommentAvail();
}

void CCommentDialogLst::OnNMDblclkLst(NMHDR *pNMHDR, LRESULT *pResult)
{
	if (pmyListCtrl.GetSelectedCount()==0) return;

	CUpDownClient* client = (CUpDownClient*)pmyListCtrl.GetItemData(pmyListCtrl.GetSelectionMark());
	if (client) theApp.emuledlg->chatwnd.StartSession(client);
	theApp.emuledlg->SetActiveDialog(&theApp.emuledlg->chatwnd);
	*pResult = 0;
}
