//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// QueueListCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "QueueListCtrl.h"
#include "otherfunctions.h"
#include "opcodes.h"
#include "ClientDetailDialog.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


// CQueueListCtrl

IMPLEMENT_DYNAMIC(CQueueListCtrl, CMuleListCtrl)
CQueueListCtrl::CQueueListCtrl(){

	// Barry - Refresh the queue every 10 secs
	m_hTimer = ::SetTimer(NULL,				// Window to associate with
						NULL,				// ID of timer (ignored if window = null)
						10000,				// Time out duration
						(TIMERPROC)CQueueListCtrl::QueueUpdateTimer);	// Proc to run
	if (!m_hTimer)
		theApp.emuledlg->AddLogLine(false, GetResString(IDS_ERR_TIMERCREATEFAILED));
}

void CQueueListCtrl::Init(){
	SetExtendedStyle(LVS_EX_FULLROWSELECT);
	InsertColumn(0,GetResString(IDS_QL_USERNAME),LVCFMT_LEFT,150,0);
	InsertColumn(1,GetResString(IDS_FILE),LVCFMT_LEFT,275,1);
	InsertColumn(2,GetResString(IDS_FILEPRIO),LVCFMT_LEFT,110,2);
	InsertColumn(3,GetResString(IDS_QL_RATING),LVCFMT_LEFT,60,3);
	InsertColumn(4,GetResString(IDS_SCORE),LVCFMT_LEFT,60,4);
	InsertColumn(5,GetResString(IDS_ASKED),LVCFMT_LEFT,60,5);
	InsertColumn(6,GetResString(IDS_LASTSEEN),LVCFMT_LEFT,110,6);
	InsertColumn(7,GetResString(IDS_ENTERQUEUE),LVCFMT_LEFT,110,7);
	InsertColumn(8,GetResString(IDS_BANNED),LVCFMT_LEFT,60,8);
	InsertColumn(9,GetResString(IDS_UPSTATUS),LVCFMT_LEFT,100,9);
	imagelist.Create(16,16,ILC_COLOR32|ILC_MASK,0,10);
	imagelist.SetBkColor(RGB(255,255,255));
	imagelist.Add(theApp.LoadIcon(IDI_USER0));
	imagelist.Add(theApp.LoadIcon(IDI_COMPPROT));
	imagelist.Add(theApp.LoadIcon(IDI_PLUS));
	imagelist.Add(theApp.LoadIcon(IDI_PLUSCOMPROT));
	imagelist.Add(theApp.LoadIcon(IDI_FRIEND));
	imagelist.Add(theApp.LoadIcon(IDI_MLDONK));
	imagelist.Add(theApp.LoadIcon(IDI_PLUSMLDONK));
	imagelist.Add(theApp.LoadIcon(IDI_EDONKEYHYBRID));
	imagelist.Add(theApp.LoadIcon(IDI_PLUSEDONKEYHYBRID));

	SetImageList(&imagelist,LVSIL_SMALL);

	m_ClientMenu.CreatePopupMenu();
	m_ClientMenu.AddMenuTitle(GetResString(IDS_CLIENTS));
	m_ClientMenu.AppendMenu(MF_STRING,MP_DETAIL, GetResString(IDS_SHOWDETAILS));
	m_ClientMenu.AppendMenu(MF_STRING,MP_ADDFRIEND, GetResString(IDS_ADDFRIEND));
	m_ClientMenu.AppendMenu(MF_STRING,MP_MESSAGE, GetResString(IDS_SEND_MSG));
	m_ClientMenu.AppendMenu(MF_STRING,MP_UNBAN, GetResString(IDS_UNBAN));
	m_ClientMenu.AppendMenu(MF_STRING,MP_SHOWLIST, GetResString(IDS_VIEWFILES));
	m_ClientMenu.AppendMenu(MF_SEPARATOR);
	m_ClientMenu.AppendMenu(MF_STRING,MP_SWITCHCTRL, GetResString(IDS_VIEWUPLOADS));
	SetMenu(&m_ClientMenu);
	LoadSettings(CPreferences::tableQueue);

	// Barry - Use preferred sort order from preferences
	int sortItem = theApp.glob_prefs->GetColumnSortItem(CPreferences::tableQueue);
	bool sortAscending = theApp.glob_prefs->GetColumnSortAscending(CPreferences::tableQueue);
	SetSortArrow(sortItem, sortAscending);
	SortItems(SortProc, sortItem + (sortAscending ? 0:10));
}

CQueueListCtrl::~CQueueListCtrl()
{
	// Barry - Kill the timer that was created
	try
	{
		if (m_hTimer)
			::KillTimer(NULL, m_hTimer);
	} catch (...) {}
}

void CQueueListCtrl::Localize() {
	CHeaderCtrl* pHeaderCtrl = GetHeaderCtrl();
	HDITEM hdi;
	hdi.mask = HDI_TEXT;

	if(pHeaderCtrl->GetItemCount() != 0) {
		CString strRes;

		strRes = GetResString(IDS_QL_USERNAME);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(0, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_FILE);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(1, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_FILEPRIO);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(2, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_QL_RATING);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(3, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_SCORE);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(4, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_ASKED);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(5, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_LASTSEEN);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(6, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_ENTERQUEUE);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(7, &hdi);
		strRes.ReleaseBuffer();

		strRes = GetResString(IDS_BANNED);
		hdi.pszText = strRes.GetBuffer();
		pHeaderCtrl->SetItem(8, &hdi);
		strRes.ReleaseBuffer();
	}
}

void CQueueListCtrl::AddClient(CUpDownClient* client, bool reset){
	uint32 itemnr = GetItemCount();
	itemnr = InsertItem(LVIF_TEXT|LVIF_PARAM,itemnr,0,0,0,1,(LPARAM)client);

    if(reset == true) {
        client->SetWaitStartTime();
	    client->SetAskedCount(1);
    }

    RefreshClient(client);
}

void CQueueListCtrl::RemoveClient(CUpDownClient* client){
	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)client;
	sint32 result = FindItem(&find);
	if (result != (-1) )
		DeleteItem(result);
}

void CQueueListCtrl::RefreshClient(CUpDownClient* client){
	// There is some type of timing issue here.. If you click on item in the queue or upload and leave
	// the focus on it when you exit the cient, it breaks on line 854 of emuleDlg.cpp.. 
	// I added this IsRunning() check to this function and the DrawItem method and
	// this seems to keep it from crashing. This is not the fix but a patch until
	// someone points out what is going wrong.. Also, it will still assert in debug mode..
	if( !theApp.emuledlg->IsRunning() )
		return;
	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)client;
	sint16 result = FindItem(&find);
	if(result != -1)
		Update(result);
	return;
}

void CQueueListCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct){
	if( !theApp.emuledlg->IsRunning() )
		return;
	if (!lpDrawItemStruct->itemData)
		return;
	CDC* odc = CDC::FromHandle(lpDrawItemStruct->hDC);
	BOOL bCtrlFocused = ((GetFocus() == this ) || (GetStyle() & LVS_SHOWSELALWAYS));
	if( (lpDrawItemStruct->itemAction | ODA_SELECT) && (lpDrawItemStruct->itemState & ODS_SELECTED )){
		if(bCtrlFocused)
			odc->SetBkColor(m_crHighlight);
		else
			odc->SetBkColor(m_crNoHighlight);
	}
	else
		odc->SetBkColor(GetBkColor());
	CUpDownClient* client = (CUpDownClient*)lpDrawItemStruct->itemData;
	CMemDC dc(CDC::FromHandle(lpDrawItemStruct->hDC),&CRect(lpDrawItemStruct->rcItem));
	dc.SelectObject(GetFont());
	COLORREF crOldTextColor = dc->GetTextColor();
	COLORREF crOldBkColor = dc->GetBkColor();
	RECT cur_rec;
	memcpy(&cur_rec,&lpDrawItemStruct->rcItem,sizeof(RECT));

	CString Sbuffer;
//	char buffer[100];

	CKnownFile* file = theApp.sharedfiles->GetFileByID(client->reqfileid);
	CHeaderCtrl *pHeaderCtrl = GetHeaderCtrl();
	int iCount = pHeaderCtrl->GetItemCount();
	cur_rec.right = cur_rec.left - 8;
	cur_rec.left += 4;

	for(int iCurrent = 0; iCurrent < iCount; iCurrent++){
		int iColumn = pHeaderCtrl->OrderToIndex(iCurrent);
		if( !IsColumnHidden(iColumn) ){
			cur_rec.right += GetColumnWidth(iColumn);
			switch(iColumn){
				case 0:{
					uint8 image;
					if (client->IsFriend())
						image = 4;
					else if (client->ExtProtocolAvailable()){
						if (client->credits->GetScoreRatio() > 1)
							image = 3;
						else
							image = 1;
					}
					else{
						if (client->GetClientSoft() == SO_MLDONKEY ){
							if (client->credits->GetScoreRatio() > 1)
								image = 6;
							else
								image = 5;
						}
						else if (client->GetClientSoft() == SO_EDONKEYHYBRID ){
							if(client->credits->GetScoreRatio() > 1)
								image = 8;
							else
								image = 7;
						}
						else{
						if (client->credits->GetScoreRatio() > 1)
							image = 2;
						else
							image = 0;
						}
					}
					POINT point = {cur_rec.left, cur_rec.top+1};
					imagelist.Draw(dc,image, point, ILD_NORMAL);
					Sbuffer.Format("%s", client->GetUserName());
					cur_rec.left +=20;
					dc->DrawText(Sbuffer,Sbuffer.GetLength(),&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER|DT_NOPREFIX|DT_END_ELLIPSIS);
					cur_rec.left -=20;
					break;
				}
				case 1:
					if(file)
						Sbuffer.Format("%s", file->GetFileName());
					else
						Sbuffer = "?";
					break;
				case 2:
					if(file){
						switch(file->GetPriority()){ 
							case PR_VERYHIGH:
								Sbuffer.Format("%s",GetResString(IDS_PRIORELEASE));
								break;
							case PR_HIGH: 
								Sbuffer.Format("%s",GetResString(IDS_PRIOHIGH));
								break; 
							case PR_LOW: 
								Sbuffer.Format("%s",GetResString(IDS_PRIOLOW));
								break; 
							case PR_VERYLOW:
								Sbuffer.Format("%s",GetResString(IDS_PRIOVERYLOW));
								break;
							default: 
								Sbuffer.Format("%s",GetResString(IDS_PRIONORMAL));
							break; 
						}
					}
					else
						Sbuffer = "?";
					break;
				case 3:
					Sbuffer.Format("%.1f",(float)client->GetScore(false,false,true));
					break;
				case 4:
					Sbuffer.Format("%i",client->GetScore(false));
					break;
				case 5:
					Sbuffer.Format("%i",client->GetAskedCount());
					break;
				case 6:
					Sbuffer.Format("%s", CastSecondsToHM((::GetTickCount() - client->GetLastUpRequest())/1000));
					break;
				case 7:
					Sbuffer.Format("%s", CastSecondsToHM((::GetTickCount() - client->GetWaitStartTime())/1000));
					break;
				case 8:
					if(client->IsBanned())
						Sbuffer.Format("%s",GetResString(IDS_YES));
					else
						Sbuffer.Format("%s",GetResString(IDS_NO));
					break;
				case 9:
					if( client->GetUpPartCount()){
						cur_rec.bottom--;
						cur_rec.top++;
						client->DrawUpStatusBar(dc,&cur_rec,false,false);
						cur_rec.bottom++;
						cur_rec.top--;
					}
					break;
					   }
				if( iColumn != 9 && iColumn != 0)
				dc->DrawText(Sbuffer,Sbuffer.GetLength(),&cur_rec,DT_LEFT|DT_SINGLELINE|DT_VCENTER|DT_NOPREFIX|DT_END_ELLIPSIS);
			cur_rec.left += GetColumnWidth(iColumn);
		}
	}
}

BEGIN_MESSAGE_MAP(CQueueListCtrl, CMuleListCtrl)
	ON_NOTIFY_REFLECT (NM_RCLICK, OnNMRclick)
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, OnColumnClick)
END_MESSAGE_MAP()

// CQueueListCtrl message handlers
void CQueueListCtrl::OnNMRclick(NMHDR *pNMHDR, LRESULT *pResult){	
	POINT point;
	::GetCursorPos(&point);	
	m_ClientMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
	*pResult = 0;
}

BOOL CQueueListCtrl::OnCommand(WPARAM wParam,LPARAM lParam ){
	if (GetSelectionMark() != (-1)){
		CUpDownClient* client = (CUpDownClient*)GetItemData(GetSelectionMark());
		switch (wParam){
			case MP_SHOWLIST:
				client->RequestSharedFileList();
				break;
			case MP_MESSAGE:{
				theApp.emuledlg->chatwnd.StartSession(client);
				break;
			}
			case MP_ADDFRIEND:{
				theApp.friendlist->AddFriend(client);
				break;
			}
			case MP_UNBAN:{
				if( client->IsBanned() )
					client->UnBan();
				break;
			}
			case MP_DETAIL:
				CClientDetailDialog dialog(client);
				dialog.DoModal();
				break;

		}
	}
	switch(wParam){
		case MP_SWITCHCTRL:{
			((CTransferWnd*)GetParent())->SwitchUploadList();
			break;
		}
	}
	return true;
} 

void CQueueListCtrl::OnColumnClick( NMHDR* pNMHDR, LRESULT* pResult){

//	theApp.uploadqueue->ResetClientPos();
	CUpDownClient* update = theApp.uploadqueue->GetNextClient(NULL);
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	// Barry - Store sort order in preferences
	// Determine ascending based on whether already sorted on this column
	int sortItem = theApp.glob_prefs->GetColumnSortItem(CPreferences::tableQueue);
	bool m_oldSortAscending = theApp.glob_prefs->GetColumnSortAscending(CPreferences::tableQueue);
	bool sortAscending = (sortItem != pNMListView->iSubItem) ? true : !m_oldSortAscending;
	// Item is column clicked
	sortItem = pNMListView->iSubItem;
	// Save new preferences
	theApp.glob_prefs->SetColumnSortItem(CPreferences::tableQueue, sortItem);
	theApp.glob_prefs->SetColumnSortAscending(CPreferences::tableQueue, sortAscending);
	// Sort table
	SetSortArrow(sortItem, sortAscending);
	SortItems(SortProc, sortItem + (sortAscending ? 0:10));

	*pResult = 0;
}

int CQueueListCtrl::SortProc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort){
	CUpDownClient* item1 = (CUpDownClient*)lParam1;
	CUpDownClient* item2 = (CUpDownClient*)lParam2;
	CKnownFile* file1 = theApp.sharedfiles->GetFileByID(item1->reqfileid);
	CKnownFile* file2 = theApp.sharedfiles->GetFileByID(item2->reqfileid);
		switch(lParamSort){
		case 0: 
			return CString(item1->GetUserName()).CompareNoCase(item2->GetUserName());
		case 10:
			return CString(item2->GetUserName()).CompareNoCase(item1->GetUserName());
		case 1: 
			if( (file1 != NULL) && (file2 != NULL))
				return CString(file1->GetFileName()).CompareNoCase(file2->GetFileName());
			else if( file1 == NULL )
				return 1;
			else
				return -1;
		case 11:
			if( (file1 != NULL) && (file2 != NULL))
				return CString(file2->GetFileName()).CompareNoCase(file1->GetFileName());
			else if( file1 == NULL )
				return 1;
			else
				return -1;
		case 2: 
			if( (file1 != NULL) && (file2 != NULL))
				return file1->GetPriority() - file2->GetPriority();
			else if( file1 == NULL )
				return 1;
			else
				return -1;
		case 12:
			if( (file1 != NULL) && (file2 != NULL))
				return file2->GetPriority() - file1->GetPriority();
			else if( file1 == NULL )
				return 1;
			else
				return -1;

		case 3: 
		return (float)item1->GetScore(false,false,true) - (float)item2->GetScore(false,false,true);
		case 13: 
			return (float)item2->GetScore(false,false,true) - (float)item1->GetScore(false,false,true);

		case 4: 
			return item1->GetScore(false) - item2->GetScore(false);
		case 14: 
			return item2->GetScore(false) - item1->GetScore(false);

		case 5: 
		return item1->GetAskedCount() - item2->GetAskedCount();
		case 15: 
			return item2->GetAskedCount() - item1->GetAskedCount();
		case 6: 
			return item1->GetLastUpRequest() - item2->GetLastUpRequest();
		case 16: 
			return item2->GetLastUpRequest() - item1->GetLastUpRequest();
		case 7: 
			return item1->GetWaitStartTime() - item2->GetWaitStartTime();
		case 17: 
			return item2->GetWaitStartTime() - item1->GetWaitStartTime();
		case 8: 
			return item1->IsBanned() - item2->IsBanned();
		case 18: 
			return item2->IsBanned() - item1->IsBanned();
		case 9: 
			return item1->GetUpPartCount()- item2->GetUpPartCount();
		case 19: 
			return item2->GetUpPartCount() - item1->GetUpPartCount();

		default:
			return 0;
	}
}

// Barry - Refresh the queue every 10 secs
void CALLBACK CQueueListCtrl::QueueUpdateTimer(HWND hwnd, UINT uiMsg, UINT idEvent, DWORD dwTime)
{
	// Don't do anything if the app is shutting down - can cause unhandled exceptions
    // Don't resort every ten seconds unless the ctrl is actually visible! Removes cpu spikes.
	if (theApp.emuledlg->activewnd != &(theApp.emuledlg->transferwnd) || theApp.emuledlg->transferwnd.isUploadQueueVisible() == false ||
        !theApp.emuledlg->IsRunning() || !theApp.glob_prefs->GetUpdateQueueList())
		return;

	CUpDownClient* update = theApp.uploadqueue->GetNextClient(NULL);
	while( update )
	{
		theApp.emuledlg->transferwnd.queuelistctrl.RefreshClient(update);
		update = theApp.uploadqueue->GetNextClient(update);
	}
}

void CQueueListCtrl::ShowSelectedUserDetails() {
	if (GetSelectedCount()>0) {
		CUpDownClient* client = (CUpDownClient*)GetItemData(GetSelectionMark());

		if (client){
			CClientDetailDialog dialog(client);
			dialog.DoModal();
		}
	}
}
