// PgTweaks.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "PPgTweaks.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


// CPPgTweaks dialog

IMPLEMENT_DYNAMIC(CPPgTweaks, CPropertyPage)
CPPgTweaks::CPPgTweaks()
	: CPropertyPage(CPPgTweaks::IDD)
{
}

CPPgTweaks::~CPPgTweaks()
{
}

void CPPgTweaks::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgTweaks, CPropertyPage)

	ON_EN_CHANGE(IDC_MAXCON5SEC, OnSettingsChange)
	ON_BN_CLICKED(IDC_VERBOSE, OnSettingsChange)
	ON_BN_CLICKED(IDC_AUTOTAKEED2KLINKS, OnSettingsChange)
	ON_BN_CLICKED(IDC_UPDATEQUEUE, OnSettingsChange)
	ON_BN_CLICKED(IDC_SHOWRATEONTITLE, OnSettingsChange)
	ON_WM_HSCROLL()

END_MESSAGE_MAP()


// CPPgTweaks message handlers


BOOL CPPgTweaks::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	LoadSettings();
	Localize();


	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgTweaks::LoadSettings(void)
{
	if(m_hWnd)
	{
		CString strBuffer;

		strBuffer.Format("%d", app_prefs->GetMaxConperFive());
		GetDlgItem(IDC_MAXCON5SEC)->SetWindowText(strBuffer);
	}
	if(app_prefs->prefs->m_bVerbose)
		CheckDlgButton(IDC_VERBOSE,1);
	else
		CheckDlgButton(IDC_VERBOSE,0);
	
	if(app_prefs->prefs->showRatesInTitle)
		CheckDlgButton(IDC_SHOWRATEONTITLE,1);
	else
		CheckDlgButton(IDC_SHOWRATEONTITLE,0);

	if(app_prefs->prefs->m_bupdatequeuelist)
		CheckDlgButton(IDC_UPDATEQUEUE,1);
	else
		CheckDlgButton(IDC_UPDATEQUEUE,0);
	// Barry
	if(app_prefs->prefs->autotakeed2klinks)
		CheckDlgButton(IDC_AUTOTAKEED2KLINKS,1);
	else
		CheckDlgButton(IDC_AUTOTAKEED2KLINKS,0);
	((CSliderCtrl*)GetDlgItem(IDC_FILEBUFFERSIZE))->SetRange(1,100,true);
	((CSliderCtrl*)GetDlgItem(IDC_FILEBUFFERSIZE))->SetPos(app_prefs->prefs->m_iFileBufferSize);
	m_iFileBufferSize = app_prefs->prefs->m_iFileBufferSize;
	((CSliderCtrl*)GetDlgItem(IDC_QUEUESIZE))->SetRange(20,100,true);
	((CSliderCtrl*)GetDlgItem(IDC_QUEUESIZE))->SetPos(app_prefs->prefs->m_iQueueSize);
	m_iQueueSize = app_prefs->prefs->m_iQueueSize;

}

BOOL CPPgTweaks::OnApply()
{
	char buffer[510];
	if(GetDlgItem(IDC_MAXCON5SEC)->GetWindowTextLength())
	{
		GetDlgItem(IDC_MAXCON5SEC)->GetWindowText(buffer,20);
		app_prefs->SetMaxDownloadConperFive((atoi(buffer)) ?
			atoi(buffer) : 20);
	}
	if(IsDlgButtonChecked(IDC_VERBOSE))
		app_prefs->prefs->m_bVerbose = true;
	else
		app_prefs->prefs->m_bVerbose = false;

	if(IsDlgButtonChecked(IDC_UPDATEQUEUE))
		app_prefs->prefs->m_bupdatequeuelist = true;
	else
		app_prefs->prefs->m_bupdatequeuelist = false;

	if(IsDlgButtonChecked(IDC_SHOWRATEONTITLE))
		app_prefs->prefs->showRatesInTitle= true;
	else
		app_prefs->prefs->showRatesInTitle= false;

	// Barry
	app_prefs->prefs->autotakeed2klinks = (int8)IsDlgButtonChecked(IDC_AUTOTAKEED2KLINKS);
	app_prefs->prefs->m_iFileBufferSize = m_iFileBufferSize;
	app_prefs->prefs->m_iQueueSize = m_iQueueSize;
	LoadSettings();
	SetModified(FALSE);
	theApp.emuledlg->serverwnd.ToggleDebugWindow();

	if (!theApp.glob_prefs->ShowRatesOnTitle()) {
		sprintf(buffer,"eMule v%s",CURRENT_VERSION_LONG);
		theApp.emuledlg->SetWindowText(buffer);
	}

	return CPropertyPage::OnApply();
}

void CPPgTweaks::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	SetModified(TRUE);
	
	CSliderCtrl* slider =(CSliderCtrl*)pScrollBar;
	CString temp;
	if (pScrollBar==GetDlgItem(IDC_FILEBUFFERSIZE)) {
		m_iFileBufferSize = slider->GetPos();
		temp.Format( GetResString(IDS_FILEBUFFERSIZE), m_iFileBufferSize*15000 );
		GetDlgItem(IDC_FILEBUFFERSIZE_STATIC)->SetWindowText(temp);
	}
	else if (pScrollBar==GetDlgItem(IDC_QUEUESIZE)) {
		m_iQueueSize = slider->GetPos();
		temp.Format( GetResString(IDS_QUEUESIZE), m_iQueueSize*100 );
		GetDlgItem(IDC_QUEUESIZE_STATIC)->SetWindowText(temp);
	}

}

void CPPgTweaks::Localize(void)
{	
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_PW_TWEAK));
		GetDlgItem(IDC_MAXCON5SECLABEL )->SetWindowText(GetResString(IDS_MAXCON5SECLABEL));
		GetDlgItem(IDC_WARNING)->SetWindowText(GetResString(IDS_WARNING));
		GetDlgItem(IDC_UPDATEQUEUE)->SetWindowText(GetResString(IDS_UPDATEQUEUE));
		GetDlgItem(IDC_AUTOTAKEED2KLINKS)->SetWindowText(GetResString(IDS_AUTOTAKEED2KLINKS));
		GetDlgItem(IDC_VERBOSE)->SetWindowText(GetResString(IDS_VERBOSE));
		CString temp;
		temp.Format( GetResString(IDS_FILEBUFFERSIZE), m_iFileBufferSize*15000 );
		GetDlgItem(IDC_FILEBUFFERSIZE_STATIC)->SetWindowText(temp);
		temp.Format( GetResString(IDS_QUEUESIZE), m_iQueueSize*100 );
		GetDlgItem(IDC_QUEUESIZE_STATIC)->SetWindowText(temp);

		GetDlgItem(IDC_SHOWRATEONTITLE)->SetWindowText(GetResString(IDS_SHOWRATEONTITLE));
	}
}

