// PPgConnection.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "PPgConnection.h"
#include "wizard.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


// CPPgConnection dialog

IMPLEMENT_DYNAMIC(CPPgConnection, CPropertyPage)
CPPgConnection::CPPgConnection()
	: CPropertyPage(CPPgConnection::IDD)
{
	guardian=false;
}

CPPgConnection::~CPPgConnection()
{
}

void CPPgConnection::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgConnection, CPropertyPage)

	ON_EN_CHANGE(IDC_DOWNLOAD_CAP, OnSettingsChange)
	ON_BN_CLICKED(IDC_UDPDISABLE, OnEnChangeUDPDisable)
	ON_EN_CHANGE(IDC_UDPPORT, OnEnChangeUDPDisable)
	ON_EN_CHANGE(IDC_UPLOAD_CAP, OnSettingsChange)
	ON_EN_CHANGE(IDC_MAXDOWN, OnSettingsChange)
	ON_EN_CHANGE(IDC_MAXUP, OnSettingsChange)
	ON_EN_CHANGE(IDC_PORT, OnSettingsChange)
	ON_EN_CHANGE(IDC_MAXCON, OnSettingsChange)
	ON_EN_CHANGE(IDC_MAXSOURCEPERFILE, OnSettingsChange)
	ON_BN_CLICKED(IDC_AUTOCONNECT, OnSettingsChange)
	ON_BN_CLICKED(IDC_RECONN, OnSettingsChange)
	ON_BN_CLICKED(IDC_WIZARD, OnBnClickedWizard)
	ON_BN_CLICKED(IDC_SHOWOVERHEAD, OnSettingsChange)
END_MESSAGE_MAP()


// CPPgConnection message handlers

void CPPgConnection::OnEnChangeUDPDisable(){
		if (guardian) return;
		
		guardian=true;
		SetModified();

		GetDlgItem(IDC_UDPPORT)->EnableWindow(!IsDlgButtonChecked(IDC_UDPDISABLE));
		
		if (!IsDlgButtonChecked(IDC_UDPDISABLE) && app_prefs->prefs->udpport==0) {

			uint16 tempVal=0;
			CString strBuffer;
			char buffer[510];

			if(GetDlgItem(IDC_PORT)->GetWindowTextLength())
			{
				GetDlgItem(IDC_PORT)->GetWindowText(buffer,20);
				tempVal= (atoi(buffer)) ? atoi(buffer)+10 : app_prefs->prefs->port+10;
			}
			strBuffer.Format("%d", tempVal);
			GetDlgItem(IDC_UDPPORT)->SetWindowText(strBuffer);
		}

		guardian=false;
}

BOOL CPPgConnection::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgConnection::LoadSettings(void)
{
	if(m_hWnd)
	{
		//if( app_prefs->prefs->maxupload != 0 ){
		//	if( app_prefs->prefs->maxupload < 4 && ( app_prefs->prefs->maxupload*3 < app_prefs->prefs->maxdownload ) )
		//		app_prefs->prefs->maxdownload = app_prefs->prefs->maxupload*3;
	
		//	if( app_prefs->prefs->maxupload < 10 && ( app_prefs->prefs->maxupload*4 < app_prefs->prefs->maxdownload ) )
		//		app_prefs->prefs->maxdownload = app_prefs->prefs->maxupload*4;
		//}
		CString strBuffer;
		
		strBuffer.Format("%d", app_prefs->prefs->udpport);
		GetDlgItem(IDC_UDPPORT)->SetWindowText(strBuffer);
		CheckDlgButton(IDC_UDPDISABLE,(app_prefs->prefs->udpport==0));

		GetDlgItem(IDC_UDPPORT)->EnableWindow(app_prefs->prefs->udpport>0);
	
		strBuffer.Format("%d", app_prefs->prefs->maxGraphDownloadRate);
		GetDlgItem(IDC_DOWNLOAD_CAP)->SetWindowText(strBuffer);
		
		strBuffer.Format("%d", app_prefs->prefs->maxGraphUploadRate);
		GetDlgItem(IDC_UPLOAD_CAP)->SetWindowText(strBuffer);

		if(app_prefs->prefs->maxdownload == 0xFFFF)
			GetDlgItem(IDC_MAXDOWN)->SetWindowText("0");
		else
		{
			strBuffer.Format("%d", app_prefs->prefs->maxdownload);
			GetDlgItem(IDC_MAXDOWN)->SetWindowText(strBuffer);
		}
		if(app_prefs->prefs->maxupload == 0xFFFF)
			GetDlgItem(IDC_MAXUP)->SetWindowText("0");
		else
		{
			strBuffer.Format("%d", app_prefs->prefs->maxupload);
			GetDlgItem(IDC_MAXUP)->SetWindowText(strBuffer);
		}

		strBuffer.Format("%d", app_prefs->prefs->port);
		GetDlgItem(IDC_PORT)->SetWindowText(strBuffer);

		strBuffer.Format("%d", app_prefs->prefs->maxconnections);
		GetDlgItem(IDC_MAXCON)->SetWindowText(strBuffer);

		if(app_prefs->prefs->maxsourceperfile == 0xFFFF)
			GetDlgItem(IDC_MAXSOURCEPERFILE)->SetWindowText("0");
		else
		{
			strBuffer.Format("%d", app_prefs->prefs->maxsourceperfile);
			GetDlgItem(IDC_MAXSOURCEPERFILE)->SetWindowText(strBuffer);
		}

		if (app_prefs->prefs->reconnect)
			CheckDlgButton(IDC_RECONN,1);
		else
			CheckDlgButton(IDC_RECONN,0);
		
		if (app_prefs->prefs->m_bshowoverhead)
			CheckDlgButton(IDC_SHOWOVERHEAD,1);
		else
			CheckDlgButton(IDC_SHOWOVERHEAD,0);

		if (app_prefs->prefs->autoconnect)
			CheckDlgButton(IDC_AUTOCONNECT,1);
		else
			CheckDlgButton(IDC_AUTOCONNECT,0);
	}
}

BOOL CPPgConnection::OnApply()
{
	char buffer[510];
	int lastmaxgu = app_prefs->prefs->maxGraphUploadRate;
	int lastmaxgd = app_prefs->prefs->maxGraphDownloadRate;

	if(GetDlgItem(IDC_DOWNLOAD_CAP)->GetWindowTextLength())
	{ 
		GetDlgItem(IDC_DOWNLOAD_CAP)->GetWindowText(buffer,20);
		app_prefs->prefs->maxGraphDownloadRate = (atoi(buffer)) ? atoi(buffer) : 100;
	}
	if(GetDlgItem(IDC_UPLOAD_CAP)->GetWindowTextLength())
	{
		GetDlgItem(IDC_UPLOAD_CAP)->GetWindowText(buffer,20);
		app_prefs->prefs->maxGraphUploadRate = (atoi(buffer)) ? atoi(buffer) : 25;
	}

	if(GetDlgItem(IDC_MAXUP)->GetWindowTextLength())
	{
		GetDlgItem(IDC_MAXUP)->GetWindowText(buffer,20);
		app_prefs->prefs->maxupload = (atoi(buffer)) ? atoi(buffer) : 0xFFFF;
	}
	if(GetDlgItem(IDC_MAXDOWN)->GetWindowTextLength())
	{
		GetDlgItem(IDC_MAXDOWN)->GetWindowText(buffer,20);
		app_prefs->prefs->maxdownload = (atoi(buffer)) ? atoi(buffer) : 0xFFFF;
	}
	
	if(GetDlgItem(IDC_PORT)->GetWindowTextLength())
	{
		GetDlgItem(IDC_PORT)->GetWindowText(buffer,20);
		app_prefs->prefs->port = (atoi(buffer)) ? atoi(buffer) : 4662;
	}
	
	if(GetDlgItem(IDC_MAXSOURCEPERFILE)->GetWindowTextLength())
	{
		GetDlgItem(IDC_MAXSOURCEPERFILE)->GetWindowText(buffer,20);
		app_prefs->prefs->maxsourceperfile = (atoi(buffer)) ? atoi(buffer) : 1;
	}

	if(GetDlgItem(IDC_UDPPORT)->GetWindowTextLength())
	{
		GetDlgItem(IDC_UDPPORT)->GetWindowText(buffer,20);
		app_prefs->prefs->udpport = (atoi(buffer) && !IsDlgButtonChecked(IDC_UDPDISABLE) ) ? atoi(buffer) : 0;
	}

	if(IsDlgButtonChecked(IDC_SHOWOVERHEAD))
		app_prefs->prefs->m_bshowoverhead = true;
	else
		app_prefs->prefs->m_bshowoverhead = false;

	
	//	if(IsDlgButtonChecked(IDC_UDPDISABLE)) app_prefs->prefs->udpport=0;
	GetDlgItem(IDC_UDPPORT)->EnableWindow(!IsDlgButtonChecked(IDC_UDPDISABLE));

	app_prefs->prefs->autoconnect = (int8)IsDlgButtonChecked(IDC_AUTOCONNECT);
	app_prefs->prefs->reconnect = (int8)IsDlgButtonChecked(IDC_RECONN);
		
	if(lastmaxgu != app_prefs->prefs->maxGraphUploadRate) 
		theApp.emuledlg->statisticswnd.SetARange(false,app_prefs->prefs->maxGraphUploadRate);
	if(lastmaxgd!=app_prefs->prefs->maxGraphDownloadRate)
		theApp.emuledlg->statisticswnd.SetARange(true,app_prefs->prefs->maxGraphDownloadRate);

	uint16 tempcon = app_prefs->prefs->maxconnections;
	if(GetDlgItem(IDC_MAXCON)->GetWindowTextLength())
	{
		GetDlgItem(IDC_MAXCON)->GetWindowText(buffer,20);
		tempcon = (atoi(buffer)) ? atoi(buffer) : CPreferences::GetRecommendedMaxConnections();
	}

	if(tempcon > (unsigned)::GetMaxConnections())
	{
		CString strMessage;
		strMessage.Format(GetResString(IDS_PW_WARNING), GetResString(IDS_PW_MAXC), ::GetMaxConnections());
		int iResult = MessageBox(strMessage, GetResString(IDS_PW_MAXC), MB_ICONWARNING | MB_YESNO);
		if(iResult != IDYES)
		{
			//TODO: set focus to max connection?
			strMessage.Format("%d", app_prefs->prefs->maxconnections);
			GetDlgItem(IDC_MAXCON)->SetWindowText(strMessage);
			tempcon = ::GetMaxConnections();
		}
	}
	app_prefs->prefs->maxconnections = tempcon;

	//if (app_prefs->prefs->maxGraphDownloadRate<app_prefs->prefs->maxdownload) app_prefs->prefs->maxdownload=UNLIMITED;
	//if (app_prefs->prefs->maxGraphUploadRate<app_prefs->prefs->maxupload) app_prefs->prefs->maxupload=UNLIMITED;

	SetModified(FALSE);
//	app_prefs->Save();
	LoadSettings();
//	theApp.emuledlg->preferenceswnd.m_wndTweaks.LoadSettings();
	return CPropertyPage::OnApply();
}

void CPPgConnection::Localize(void)
{	
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_PW_CONNECTION));
		
		GetDlgItem(IDC_CAPACITIES_FRM)->SetWindowText(GetResString(IDS_PW_CON_CAPFRM));
		GetDlgItem(IDC_DCAP_LBL)->SetWindowText(GetResString(IDS_PW_CON_DOWNLBL));
		GetDlgItem(IDC_UCAP_LBL)->SetWindowText(GetResString(IDS_PW_CON_UPLBL));
		
		GetDlgItem(IDC_LIMITS_FRM)->SetWindowText(GetResString(IDS_PW_CON_LIMITFRM));
		GetDlgItem(IDC_DLIMIT_LBL)->SetWindowText(GetResString(IDS_PW_CON_DOWNLBL));
		GetDlgItem(IDC_ULIMIT_LBL)->SetWindowText(GetResString(IDS_PW_CON_UPLBL));

		GetDlgItem(IDC_KBS1)->SetWindowText(GetResString(IDS_KBYTESEC));
		GetDlgItem(IDC_KBS2)->SetWindowText(GetResString(IDS_KBYTESEC));
		GetDlgItem(IDC_KBS3)->SetWindowText(GetResString(IDS_KBYTESEC));
		GetDlgItem(IDC_KBS4)->SetWindowText(GetResString(IDS_KBYTESEC));

		GetDlgItem(IDC_MAXCONN_FRM)->SetWindowText(GetResString(IDS_PW_CONLIMITS));
		GetDlgItem(IDC_MAXCONLABEL)->SetWindowText(GetResString(IDS_PW_MAXC));

		GetDlgItem(IDC_SHOWOVERHEAD)->SetWindowText(GetResString(IDS_SHOWOVERHEAD));
		
		GetDlgItem(IDC_CLIENTPORT_FRM)->SetWindowText(GetResString(IDS_PW_CLIENTPORT));
		GetDlgItem(IDC_MAXSRC_FRM)->SetWindowText(GetResString(IDS_PW_MAXSOURCES));

		GetDlgItem(IDC_AUTOCONNECT)->SetWindowText(GetResString(IDS_PW_AUTOCON));
		GetDlgItem(IDC_RECONN)->SetWindowText(GetResString(IDS_PW_RECON));
		GetDlgItem(IDC_MAXSRCHARD_LBL)->SetWindowText(GetResString(IDS_HARDLIMIT));
		GetDlgItem(IDC_WIZARD)->SetWindowText(GetResString(IDS_WIZARD));

		GetDlgItem(IDC_UDPPORTLABEL)->SetWindowText(GetResString(IDS_UDPPORT));
		GetDlgItem(IDC_UDPDISABLE)->SetWindowText(GetResString(IDS_UDPDISABLED));
	}
}

void CPPgConnection::OnBnClickedWizard()
{
	Wizard test;
	test.SetPrefs( app_prefs );
	test.DoModal();
}
