//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "StdAfx.h"
#include "friendlist.h"
#include "emule.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


CFriendList::CFriendList(void)
{
	LoadList();
	m_nLastSaved = ::GetTickCount();
}

CFriendList::~CFriendList(void)
{
	SaveList();
	for (POSITION pos = m_listFriends.GetHeadPosition();pos != 0;m_listFriends.GetNext(pos))
		delete m_listFriends.GetAt(pos);
	m_listFriends.RemoveAll();
}

bool CFriendList::LoadList(){
	CFriend* Record = 0; 
	CSafeFile file;
	try {
		CString strFileName = CString(theApp.glob_prefs->GetAppDir()) + CString("emfriends.met");
		if (!file.Open(strFileName.GetBuffer(),CFile::modeRead|CFile::osSequentialScan))
			return false;
		uint8 header;
		file.Read(&header,1);
		if (header != MET_HEADER){
			file.Close();
			return false;
		}
		uint32 nRecordsNumber;
		file.Read(&nRecordsNumber,4);
		for (uint32 i = 0; i != nRecordsNumber; i++) {
			Record =  new CFriend();
			Record->LoadFromFile(&file);
			m_listFriends.AddTail(Record);
		}
		file.Close();
		return true;
	}
	catch(CFileException* error){
		OUTPUT_DEBUG_TRACE();
		if (error->m_cause == CFileException::endOfFile)
			theApp.emuledlg->AddLogLine(true,GetResString(IDS_ERR_EMFRIENDSINVALID));
		else{
			char buffer[150];
			error->GetErrorMessage(buffer,150);
			theApp.emuledlg->AddLogLine(true,GetResString(IDS_ERR_READEMFRIENDS),buffer);
		}
		error->Delete();
		return false;
	}
}

void CFriendList::SaveList(){
	m_nLastSaved = ::GetTickCount(); 
	CFile file;
	CString strFileName = CString(theApp.glob_prefs->GetAppDir()) + CString("emfriends.met");
	if (!file.Open(strFileName.GetBuffer(),CFile::modeCreate|CFile::modeWrite))
		return;
	uint8 header = MET_HEADER;
	file.Write(&header,1);
	uint32 nRecordsNumber = m_listFriends.GetCount();
	file.Write(&nRecordsNumber,4);
	for (POSITION pos = m_listFriends.GetHeadPosition();pos != 0;m_listFriends.GetNext(pos)){
		m_listFriends.GetAt(pos)->WriteToFile(&file);
	}
	file.Close();
}

CFriend* CFriendList::LinkFriend(uchar* abyUserHash, uint32 m_dwIp, uint16 m_nPort){
	CFriend* backup_friend = NULL;
	for (POSITION pos = m_listFriends.GetHeadPosition();pos != 0;m_listFriends.GetNext(pos)){
		CFriend* cur_friend = m_listFriends.GetAt(pos);
		if( cur_friend->m_dwLastUsedIP == m_dwIp && cur_friend->m_nLastUsedPort == m_nPort )
			backup_friend = cur_friend;
		if (!memcmp(cur_friend->m_abyUserhash, abyUserHash,16)){
			CTime lwtime;
			cur_friend->m_dwLastSeen = mktime(lwtime.GetLocalTm());
			if (cur_friend->m_LinkedClient){
				cur_friend->m_LinkedClient->m_Friend = NULL;
				cur_friend->m_LinkedClient = NULL;
			}
			return cur_friend;
		}
	}
	return backup_friend;
}

void CFriendList::RefreshFriend(CFriend* torefresh){
	if (m_wndOutput)
		m_wndOutput->RefreshFriend(torefresh);
}

void CFriendList::ShowFriends(){
	if (!m_wndOutput){
		ASSERT ( false );
		return;
	}
	m_wndOutput->DeleteAllItems();
	for (POSITION pos = m_listFriends.GetHeadPosition();pos != 0;m_listFriends.GetNext(pos)){
		CFriend* cur_friend = m_listFriends.GetAt(pos);
		m_wndOutput->AddFriend(cur_friend);	
	}
}

//Added this to work with the IRC.. Probably a better way to do it.. But wanted this in the release..
void CFriendList::AddFriend( uchar t_m_abyUserhash[16], uint32 tm_dwLastSeen, uint32 tm_dwLastUsedIP, uint32 tm_nLastUsedPort, uint32 tm_dwLastChatted, CString tm_strName, uint32 tm_dwHasHash){
	CFriend* Record = 0; 
	Record = new CFriend( t_m_abyUserhash, tm_dwLastSeen, tm_dwLastUsedIP, tm_nLastUsedPort, tm_dwLastChatted, tm_strName, tm_dwHasHash );
	m_listFriends.AddTail(Record);
	ShowFriends();
	SaveList();
}

// Added for the friends function in the IRC..
bool CFriendList::IsAlreadyFriend( uint32 tm_dwLastUsedIP, uint32 tm_nLastUsedPort ){
	for (POSITION pos = m_listFriends.GetHeadPosition();pos != 0;m_listFriends.GetNext(pos)){
		CFriend* cur_friend = m_listFriends.GetAt(pos);
		if ( cur_friend->m_dwLastUsedIP == tm_dwLastUsedIP && cur_friend->m_nLastUsedPort == tm_nLastUsedPort ){
			return true;
		}
	}
	return false;
}

void CFriendList::AddFriend(CUpDownClient* toadd){
	if (toadd->IsFriend())
		return;
	CFriend* NewFriend = new CFriend(toadd);
	toadd->m_Friend = NewFriend;
	m_listFriends.AddTail(NewFriend);
	if (m_wndOutput)
		m_wndOutput->AddFriend(NewFriend);	
	SaveList();
}

void CFriendList::RemoveFriend(CFriend* todel){
	POSITION pos = m_listFriends.Find(todel);
	if (!pos){
		ASSERT ( false );
		return;
	}
	if (todel->m_LinkedClient){
		todel->m_LinkedClient->SetFriendSlot(false);
		todel->m_LinkedClient->m_Friend = NULL;
		todel->m_LinkedClient = NULL;
	}
	if (m_wndOutput)
		m_wndOutput->RemoveFriend(todel);
	m_listFriends.RemoveAt(pos);
	delete todel;
	SaveList();
}

void CFriendList::RemoveAllFriendSlots(){
	for (POSITION pos = m_listFriends.GetHeadPosition();pos != 0;m_listFriends.GetNext(pos)){
		CFriend* cur_friend = m_listFriends.GetAt(pos);
		if (cur_friend->m_LinkedClient){
			cur_friend->m_LinkedClient->SetFriendSlot(false);
		}
	}
}

void CFriendList::Process()
{
	if (::GetTickCount() - m_nLastSaved > 300000)
		this->SaveList();
}