//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// AddFriend.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "AddFriend.h"
#include "Friend.h"
#include "otherfunctions.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


// CAddFriend dialog

IMPLEMENT_DYNAMIC(CAddFriend, CDialog)
CAddFriend::CAddFriend()
	: CDialog(CAddFriend::IDD, 0)
{
}

CAddFriend::~CAddFriend()
{
}

void CAddFriend::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BOOL CAddFriend::OnInitDialog(){
	CDialog::OnInitDialog();
	Localize();
	

	return true;
}

BEGIN_MESSAGE_MAP(CAddFriend, CDialog)
	ON_BN_CLICKED(IDC_ADD, OnAddBtn)
END_MESSAGE_MAP()


// CAddFriend message handlers
void CAddFriend::Localize(){
	SetWindowText(GetResString(IDS_ADDAFRIEND));
	GetDlgItem(IDC_INFO1)->SetWindowText(GetResString(IDS_PAF_REQINFO));
	GetDlgItem(IDC_INFO2)->SetWindowText(GetResString(IDS_PAF_MOREINFO));

	GetDlgItem(IDC_ADD)->SetWindowText(GetResString(IDS_ADD));
	GetDlgItem(IDCANCEL)->SetWindowText(GetResString(IDS_CANCEL));

	GetDlgItem(IDC_STATIC31)->SetWindowText(GetResString(IDS_CD_UNAME));
	GetDlgItem(IDC_STATIC32)->SetWindowText(GetResString(IDS_CD_UHASH));
	GetDlgItem(IDC_STATIC34)->SetWindowText(GetResString(IDS_CD_UIP));
	GetDlgItem(IDC_STATIC35)->SetWindowText(GetResString(IDS_PORT)+":");
}

void CAddFriend::OnAddBtn() {


//	if( GetDlgItem(IDC_USERNAME)->GetWindowTextLength()==0
//		|| GetDlgItem(IDC_USERHASH)->GetWindowTextLength()!=32	){
//		
//			MessageBox(GetResString(IDS_ERR_NOVALIDFRIENDINFO));
//			return;
//	}

	char buffer[256];
	CString name,userhash, fullip;
	uint32 ip;
	uint16 port;
	ip=port=0;
	if( GetDlgItem(IDC_USERNAME)->GetWindowTextLength() ){
		GetDlgItem(IDC_USERNAME)->GetWindowText(buffer,255);
		name.Format("%s",buffer);
	}
	if(GetDlgItem(IDC_IP)->GetWindowTextLength()){
		GetDlgItem(IDC_IP)->GetWindowText(buffer,20);
		fullip.Format("%s", buffer);
	}
	else{
		MessageBox(GetResString(IDS_ERR_NOVALIDFRIENDINFO));
		return;
	}
	if(GetDlgItem(IDC_PORT)->GetWindowTextLength())
	{
		GetDlgItem(IDC_PORT)->GetWindowText(buffer,20);
		port = (atoi(buffer)) ? atoi(buffer) : 0;
	}
	else{
		MessageBox(GetResString(IDS_ERR_NOVALIDFRIENDINFO));
		return;
	}
	int counter = 0;
	CString temp;
	for( int i = 0; i < 4; i++){
		fullip.Tokenize(".",counter);
		if( counter == -1 ){
			MessageBox(GetResString(IDS_ERR_NOVALIDFRIENDINFO));
			return;
		}
	}
	counter=0;
	for(int i=0; i<4; i++){ 
		temp = fullip.Tokenize(".",counter);
		ip += atoi(temp) * pow(256,i);
	}
	
	theApp.friendlist->AddFriend(NULL, 0, ip, port, 0, name, 0 );
	
	OnCancel();
}