//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once
#include "types.h"
#include <math.h>

#define _WINVER_NT4_	0x0004
#define _WINVER_95_		0x0004
#define _WINVER_98_		0x0A04
#define _WINVER_ME_		0x5A04
#define _WINVER_2K_		0x0005
#define _WINVER_XP_		0x0105

#define ROUND(x) (floor((float)x+0.5f))

#ifdef _DEBUG
#define OUTPUT_DEBUG_TRACE() { \
	CString strTrace; \
	strTrace.Format("%s:%d, %s\n", strrchr(__FILE__, '\\') + 1, __LINE__, __FUNCTION__); \
	OutputDebugString(strTrace); \
}
#else
#define OUTPUT_DEBUG_TRACE() ((void)0)
#endif

void CastItoXBytes(uint64 count,char* output);
CString CastItoIShort(uint64 number);
void CastSecondsToHM(sint32 seconds,char* output); //<<--9/21/02
CString LeadingZero(uint32 units);
void ShellOpenFile(CString name); //<<--9/21/02
CString GetResString(UINT uStringID);//<<--10/01/02
CString GetResString(UINT uStringID,WORD languageID);
inline char* nstrdup(const char* todup);

void URLDecode(CString& result, const char* buff);// Make a malloc'd decoded strnig from an URL encoded string (with escaped spaces '%20' and  the like
CString URLEncode(CString sIn);
inline BYTE toHex(const BYTE &x);
CString GetFiletypeByName(CString infile);
bool Ask4RegFix(bool checkOnly);
int GetMaxConnections();

WORD	DetectWinVersion();
_int64	GetFreeDiskSpaceX(PCHAR pDirectory);
//For Rate File 
CString GetRateString(uint16 rate);
