//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include "otherfunctions.h"
#include "emule.h"

void CastItoXBytes(uint64 count,char* output){
	if (count < 1024)
		sprintf(output,"%.0f %s",(float)count,GetResString(IDS_BYTES));
	else if (count < 1048576)
		sprintf(output,"%.0f %s",(float)count/1024,GetResString(IDS_KBYTES));
	else if (count < 1073741824)
		sprintf(output,"%.2f %s",(float)count/1048576,GetResString(IDS_MBYTES));
	else if (count < 1099511627776)
		sprintf(output,"%.2f %s",(float)count/1073741824,GetResString(IDS_GBYTES));
	else 
		sprintf(output,"%.3f %s",(float)count/1073741824,GetResString(IDS_TBYTES));
}

CString CastItoIShort(uint64 count){
	CString output;
	if (count < 1000)
		output.Format("%.0f",count);
	else if (count < 1000000)
		output.Format("%.0f%s",(float)count/1000, GetResString(IDS_KILO));
	else if (count < 1000000000)
		output.Format("%.2f%s",(float)count/1000000, GetResString(IDS_MEGA));
	else if (count < 1000000000000)
		output.Format("%.2f%s",(float)count/1000000000, GetResString(IDS_GIGA));
	else if (count < 1000000000000000)
		output.Format("%.2f%s",(float)count/1000000000000, GetResString(IDS_TERRA));
	return output;
}

void CastSecondsToHM(sint32 count,char* output){ 
   if (count < 0) 
      sprintf(output,"?"); 
   else if (count < 60) 
	   sprintf(output,"%i %s",count,GetResString(IDS_SECS)); 
   else if (count < 3600) 
	   sprintf(output,"%i:%s %s",count/60,LeadingZero(count-(count/60)*60),GetResString(IDS_MINS));
   else if (count < 86400) 
	   sprintf(output,"%i:%s %s",count/3600,LeadingZero((count-(count/3600)*3600)/60),GetResString(IDS_HOURS));
   else 
	   sprintf(output,"%i %s %i %s",count/86400,GetResString(IDS_DAYS),(count-(count/86400)*86400)/3600,GetResString(IDS_HOURS)); 
} 

CString LeadingZero(uint32 units) {
	CString temp;
	if (units<10) temp.Format("0%i",units); else temp.Format("%i",units);
	return temp;
}

//<<--9/21/02
void ShellOpenFile(CString name){ 
    ShellExecute(NULL, "open", name, NULL, NULL, SW_SHOW); 
} 

namespace {
	bool IsHexDigit(int c) {
		switch (c) {
		case '0': return true;
		case '1': return true;
		case '2': return true;
		case '3': return true;
		case '4': return true;
		case '5': return true;
		case '6': return true;
		case '7': return true;
		case '8': return true;
		case '9': return true;
		case 'A': return true;
		case 'B': return true;
		case 'C': return true;
		case 'D': return true;
		case 'E': return true;
		case 'F': return true;
		case 'a': return true;
		case 'b': return true;
		case 'c': return true;
		case 'd': return true;
		case 'e': return true;
		case 'f': return true;
		default: return false;
		}
	}
}

void URLDecode(CString& result, const char* buff)
{
	int buflen = (int)strlen(buff);
	int x;
	int y;
	char* buff2 = nstrdup(buff); // length of buff2 will be less or equal to length of buff
	for (x = 0, y = 0; x < buflen ; ++x )
	{
		if ( buff[x] == '%' && x+2 < buflen && IsHexDigit(buff[x+1]) && IsHexDigit(buff[x+2]) ) {
			char hexstr[3];
			// Copy the two bytes following the %
			strncpy(hexstr, &buff[x + 1], 2);

			// Skip over the hex
			x = x + 2;

			// Convert the hex to ASCII
			buff2[y++] = (unsigned char)strtoul(hexstr, NULL, 16);
		}
		else {
			buff2[y++] = buff[x];
			break;
		}
	}
	result = buff2;
	free(buff2);
}

CString URLEncode(CString sIn){
    CString sOut;
	
    const int nLen = sIn.GetLength() + 1;

    register LPBYTE pOutTmp = NULL;
    LPBYTE pOutBuf = NULL;
    register LPBYTE pInTmp = NULL;
    LPBYTE pInBuf =(LPBYTE)sIn.GetBuffer(nLen);
    BYTE b = 0;
	
    //alloc out buffer
    pOutBuf = (LPBYTE)sOut.GetBuffer(nLen  * 3 - 2);//new BYTE [nLen  * 3];

    if(pOutBuf)
    {
        pInTmp	= pInBuf;
	pOutTmp = pOutBuf;
		
	// do encoding
	while (*pInTmp)
	{
	    if(isalnum(*pInTmp))
	        *pOutTmp++ = *pInTmp;
	    else
	        if(isspace(*pInTmp))
		    *pOutTmp++ = '+';
		else
		{
		    *pOutTmp++ = '%';
		    *pOutTmp++ = toHex(*pInTmp>>4);
		    *pOutTmp++ = toHex(*pInTmp%16);
		}
	    pInTmp++;
	}
	*pOutTmp = '\0';
	//sOut=pOutBuf;
	//delete [] pOutBuf;
	sOut.ReleaseBuffer();
    }
    sIn.ReleaseBuffer();
    return sOut;
}

inline BYTE toHex(const BYTE &x){
	return x > 9 ? x + 55: x + 48;
}

// Returns the Typename, examining the extention of the given filename
CString GetFiletypeByName(CString infile) {
	CString ext;

	if (infile.ReverseFind('.')==-1) return GetResString(IDS_SEARCH_ANY);

	ext= infile.Right(infile.GetLength()-infile.ReverseFind('.')).MakeLower() ;
	
	if (ext==".mpc" || ext==".mp4" || ext==".aac" || ext==".ape" || ext==".mp3" || 
		ext==".mp2" || ext==".wav" || ext==".au" || ext==".ogg" || ext==".wma") return GetResString(IDS_SEARCH_AUDIO);

	if (ext==".jpg" || ext==".jpeg" || ext==".bmp" || ext==".gif" || ext==".tif" ||
		ext==".png") return GetResString(IDS_SEARCH_PICS);

	if (ext==".avi" || ext==".mpg" || ext==".mpeg" || ext==".ram" || ext==".rm" || ext==".asf" ||
		ext==".vob" || ext==".divx" || ext==".vivo" || ext==".ogm" || ext==".mov") return GetResString(IDS_SEARCH_VIDEO);

	if (ext==".zip" || ext==".ace" || ext==".rar") return GetResString(IDS_SEARCH_ARC);

	if (ext==".exe" || ext==".com") return GetResString(IDS_SEARCH_PRG);

	if (ext==".ccd"|| ext==".sub" || ext==".cue" || ext==".bin" || ext==".iso" ||
		ext==".nrg" || ext==".ccd" || ext==".img") return GetResString(IDS_SEARCH_CDIMG);

	return GetResString(IDS_SEARCH_ANY);
}

CString GetResString(UINT uStringID) {
	return GetResString(uStringID,theApp.glob_prefs->GetLanguageID());
}

CString GetResString(UINT uStringID,WORD languageID) {
	CString resString;
	resString.LoadString(::GetModuleHandle(NULL),uStringID, languageID );
	if (!resString.GetLength())
		resString.LoadString(::GetModuleHandle(NULL),uStringID, MAKELANGID(LANG_ENGLISH,SUBLANG_DEFAULT) );
	return resString;
}

inline char* nstrdup(const char* todup) { 
   size_t len = strlen(todup)+1; 
   return (char*)memcpy(new char[len], todup, len); 
} 

bool Ask4RegFix(bool checkOnly){
	// check registry if ed2k links is assigned to emule
	CRegKey regkey;
	regkey.Create(HKEY_CLASSES_ROOT,"ed2k\\shell\\open\\command");
	ULONG maxsize = 500;
	TCHAR rbuffer[500];
	char modbuffer[490];
	char regbuffer[520];
	regkey.QueryStringValue(0,rbuffer,&maxsize);
	::GetModuleFileName(0,modbuffer, 490);
	sprintf(regbuffer,"\"%s\" \"%%1\"",modbuffer);
	if (strcmp(rbuffer,regbuffer)){
		if (checkOnly) return true;
		if (MessageBox(0,GetResString(IDS_ASSIGNED2K),GetResString(IDS_ED2KLINKFIX),MB_ICONQUESTION|MB_YESNO) == IDYES){
			regkey.SetStringValue(0,regbuffer);	
			regkey.Create(HKEY_CLASSES_ROOT,"ed2k\\DefaultIcon" );// Added Shrink 
			regkey.SetStringValue(0,modbuffer);
			regkey.Create(HKEY_CLASSES_ROOT,"ed2k" );
			regkey.SetStringValue(0,"URL: ed2k Protocol");
			regkey.SetStringValue("URL Protocol","" );
		}
	}
	regkey.Close();
	return false;
}

int GetMaxConnections() {
	OSVERSIONINFOEX osvi;
	ZeroMemory(&osvi, sizeof(OSVERSIONINFOEX));
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);

	if(!GetVersionEx((OSVERSIONINFO*)&osvi)) {
		//if OSVERSIONINFOEX doesn't work, try OSVERSIONINFO
		osvi.dwOSVersionInfoSize = sizeof (OSVERSIONINFO);
		if(!GetVersionEx((OSVERSIONINFO*)&osvi))
			return -1;  //shouldn't ever happen
	}

	if(osvi.dwPlatformId == VER_PLATFORM_WIN32_NT) // Windows NT product family
		return -1;  //no limits

	if(osvi.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS) { // Windows 95 product family

		if (osvi.dwMajorVersion == 4 && osvi.dwMinorVersion == 0) { //old school 95
			HKEY hKey;
			DWORD dwValue;
			DWORD dwLength = sizeof(dwValue);
			LONG lResult;

			RegOpenKeyEx(HKEY_LOCAL_MACHINE, "System\\CurrentControlSet\\Services\\VxD\\MSTCP",
				0, KEY_QUERY_VALUE, &hKey);
			lResult = RegQueryValueEx(hKey, TEXT("MaxConnections"), NULL, NULL,
				(LPBYTE)&dwValue, &dwLength);
			RegCloseKey(hKey);

			if(lResult != ERROR_SUCCESS || lResult < 1)
				return 100;  //the default for 95 is 100

			return dwValue;

		} else { //98 or ME
			HKEY hKey;
			TCHAR szValue[32];
			DWORD dwLength = sizeof(szValue);
			LONG lResult;

			RegOpenKeyEx(HKEY_LOCAL_MACHINE, "System\\CurrentControlSet\\Services\\VxD\\MSTCP",
				0, KEY_QUERY_VALUE, &hKey);
			lResult = RegQueryValueEx(hKey, TEXT("MaxConnections"), NULL, NULL,
				(LPBYTE)szValue, &dwLength);
			RegCloseKey(hKey);

			LONG lMaxConnections;
			if(lResult != ERROR_SUCCESS || (lMaxConnections = atoi(szValue)) < 1)
				return 100;  //the default for 98/ME is 100

			return lMaxConnections;
		}         
	}

	return -1;  //give the user the benefit of the doubt, most use NT+ anyway
}

WORD DetectWinVersion()
{
	OSVERSIONINFOEX osvi;
	BOOL bOsVersionInfoEx;

	ZeroMemory(&osvi, sizeof(OSVERSIONINFOEX));
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);

	if(!(bOsVersionInfoEx = GetVersionEx((OSVERSIONINFO*)&osvi)))
	{
		osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
		if(!GetVersionEx((OSVERSIONINFO*)&osvi)) 
		return FALSE;
	}

	switch(osvi.dwPlatformId)
	{
		case VER_PLATFORM_WIN32_NT:
			if(osvi.dwMajorVersion <= 4)
				return _WINVER_NT4_;
			if(osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 0)
				return _WINVER_2K_;
			if(osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 1)
				return _WINVER_XP_;
			break;
      
		case VER_PLATFORM_WIN32_WINDOWS:
			if(osvi.dwMajorVersion == 4 && osvi.dwMinorVersion == 0)
				return _WINVER_95_; 
			if(osvi.dwMajorVersion == 4 && osvi.dwMinorVersion == 10)
				return _WINVER_98_; 
			if(osvi.dwMajorVersion == 4 && osvi.dwMinorVersion == 90)
				return _WINVER_ME_; 
			break;
		
		default:
			break;
	}
	
	return _WINVER_95_;		// there should'nt be anything lower than this
}

_int64 GetFreeDiskSpaceX(PCHAR pDirectory)
{	
	FARPROC pGetDiskFreeSpaceEx;

	pGetDiskFreeSpaceEx = GetProcAddress(GetModuleHandle("kernel32.dll"), "GetDiskFreeSpaceExA");

	if(pGetDiskFreeSpaceEx)
	{
		ULARGE_INTEGER nFreeDiskSpace;
		ULARGE_INTEGER dummy;
		GetDiskFreeSpaceEx(pDirectory, &nFreeDiskSpace, &dummy, &dummy);
		return nFreeDiskSpace.QuadPart;
	}
	else 
	{
		char cDrive[16];
		char *p = strchr(pDirectory, '\\');
		if(p)
		{	
			memcpy(cDrive, pDirectory, p-pDirectory);
			cDrive[p-pDirectory] = '\0';
		}
		else
			strcpy(cDrive, pDirectory);
		DWORD dwSectPerClust, dwBytesPerSect, dwFreeClusters, dwDummy;
		GetDiskFreeSpace(cDrive, &dwSectPerClust, &dwBytesPerSect, &dwFreeClusters, &dwDummy);
		return (dwFreeClusters * dwSectPerClust * dwBytesPerSect);
	}
	
	return 0;
}

//For  Rate File // 
CString   GetRateString(uint16 rate)   { 
      switch (rate){ 
      case 0: 
         return GetResString(IDS_CMT_NOTRATED); 
         break; 
      case 1: 
         return GetResString(IDS_CMT_FAKE); 
         break; 
      case 2: 
         return GetResString(IDS_CMT_POOR); 
         break; 
      case 3: 
         return GetResString(IDS_CMT_GOOD); 
         break; 
      case 4: 
         return GetResString(IDS_CMT_FAIR); 
         break; 
      case 5: 
         return GetResString(IDS_CMT_EXCELLENT); 
         break; 
      } 
      return GetResString(IDS_CMT_NOTRATED); 
} 
//end rate File//