//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// SearchDlg.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "SearchDlg.h"
#include "packets.h"
#include "server.h"
#include "opcodes.h"
#include "otherfunctions.h"
#include "ED2KLink.h"

// CSearchDlg dialog

IMPLEMENT_DYNAMIC(CSearchDlg, CDialog)
CSearchDlg::CSearchDlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CSearchDlg::IDD, pParent){
		m_nSearchID = 0;
}

CSearchDlg::~CSearchDlg(){
}

BOOL CSearchDlg::OnInitDialog(){
	CResizableDialog::OnInitDialog();
	theApp.searchlist->SetOutputWnd(&searchlistctrl);
	searchlistctrl.Init(theApp.searchlist);
	Localize();
	searchprogress.SetStep(1);
	global_search_timer = 0;
	globsearch = false;

	m_ctrlSearchFrm.Init(IDI_NORMALSEARCH);
	m_ctrlWebSearchFrm.Init(IDI_WEBBASED);
	m_ctrlDirectDlFrm.Init(IDI_DIRECTDOWNLOAD);
	((CStatic*)GetDlgItem(IDC_SEARCHLST_ICO))->SetIcon((HICON)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_SEARCHRESULTS), IMAGE_ICON, 16, 16, 0));

	searchselect.ShowWindow(SW_HIDE);
	m_ImageList.Create(16,16,ILC_COLOR32|ILC_MASK,0,10);
	m_ImageList.SetBkColor(CLR_NONE);
	m_ImageList.Add(theApp.LoadIcon(IDI_BN_SEARCH));
	searchselect.SetImageList(&m_ImageList);

	AddAnchor(IDC_SDOWNLOAD,BOTTOM_RIGHT);
	AddAnchor(IDC_SEARCHLIST,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_PROGRESS1,BOTTOM_LEFT,BOTTOM_RIGHT);

	AddAnchor(IDC_DDOWN_FRM, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_ELINK, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_STARTS, TOP_RIGHT);
	AddAnchor(IDC_CANCELS, TOP_RIGHT);
	AddAnchor(IDC_CLEARALL, TOP_RIGHT);
	AddAnchor(searchselect.m_hWnd,TOP_LEFT,TOP_RIGHT);
	return true;
}

void CSearchDlg::DoDataExchange(CDataExchange* pDX){
	CResizableDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SEARCHLIST, searchlistctrl);
	DDX_Control(pDX, IDC_PROGRESS1, searchprogress);
	DDX_Control(pDX, IDC_COMBO1, typebox);
	DDX_Control(pDX, IDC_TypeSearch, Stypebox);
	DDX_Control(pDX, IDC_TAB1, searchselect);
	DDX_Control(pDX, IDC_SEARCH_FRM, m_ctrlSearchFrm);
	DDX_Control(pDX, IDC_WEBSEARCH_FRM, m_ctrlWebSearchFrm);
	DDX_Control(pDX, IDC_DDOWN_FRM, m_ctrlDirectDlFrm);
}


BEGIN_MESSAGE_MAP(CSearchDlg, CResizableDialog)
	ON_BN_CLICKED(IDC_STARTS, OnBnClickedStarts)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_CANCELS, OnBnClickedCancels)
	ON_BN_CLICKED(IDC_SDOWNLOAD, OnBnClickedSdownload)
	ON_NOTIFY(NM_DBLCLK, IDC_SEARCHLIST, OnNMDblclkSearchlist)
	ON_BN_CLICKED(IDC_CLEARALL, OnBnClickedClearall)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB1, OnTcnSelchangeTab1)
	ON_EN_CHANGE(IDC_SEARCHNAME, OnEnChangeSearchname)
	ON_CBN_SELCHANGE(IDC_TypeSearch, OnEnChangeSearchname)
	ON_MESSAGE(WM_CLOSETAB, OnCloseTab)
END_MESSAGE_MAP()


// CSearchDlg message handlers

void CSearchDlg::OnBnClickedStarts(){
		searchprogress.SetPos(0);

		if (GetDlgItem(IDC_ELINK)->GetWindowTextLength()){
		CString strlink;
		GetDlgItem(IDC_ELINK)->GetWindowText(strlink);
		if (strlink.Right(1)!="/") strlink+="/";
		GetDlgItem(IDC_ELINK)->SetWindowText("");
		try {
			CED2KLink* pLink = CED2KLink::CreateLinkFromUrl(strlink);
			_ASSERT( pLink !=0 );
			if ( pLink->GetKind() == CED2KLink::kFile) {
				theApp.downloadqueue->AddFileLinkToDownload(pLink->GetFileLink());
			} else {
				delete pLink; // [i_a] memleak
				throw CString("bad link");
			}
			delete pLink;
		} catch(CString error){
			OUTPUT_DEBUG_TRACE();
			char buffer[200];
			sprintf(buffer,GetResString(IDS_ERR_INVALIDLINK),error.GetBuffer());
			theApp.emuledlg->AddLogLine(true, GetResString(IDS_ERR_LINKERROR), buffer);
		}
		return;
	}
	if (GetDlgItem(IDC_SWEB)->GetWindowTextLength()){
		ShellOpenFile(CreateWebQuery());
		return;
	}
	// start search
	StartNewSearch();

}

void CSearchDlg::OnTimer(UINT nIDEvent){
	CResizableDialog::OnTimer(nIDEvent);
	if (theApp.serverconnect->IsConnected()){
		CServer* toask = theApp.serverlist->GetNextSearchServer();
		if (toask == theApp.serverlist->GetServerByAddress(theApp.serverconnect->GetCurrentServer()->GetAddress(),theApp.serverconnect->GetCurrentServer()->GetPort()))
			toask = theApp.serverlist->GetNextSearchServer();

		if (toask && theApp.serverlist->GetServerCount()-1 != servercount){
			servercount++;
			theApp.serverconnect->SendUDPPacket(searchpacket,toask,false);
			searchprogress.StepIt();
		}
		else
			OnBnClickedCancels();
	}
	else
		OnBnClickedCancels();
}

void CSearchDlg::OnBnClickedCancels(){
	canceld = true;
	globsearch = false;
	if (global_search_timer){
		delete searchpacket;
		KillTimer(global_search_timer);
		global_search_timer = 0;
		searchprogress.SetPos(0);
	}
	this->GetDlgItem(IDC_CANCELS)->EnableWindow(false);
	this->GetDlgItem(IDC_STARTS)->EnableWindow(true);
}


void CSearchDlg::LocalSearchEnd(uint16 count){
	if (!canceld && count > MAX_RESULTS)
		OnBnClickedCancels();
	if (!canceld){	
		if (!globsearch){
			this->GetDlgItem(IDC_STARTS)->EnableWindow(true);
			this->GetDlgItem(IDC_CANCELS)->EnableWindow(false);
		}
		else
			global_search_timer = SetTimer(1, 750, 0);

	}
}
void CSearchDlg::AddUDPResult(uint16 count){
	if (!canceld && count > MAX_RESULTS)
		OnBnClickedCancels();
}

void CSearchDlg::OnBnClickedSdownload(){
	//start download(s)
	DownloadSelected();
}

BOOL CSearchDlg::PreTranslateMessage(MSG* pMsg) 
{
   if((pMsg->message == WM_KEYDOWN) && (pMsg->wParam == 13)){
	   if (pMsg->hwnd == GetDlgItem(IDC_SEARCHLIST)->m_hWnd)
			OnBnClickedSdownload();
	   else if (pMsg->hwnd == GetDlgItem(IDC_ELINK)->m_hWnd)
			OnBnClickedStarts();
	   else if (pMsg->hwnd == GetDlgItem(IDC_SEARCHNAME)->m_hWnd)
			OnBnClickedStarts();
   }

   return CResizableDialog::PreTranslateMessage(pMsg);
}

void CSearchDlg::OnNMDblclkSearchlist(NMHDR *pNMHDR, LRESULT *pResult){
	OnBnClickedSdownload();
	*pResult = 0;
}

CString	CSearchDlg::CreateWebQuery(){
	CString query;
	query = "http://www.filedonkey.com/fdsearch/index.php?media=";
	switch (typebox.GetCurSel()){
		case 1:
			query += "Audio";
			break;
		case 2:
			query += "Video";
			break;
		case 3:
			query += "Pro";
			break;
		default:
			;
	}
	CString tosearch;
	GetDlgItem(IDC_SWEB)->GetWindowText(tosearch);
	tosearch = URLEncode(tosearch);
	tosearch.Replace("%20","+");
	query += "&pattern=";
	query += tosearch;
	query += "&action=search&name=FD-Search&op=modload&file=index&requestby=emule";
	return query;
}

void CSearchDlg::DownloadSelected() {
	int index = -1; 
	POSITION pos = searchlistctrl.GetFirstSelectedItemPosition(); 
	while(pos != NULL) 
	{ 
		index = searchlistctrl.GetNextSelectedItem(pos); 
		if(index > -1) {
			theApp.downloadqueue->AddSearchToDownload((CSearchFile*)searchlistctrl.GetItemData(index ));
			searchlistctrl.Update(index);
		}
	} 
}


void CSearchDlg::Localize(){
	searchlistctrl.Localize();

	GetDlgItem(IDC_SEARCH_FRM)->SetWindowText(GetResString(IDS_SW_SEARCHBOX));
	GetDlgItem(IDC_MSTATIC3)->SetWindowText(GetResString(IDS_SW_NAME));
	GetDlgItem(IDC_SGLOBAL)->SetWindowText(GetResString(IDS_SW_GLOBAL));
	GetDlgItem(IDC_MSTATIC7)->SetWindowText(GetResString(IDS_SW_TYPE));
	GetDlgItem(IDC_WEBSEARCH_FRM)->SetWindowText(GetResString(IDS_SW_WEBBASED));
	GetDlgItem(IDC_MSTATIC4)->SetWindowText(GetResString(IDS_SW_TYPE));
	GetDlgItem(IDC_NAME21)->SetWindowText(GetResString(IDS_SW_NAME));
	GetDlgItem(IDC_DDOWN_FRM)->SetWindowText(GetResString(IDS_SW_DIRECTDOWNLOAD));
	GetDlgItem(IIDC_FSTATIC2)->SetWindowText(GetResString(IDS_SW_LINK));
	GetDlgItem(IDC_STARTS)->SetWindowText(GetResString(IDS_SW_START));
	GetDlgItem(IDC_CANCELS)->SetWindowText(GetResString(IDS_CANCEL));
	GetDlgItem(IDC_CLEARALL)->SetWindowText(GetResString(IDS_REMOVEALLSEARCH));
	GetDlgItem(IDC_RESULTS_LBL)->SetWindowText(GetResString(IDS_SW_RESULT));
	GetDlgItem(IDC_SDOWNLOAD)->SetWindowText(GetResString(IDS_SW_DOWNLOAD));
	GetDlgItem(IDC_MSTATIC4)->SetWindowText(GetResString(IDS_TYPE));
	GetDlgItem(IDC_MSTATIC7)->SetWindowText(GetResString(IDS_TYPE));
	GetDlgItem(IDC_SEARCHMINSIZE)->SetWindowText(GetResString(IDS_SEARCHMINSIZE));
	GetDlgItem(IDC_SEARCHMAXSIZE)->SetWindowText(GetResString(IDS_SEARCHMAXSIZE));

	while (typebox.GetCount()>0) typebox.DeleteString(0);
	typebox.AddString(GetResString(IDS_SEARCH_ANY));
	typebox.AddString(GetResString(IDS_SEARCH_AUDIO));
	typebox.AddString(GetResString(IDS_SEARCH_VIDEO));
	typebox.AddString(GetResString(IDS_SEARCH_PRG));
	typebox.SetCurSel(typebox.FindString(-1,GetResString(IDS_SEARCH_ANY)));

	while (Stypebox.GetCount()>0) Stypebox.DeleteString(0);
	Stypebox.AddString(GetResString(IDS_SEARCH_ANY));
	Stypebox.AddString(GetResString(IDS_SEARCH_ARC));
	Stypebox.AddString(GetResString(IDS_SEARCH_AUDIO));
	Stypebox.AddString(GetResString(IDS_SEARCH_CDIMG));
	Stypebox.AddString(GetResString(IDS_SEARCH_PICS));
	Stypebox.AddString(GetResString(IDS_SEARCH_PRG));
	Stypebox.AddString(GetResString(IDS_SEARCH_VIDEO));
	Stypebox.SetCurSel(Stypebox.FindString(-1,GetResString(IDS_SEARCH_ANY)));
}

void CSearchDlg::OnBnClickedClearall()
{
	OnBnClickedCancels();
	DeleteAllSearchs();
}

void CSearchDlg::StartNewSearch(){
	if (!theApp.serverconnect->IsConnected())
		MessageBox(GetResString(IDS_ERR_NOTCONNECTED),GetResString(IDS_NOTCONNECTED),64);
	else{
		m_nSearchID++;
		CString typeText;
		CString searchString;
		GetDlgItem(IDC_TypeSearch)->GetWindowText(typeText);
		GetDlgItem(IDC_SEARCHNAME)->GetWindowText(searchString);
		theApp.searchlist->NewSearch(&searchlistctrl,typeText,m_nSearchID);
		this->GetDlgItem(IDC_STARTS)->EnableWindow(false);
		this->GetDlgItem(IDC_CANCELS)->EnableWindow(true);
		canceld = false;
		CMemFile* data = new CMemFile(100); 
		int8 buffer=1; 
		data->Write(&buffer,1);
		uint16 nSize = searchString.GetLength();
		data->Write(&nSize,2);
		data->Write(searchString.GetBuffer(),nSize);
		Packet* packet = new Packet(data);
		packet->opcode = OP_SEARCHREQUEST;
		delete data;
		theApp.serverconnect->SendPacket(packet,false);
		if (this->IsDlgButtonChecked(IDC_SGLOBAL)){
			if( theApp.glob_prefs->Score() ){
				theApp.serverlist->ResetSearchServerPos();
			}
			searchpacket = packet;
			searchpacket->opcode = OP_GLOBSEARCHREQ;
			servercount = 0;
			searchprogress.SetRange32(0,theApp.serverlist->GetServerCount()-1);
			globsearch = true;
		}
		else{
			globsearch = false;
			delete packet;
		}
		CreateNewTab(searchString,m_nSearchID);
	}
}

void CSearchDlg::CreateNewTab(CString searchString,uint32 nSearchID){
	// add new tab
	TCITEM newitem;
	if (searchString.GetLength() == 0)
		searchString = "-";
	newitem.mask = TCIF_PARAM|TCIF_TEXT|TCIF_IMAGE;
	newitem.lParam = (LPARAM)nSearchID;
	newitem.pszText = searchString.GetBuffer();
	newitem.cchTextMax = (int)searchString.GetLength()+10;
	newitem.iImage = 0;
	uint16 itemnr = searchselect.InsertItem(searchselect.GetItemCount(),&newitem);
	if (!searchselect.IsWindowVisible())
		searchselect.ShowWindow(SW_SHOW);
	searchselect.SetCurSel(itemnr);
	searchlistctrl.ShowResults(nSearchID);
}

void CSearchDlg::DeleteSearch(uint32 nSearchID){
	TCITEM item;
	item.mask = TCIF_PARAM;
	int i;
	for (i = 0; i != searchselect.GetItemCount();i++){
		searchselect.GetItem(i,&item);
		if (item.lParam == nSearchID)
			break;
	}
	if (item.lParam != nSearchID)
		return;
	theApp.searchlist->RemoveResults(nSearchID);
	searchselect.DeleteItem(i);
	if (searchselect.GetItemCount()){
		searchselect.SetCurSel(0);
		item.mask = TCIF_PARAM;
		searchselect.GetItem(0,&item);
		searchlistctrl.ShowResults(item.lParam);
	}
	else{
		searchlistctrl.DeleteAllItems();
		searchselect.ShowWindow(SW_HIDE);
		searchlistctrl.NoTabs();
	}
}

void CSearchDlg::DeleteAllSearchs(){
	theApp.searchlist->Clear();
	searchlistctrl.DeleteAllItems();
	searchselect.ShowWindow(SW_HIDE);
	searchselect.DeleteAllItems();
}

void CSearchDlg::OnTcnSelchangeTab1(NMHDR *pNMHDR, LRESULT *pResult)
{
	TCITEM item;
	item.mask = TCIF_PARAM;
	int cur_sel = searchselect.GetCurSel();
	if (cur_sel == (-1))
		return;
	searchselect.GetItem(cur_sel,&item);
	searchlistctrl.ShowResults(item.lParam);
	*pResult = 0;
}


LRESULT CSearchDlg::OnCloseTab(WPARAM wparam, LPARAM lparam) {
	TCITEM item;
	item.mask = TCIF_PARAM;
	int i = (int)wparam;
	searchselect.GetItem(i,&item);
	int nSearchID = item.lParam;

	DeleteSearch(nSearchID);
	//theApp.searchlist->RemoveResults(nSearchID);
/*
	searchselect.DeleteItem(i);
	if (searchselect.GetItemCount()){
		searchselect.SetCurSel(0);
		item.mask = TCIF_PARAM;
		searchselect.GetItem(0,&item);
		searchlistctrl.ShowResults(item.lParam);
	}
	else{
		searchlistctrl.DeleteAllItems();
		searchselect.ShowWindow(SW_HIDE);
	}
*/
	return true;

}

void CSearchDlg::OnEnChangeSearchname()
{
		this->GetDlgItem(IDC_STARTS)->EnableWindow(true);
		this->GetDlgItem(IDC_CANCELS)->EnableWindow(false);	
}
