//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once
#include "types.h"
#include "opcodes.h"

#pragma pack(1)
// DO NOT EDIT VALUES like making a uint16 to uint32, or insert any value. ONLY append new vars
struct Preferences_Ext_Struct{
	int8	version;
	uchar	userhash[16];
	WINDOWPLACEMENT EmuleWindowPlacement;
};

struct Preferences_Struct{
	char	nick[255];
	uint16	maxupload;
	uint16	maxdownload;
	uint16	port;
	uint16	udpport;
	uint16	maxconnections;
	int8	reconnect;
	int8	deadserver;
	int8	scorsystem;
	char	incomingdir[510];
	char	tempdir[510];
	int8	ICH;
	int8	autoserverlist;
	int8	updatenotify;
	int8	mintotray;
	int8	autoconnect;
	int8	addserversfromserver;
	int8	addserversfromclient;
	int16	maxsourceperfile;
	int16	trafficOMeterInterval;
	int16	statsInterval;
	uchar	userhash[16];
	WINDOWPLACEMENT EmuleWindowPlacement;
	int		maxGraphDownloadRate;
	int		maxGraphUploadRate;
	uint8	beepOnError;
	uint8	confirmExit;
	int16	downloadColumnWidths[9];
	BOOL	downloadColumnHidden[9];
	INT		downloadColumnOrder[9];
	int16	uploadColumnWidths[7];
	BOOL	uploadColumnHidden[7];
	INT		uploadColumnOrder[7];
	int16	queueColumnWidths[9];
	BOOL	queueColumnHidden[9];
	INT		queueColumnOrder[9];
	int16	searchColumnWidths[5];
	BOOL	searchColumnHidden[5];
	INT		searchColumnOrder[5];
	int16	sharedColumnWidths[9];
	BOOL	sharedColumnHidden[9];
	INT		sharedColumnOrder[9];
	int16	serverColumnWidths[9];
	BOOL	serverColumnHidden[9];
	INT 	serverColumnOrder[9];
	DWORD	statcolors[15];

	uint8	splashscreen;
	uint8	filerBadIP;
	uint8	onlineSig;

	uint64  totalDownloadedBytes;
	uint64	totalUploadedBytes;
	WORD	languageID;
	int8	transferDoubleclick;
	int8	m_iSeeShares;		// 0=everybody 1=friends only 2=noone
	int8	m_iToolDelayTime;	// tooltip delay time in seconds
	int8	bringtoforeground;
	int8	splitterbarPosition;
	uint16	deadserverretries;
	uint8	flatbar;
	uint8   statsMax;
	int8	statsAverageMinutes;

    int8    useDownloadNotifier;
    int8    useChatNotifier;
    int8    useLogNotifier;	
    int8    useSoundInNotifier;
	int8    notifierPopsEveryChatMsg;
	int8	notifierImportantError;
    char    notifierSoundFilePath[510];

	char	m_sircserver[50];
	char	m_sircnick[30];
	char	m_sircchannamefilter[50];
	bool	m_bircaddtimestamp;
	bool	m_bircusechanfilter;
	uint16	m_iircchanneluserfilter;
	char	m_sircperformstring[255];
	bool	m_bircuseperform;
	bool	m_birclistonconnect;
	bool	m_bircacceptlinks;
	bool	m_bircignoreinfomessage;
	bool	m_bircignoreemuleprotoinfomessage;

	bool	smartidcheck;
	uint8	smartidstate;
	bool	fastServerConnect;
	bool	startMinimized;
	uint16	MaxConperFive;
	int8	UAP ;
};

struct Preferences_Import19c_Struct{
	int8	version;
	char	nick[50];
	uint16	maxupload;
	uint16	maxdownload;
	uint16	port;
	uint16	maxconnections;
	int8	reconnect;
	int8	deadserver;
	int8	scorsystem;
	char	incomingdir[510];
	char	tempdir[510];
	int8	ICH;
	int8	autoserverlist;
	int8	updatenotify;
	int8	mintotray;
	uchar	userhash[16];
	int8	autoconnect;
	int8	addserversfromserver;
	int8	addserversfromclient;
};
struct Preferences_Import20a_Struct{
	int8	version;
	char	nick[50];
	uint16	maxupload;
	uint16	maxdownload;
	uint16	port;
	uint16	maxconnections;
	int8	reconnect;
	int8	deadserver;
	uint16	deadserverretries;
	int8	scorsystem;
	char	incomingdir[510];
	char	tempdir[510];
	int8	ICH;
	int8	autoserverlist;
	int8	updatenotify;
	int8	mintotray;
	uchar	userhash[16];
	int8	autoconnect;
	int8	addserversfromserver;
	int8	addserversfromclient;
	int16	maxsourceperfile;
	int16	trafficOMeterInterval;
	int32   totalDownloaded;
	int32	totalUploaded;
	int		maxGraphDownloadRate;
	int		maxGraphUploadRate;
	uint8	beepOnError;
	uint8	confirmExit;
	WINDOWPLACEMENT EmuleWindowPlacement;
	int transferColumnWidths[9];
	int serverColumnWidths[8];
	uint8	splashscreen;
	uint8	filerBadIP;
};

struct Preferences_Import20b_Struct{
	int8	version;
	char	nick[50];
	uint16	maxupload;
	uint16	maxdownload;
	uint16	port;
	uint16	maxconnections;
	int8	reconnect;
	int8	deadserver;
	int8	scorsystem;
	char	incomingdir[510];
	char	tempdir[510];
	int8	ICH;
	int8	autoserverlist;
	int8	updatenotify;
	int8	mintotray;
	uchar	userhash[16];
	int8	autoconnect;
	int8	addserversfromserver;
	int8	addserversfromclient;
	int16	maxsourceperfile;
	int16	trafficOMeterInterval;
	int32   totalDownloaded;	// outdated
	int32	totalUploaded;		// outdated
	int		maxGraphDownloadRate;
	int		maxGraphUploadRate;
	uint8	beepOnError;
	uint8	confirmExit;
	WINDOWPLACEMENT EmuleWindowPlacement;
	int transferColumnWidths[9];
	int serverColumnWidths[8];
	uint8	splashscreen;
	uint8	filerBadIP;
	int64   totalDownloadedBytes;
	int64	totalUploadedBytes;
};

class CPreferences{
public:
	enum Table { tableDownload, tableUpload, tableQueue, tableSearch,
		tableShared, tableServer };

	friend class CPreferencesWnd;
	friend class CPPgGeneral;
	friend class CPPgConnection;
	friend class CPPgServer;
	friend class CPPgDirectories;
	friend class CPPgFiles;
	friend class CPPgNotify;
	friend class CPPgIRC;
	friend class Wizard;
	friend class CPPgTweaks;
	CPreferences();
	~CPreferences();
	char*	GetAppDir()		{return appdir;}
	bool	Save();

	int8	Score()			{return prefs->scorsystem;}
	bool	Reconnect()		{return prefs->reconnect;}
	int8	DeadServer()	{return prefs->deadserver;}
	char*	GetUserNick()	{return prefs->nick;}
	uint16	GetPort()		{return prefs->port;}
	uint16	GetUDPPort()	{return prefs->udpport;}
	char*	GetIncomingDir(){return prefs->incomingdir;}
	char*	GetTempDir()	{return prefs->tempdir;}
	char*	GetUserHash()	{return userhash;}
	uint16	GetMaxUpload()	{return	prefs->maxupload;}
	bool	IsICHEnabled()	{return prefs->ICH;}
	bool	AutoServerlist(){return prefs->autoserverlist;}
	bool	UpdateNotify()	{return prefs->updatenotify;}
	bool	DoMinToTray()	{return prefs->mintotray;}
	bool	DoAutoConnect() {return prefs->autoconnect;}
	bool	AddServersFromServer()		{return prefs->addserversfromserver;}
	bool	AddServersFromClient()		{return prefs->addserversfromclient;}
	int8*	GetMinTrayPTR() {return &prefs->mintotray;}
	uint16	GetTrafficOMeterInterval() { return prefs->trafficOMeterInterval;}
	void	SetTrafficOMeterInterval(int16 in) { prefs->trafficOMeterInterval=in;}
	uint16	GetStatsInterval() { return prefs->statsInterval;}
	void	SetStatsInterval(int16 in) { prefs->statsInterval=in;}
	void	Add2TotalDownloaded(uint64 in) {prefs->totalDownloadedBytes+=in;}
	void	Add2TotalUploaded(uint64 in) {prefs->totalUploadedBytes+=in;}
	uint64  GetTotalDownloaded()		{return prefs->totalDownloadedBytes;}
	uint64	GetTotalUploaded()			{return prefs->totalUploadedBytes;}
	bool	IsErrorBeepEnabled()		{return prefs->beepOnError;}
	bool	IsConfirmExitEnabled()		{return prefs->confirmExit;}
	bool	UseSplashScreen()			{return prefs->splashscreen;}
	bool	FilerBadIPs()				{return prefs->filerBadIP;}
	bool	IsOnlineSignatureEnabled()  {return prefs->onlineSig;}
	bool	IsUAPEnabled()				{return prefs->UAP;				}
	int		GetMaxGraphUploadRate()		{return prefs->maxGraphUploadRate;}
	int		GetMaxGraphDownloadRate()		{return prefs->maxGraphDownloadRate;}
	void	SetMaxGraphUploadRate(int in){prefs->maxGraphUploadRate=in;}
	void	SetMaxGraphDownloadRate(int in){prefs->maxGraphDownloadRate=in;}

	uint16	GetMaxDownload();
	uint16	GetMaxConnections()			{return	prefs->maxconnections;}
	uint16	GetMaxSourcePerFile()		{return prefs->maxsourceperfile;}
	uint16	GetMaxSourcePerFileSoft()	{	uint16 temp = prefs->maxsourceperfile*0.9;
											if( temp > 1000 )
												return 1000;
                                            return temp;}
	uint16	GetMaxSourcePerFileUDP()	{	uint16 temp = prefs->maxsourceperfile*0.75;
											if( temp > 100 )
												return 100;
                                            return temp;
										}
	uint16	GetDeadserverRetries()		{return prefs->deadserverretries;}

	int     GetColumnWidth (Table t, int index) const;
	BOOL    GetColumnHidden(Table t, int index) const;
	int     GetColumnOrder (Table t, int index) const;
	void	SetColumnWidth (Table t, int index, int width);
	void	SetColumnHidden(Table t, int index, BOOL bHidden);
	void	SetColumnOrder (Table t, INT *piOrder);

	WORD	GetLanguageID()				{return prefs->languageID;}
	int8	IsDoubleClickEnabled()		{return prefs->transferDoubleclick;}
	int8	CanSeeShares(void)			{return prefs->m_iSeeShares;}
	int8	GetToolTipDelay(void)		{return prefs->m_iToolDelayTime;}
	int8	IsBringToFront()			{return prefs->bringtoforeground;}

	int8    GetSplitterbarPosition()	{return prefs->splitterbarPosition;}
	void	SetSplitterbarPosition(int8 pos) {prefs->splitterbarPosition=pos;}
	int8	GetStatsMax()				{return prefs->statsMax;}
	int8	UseFlatBar()				{return prefs->flatbar;}
	int8	GetStatsAverageMinutes()	{return prefs->statsAverageMinutes;}
	void	SetStatsAverageMinutes(int8 in)	{prefs->statsAverageMinutes=in;}

    bool    GetUseDownloadNotifier() {return prefs->useDownloadNotifier;}
    bool    GetUseChatNotifier()	 {return prefs->useChatNotifier;}
    bool    GetUseLogNotifier()		 {return prefs->useLogNotifier;}
    bool    GetUseSoundInNotifier()  {return prefs->useSoundInNotifier;}
	bool    GetNotifierPopsEveryChatMsg() {return prefs->notifierPopsEveryChatMsg;}
	bool	GetNotifierPopOnImportantError()	{return prefs->notifierImportantError;}
	char*   GetNotifierWavSoundPath() {return prefs->notifierSoundFilePath;}

	CString	GetIRCNick()				{return (CString)prefs->m_sircnick;}
	void	SetIRCNick( char in_nick[] )		{ strcpy(prefs->m_sircnick,in_nick);}
	CString	GetIRCServer()				{return (CString)prefs->m_sircserver;}
	void	SetIRCServer( char in_serv[] )		{ strcpy(prefs->m_sircserver,in_serv);}
	bool	GetIRCAddTimestamp()		{return prefs->m_bircaddtimestamp;}
	void	SetIRCAddTimestamp( bool flag )		{prefs->m_bircaddtimestamp = flag;}
	CString	GetIRCChanNameFilter()				{return (CString)prefs->m_sircchannamefilter;}
	bool	GetIRCUseChanFilter()				{return prefs->m_bircusechanfilter;}
	uint16	GetIRCChannelUserFilter()			{return	prefs->m_iircchanneluserfilter;}
	void	SetIRCChanNameFilter( char in_name[] )		{ strcpy(prefs->m_sircchannamefilter,in_name);}
	void	SetIRCUseChanFilter( bool flag )		{prefs->m_bircusechanfilter = flag;}
	void	SetIRCChanUserFilter( uint16 in_user)		{prefs->m_iircchanneluserfilter = in_user;}
	CString	GetIrcPerformString()				{return (CString)prefs->m_sircperformstring;}
	bool	GetIrcUsePerform()					{return prefs->m_bircuseperform;}
	bool	GetIRCListOnConnect()				{return prefs->m_birclistonconnect;}
	void	SetIRCListonConnect( bool flag )	{prefs->m_birclistonconnect = flag;}
	void	SetIRCPerformString( char in_perf[] )		{ strcpy(prefs->m_sircperformstring, in_perf);}
	void	SetIrcUsePerform( bool flag )							{prefs->m_bircuseperform = flag;}
	bool	GetIrcAcceptLinks()					{return prefs->m_bircacceptlinks;}
	void	SetIrcAcceptLInks( bool flag )		{prefs->m_bircacceptlinks = flag;}
	bool	GetIrcIgnoreInfoMessage()					{return prefs->m_bircignoreinfomessage;}
	void	SetIrcIgnoreInfoMessage( bool flag )		{prefs->m_bircignoreinfomessage = flag;}
	bool	GetIrcIgnoreEmuleProtoInfoMessage()					{return prefs->m_bircignoreemuleprotoinfomessage;}
	void	SetIrcIgnoreEmuleProtoInfoMessage( bool flag )		{prefs->m_bircignoreemuleprotoinfomessage = flag;}
	WORD	GetWindowsVersion();
	bool	GetStartMinimized()					{return prefs->startMinimized;}
	bool	GetSmartIdCheck()					{return prefs->smartidcheck;}
	void	SetSmartIdCheck( bool in_smartidcheck )	{prefs->smartidcheck = in_smartidcheck;}
	uint8	GetSmartIdState()					{return prefs->smartidstate;}
	void	SetSmartIdState( uint8 in_smartidstate )	{prefs->smartidstate = in_smartidstate;}


	void	SetStatsColor(int index,DWORD value) {prefs->statcolors[index]=value;}
	DWORD	GetStatsColor(int index) {return prefs->statcolors[index];}
	void	SetMaxDownloadConperFive(int in) {prefs->MaxConperFive=in;}

	uint16	GetMaxConperFive();
	uint16	GetDefaultMaxConperFive();

	void	ResetStatsColor(int index);
	bool	IsFastServerConnectEnabled()		{return prefs->fastServerConnect;}
	void	SetFastServerConnectEnabled(bool in)		{prefs->fastServerConnect=in;}

	// quick-speed changer [xrmb]
	void	SetMaxUpload(uint16 in) {prefs->maxupload =in;};
	void	SetMaxDownload(uint16 in) {prefs->maxdownload=in; };

	WINDOWPLACEMENT GetEmuleWindowPlacement() {return prefs->EmuleWindowPlacement; }
	void SetWindowLayout(WINDOWPLACEMENT in) {prefs->EmuleWindowPlacement=in; }

	CStringList shareddir_list;
	CStringList adresses_list;
protected:
	void	CreateUserHash();
	void	SetStandartValues();
	static int GetRecommendedMaxConnections();

private:
	char* appdir;
	Preferences_Struct* prefs;
	Preferences_Ext_Struct* prefsExt;

	Preferences_Import19c_Struct* prefsImport19c;
	Preferences_Import20a_Struct* prefsImport20a;
	Preferences_Import20b_Struct* prefsImport20b;

	char userhash[16];
	WORD m_wWinVer;

	void LoadPreferences();
	void SavePreferences();
};
