//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once
#include "knownfile.h"
#include "types.h"
#include "opcodes.h"
#include "BarShader.h"

#define	PS_READY			0
#define	PS_EMPTY			1
#define PS_WAITINGFORHASH	2
#define PS_HASHING			3
#define PS_ERROR			4
#define	PS_UNKNOWN			6
#define PS_PAUSED			7
#define PS_COMPLETING		8
#define PS_COMPLETE			9

#define PR_VERYLOW			4 // I Had to change this because it didn't save negative number correctly.. Had to modify the sort function for this change..
#define PR_LOW				0 //*
#define PR_NORMAL			1 // Don't change this - needed for edonkey clients and server!
#define	PR_HIGH				2 //*
#define PR_VERYHIGH			3
#define PR_AUTO				5 //UAP Hunter

class CSearchFile;
class CUpDownClient;

class CPartFile : public CKnownFile {
public:
	CPartFile();
	CPartFile(CSearchFile* searchresult);  //used when downloading a new file
	CPartFile(CString edonkeylink);
	CPartFile(class CED2KFileLink* fileLink);
	void InitializeFromLink(CED2KFileLink* fileLink);
	virtual ~CPartFile();
	
	bool	CreateFromFile(char* directory,char* filename)	{return false;}// not supported in this class
	bool	LoadFromFile(FILE* file)						{return false;}
	bool	WriteToFile(FILE* file)							{return false;}
	bool	IsPartFile()									{return !(status == PS_COMPLETE);}
	uint32	Process(sint16 reducedownload);
	bool	LoadPartFile(char* in_directory, char* filename); //filename = *.part.met
	bool	SavePartFile();
	void	PartFileHashFinished(CKnownFile* result);
	bool	HashSinglePart(uint16 partnumber); // true = ok , false = corrupted	

	void	AddGap(uint32 start, uint32 end);
	void	FillGap(uint32 start, uint32 end);
	void	DrawStatusBar(CDC* dc, RECT* rect, bool bFlat);
	bool	IsComplete(uint32 start, uint32 end);
	bool	IsPureGap(uint32 start, uint32 end);
	bool	IsCorruptedPart(uint16 partnumber);
	void	UpdateCompletedInfos();

	bool	GetNextRequestedBlock(CUpDownClient* sender,Requested_Block_Struct** newblocks,uint16* count);
	void	WritePartStatus(CFile* file);
	void	AddSources(CMemFile* sources,uint32 serverip, uint16 serverport);
	uint8	GetStatus(bool ignorepause = false);
	void	NewSrcPartsInfo();
	void	SetPriority(uint8 np);
	char*	GetPartMetFileName()							{return partmetfilename;}
	uint32	GetTransfered()									{return transfered;}
	uint8	GetPriority()									{return priority;}
	char*	GetFullName()									{return fullname;}
	uint16	GetSourceCount()								{return srclist.GetCount();}
	uint16	GetTransferingSrcCount()						{return transferingsrc;}
	uint32	GetDatarate()									{return datarate;}
	float	GetPercentCompleted()							{return percentcompleted;}
	uint16  GetNotCurrentSourcesCount();
	int		GetValidSourcesCount();
	bool	IsMovie();
	CString CPartFile::getPartfileStatus(); //<<--9/21/02
	sint32	CPartFile::getTimeRemaining(); //<<--9/21/02
	CTime	lastseencomplete;
	
	void	BlockReceived(uint32 start,uint32 end, char* blockdata, uint32 transferedsize = 0);
	void	RemoveBlockFromList(uint32 start,uint32 end);
	void	RemoveAllSources(bool bTryToSwap);
	void	DeleteFile();
	void	StopFile();
	void	PauseFile();
	void	ResumeFile();

	virtual	Packet* CreateSrcInfoPacket(CUpDownClient* forClient);
	void	AddClientSources(CMemFile* sources);

	void	PreviewFile();
	bool	PreviewAvailable();
	uint8   GetAvailablePartCount()			{return availablePartsCount;}
	void	UpdateAvailablePartsCount();

	uint32	GetLastAnsweredTime()			{ return m_ClientSrcAnswered; }
	void	SetLastAnsweredTime()			{ m_ClientSrcAnswered = ::GetTickCount(); }
	void	SetLastAnsweredTimeTimeout()	{ m_ClientSrcAnswered = 2 * CONNECTION_LATENCY +
											                        ::GetTickCount() - SOURCECLIENTREASK; }

	int		GetCommonFilePenalty();

	CFile	m_hpartfile;	//permanent opened handle to avoid write conflicts
	volatile bool m_bPreviewing;
	//UAP Hunter
	void    UpdateUploadAutoPriority(void) ;
	bool	IsAutoPrioritized() { return m_bAutoPriority ; }
	void	SetAutoPriority(bool newAutoPriority) { this->m_bAutoPriority = newAutoPriority ; }
	//end UAP
protected:
	bool	GetNextEmptyBlockInPart(uint16 partnumber,Requested_Block_Struct* result);
	bool	IsAlreadyRequested(uint32 start, uint32 end);
	void	CompleteFile(bool hashingdone);
	void	CreatePartFile();
	void	Init();
private:
	uint16	count;
	uint16	transferingsrc;
	uint32  completedsize;
	uint32	datarate;
	char*	fullname;
	char*	partmetfilename;
	uint32	transfered;
	bool	paused;
	uint8	priority;
	uint8	status;
	bool	newdate;	// indicates if there was a writeaccess to the .part file
	uint32	lastsearchtime;
	uint32	m_LastNoNeededCheck;
	CTypedPtrList<CPtrList, Gap_Struct*> gaplist;
	CTypedPtrList<CPtrList, Requested_Block_Struct*> requestedblocks_list;
	CArray<uint16,uint16> m_SrcpartFrequency;
	float	percentcompleted;
	CList<uint16,uint16>	corrupted_list;
	uint8	availablePartsCount;
	uint32	m_ClientSrcAnswered;
	static	CBarShader s_LoadBar; 
	static	CBarShader s_ChunkBar; 
    bool	m_bAutoPriority ;	//UAP Hunter

public:
	CTypedPtrList<CPtrList, CUpDownClient*> srclist;
	bool	srcarevisible; // used for downloadlistctrl
	bool	hashsetneeded;							
	uint32  GetCompletedSize()   {return completedsize;}
};
