// PgTweaks.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "PPgTweaks.h"



// CPPgTweaks dialog

IMPLEMENT_DYNAMIC(CPPgTweaks, CPropertyPage)
CPPgTweaks::CPPgTweaks()
	: CPropertyPage(CPPgTweaks::IDD)
{
}

CPPgTweaks::~CPPgTweaks()
{
}

void CPPgTweaks::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgTweaks, CPropertyPage)

	ON_EN_CHANGE(IDC_MAXCON5SEC, OnSettingsChange)
	ON_EN_CHANGE(IDC_MAXSRCEPERFILESOFT, OnEnChangeMaxsourceperfilesoft)
	ON_EN_CHANGE(IDC_MAXSRCEPERFILEUDP, OnEnChangeMaxsourceperfileudp)

END_MESSAGE_MAP()


// CPPgTweaks message handlers


BOOL CPPgTweaks::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgTweaks::LoadSettings(void)
{
	if(m_hWnd)
	{
		CString strBuffer;

		strBuffer.Format("%d", app_prefs->GetMaxConperFive());
		GetDlgItem(IDC_MAXCON5SEC)->SetWindowText(strBuffer);
	}
}

BOOL CPPgTweaks::OnApply()
{
	char buffer[510];
	if(GetDlgItem(IDC_MAXCON5SEC)->GetWindowTextLength())
	{
		GetDlgItem(IDC_MAXCON5SEC)->GetWindowText(buffer,20);
		app_prefs->SetMaxDownloadConperFive((atoi(buffer)) ?
			atoi(buffer) : 20);
	}

	LoadSettings();
	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgTweaks::Localize(void)
{	
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_PW_TWEAK));
		GetDlgItem(IDC_MAXCON5SECLABEL )->SetWindowText(GetResString(IDS_MAXCON5SECLABEL));
		GetDlgItem(IDC_WARNING)->SetWindowText(GetResString(IDS_WARNING));
	}
}

