// PPgGeneral.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "PPgGeneral.h"


// CPPgGeneral dialog

IMPLEMENT_DYNAMIC(CPPgGeneral, CPropertyPage)
CPPgGeneral::CPPgGeneral()
	: CPropertyPage(CPPgGeneral::IDD)
{
}

CPPgGeneral::~CPPgGeneral()
{
}

void CPPgGeneral::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LANGS, m_language);
}


BEGIN_MESSAGE_MAP(CPPgGeneral, CPropertyPage)
	ON_BN_CLICKED(IDC_STARTMIN, OnEnChangeStartMin)
	ON_EN_CHANGE(IDC_NICK, OnEnChangeNick)
	ON_BN_CLICKED(IDC_MINTRAY, OnBnClickedMintray)
	ON_BN_CLICKED(IDC_BEEPER, OnBnClickedBeeper)
	ON_BN_CLICKED(IDC_EXIT, OnBnClickedExit)
	ON_BN_CLICKED(IDC_SPLASHON, OnBnClickedSplashon)
	ON_BN_CLICKED(IDC_DBLCLICK, OnBnClickedDblclick)
	ON_BN_CLICKED(IDC_BRINGTOFOREGROUND, OnBnClickedBringtoforeground)
	ON_BN_CLICKED(IDC_NOTIFY, OnBnClickedNotify)
	ON_EN_CHANGE(IDC_TOOLTIPDELAY, OnEnChangeTooltipdelay)
	ON_CBN_SELCHANGE(IDC_LANGS, OnCbnSelchangeLangs)
	ON_BN_CLICKED(IDC_FLAT, OnBnClickedFlat)
	ON_BN_CLICKED(IDC_ED2KFIX, OnBnClickedEd2kfix)
	ON_BN_CLICKED(IDC_ONLINESIG, OnBnClickedOnlinesig)
END_MESSAGE_MAP()

void CPPgGeneral::LoadSettings(void)
{
	GetDlgItem(IDC_NICK)->SetWindowText(app_prefs->prefs->nick);

	for(int i = 0; i != m_language.GetCount(); i++)
		if(m_language.GetItemData(i) == app_prefs->GetLanguageID())
			m_language.SetCurSel(i);
	
	if(app_prefs->prefs->flatbar)
		CheckDlgButton(IDC_FLAT,1);
	else
		CheckDlgButton(IDC_FLAT,0);

	if(app_prefs->prefs->startMinimized)
		CheckDlgButton(IDC_STARTMIN,1);
	else
		CheckDlgButton(IDC_STARTMIN,0);

	if(app_prefs->prefs->mintotray)
		CheckDlgButton(IDC_MINTRAY,1);
	else
		CheckDlgButton(IDC_MINTRAY,0);

	if (app_prefs->prefs->onlineSig)
		CheckDlgButton(IDC_ONLINESIG,1);
	else
		CheckDlgButton(IDC_ONLINESIG,0);
	
	if(app_prefs->prefs->beepOnError)
		CheckDlgButton(IDC_BEEPER,1);
	else
		CheckDlgButton(IDC_BEEPER,0);

	if(app_prefs->prefs->confirmExit)
		CheckDlgButton(IDC_EXIT,1);
	else
		CheckDlgButton(IDC_EXIT,0);

	if(app_prefs->prefs->splashscreen)
		CheckDlgButton(IDC_SPLASHON,1);
	else
		CheckDlgButton(IDC_SPLASHON,0);

	if(app_prefs->prefs->transferDoubleclick)
		CheckDlgButton(IDC_DBLCLICK,1);
	else
		CheckDlgButton(IDC_DBLCLICK,0);

	if(app_prefs->prefs->bringtoforeground)
		CheckDlgButton(IDC_BRINGTOFOREGROUND,1);
	else
		CheckDlgButton(IDC_BRINGTOFOREGROUND,0);
/*
	if(app_prefs->prefs->updatenotify)
		CheckDlgButton(IDC_NOTIFY,1);
	else
		CheckDlgButton(IDC_NOTIFY,0);*/

	CString strBuffer;
	strBuffer.Format("%d", app_prefs->prefs->m_iToolDelayTime);
	GetDlgItem(IDC_TOOLTIPDELAY)->SetWindowText(strBuffer);
}

BOOL CPPgGeneral::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	((CEdit*)GetDlgItem(IDC_NICK))->SetLimitText(49);
	
	m_language.SetItemData(m_language.AddString("Bulgarian"),MAKELANGID(LANG_BULGARIAN ,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Catalonian"),MAKELANGID(LANG_CATALAN ,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Chinese (simplified)"),MAKELANGID(LANG_CHINESE,SUBLANG_CHINESE_SIMPLIFIED));
	m_language.SetItemData(m_language.AddString("Chinese (traditional)"),MAKELANGID(LANG_CHINESE,SUBLANG_CHINESE_TRADITIONAL));
	m_language.SetItemData(m_language.AddString("Danish"),MAKELANGID(LANG_DANISH,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Dutch"),MAKELANGID(LANG_DUTCH,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("English"),MAKELANGID(LANG_ENGLISH,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Finnish"),MAKELANGID(LANG_FINNISH,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("French"),MAKELANGID(LANG_FRENCH,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("German"),MAKELANGID(LANG_GERMAN,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Greek"),MAKELANGID(LANG_GREEK,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Hungarian"),MAKELANGID(LANG_HUNGARIAN,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Italian"),MAKELANGID(LANG_ITALIAN,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Korean"),MAKELANGID(LANG_KOREAN,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Latvian"),MAKELANGID(LANG_LATVIAN,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Lithuanian"),MAKELANGID(LANG_LITHUANIAN,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Norwegian"),MAKELANGID(LANG_NORWEGIAN,SUBLANG_NORWEGIAN_BOKMAL));
	m_language.SetItemData(m_language.AddString("Polish"),MAKELANGID(LANG_POLISH,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Portuguese"),MAKELANGID(LANG_PORTUGUESE,SUBLANG_PORTUGUESE));
	m_language.SetItemData(m_language.AddString("Portuguese (Brasilian)"),MAKELANGID(LANG_PORTUGUESE,SUBLANG_PORTUGUESE_BRAZILIAN));
	m_language.SetItemData(m_language.AddString("Russian"),MAKELANGID(LANG_RUSSIAN,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Slovenian"),MAKELANGID(LANG_SLOVENIAN,SUBLANG_DEFAULT));
	m_language.SetItemData(m_language.AddString("Spanish"),MAKELANGID(LANG_SPANISH,SUBLANG_SPANISH));
	m_language.SetItemData(m_language.AddString("Swedish"),MAKELANGID(LANG_SWEDISH,SUBLANG_DEFAULT));
	//m_language.SetItemData(m_language.AddString("Swiss"),MAKELANGID(LANG_GERMAN ,SUBLANG_GERMAN_SWISS));
	m_language.SetItemData(m_language.AddString("Turkish"),MAKELANGID(LANG_TURKISH,SUBLANG_DEFAULT));
	
	GetDlgItem(IDC_ED2KFIX)->EnableWindow(Ask4RegFix(true));

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CPPgGeneral::OnApply()
{
	char buffer[510];
	if(GetDlgItem(IDC_NICK)->GetWindowTextLength())
	{
		GetDlgItem(IDC_NICK)->GetWindowText(buffer,255);
		strcpy(app_prefs->prefs->nick,buffer);
	}
	if (m_language.GetCurSel() != CB_ERR){
		WORD byNewLang =  m_language.GetItemData(m_language.GetCurSel());
		if (app_prefs->prefs->languageID != byNewLang){
			app_prefs->prefs->languageID= byNewLang;
			SetThreadLocale(byNewLang);
			theApp.emuledlg->preferenceswnd.Localize();
			theApp.emuledlg->statisticswnd.Localize();
			theApp.emuledlg->serverwnd.Localize();
			theApp.emuledlg->transferwnd.Localize();
			theApp.emuledlg->searchwnd.Localize();
			theApp.emuledlg->sharedfileswnd.Localize();
			theApp.emuledlg->chatwnd.Localize();
			theApp.emuledlg->Localize();
			theApp.emuledlg->ircwnd.Localize();
		}
	}

	app_prefs->prefs->flatbar = (int8)IsDlgButtonChecked(IDC_FLAT);
	app_prefs->prefs->startMinimized= (int8)IsDlgButtonChecked(IDC_STARTMIN);
	app_prefs->prefs->mintotray = (int8)IsDlgButtonChecked(IDC_MINTRAY);
	app_prefs->prefs->beepOnError= (int8)IsDlgButtonChecked(IDC_BEEPER);
	app_prefs->prefs->confirmExit= (int8)IsDlgButtonChecked(IDC_EXIT);
	app_prefs->prefs->splashscreen = (int8)IsDlgButtonChecked(IDC_SPLASHON);
	app_prefs->prefs->transferDoubleclick= (int8)IsDlgButtonChecked(IDC_DBLCLICK);
	app_prefs->prefs->bringtoforeground = (int8)IsDlgButtonChecked(IDC_BRINGTOFOREGROUND);
	//app_prefs->prefs->updatenotify = (int8)IsDlgButtonChecked(IDC_NOTIFY);
	app_prefs->prefs->onlineSig= (int8)IsDlgButtonChecked(IDC_ONLINESIG);

	GetDlgItem(IDC_TOOLTIPDELAY)->GetWindowText(buffer,20);
	if(atoi(buffer) > 60)
		app_prefs->prefs->m_iToolDelayTime = 60;
	else
		app_prefs->prefs->m_iToolDelayTime = atoi(buffer);
	((CemuleDlg*)AfxGetMainWnd())->transferwnd.m_ttip.SetDelayTime(TTDT_INITIAL, theApp.glob_prefs->GetToolTipDelay()*1000);
	
	theApp.emuledlg->transferwnd.downloadlistctrl.SetStyle();
//	app_prefs->Save();
	LoadSettings();

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}

void CPPgGeneral::OnBnClickedEd2kfix()
{
	Ask4RegFix(false);
	GetDlgItem(IDC_ED2KFIX)->EnableWindow(Ask4RegFix(true));
}

void CPPgGeneral::Localize(void)
{
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_PW_GENERAL));
		GetDlgItem(IDC_NICK_FRM)->SetWindowText(GetResString(IDS_PW_NICK));
		GetDlgItem(IDC_LANG_FRM)->SetWindowText(GetResString(IDS_PW_LANG));
		GetDlgItem(IDC_MISC_FRM)->SetWindowText(GetResString(IDS_PW_MISC));
		GetDlgItem(IDC_FLAT)->SetWindowText(GetResString(IDS_PW_FLAT));
		GetDlgItem(IDC_MINTRAY)->SetWindowText(GetResString(IDS_PW_TRAY));
		GetDlgItem(IDC_BEEPER)->SetWindowText(GetResString(IDS_PW_BEEP));
		GetDlgItem(IDC_EXIT)->SetWindowText(GetResString(IDS_PW_PROMPT));
		GetDlgItem(IDC_SPLASHON)->SetWindowText(GetResString(IDS_PW_SPLASH));
		GetDlgItem(IDC_DBLCLICK)->SetWindowText(GetResString(IDS_PW_DBLCLICK));
		GetDlgItem(IDC_TOOLTIPDELAY_LBL)->SetWindowText(GetResString(IDS_PW_TOOL));
		GetDlgItem(IDC_BRINGTOFOREGROUND)->SetWindowText(GetResString(IDS_PW_FRONT));
		GetDlgItem(IDC_ONLINESIG)->SetWindowText(GetResString(IDS_PREF_ONLINESIG));	
		GetDlgItem(IDC_STARTMIN)->SetWindowText(GetResString(IDS_PREF_STARTMIN));	

		GetDlgItem(IDC_ED2KFIX)->SetWindowText(GetResString(IDS_ED2KLINKFIX));//added by CML 
	}
}
