// PPgFiles.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "PPgFiles.h"


// CPPgFiles dialog

IMPLEMENT_DYNAMIC(CPPgFiles, CPropertyPage)
CPPgFiles::CPPgFiles()
	: CPropertyPage(CPPgFiles::IDD)
{
}

CPPgFiles::~CPPgFiles()
{
}

void CPPgFiles::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CPPgFiles, CPropertyPage)

	ON_BN_CLICKED(IDC_SEESHARE1, OnBnClickedSeeshare1)
	ON_BN_CLICKED(IDC_SEESHARE2, OnBnClickedSeeshare2)
	ON_BN_CLICKED(IDC_SEESHARE3, OnBnClickedSeeshare3)
	ON_BN_CLICKED(IDC_ICH, OnBnClickedIch)
	ON_BN_CLICKED(IDC_UAP, OnBnClickedUAP)
END_MESSAGE_MAP()


BOOL CPPgFiles::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgFiles::LoadSettings(void)
{	
	switch(app_prefs->prefs->m_iSeeShares)
	{
		case 0:  this->CheckDlgButton(IDC_SEESHARE1,1); break;
		case 1:	 this->CheckDlgButton(IDC_SEESHARE2,1); break;
		default: this->CheckDlgButton(IDC_SEESHARE3,1);	break;
	}
	
	if(app_prefs->prefs->ICH)
		CheckDlgButton(IDC_ICH,1);
	else
		CheckDlgButton(IDC_ICH,0);
	if(app_prefs->prefs->UAP) CheckDlgButton(IDC_UAP, BST_CHECKED);
}


BOOL CPPgFiles::OnApply()
{
	if(IsDlgButtonChecked(IDC_SEESHARE1))
		app_prefs->prefs->m_iSeeShares = 0;
	else if(IsDlgButtonChecked(IDC_SEESHARE2))
		app_prefs->prefs->m_iSeeShares = 1;
	else
		app_prefs->prefs->m_iSeeShares = 2;

	app_prefs->prefs->ICH = (int8)IsDlgButtonChecked(IDC_ICH);
	app_prefs->prefs->UAP = IsDlgButtonChecked(IDC_UAP);
//	app_prefs->Save();
	LoadSettings();

	SetModified(FALSE);
	return CPropertyPage::OnApply();
}
void CPPgFiles::Localize(void)
{
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_PW_FILES));
		GetDlgItem(IDC_ICH_FRM)->SetWindowText(GetResString(IDS_PW_ICH));
		GetDlgItem(IDC_ICH)->SetWindowText(GetResString(IDS_PW_FILE_ICH));
		GetDlgItem(IDC_SEEMYSHARE_FRM)->SetWindowText(GetResString(IDS_PW_SHARE));
		GetDlgItem(IDC_SEESHARE1)->SetWindowText(GetResString(IDS_PW_EVER));
		GetDlgItem(IDC_SEESHARE2)->SetWindowText(GetResString(IDS_PW_FRIENDS));
		GetDlgItem(IDC_SEESHARE3)->SetWindowText(GetResString(IDS_PW_NOONE));
		GetDlgItem(IDC_UAP)->SetWindowText(GetResString(IDS_PW_UAP));
	}
}