#pragma once

#include "preferences.h"
#include "DirectoryTreeCtrl.h"

// CPPgDirectories dialog

class CPPgDirectories : public CPropertyPage
{
	DECLARE_DYNAMIC(CPPgDirectories)

public:
	CPPgDirectories();									// standard constructor
	virtual ~CPPgDirectories();

	void SetPrefs(CPreferences* in_prefs) {	app_prefs = in_prefs; }

// Dialog Data
	enum { IDD = IDD_PPG_DIRECTORIES };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()

public:
	virtual BOOL OnInitDialog();
public:
	CDirectoryTreeCtrl m_ShareSelector;
	CPreferences* app_prefs;
private:
	void LoadSettings(void);
	bool SelectDir(char* outdir, CString titletext);
public:
	virtual BOOL OnApply();

	afx_msg void OnBnClickedSelincdir();
	afx_msg void OnBnClickedSeltempdir();
	
	afx_msg void OnEnChangeIncfiles()	{ SetModified(); }
	afx_msg void OnEnChangeTempfiles()	{ SetModified(); }
	afx_msg void OnBnClickedCheck1()	{ SetModified(); }
protected:
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
public:
	void Localize(void);
};
