// PPgDirectories.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "PPgDirectories.h"

// CPPgDirectories dialog

IMPLEMENT_DYNAMIC(CPPgDirectories, CPropertyPage)
CPPgDirectories::CPPgDirectories()
	: CPropertyPage(CPPgDirectories::IDD)
{
	
}

CPPgDirectories::~CPPgDirectories()
{
}

void CPPgDirectories::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SHARESELECTOR, m_ShareSelector);
}


BEGIN_MESSAGE_MAP(CPPgDirectories, CPropertyPage)
	ON_BN_CLICKED(IDC_SELTEMPDIR, OnBnClickedSeltempdir)
	ON_BN_CLICKED(IDC_SELINCDIR, OnBnClickedSelincdir)
	ON_EN_CHANGE(IDC_INCFILES, OnEnChangeIncfiles)
	ON_EN_CHANGE(IDC_TEMPFILES, OnEnChangeTempfiles)
	ON_BN_CLICKED(IDC_CHECK1, OnBnClickedCheck1)
END_MESSAGE_MAP()


// CPPgDirectories message handlers

BOOL CPPgDirectories::OnInitDialog()
{
	CPropertyPage::OnInitDialog();
	m_ShareSelector.Init();	

	((CEdit*)GetDlgItem(IDC_INCFILES))->SetLimitText(509);
	((CEdit*)GetDlgItem(IDC_TEMPFILES))->SetLimitText(509);
	
	LoadSettings();
	Localize();

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgDirectories::LoadSettings(void)
{
	GetDlgItem(IDC_INCFILES)->SetWindowText(app_prefs->prefs->incomingdir);
	GetDlgItem(IDC_TEMPFILES)->SetWindowText(app_prefs->prefs->tempdir);
	m_ShareSelector.SetSharedDirectories(&app_prefs->shareddir_list);
}

bool CPPgDirectories::SelectDir(char* outdir, CString titletext)
{
	CoInitialize(0);
	bool done;
	char* buffer = new char[MAX_PATH];
	BROWSEINFO bi = { GetSafeHwnd(), 0, buffer, titletext, BIF_VALIDATE | BIF_NEWDIALOGSTYLE | BIF_RETURNONLYFSDIRS | BIF_SHAREABLE, 0, 0, 0};
	LPITEMIDLIST pidl = SHBrowseForFolder(&bi);
	delete[] buffer;
	done = SHGetPathFromIDList(pidl,outdir);
	LPMALLOC ppMalloc;
	if(SHGetMalloc(&ppMalloc) == NOERROR)
		ppMalloc->Free(pidl);
	CoUninitialize();
	return done;
}

void CPPgDirectories::OnBnClickedSelincdir()
{
	char buffer[MAX_PATH];
	if(SelectDir(buffer,GetResString(IDS_SELECT_INCOMINGDIR)))
		GetDlgItem(IDC_INCFILES)->SetWindowText(buffer);
}

void CPPgDirectories::OnBnClickedSeltempdir()
{
	char buffer[MAX_PATH];
	if(SelectDir(buffer,GetResString(IDS_SELECT_TEMPDIR)))
		GetDlgItem(IDC_TEMPFILES)->SetWindowText(buffer);
}


BOOL CPPgDirectories::OnApply()
{
	char buffer[510];
	
	if(GetDlgItem(IDC_INCFILES)->GetWindowTextLength())
	{
		GetDlgItem(IDC_INCFILES)->GetWindowText(buffer,509);
		strcpy(app_prefs->prefs->incomingdir,buffer);
	}
	
	if(GetDlgItem(IDC_TEMPFILES)->GetWindowTextLength())
	{
		GetDlgItem(IDC_TEMPFILES)->GetWindowText(buffer,509);
		strcpy(app_prefs->prefs->tempdir,buffer);
	}
			
	app_prefs->shareddir_list.RemoveAll();
	m_ShareSelector.GetSharedDirectories(&app_prefs->shareddir_list);
	theApp.sharedfiles->Reload();
	
//	app_prefs->Save();
//	LoadSettings();

	SetModified(0);
	return CPropertyPage::OnApply();
}

BOOL CPPgDirectories::OnCommand(WPARAM wParam, LPARAM lParam)
{
//	if(wParam == USRMSG_ITEMSTATECHANGED)
//		SetModified();	
	return CPropertyPage::OnCommand(wParam, lParam);
}

void CPPgDirectories::Localize(void)
{
	if(m_hWnd)
	{
		SetWindowText(GetResString(IDS_PW_DIR));

		GetDlgItem(IDC_INCOMING_FRM)->SetWindowText(GetResString(IDS_PW_INCOMING));
		GetDlgItem(IDC_TEMP_FRM)->SetWindowText(GetResString(IDS_PW_TEMP));
		GetDlgItem(IDC_SELINCDIR)->SetWindowText(GetResString(IDS_PW_BROWSE));
		GetDlgItem(IDC_SELTEMPDIR)->SetWindowText(GetResString(IDS_PW_BROWSE));
		GetDlgItem(IDC_SHARED_FRM)->SetWindowText(GetResString(IDS_PW_SHARED));
	}
}
