// MuleToolBarCtrl.cpp : implementation file
///////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MuleToolbarCtrl.h"
#include "emule.h"


// CMuleToolbarCtrl

IMPLEMENT_DYNAMIC(CMuleToolbarCtrl, CToolBarCtrl)
CMuleToolbarCtrl::CMuleToolbarCtrl()
{
}

CMuleToolbarCtrl::~CMuleToolbarCtrl()
{
}


BEGIN_MESSAGE_MAP(CMuleToolbarCtrl, CToolBarCtrl)
	ON_WM_ERASEBKGND()
END_MESSAGE_MAP()



// CMuleToolbarCtrl message handlers
BOOL CMuleToolbarCtrl::OnEraseBkgnd(CDC* pDC)
{
#ifdef USE_TEXTRE	
	CRect r;
	GetClientRect(&r);
	
	CDC MemDC;
	MemDC.CreateCompatibleDC(pDC);
	CBitmap MemBMP;
	MemBMP.CreateCompatibleBitmap(pDC, r.Width(), r.Height() + 1);
	MemDC.SelectObject(&MemBMP);
	MemDC.FillRect(CRect(0,0,r.Width(),r.Height()+1), &m_cbBackBrush);
	pDC->BitBlt(r.left, r.top, r.Width(), r.Height(), &MemDC, 0, 1, SRCCOPY);
	MemBMP.DeleteObject();



	return TRUE;
#endif
#ifndef USE_TEXTURE
	return CToolBarCtrl::OnEraseBkgnd(pDC);
#endif
}

void CMuleToolbarCtrl::Init(void)
{
	ModifyStyle(0, TBSTYLE_FLAT );
	SetButtonSize(CSize(60,65));
	SetBitmapSize(CSize(32,35));
	
// add button-images:
#ifdef USE_TEXTURE	
	m_bmpBackground.LoadBitmap(IDB_TB_BACKGROUND);
	m_cbBackBrush.CreatePatternBrush(&m_bmpBackground);
#endif
#ifndef USE_TEXTURE	
	m_cbBackBrush.CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
#endif
	
	CImageList ImageList;
	CBitmap Bitmap, *pOldBitmap;
	CDC *pCtrlDC = GetDC(), TempDC;
	TempDC.CreateCompatibleDC(pCtrlDC);
	Bitmap.CreateCompatibleBitmap(pCtrlDC, 32 * 11, 35);
	pOldBitmap = TempDC.SelectObject(&Bitmap);
		
#ifdef USE_TEXTURE	
	TempDC.FillRect(CRect(0,0,32*11,35), &m_cbBackBrush);
#endif
#ifndef USE_TEXTURE	
	TempDC.FillSolidRect(0,0,32*11,35,RGB(255,0,255));
#endif

	TempDC.DrawIcon(CPoint(  0,3), theApp.LoadIcon(IDI_BN_CONNECT));
	TempDC.DrawIcon(CPoint( 32,3), theApp.LoadIcon(IDI_BN_SERVER));
	TempDC.DrawIcon(CPoint( 64,3), theApp.LoadIcon(IDI_BN_DOWNLOAD));
	TempDC.DrawIcon(CPoint( 96,3), theApp.LoadIcon(IDI_BN_SEARCH));
	TempDC.DrawIcon(CPoint(128,3), theApp.LoadIcon(IDI_BN_FILES));
	TempDC.DrawIcon(CPoint(160,3), theApp.LoadIcon(IDI_BN_MESSAGES));
	TempDC.DrawIcon(CPoint(192,3), theApp.LoadIcon(IDI_BN_IRC));
	TempDC.DrawIcon(CPoint(224,3), theApp.LoadIcon(IDI_BN_STATISTICS));
	TempDC.DrawIcon(CPoint(256,3), theApp.LoadIcon(IDI_BN_PREFERENCES));
	TempDC.DrawIcon(CPoint(288,3), theApp.LoadIcon(IDI_BN_DISCONNECT));
	TempDC.DrawIcon(CPoint(320,3), theApp.LoadIcon(IDI_BN_STOPCONNECTING));
	TempDC.SelectObject(pOldBitmap);
	
	ImageList.Create(32, 35, ILC_COLOR16 | ILC_MASK, 11, 1);
	ImageList.Add(&Bitmap, RGB(255,0,255));
	SetImageList(&ImageList);
	ImageList.Detach();
	Bitmap.DeleteObject();

// add button-text:				
	char cButtonStrings[] = "Connect\0Transfers\0Servers\0Search\0Files\0Messages\0Irc\0Statistics\0Preferences\0";
	AddStrings(cButtonStrings); // we just need some strings :)

// add buttons:	
	int i, j;
	TBBUTTON TBButtons[11];

	for(i = 0, j = 0; i < 11; i++, j++)
	{		
		TBButtons[i].fsState	= TBSTATE_ENABLED;
		TBButtons[i].fsStyle	= TBSTYLE_CHECKGROUP;
		TBButtons[i].iBitmap	= j;
		TBButtons[i].idCommand	= IDC_TOOLBARBUTTON + j;
		TBButtons[i].iString	= j;

		switch(i)
	{		
			case 0:
			case 10:
			TBButtons[i].fsStyle = TBSTYLE_BUTTON;
				break;
			case 1:
			case 9:
				TBButtons[i].fsStyle	= TBSTYLE_SEP;
			TBButtons[i].iBitmap	= -1;
			TBButtons[i].idCommand	= 0;
			TBButtons[i].iString	= -1;
				j--;
				break;
			case 2:
			TBButtons[i].fsState |= TBSTATE_CHECKED;
			default:
				break;
		}
	}
	
	AddButtons(11, TBButtons);

// recalc toolbar-size:	
	Localize();		// at first we have to localize the button-text!!!
	
	CRect rClient;
	GetClientRect(&rClient);
	rClient.DeflateRect(7,7);
	int iHeight = rClient.Height();
	rClient.left = rClient.right - iHeight * 2;

	CRect r;
	GetWindowRect(&r);
	OnSize(0,r.Width(),r.Height());
}

void CMuleToolbarCtrl::Localize(void)
{	
	if(m_hWnd)
	{
		char szBuf[200];
		LPSTR pszBuf;
		TBBUTTONINFO tbi;
		LPTBBUTTONINFO lptbbi;
		pszBuf = szBuf;
		lptbbi = &tbi;
		tbi.dwMask = TBIF_TEXT;
		tbi.cbSize = sizeof (TBBUTTONINFO);
		tbi.pszText = pszBuf;
		CString buffer;
		buffer = GetResString(IDS_EM_SERVER);
		buffer.Remove('&');
		sprintf(szBuf, "%s", buffer);
		pszBuf = szBuf;
		
		tbi.cchText = sizeof (szBuf);
		SetButtonInfo(IDC_TOOLBARBUTTON+1, lptbbi);
		
		buffer = GetResString(IDS_EM_TRANS);
		buffer.Remove('&');
		sprintf(szBuf, "%s", buffer);
		tbi.cchText = sizeof (szBuf);
		SetButtonInfo(IDC_TOOLBARBUTTON+2, lptbbi);

		buffer = GetResString(IDS_EM_SEARCH);
		buffer.Remove('&');
		sprintf(szBuf, "%s", buffer);
		tbi.cchText = sizeof (szBuf);
		SetButtonInfo(IDC_TOOLBARBUTTON+3, lptbbi);

		buffer = GetResString(IDS_EM_FILES);
		buffer.Remove('&');
		sprintf(szBuf, "%s", buffer);
		tbi.cchText = sizeof (szBuf);
		SetButtonInfo(IDC_TOOLBARBUTTON+4, lptbbi);
		
		buffer = GetResString(IDS_EM_MESSAGES);
		buffer.Remove('&');
		sprintf(szBuf, "%s", buffer);
		tbi.cchText = sizeof (szBuf);
		SetButtonInfo(IDC_TOOLBARBUTTON+5, lptbbi);

		buffer = GetResString(IDS_IRC);
		buffer.Remove('&');
		sprintf(szBuf, "%s", buffer);
		tbi.cchText = sizeof (szBuf);
		SetButtonInfo(IDC_TOOLBARBUTTON+6, lptbbi);

		buffer = GetResString(IDS_EM_STATISTIC);
		buffer.Remove('&');
		sprintf(szBuf, "%s", buffer);
		tbi.cchText = sizeof (szBuf);
		SetButtonInfo(IDC_TOOLBARBUTTON+7, lptbbi);

		buffer =  GetResString(IDS_EM_PREFS);
		buffer.Remove('&');
		sprintf(szBuf, "%s", buffer);
		tbi.cchText = sizeof (szBuf);
		SetButtonInfo(IDC_TOOLBARBUTTON+8, lptbbi);

		AutoSize();
		CSize bs=GetButtonSize();
		bs.cx=bs.cx+5;
		SetButtonSize(bs);
	}
}



