//this file is part of eMule
// added by quekky
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// FileInfoDialog.cpp : implementation file

#include "stdafx.h"
#include "eMule.h"
#include "FileInfoDialog.h"


// CFileInfoDialog dialog

IMPLEMENT_DYNAMIC(CFileInfoDialog, CDialog)
CFileInfoDialog::CFileInfoDialog(CPartFile* pfile)
	: CDialog(CFileInfoDialog::IDD, 0)
	, ARoundBitrate(FALSE)
{
	m_file = pfile;
}

BOOL CFileInfoDialog::OnInitDialog(){
	CDialog::OnInitDialog();
	ARoundBitrate = 1;
	CDialog::UpdateData(FALSE);
	Localize();
	UpdateData();

	return true;
}

void CFileInfoDialog::UpdateData(){
	CFile* file = &m_file->m_hpartfile;
	try{
		char stemp[5];
		char buffer[100];
		uint32 u32;
		uint16 u16;

		if(!file)
			return;
		
		file->Seek(8, CFile::begin);
		file->Read(stemp, 4);
		stemp[4] = 0;
		if(strcmp(stemp, "AVI ")) // not avi
			return;
		


		// filesize
		long size;
		file->Seek(4, CFile::begin);
		file->Read(&size, 4);
		sprintf(buffer, "%.2f MB",((float)size / 1024 / 1024));
		GetDlgItem(IDC_FILESIZE)->SetWindowText(buffer);

		// header sizes
		long Aviheadersize,Vheadersize;
		file->Seek(28, CFile::begin);
		file->Read(&Aviheadersize, 4);

		long Aviheaderstart = 32;
		long Vheaderstart = Aviheaderstart + Aviheadersize + 20;

		// misc
		long Microsec;
		file->Seek(Aviheaderstart, CFile::begin);
		file->Read(&Microsec, 4);

		long LengthInFrames;
		file->Seek(Aviheaderstart + 16, CFile::begin);
		file->Read(&LengthInFrames, 4);

		// fps
		double fps = (double)1000000 / (double)Microsec;
		sprintf(buffer, "%.2f", fps);
		GetDlgItem(IDC_VFPS)->SetWindowText(buffer);
		
		// length
		long LengthInSec = (long)(LengthInFrames / fps);
		CastSecondsToHM(LengthInSec,buffer);
		GetDlgItem(IDC_LENGTH)->SetWindowText(buffer);

		// video width
		file->Seek(Aviheaderstart + 32, CFile::begin);
		file->Read(&u32, 4);
		sprintf(buffer, "%d", u32);
		GetDlgItem(IDC_VWIDTH)->SetWindowText(buffer);

		// video height
		file->Seek(Aviheaderstart + 36, CFile::begin);
		file->Read(&u32, 4);
		sprintf(buffer, "%d", u32);
		GetDlgItem(IDC_VHEIGHT)->SetWindowText(buffer);


		// video codec
		file->Seek(Vheaderstart + 4, CFile::begin);
		file->Read(stemp, 4);
		stemp[4] = 0;
		if(!strcmp(stemp, "div3") || !strcmp(stemp, "DIV3"))
			GetDlgItem(IDC_VCODEC)->SetWindowText("DivX;-) MPEG4 v3");
		else if(!strcmp(stemp, "div4") || !strcmp(stemp, "DIV4"))
				GetDlgItem(IDC_VCODEC)->SetWindowText("DivX;-) MPEG4 v4");
		else if(!strcmp(stemp, "divx") || !strcmp(stemp, "DIVX"))
				GetDlgItem(IDC_VCODEC)->SetWindowText("DivX 4/5");
		else if(!strcmp(stemp, "div2") || !strcmp(stemp, "DIV2"))
				GetDlgItem(IDC_VCODEC)->SetWindowText("MS MPEG4 v2");
		else if(!strcmp(stemp, "mp43"))
				GetDlgItem(IDC_VCODEC)->SetWindowText("Microcrap MPEG4 v3");
		else
				GetDlgItem(IDC_VCODEC)->SetWindowText(stemp);


		// header sizes
		file->Seek(Aviheaderstart + Aviheadersize + 4, CFile::begin);
		file->Read(&Vheadersize, 4);

		long Aheaderstart = Vheaderstart + Vheadersize + 8;	//first databyte of audio header

		long Astrhsize;
		file->Seek(Aheaderstart - 4, CFile::begin);
		file->Read(&Astrhsize, 4);

		// audio codec
		file->Seek(Aheaderstart + Astrhsize + 8, CFile::begin);
		file->Read(&u16, 2);
		switch(u16)
		{
			case 0:
			case 1:
				GetDlgItem(IDC_ACODEC)->SetWindowText("PCM");
				break;
			case 353:
				GetDlgItem(IDC_ACODEC)->SetWindowText("DivX;-) Audio");
				break;
			case 85:
				GetDlgItem(IDC_ACODEC)->SetWindowText("MPEG Layer 3");
				break;
			case 8192:
				GetDlgItem(IDC_ACODEC)->SetWindowText("AC3-Digital");
				break;
			default:
				sprintf(buffer, "Unknown (%d)", u16);
				GetDlgItem(IDC_ACODEC)->SetWindowText(buffer);
				break;
		}
			
			
		// audio channel
		file->Seek(Aheaderstart + 2 + Astrhsize + 8, CFile::begin);
		file->Read(&u16, 2);
		switch(u16)
		{
			case 1:
				GetDlgItem(IDC_ACHANNEL)->SetWindowText("1 (mono)");
				break;
			case 2:
				GetDlgItem(IDC_ACHANNEL)->SetWindowText("2 (stereo)");
				break;
			case 5:
				GetDlgItem(IDC_ACHANNEL)->SetWindowText("5.1 (surround)");
				break;
			default:
				sprintf(buffer, "%d", u16);
				GetDlgItem(IDC_ACHANNEL)->SetWindowText(buffer);
				break;
		}
			
		// audio samplerate
		file->Seek(Aheaderstart + 4 + Astrhsize + 8, CFile::begin);
		file->Read(&u32, 2);
		sprintf(buffer, "%d", u32);
		GetDlgItem(IDC_ASAMPLERATE)->SetWindowText(buffer);

		// audio bitrate
		file->Seek(Aheaderstart + 8 + Astrhsize + 8, CFile::begin);
		file->Read(&Abitrate, 4);
		OnBnClickedRoundbit();

		// video bitrate
		sprintf(buffer, "%d Kbit/s", (size / LengthInSec - Abitrate) / 128);
		GetDlgItem(IDC_VBITRATE)->SetWindowText(buffer);

	}
	catch(CFileException* error){
		OUTPUT_DEBUG_TRACE();
		error->Delete();	//memleak fix
		return;
	}
}

CFileInfoDialog::~CFileInfoDialog()
{
}

void CFileInfoDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_ROUNDBIT, ARoundBitrate);
}


BEGIN_MESSAGE_MAP(CFileInfoDialog, CDialog)
	ON_BN_CLICKED(IDC_ROUNDBIT, OnBnClickedRoundbit)
END_MESSAGE_MAP()


// CFileInfoDialog message handlers

void CFileInfoDialog::OnBnClickedRoundbit()
{
	char buffer[100];
	if(Abitrate != 0)
	{
		CDialog::UpdateData();
		if(ARoundBitrate)
		{
			long t = Abitrate / (1024 / 8);
			if(t>=246 && t<=260)
				GetDlgItem(IDC_ABITRATE)->SetWindowText("256 Kbit/s");
			else if(t>=216 && t<=228)
				GetDlgItem(IDC_ABITRATE)->SetWindowText("224 Kbit/s");
			else if(t>=187 && t<=196)
				GetDlgItem(IDC_ABITRATE)->SetWindowText("192 Kbit/s");
			else if(t>=156 && t<=164)
				GetDlgItem(IDC_ABITRATE)->SetWindowText("160 Kbit/s");
			else if(t>=124 && t<=132)
				GetDlgItem(IDC_ABITRATE)->SetWindowText("128 Kbit/s");
			else if(t>=108 && t<=116)
				GetDlgItem(IDC_ABITRATE)->SetWindowText("112 Kbit/s");
			else if(t>=92 && t<=100)
				GetDlgItem(IDC_ABITRATE)->SetWindowText("96 Kbit/s");
			else if(t>=60 && t<=68)
				GetDlgItem(IDC_ABITRATE)->SetWindowText("64 Kbit/s");
			else
			{
				sprintf(buffer, "%d Kbit/s", t);
				GetDlgItem(IDC_ABITRATE)->SetWindowText(buffer);
			}
		}
		else
		{
			sprintf(buffer, "%d Kbit/s", Abitrate / (1024 / 8));
			GetDlgItem(IDC_ABITRATE)->SetWindowText(buffer);
		}
	}
	else
		GetDlgItem(IDC_ABITRATE)->SetWindowText("");
}

void CFileInfoDialog::Localize(){
	GetDlgItem(IDC_FD_XI1)->SetWindowText(GetResString(IDS_FD_SIZE));
	GetDlgItem(IDC_FD_XI2)->SetWindowText(GetResString(IDS_LENGTH)+":");
	GetDlgItem(IDC_FD_XI3)->SetWindowText(GetResString(IDS_VIDEO));
	GetDlgItem(IDC_FD_XI4)->SetWindowText(GetResString(IDS_AUDIO));
	GetDlgItem(IDOK)->SetWindowText( GetResString(IDS_FD_CLOSE));

	GetDlgItem(IDC_FD_XI5)->SetWindowText( GetResString(IDS_CODEC)+":");
	GetDlgItem(IDC_FD_XI6)->SetWindowText( GetResString(IDS_CODEC)+":");
	
	GetDlgItem(IDC_FD_XI7)->SetWindowText( GetResString(IDS_BITRATE)+":");
	GetDlgItem(IDC_FD_XI8)->SetWindowText( GetResString(IDS_BITRATE)+":");
	
	GetDlgItem(IDC_FD_XI9)->SetWindowText( GetResString(IDS_WIDTH)+":");
	GetDlgItem(IDC_FD_XI11)->SetWindowText( GetResString(IDS_HEIGHT)+":");
	GetDlgItem(IDC_FD_XI13)->SetWindowText( GetResString(IDS_FPS)+":");
	GetDlgItem(IDC_FD_XI10)->SetWindowText( GetResString(IDS_CHANNELS)+":");
	GetDlgItem(IDC_FD_XI12)->SetWindowText( GetResString(IDS_SAMPLERATE)+":");
	GetDlgItem(IDC_ROUNDBIT)->SetWindowText( GetResString(IDS_ROUNDBITRATE)+":");

	CString title=GetResString(IDS_FILEINFO); title.Remove('&');
	SetWindowText(title);
}
