//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once
#include "types.h"

// CFileDetailDialog dialog

class CFileDetailDialog : public CDialog
{
	DECLARE_DYNAMIC(CFileDetailDialog)

public:
	CFileDetailDialog(CPartFile* file);   // standard constructor
	virtual ~CFileDetailDialog();
	virtual BOOL OnInitDialog();
	void Localize();
// Dialog Data
	enum { IDD = IDD_FILEDETAILS };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	void OnTimer(UINT nIDEvent);
	void OnDestroy();
	DECLARE_MESSAGE_MAP()

	static int CALLBACK CompareListNameItems(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort);	// Juanjo

private:
	void UpdateData();
	void FillSourcenameList();
	CPartFile* m_file;
	uint32 m_timer;
	afx_msg void OnBnClickedButtonrename();
	afx_msg void OnBnClickedButtonStrip();
	afx_msg void OnBnClickedFileinfo();
	afx_msg void OnBnClickedShowComment();//for Comment//
	afx_msg void TakeOver();
	CMuleListCtrl* sourcesList;
	bool	m_SortAscending[2];
public:
	afx_msg void OnLvnColumnclick(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMDblclkList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMRclickList(NMHDR *pNMHDR, LRESULT *pResult);
	virtual BOOL OnCommand(WPARAM wParam,LPARAM lParam );
};
