// CreditsThread.cpp: implementation of the CCreditsThread class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CreditsThread.h"
#include <wingdi.h>
#include "opcodes.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// define mask color
#define MASK_RGB	(COLORREF)0xFFFFFF

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNAMIC(CCreditsThread, CGDIThread)

BEGIN_MESSAGE_MAP(CCreditsThread, CGDIThread)
	//{{AFX_MSG_MAP(CCreditsThread)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CCreditsThread::CCreditsThread(CWnd* pWnd, HDC hDC, CRect rectScreen)
    : CGDIThread(pWnd,hDC)
{
	m_rectScreen = rectScreen;
	m_rgnScreen.CreateRectRgnIndirect(m_rectScreen);
	m_nScrollPos = 0;
}

CCreditsThread::~CCreditsThread() 
{
	if(m_dcBk.m_hDC != NULL && m_pbmpOldBk != NULL)
	{
		m_dcBk.SelectObject(m_pbmpOldBk);
		m_bmpBk.DeleteObject();
	}

	if(m_dcScreen.m_hDC != NULL && m_pbmpOldScreen != NULL)
	{
		m_dcScreen.SelectObject(m_pbmpOldScreen);
		m_bmpScreen.DeleteObject();
	}

	if(m_dcCredits.m_hDC != NULL && m_pbmpOldCredits != NULL)
	{
		m_dcCredits.SelectObject(m_pbmpOldCredits);
		m_bmpCredits.DeleteObject();
	}

	if(m_dcMask.m_hDC != NULL && m_pbmpOldMask != NULL)
	{
		m_dcMask.SelectObject(m_pbmpOldMask);
		m_bmpMask.DeleteObject();
	}

	// clean up the fonts we created
	for(int n = 0; n < m_arFonts.GetSize(); n++)
	{
		m_arFonts.GetAt(n)->DeleteObject();
		delete m_arFonts.GetAt(n);
	}
}

BOOL CCreditsThread::InitInstance()
{
	return CGDIThread::InitInstance();
}

// wait for vertical retrace
// makes scrolling smoother, especially at fast speeds
// NT does not like this at all
void waitvrt(void)
{
	__asm {
			mov	dx,3dah
	VRT:
			in		al,dx
			test	al,8
			jnz		VRT
	NoVRT:
			in		al,dx
			test	al,8
			jz		NoVRT
	}
}

void CCreditsThread::SingleStep()
{
	// if this is our first time, initialize the credits
	if(m_dcCredits.m_hDC == NULL)
	{
		CreateCredits();
	}

	// track scroll position
	static int nScrollY = 0;

	// timer variables
	LARGE_INTEGER nFrequency;
	LARGE_INTEGER nStart;
	LARGE_INTEGER nEnd;
	int nTimeInMilliseconds;
	BOOL bTimerValid;

	nStart.QuadPart = 0;

	if(!QueryPerformanceFrequency(&nFrequency))
	{
		bTimerValid = FALSE;
	}
	else
	{
		bTimerValid = TRUE;

		// get start time
		QueryPerformanceCounter(&nStart);
	}

	EnterCriticalSection(&CGDIThread::m_csGDILock);
	{
		PaintBk(&m_dcScreen);

		m_dcScreen.BitBlt(0, 0, m_nCreditsBmpWidth, m_nCreditsBmpHeight, &m_dcCredits, 0, nScrollY, SRCINVERT);
		m_dcScreen.BitBlt(0, 0, m_nCreditsBmpWidth, m_nCreditsBmpHeight, &m_dcMask, 0, nScrollY, SRCAND);
		m_dcScreen.BitBlt(0, 0, m_nCreditsBmpWidth, m_nCreditsBmpHeight, &m_dcCredits, 0, nScrollY, SRCINVERT);

		// wait for vertical retrace
		if(m_bWaitVRT) waitvrt();

		m_dc.BitBlt(m_rectScreen.left, m_rectScreen.top, m_rectScreen.Width(), m_rectScreen.Height(), &m_dcScreen, 0, 0, SRCCOPY);

		GdiFlush();
	}
	LeaveCriticalSection(&CGDIThread::m_csGDILock);

	// continue scrolling
	nScrollY += m_nScrollInc;
	if(nScrollY >= m_nCreditsBmpHeight) nScrollY = 0;	// scrolling up
	if(nScrollY < 0) nScrollY = m_nCreditsBmpHeight;	// scrolling down

	// delay scrolling by the specified time
	if(bTimerValid)
	{
		QueryPerformanceCounter(&nEnd);
		nTimeInMilliseconds = (int)((nEnd.QuadPart - nStart.QuadPart) * 1000 / nFrequency.QuadPart);

		if(nTimeInMilliseconds < m_nDelay)
		{
			Sleep(m_nDelay - nTimeInMilliseconds);
		}
	}
	else
	{
		Sleep(m_nDelay);
	}
}

void CCreditsThread::PaintBk(CDC* pDC)
{
	//save background the first time
	if (m_dcBk.m_hDC == NULL)
	{
		m_dcBk.CreateCompatibleDC(&m_dc);
		m_bmpBk.CreateCompatibleBitmap(&m_dc, m_rectScreen.Width(), m_rectScreen.Height());
		m_pbmpOldBk = m_dcBk.SelectObject(&m_bmpBk);
		m_dcBk.BitBlt(0, 0, m_rectScreen.Width(), m_rectScreen.Height(), &m_dc, m_rectScreen.left, m_rectScreen.top, SRCCOPY);
	}

	pDC->BitBlt(0, 0, m_rectScreen.Width(), m_rectScreen.Height(), &m_dcBk, 0, 0, SRCCOPY);
}

void CCreditsThread::CreateCredits()
{
	InitFonts();
	InitColors();
	InitText();

	m_dc.SelectClipRgn(&m_rgnScreen);

	m_dcScreen.CreateCompatibleDC(&m_dc);
	m_bmpScreen.CreateCompatibleBitmap(&m_dc, m_rectScreen.Width(), m_rectScreen.Height());
	m_pbmpOldScreen = m_dcScreen.SelectObject(&m_bmpScreen);

	m_nCreditsBmpWidth = m_rectScreen.Width();
	m_nCreditsBmpHeight = CalcCreditsHeight();

	m_dcCredits.CreateCompatibleDC(&m_dc);
	m_bmpCredits.CreateCompatibleBitmap(&m_dc, m_nCreditsBmpWidth, m_nCreditsBmpHeight);
	m_pbmpOldCredits = m_dcCredits.SelectObject(&m_bmpCredits);

	m_dcCredits.FillSolidRect(0, 0, m_nCreditsBmpWidth, m_nCreditsBmpHeight, MASK_RGB);

	CFont* pOldFont;

	pOldFont  = m_dcCredits.SelectObject(m_arFonts.GetAt(0));

	m_dcCredits.SetBkMode(TRANSPARENT);

	int y = 0;

	int nFont;
	int nColor;

	int nLastFont = -1;
	int nLastColor = -1;

	int nTextHeight = m_dcCredits.GetTextExtent(_T("Wy")).cy;

	for(int n = 0; n < m_arCredits.GetSize(); n++)
	{
		CString sType = m_arCredits.GetAt(n).Left(1);

		if(sType == 'B')
		{
			// it's a bitmap

			CBitmap bmp;
			if(! bmp.LoadBitmap((const char *)m_arCredits.GetAt(n).Mid(2)))
			{
				CString str; 
				str.Format(_T("Could not find bitmap resource \"%s\". Be sure to assign the bitmap a QUOTED resource name"), m_arCredits.GetAt(n).Mid(2)); 
				AfxMessageBox(str); 
				return; 
			}

			BITMAP bmInfo;
			bmp.GetBitmap(&bmInfo);

			CDC dc;
			dc.CreateCompatibleDC(&m_dcCredits);
			CBitmap* pOldBmp = dc.SelectObject(&bmp);

			// draw the bitmap
			m_dcCredits.BitBlt((m_rectScreen.Width() - bmInfo.bmWidth) / 2, y, bmInfo.bmWidth, bmInfo.bmHeight, &dc, 0, 0, SRCCOPY);

			dc.SelectObject(pOldBmp);
			bmp.DeleteObject();

			y += bmInfo.bmHeight;
		}
		else if(sType == 'S')
		{
			// it's a vertical space

			y += _ttoi(m_arCredits.GetAt(n).Mid(2));
		}
		else
		{
			// it's a text string

			nFont = _ttoi(m_arCredits.GetAt(n).Left(2));
			nColor = _ttoi(m_arCredits.GetAt(n).Mid(3,2));

			if(nFont != nLastFont)
			{
				m_dcCredits.SelectObject(m_arFonts.GetAt(nFont));
				nTextHeight = m_arFontHeights.GetAt(nFont);
			}

			if(nColor != nLastColor)
			{
				m_dcCredits.SetTextColor(m_arColors.GetAt(nColor));
			}

			CRect rect(0, y, m_rectScreen.Width(), y + nTextHeight);

			m_dcCredits.DrawText(m_arCredits.GetAt(n).Mid(6), &rect, DT_CENTER);

			y += nTextHeight;
		}
	}

	m_dcCredits.SetBkColor(MASK_RGB);
	m_dcCredits.SelectObject(pOldFont);

	// create the mask bitmap
	m_dcMask.CreateCompatibleDC(&m_dcScreen);
	m_bmpMask.CreateBitmap(m_nCreditsBmpWidth, m_nCreditsBmpHeight, 1, 1, NULL);

	// select the mask bitmap into the appropriate dc
	m_pbmpOldMask = m_dcMask.SelectObject(&m_bmpMask);

	// build mask based on transparent color
	m_dcMask.BitBlt(0, 0, m_nCreditsBmpWidth, m_nCreditsBmpHeight, &m_dcCredits, 0, 0, SRCCOPY);
}

void CCreditsThread::InitFonts()
{
	// create each font we'll need and add it to the fonts array

	CDC dcMem;
	dcMem.CreateCompatibleDC(&m_dc);
	CFont* pOldFont;
	int nTextHeight;

	LOGFONT lf;

	// font 0
	// SMALL ARIAL
	CFont* font0 = new CFont;
	memset((void*)&lf, 0, sizeof(lf));
	lf.lfHeight = 16;
	lf.lfWeight = 600;
	lf.lfQuality = NONANTIALIASED_QUALITY;
	_tcscpy(lf.lfFaceName, _T("Arial"));
	font0->CreateFontIndirect(&lf);
	m_arFonts.Add(font0);

	pOldFont = dcMem.SelectObject(font0);
	nTextHeight = dcMem.GetTextExtent(_T("Wy")).cy;
	m_arFontHeights.Add(nTextHeight);

	// font 1
	// MEDIUM BOLD ARIAL
	CFont* font1 = new CFont;
	memset((void*)&lf, 0, sizeof(lf));
	lf.lfHeight = 22;
	lf.lfWeight = 700;
	lf.lfQuality = NONANTIALIASED_QUALITY;
	_tcscpy(lf.lfFaceName, _T("Arial"));
	font1->CreateFontIndirect(&lf);
	m_arFonts.Add(font1);

	pOldFont = dcMem.SelectObject(font1);
	nTextHeight = dcMem.GetTextExtent(_T("Wy")).cy;
	m_arFontHeights.Add(nTextHeight);

	// font 2
	// LARGE ITALIC HEAVY BOLD TIMES ROMAN
	CFont* font2 = new CFont;
	memset((void*)&lf, 0, sizeof(lf));
	lf.lfHeight = 32;
	lf.lfWeight = 900;
	lf.lfItalic = TRUE;
	lf.lfQuality = NONANTIALIASED_QUALITY;
	_tcscpy(lf.lfFaceName, _T("Times Roman"));
	font2->CreateFontIndirect(&lf);
	m_arFonts.Add(font2);

	pOldFont = dcMem.SelectObject(font2);
	nTextHeight = dcMem.GetTextExtent(_T("Wy")).cy;
	m_arFontHeights.Add(nTextHeight);

	// font 3
	CFont* font3 = new CFont;
	memset((void*)&lf, 0, sizeof(lf));
	lf.lfHeight = 18;
	lf.lfWeight = 700;
	lf.lfQuality = NONANTIALIASED_QUALITY;
	_tcscpy(lf.lfFaceName, _T("Arial"));
	font3->CreateFontIndirect(&lf);
	m_arFonts.Add(font3);

	pOldFont = dcMem.SelectObject(font3);
	nTextHeight = dcMem.GetTextExtent(_T("Wy")).cy;
	m_arFontHeights.Add(nTextHeight);

	dcMem.SelectObject(pOldFont);
}

void CCreditsThread::InitColors()
{
	// define each color we'll be using

	m_arColors.Add(PALETTERGB(180, 0, 180));	// 0 = PURPLE
	m_arColors.Add(PALETTERGB(250, 250, 250));	// 1 = ALMOST WHITE
	m_arColors.Add(PALETTERGB(50, 50, 50));		// 2 = VERY DARK GRAY
	m_arColors.Add(PALETTERGB(200, 200, 200));	// 3 = LIGHT GRAY
	m_arColors.Add(PALETTERGB(200, 50, 50));	// 4 = REDDISH
	m_arColors.Add(PALETTERGB(30, 100, 255));	// 5 = BLUEISH
	m_arColors.Add(PALETTERGB(150, 225, 200));	// 6 = GREENISH
	m_arColors.Add(PALETTERGB(255, 255, 128));	// 7 yellow
}

void CCreditsThread::InitText()
{
	// 1st pair of digits identifies the font to use
	// 2nd pair of digits identifies the color to use
	// B = Bitmap
	// S = Space (moves down the specified number of pixels)

	CString sTmp;
	
	/*
		You may NOT modify this copyright message. You may add your name, if you
		changed or improved this code, but you mot not delete any part of this message,
		make it invisible etc.
	*/

	// start at the bottom of the screen
	sTmp.Format(_T("S:%d"), m_rectScreen.Height());
	m_arCredits.Add(sTmp);

	m_arCredits.Add(_T("02:04:eMule"));
	sTmp.Format("02:04:Version %s",CURRENT_VERSION_LONG);
	m_arCredits.Add(_T(sTmp));
	m_arCredits.Add(_T("00:05:Copyright (C)2002 Merkur"));
	m_arCredits.Add(_T("S:100"));
	m_arCredits.Add(_T("01:07:Developers"));
	m_arCredits.Add(_T("S:20"));
	m_arCredits.Add(_T("03:04:Unknown1"));
	m_arCredits.Add(_T("S:20"));
	m_arCredits.Add(_T("03:04:Ornis"));
	m_arCredits.Add(_T("S:20"));
	m_arCredits.Add(_T("03:04:Dirus"));

	m_arCredits.Add(_T("S:80"));

	m_arCredits.Add(_T("01:07:Tester"));
	m_arCredits.Add(_T("S:20"));
	m_arCredits.Add(_T("03:04:Sony666"));
	m_arCredits.Add(_T("S:20"));
	m_arCredits.Add(_T("03:04:Monk"));
	m_arCredits.Add(_T("S:20"));
	m_arCredits.Add(_T("03:04:Mr Ozon"));

	m_arCredits.Add(_T("S:80"));
	m_arCredits.Add(_T("01:07:Retired Members"));
	m_arCredits.Add(_T("S:20"));
	m_arCredits.Add(_T("03:04:Merkur (the Founder)"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("03:04:tecxx"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("03:04:Pach2"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("03:04:Juanjo"));
	m_arCredits.Add(_T("S:10"));

	m_arCredits.Add(_T("S:80"));
	m_arCredits.Add(_T("01:07:Thanks to these programmers"));
	m_arCredits.Add(_T("01:07:for publishing useful codeparts"));
	m_arCredits.Add(_T("S:20"));
	m_arCredits.Add(_T("00:05:Paolo Messina (ResizableDialog class)"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:5:PJ Naughter (HttpDownload Dialog)"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Jim Connor (Scrolling Credits)"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Yury Goltsman (extended Progressbar)"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Magomed G. Abdurakhmanov (Hyperlink ctrl)"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Arthur Westerman (Titled menu)"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Keith Rule (Memory DC)"));
	m_arCredits.Add(_T("S:50"));

	m_arCredits.Add(_T("S:80"));
	m_arCredits.Add(_T("01:07:And thanks to the following"));
	m_arCredits.Add(_T("01:07:people for translating eMule"));
	m_arCredits.Add(_T("01:07:into different languages:"));
	m_arCredits.Add(_T("S:20"));
	m_arCredits.Add(_T("00:05:Bulgarian: DapKo"));
	m_arCredits.Add(_T("S:10"));	
	m_arCredits.Add(_T("00:05:Catalan: LeChuck"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Chinese simplyfied: Tim Chen"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Chinese Traditional: Donlong, CML, Ryan"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Danish: KimTiede, Cirrus, Itchy"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Dutch: Mr.Bean"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Finnish: Nikerabbit, Miksan"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:French: Alexis, Bouc7, abc, obi1"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Greek: Michael Papadakis"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Italian: Trevi"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Hungarian: r0ll3r"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Korean: MoonHyoung Lee"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Latvian: Ai"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Lithuanian: Daan"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Norwegian: Iznogood"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Polish: Tomasz \"TMouse\" Broniarek"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Portugese: Lus Claro"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Portugese Brasilian: DarthMaul,Brasco"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Russian: BRMAIL"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Slowenian: Rok Kralj"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Spanish Castellano: Azuredraco, Javier, Juanan"));
	m_arCredits.Add(_T("S:10"));
	m_arCredits.Add(_T("00:05:Swedish: Andre"));

	// pause before repeating
	m_arCredits.Add(_T("S:100"));
}

int CCreditsThread::CalcCreditsHeight()
{
	int nHeight = 0;

	for(int n = 0; n < m_arCredits.GetSize(); n++)
	{
		CString sType = m_arCredits.GetAt(n).Left(1);

		if(sType == 'B')
		{
			// it's a bitmap

			CBitmap bmp;
			if (! bmp.LoadBitmap((const char *)m_arCredits.GetAt(n).Mid(2)))
			{
				CString str; 
				str.Format(_T("Could not find bitmap resource \"%s\". Be sure to assign the bitmap a QUOTED resource name"), m_arCredits.GetAt(n).Mid(2)); 
				AfxMessageBox(str); 
				return -1; 
			}

			BITMAP bmInfo;
			bmp.GetBitmap(&bmInfo);

			nHeight += bmInfo.bmHeight;
		}
		else if(sType == 'S')
		{
			// it's a vertical space

			nHeight += _ttoi(m_arCredits.GetAt(n).Mid(2));
		}
		else
		{
			// it's a text string

			int nFont = _ttoi(m_arCredits.GetAt(n).Left(2));
			nHeight += m_arFontHeights.GetAt(nFont);
		}
	}

	return nHeight;
}
