
#include "stdafx.h" 
#include "emule.h"
#include "CommentDialogLst.h"


IMPLEMENT_DYNAMIC(CCommentDialogLst, CDialog) 
CCommentDialogLst::CCommentDialogLst(CPartFile* file) 
   : CDialog(CCommentDialogLst::IDD, 0) 
{ 
   m_file = file; 
} 

CCommentDialogLst::~CCommentDialogLst() 
{ 
} 

void CCommentDialogLst::DoDataExchange(CDataExchange* pDX) 
{ 
   CDialog::DoDataExchange(pDX); 
} 

BEGIN_MESSAGE_MAP(CCommentDialogLst, CDialog) 
   ON_BN_CLICKED(IDCOK, OnBnClickedApply) 
   ON_BN_CLICKED(IDCREF, OnBnClickedRefresh) 
END_MESSAGE_MAP() 



void CCommentDialogLst::OnBnClickedApply() 
{ 
   CDialog::OnOK(); 
} 

void CCommentDialogLst::OnBnClickedRefresh() 
{ 
   CompleteList(); 
} 

BOOL CCommentDialogLst::OnInitDialog(){ 
   CDialog::OnInitDialog(); 
   Localize(); 

   return TRUE; 
} 

void CCommentDialogLst::Localize(void){ 
   GetDlgItem(IDCOK)->SetWindowText(GetResString(IDS_CW_CLOSE)); 
   GetDlgItem(IDCREF)->SetWindowText(GetResString(IDS_CMT_REFRESH)); 

   SetWindowText(GetResString(IDS_CMT_READALL)); 
    
   CRect rect; 

   GetDlgItem(IDC_LST)->GetWindowRect(rect); 
   ::MapWindowPoints(NULL, m_hWnd, (LPPOINT)&rect, 2); 
   lstbox.CreateEx(WS_EX_STATICEDGE,0,"LSTWnd",WS_VISIBLE | WS_CHILD | HTC_WORDWRAP |HTC_AUTO_SCROLL_BARS | HTC_UNDERLINE_HOVER,rect.left,rect.top,rect.Width(),rect.Height(),m_hWnd,0); 
    
   CompleteList(); 
} 

void CCommentDialogLst::CompleteList () { 
   POSITION pos1,pos2; 
   CUpDownClient* cur_src; 
   CString text; 
    
   int count; 
   count=0; 
   CString comment; 
   CString rated; 
   for (pos1 = m_file->srclist.GetHeadPosition(); (pos2 = pos1) != NULL;) { 
      m_file->srclist.GetNext(pos1); 
      cur_src = m_file->srclist.GetAt(pos2); 
      try{ 
         comment = cur_src->GetFileComment(); 
		 rated=GetRateString(cur_src->GetFileRate());
         if ((comment != "")||(rated!=GetRateString(0))) { 
            text += cur_src->GetUserName();
			text+=": "; 
			text+=" ("+GetResString(IDS_CMT_RATEQUEST)+": "+ rated +") ";
			if (comment != ""){
				text += comment; 
			}
			text+=CString("\n\n");
			count++;
		 }
	  } 
        catch (...){} 
   } 
   if (count == 0) { 
      text += GetResString(IDS_CMT_NOCOMMENT) + CString("\n"); 
   } 
   lstbox.SetWindowText(CString(text)); 
}