//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once
#include "types.h"
#include "preferences.h"
#include "mapkey.h"

#pragma pack(1)

struct Credit_Struct{
	uchar		key[16];
	uint32		uploaded;	//uploaded TO him
	uint32		downloaded; // downloaded from him
	uint32		lastseen;
	uint32		reserved1;
	uint32		reserved2;
	uint16		reserved3;
};

class CClientCredits{
public:
	CClientCredits(Credit_Struct* in_credits);
	CClientCredits(uchar* key);
	~CClientCredits();

	uchar*	GetKey()						{return credits->key;}
	Credit_Struct* GetDataStruct()			{return credits;}
	void	AddDownloaded(uint32 bytes)		{credits->downloaded += bytes;}
	void	AddUploaded(uint32 bytes)		{credits->uploaded += bytes;}
	uint32	GetUploadedTotal()				{return credits->uploaded;} //uploaded TO him
	uint32	GetDownloadedTotal()			{return credits->downloaded; } // downloaded from him
	float	GetScoreRatio();
	void	SetLastSeen()					{CTime lwtime; credits->lastseen = mktime(lwtime.GetLocalTm());}
private:
	Credit_Struct* credits;
};

class CClientCreditsList{
public:
	CClientCreditsList(CPreferences* in_prefs);
	~CClientCreditsList();
	CClientCredits* GetCredit(uchar* key);
	void			Process();
protected:
	void	LoadList();
	void	SaveList();
private:
	CPreferences* app_prefs;
	CMap<CCKey,CCKey&,CClientCredits*,CClientCredits*> client_map;
	uint32	lastsaved;
};