//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once
#include "types.h"
#include "listensocket.h"
#include "partfile.h"
// uploadstate
#define US_NONE				0
#define	US_PENDING			1
#define	US_ONUPLOADQUEUE	2
#define	US_UPLOADING		4
#define US_BANNED			6
#define US_ERROR			7
#define	US_WAITCALLBACK		8
#define	US_CONNECTING		9
#define	US_LOWTOLOWIP		10

// downloadstate
#define	DS_NONE				0
#define	DS_DOWNLOADING		1
#define	DS_ONQUEUE			2
#define	DS_CONNECTING		3
#define	DS_WAITCALLBACK		4
#define	DS_NONEEDEDPARTS	5
#define DS_BANNED			6
#define DS_ERROR			7
#define	DS_CONNECTED		9
#define	DS_LOWTOLOWIP		10
#define	DS_REQHASHSET		11

// chatstate
#define	MS_NONE				0
#define	MS_CHATTING			1
#define	MS_CONNECTING		2
#define	MS_UNABLETOCONNECT	3

// clientsoft
#define SO_UNKNOWN			0
#define SO_EMULE			1
#define	SO_EDONKEY			2
#define SO_MLDONKEY			3
#define SO_OLDEMULE			4

class CClientReqSocket;

class CUpDownClient
{
	//friend class
public:
	//base
	CUpDownClient(CClientReqSocket* sender = 0);
	CUpDownClient(uint16 in_port, uint32 in_userid, uint32 in_serverup, uint16 in_serverport,CPartFile* in_reqfile);
	~CUpDownClient();
	void			Disconnected();
	void			ConnectionFailed();
	void			TryToConnect();
	void			ConnectionEstablished();
	uint32			GetUserID()					{return userid;}
	char*			GetUserName()				{return username;}
	uint32			GetIP()						{return userip;}
	bool			HasLowID()					{return (userid < 16777216);}
	char*			GetFullIP()					{return fulluserip;}
	uint32			GetUserPort()				{return userport;}
	uint32			GetTransferedUp()			{return transfered;}
	uint32			GetTransferedDown()			{return transfereddown;}
	uint32			GetServerIP()				{return serverip;}
	uchar*			GetUserHash()				{return (uchar*)userhash;}
	uint8			GetVersion()				{return clientversion;}
	uint8			GetMuleVersion()			{return emuleversion;}
	bool			ExtProtocolAvailable()		{return useemuleprotocol;}
	bool			IsEmuleClient()				{return emuleversion;}
	uint8			GetClientSoft();
	void			ProcessHelloAnswer(char* packet, uint32 size);
	void			ProcessHelloPacket(char* packet, uint32 size);
	void			SendHelloAnswer();
	void			SendHelloPacket();
	void			SendMuleInfoPacket(bool answer);
	void			ProcessMuleInfoPacket(char* packet, uint32 size);
	bool			Compare(CUpDownClient* tocomp);
	CClientReqSocket*	socket;

	//upload
	uint8			GetUploadState()			{return uploadstate;}
	void			SetUploadState(uint8 news)	{uploadstate = news;}
	uint32			GetWaitStartTime()			{return starttime;}
	uint32			GetWaitTime()				{return upstarttime-starttime;}
	bool			IsDownloading()				{return (uploadstate == US_UPLOADING);}
	bool			HasBlocks()					{return !blocksend_queue.IsEmpty();}
	uint32			GetDatarate()				{return datarate;}	
	uint32			GetScore(bool isdownloading = false, bool onlybasevalue = false);
	void			AddReqBlock(Requested_Block_Struct* reqblock);
	bool			CreateNextBlockPackage();
	void			SetUpStartTime(uint32 time = 0);
	void			SetWaitStartTime(uint32 time = 0);
	void			SendHashsetPacket(char* forfileid);
	uchar			reqfileid[16];
	uint32			SendBlockData(uint32 maxammount);
	void			ClearUploadBlockRequests();
	void			SendRankingInfo();

	//download
	uint8			GetDownloadState()			{return substate;}
	void			SetDownloadState(uint8 news);
	uint32			GetLastAskedTime()			{return lastaskedtime;}
	bool			IsPartAvailable(uint8 part)	{return	(part >= partcount)? 0:partstatus[part];} 	
	uint8*			GetPartStatus()				{return partstatus;}
	uint32			GetDownloadDatarate()		{return downdatarate;}
	uint16			GetRemoteQueueRank()		{return remotequeuerank;}
	void			SetRemoteQueueRank(uint16 nr);
	void			DrawStatusBar(CDC* dc,RECT* rect,bool onlygreyrect);
	void			AskForDownload();
	void			SendFileRequest();
	void			ProcessFileInfo(char* packet,uint32 size);
	void			ProcessFileStatus(char* packet,uint32 size);
	void			ProcessHashSet(char* packet,uint32 size);
	bool			AddRequestForAnotherFile(CPartFile* file);
	void			SendBlockRequests();
	void			ProcessBlockPacket(char* packet, uint32 size, bool packed = false);
	uint32			CalculateDownloadRate();
	uint16			GetAvailablePartCount();
	
	CPartFile*		reqfile;

	//chat
	uint8			GetChatState()			{return chatstate;}
	void			SetChatState(uint8 news){chatstate = news;}
private:
	// base
	void	Init();
	void	ProcessHelloTypePacket(CMemFile* data);
	void	SendHelloTypePacket(CMemFile* data);
	bool	isbotuser;
	bool	haslowid;
	bool	isfriend;
	bool	isemuleclient;
	uint32	userip;
	uint32	serverip;
	uint32	userid;
	int16	userport;
	int16	serverport;
	uint32	clientversion;
	uint32	datarate;
	uint32	dataratems;
	uint32	count;
	uint8	emuleversion;
	uint8	datacompression;
	bool	useemuleprotocol;
	char*	username;
	char	fulluserip[21];
	char	userhash[16];

	//upload
	void CreateStandartPackets(byte* data,uint32 togo, Requested_Block_Struct* currentblock);
	void CreatePackedPackets(byte* data,uint32 togo, Requested_Block_Struct* currentblock);
	uint32	transfered;
	uint8	uploadstate;
	uint32	starttime;
	uint32	upstarttime;
	int16	filepriority;
	uint32	maxsendallowed;
	uint32	avupdatarate;
	bool	usedcompressionup;	//only used for interface output
	CList<int,int>									 avarage_udr_list;
	CTypedPtrList<CPtrList, Packet*>				 blocksend_queue;
	CTypedPtrList<CPtrList, Requested_Block_Struct*> blockreqlist;
	CTypedPtrList<CPtrList, Requested_Block_Struct*> doneblocklist;
	//download
	bool		usedcompressiondown; //only used for interface output
	uint8		substate;
	uint16		partcount;
	uint8*		partstatus;
	uint32		lastaskedtime;
	char*		clientfilename;
	uint32		transfereddown;
	uint32		downdatarate;
	uint32		downdataratems;
	uint32		avdowndatarate;
	uint8		failedconnection;
	bool		progressbarchanged;
	uint16		dcount;
	uint32		lastblockreceived;
	uint16		remotequeuerank;
	CList<int,int>									 avarage_ddr_list;
	CTypedPtrList<CPtrList, Pending_Block_Struct*>	 pendingblocks_list;
	CTypedPtrList<CPtrList, Requested_Block_Struct*> downloadblocks_list;
	CTypedPtrList<CPtrList, CPartFile*>				 otherrequests_list;
	
	// chat
	uint8 chatstate;
};

