//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Client to Server communication

#pragma once

#include "types.h"
#include "server.h"
#include "packets.h"
#include "ServerListCtrl.h"
#include "Preferences.h"
#include "server.h"
#include "serverlist.h"
#include "preferences.h"
#include "serversocket.h"

#define CS_FATALERROR	-5
#define CS_DISCONNECTED	-4
#define CS_SERVERDEAD	-3
#define	CS_ERROR		-2
#define CS_SERVERFULL	-1
#define	CS_NOTCONNECTED	0
#define	CS_CONNECTING	1
#define	CS_CONNECTED	2
#define	CS_WAITFORLOGIN	3

class CServerConnect;


class CUDPSocket : public CAsyncSocket
{
	friend class CServerConnect;
public:
	CUDPSocket(CServerConnect* in_serverconnect) {serverconnect = in_serverconnect;}
	~CUDPSocket() {}
	virtual void OnReceive(int nErrorCode);
private:
	bool	ProcessPacket(char* packet, int16 size, int8 opcode, char* host, uint16 port);
	CServerConnect*	serverconnect; 
};

class CServerConnect{
public:
	CServerConnect(CServerList* in_serverlist, CPreferences* in_prefs);
	~CServerConnect();
	void	ConnectionFailed(CServerSocket* sender);
	void	ConnectionEstablished(CServerSocket* sender);
	void	ConnectToAnyServer();
	void	ConnectToServer(CServer* toconnect);
	void	StopConnectionTry();
	bool	SendPacket(Packet* packet,bool delpacket = true, CServerSocket* to = 0);
	bool	SendUDPPacket(Packet* packet,char* host, bool delpacket = false);
	bool	Disconnect();
	bool	IsConnecting()	{return connecting;}
	bool	IsConnected()	{return connected;}
	uint32	GetClientID()		{return clientid;}
	CServer*	GetCurrentServer();
	uint32	clientid;
	bool	IsLowID()		{return (clientid < 16777216);}
	void	SetClientID(uint32 newid);

private:
	bool	connecting;
	bool	singleconnecting;
	bool	connected;
	int8	max_simcons;
	CPreferences*	app_prefs;
	CServerSocket*	connectedsocket;
	CServerList*	used_list;
	CUDPSocket*		udpsocket;
};