//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "emule.h"
#include "packets.h"
#include "sockets.h"
#include "emuleDlg.h"
#include "opcodes.h"
#include "searchlist.h"
#include <time.h>
#include <afxmt.h>
// TODO reorganize header file

void CUDPSocket::OnReceive(int nErrorCode){
	char buffer[5000];
	CString serverbuffer;
	uint32 port;
	int32 length = ReceiveFrom(buffer,5000,serverbuffer,port);
	if ((uint8)buffer[0] == OP_EDONKEYHEADER && length != SOCKET_ERROR)
		ProcessPacket(buffer+2,length-2,buffer[1],serverbuffer.GetBuffer(),port);
}

bool CUDPSocket::ProcessPacket(char* packet, int16 size, int8 opcode, char* host, uint16 port){
	try{
		switch(opcode){
			case OP_GLOBSEARCHRES:{
				theApp.emuledlg->searchwnd.AddUDPResult(theApp.searchlist->ProcessUDPSearchanswer(packet,size));
				break;
			}
			case OP_GLOBFOUNDSORUCES:{
				CMemFile* sources = new CMemFile((BYTE*)packet,size);
				uchar fileid[16];
				sources->Read(fileid,16);
				if (CPartFile* file = theApp.downloadqueue->GetFileByID(fileid))
					file->AddSources(sources,inet_addr(host),port);
				else
					theApp.serverlist->CancelUDPBroadcast();
				delete sources;
			}
			default:
				return false;
		}
		return true;
	}
	catch(char* error){
		theApp.emuledlg->AddLogLine(false,"Error while processing incoming UDP Packet");
		return false;
	}
}

// CServerConnect

void CServerConnect::ConnectToAnyServer(){
	StopConnectionTry();
	Disconnect();
	connecting = true;
	singleconnecting = false;
	max_simcons = 10;
	max_simcons = (used_list->GetServerCount() < max_simcons) ? used_list->GetServerCount():max_simcons;
	if (!max_simcons){
		connecting = false;
		return;
	}
	for (int i = 0;i != max_simcons; i++){
		CServerSocket* newsocket = new CServerSocket(this);
		newsocket->Create(0,SOCK_STREAM,FD_READ|FD_WRITE|FD_CLOSE|FD_CONNECT,NULL);
		CServer*  next_server = used_list->GetNextServer();
		if (next_server)
			newsocket->ConnectToServer(next_server);
		else {
			theApp.emuledlg->AddLogLine(true,"No valid servers to connect in serverlist found");
			StopConnectionTry();
			delete newsocket;
			return;
		}
	}
}

void CServerConnect::ConnectToServer(CServer* server){
	StopConnectionTry();
	Disconnect();
	connecting = true;
	singleconnecting = true;
	CServerSocket* newsocket = new CServerSocket(this);
	newsocket->Create(0,SOCK_STREAM,FD_READ|FD_WRITE|FD_CLOSE|FD_CONNECT,NULL);
	newsocket->ConnectToServer(server);
}

void CServerConnect::StopConnectionTry(){
	connecting = false;
	singleconnecting = false;
}

void CServerConnect::ConnectionEstablished(CServerSocket* sender){
	if (connecting == false){
		sender->Close();
		delete sender;
		return;
	}
	if (sender->GetConnectionState() == CS_WAITFORLOGIN){
		theApp.emuledlg->AddLogLine(false,"Connected to %s (%s:%i), sending loginrequest",sender->cur_server->GetListName(),sender->cur_server->GetFullIP(),sender->cur_server->GetPort());
		//send loginpacket
		
		CMemFile* data = new CMemFile();
		data->Write(theApp.glob_prefs->GetUserHash(),16);
		uint32 clientid = GetClientID();
		data->Write(&clientid,4);
		uint16 port = app_prefs->GetPort();
		data->Write(&port,2);
		uint32 tagcount = 3;
		data->Write(&tagcount,4);
		CTag* tag = new CTag(CT_NAME,app_prefs->GetUserNick());
		tag->WriteTagToFile(data);
		delete tag;
		tag = new CTag(CT_VERSION,EDONKEYVERSION);
		tag->WriteTagToFile(data);
		delete tag;
		tag = new CTag(CT_PORT,app_prefs->GetPort());
		tag->WriteTagToFile(data);
		delete tag;

		Packet* packet = new Packet(data);
		packet->opcode = OP_LOGINREQUEST;
		this->SendPacket(packet,true,sender);
		delete data;
	}
	else if (sender->GetConnectionState() == CS_CONNECTED){	
		connected = true;
		theApp.emuledlg->AddLogLine(true,"Connection established on %s",sender->cur_server->GetListName());
		theApp.emuledlg->ShowConnectionState(true);
		connectedsocket = sender;
		StopConnectionTry();
		theApp.sharedfiles->SendListToServer();
	}

}
bool CServerConnect::SendPacket(Packet* packet,bool delpacket, CServerSocket* to){
	if (!to){
		if (connected){
			connectedsocket->Send(packet->GetHeader(),6);
			connectedsocket->Send(packet->pBuffer,packet->size);
			if (delpacket)
				delete packet;
		}
		else
			return false;
	}
	else{
		to->Send(packet->GetHeader(),6);
		to->Send(packet->pBuffer,packet->size);
		if (delpacket)
			delete packet;
	}
	return true;
}

bool CServerConnect::SendUDPPacket(Packet* packet,char* host,bool delpacket){
		if (connected){
			char* buffer = new char[packet->size+2];
			memcpy(buffer,packet->GetUDPHeader(),2);
			memcpy(buffer+2,packet->pBuffer,packet->size);
			udpsocket->SendTo(buffer,packet->size+2,UDPSERVERPORT,host);
			delete[] buffer;
			if (delpacket)
				delete packet;
		}
		else
			return false;
	return true;
}

void CServerConnect::ConnectionFailed(CServerSocket* sender){
	if (connecting == false && sender != connectedsocket){
		sender->Close();
		delete sender;
	}
	//messages
	switch (sender->GetConnectionState()){
		case CS_FATALERROR:
			theApp.emuledlg->AddLogLine(true,"Fatal Error while trying to connect. Internet connection might be down");
			break;
		case CS_DISCONNECTED:
			theApp.emuledlg->AddLogLine(true,"Lost connection to %s (%s:%i)",sender->cur_server->GetListName(),sender->cur_server->GetFullIP(),sender->cur_server->GetPort());
			break;
		case CS_SERVERDEAD:
			theApp.emuledlg->AddLogLine(false,"%s (%s:%i) appears to be dead",sender->cur_server->GetListName(),sender->cur_server->GetFullIP(),sender->cur_server->GetPort());
			break;
		case CS_ERROR:
			break;
		case CS_SERVERFULL:
			theApp.emuledlg->AddLogLine(false,"%s (%s:%i) appears to be full",sender->cur_server->GetListName(),sender->cur_server->GetFullIP(),sender->cur_server->GetPort());
			break;
		case CS_NOTCONNECTED:;
	}

	switch (sender->GetConnectionState()){
		case CS_FATALERROR:{
			StopConnectionTry();
			break;
		}
		case CS_DISCONNECTED:{
			connected = false;
			theApp.emuledlg->ShowConnectionState(false);
			sender->Close();
			delete sender;
			connectedsocket = 0;
			theApp.emuledlg->searchwnd.OnBnClickedCancels();
			if (app_prefs->Reconnect() && !connecting){
				ConnectToAnyServer();		
			}
			break;
		}
		case CS_SERVERDEAD:
		case CS_ERROR:
		case CS_SERVERFULL:
		case CS_NOTCONNECTED:{
			if (!connecting)
				break;
			sender->Close();
			delete sender;
			if (singleconnecting){
				StopConnectionTry();
				break;
			}
			sender = new CServerSocket(this);

			sender->Create(0,SOCK_STREAM,FD_READ|FD_WRITE|FD_CLOSE|FD_CONNECT,NULL);			
			CServer* next_server = used_list->GetNextServer();
			if (next_server)
				sender->ConnectToServer(next_server);
			else {
				theApp.emuledlg->AddLogLine(true,"No valid servers to connect in serverlist found");
				StopConnectionTry();
				return;
			}
		}

	}
}

bool CServerConnect::Disconnect(){
	if (connected && connectedsocket){
		connectedsocket->Close();
		delete connectedsocket;
		connectedsocket = 0;
		connected = false;
		theApp.emuledlg->ShowConnectionState(false);
		theApp.emuledlg->serverwnd.servermsgbox.AppendText(CString("\n\n\n\n"));
		return true;
	}
	else
		return false;
}

CServerConnect::CServerConnect(CServerList* in_serverlist, CPreferences* in_prefs){
	connectedsocket = 0;
	used_list = in_serverlist;
	max_simcons = 10;
	connecting = false;
	connected = false;
	app_prefs = in_prefs;
	clientid = 0;
	singleconnecting = false;
	udpsocket = new CUDPSocket(this); // initalize socket for udp packets
	udpsocket->Create(0,SOCK_DGRAM);
}

CServerConnect::~CServerConnect(){
	StopConnectionTry();
	safe_delete(connectedsocket);
	udpsocket->Close();
	delete udpsocket;
}

CServer* CServerConnect::GetCurrentServer(){
	if (IsConnected() && connectedsocket)
		return connectedsocket->cur_server;
	return 0;
}

void CServerConnect::SetClientID(uint32 newid){
	clientid = newid;
	theApp.emuledlg->ShowConnectionState(IsConnected());
}