//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once

#include "types.h"
#include "packets.h"
#include "otherstructs.h"
#include <afxcoll.h>
#include <afxtempl.h>
#include <afxcmn.h>

class CServer{
public:
	CServer(ServerMet_Struct* in_data);
	CServer(uint16 in_port, uint32 in_ip);
	~CServer();
	void	AddTag(CTag* in_tag)			{taglist->AddTail(in_tag);}
	char*	GetListName()					{return listname;}
	char*	GetRealName()					{return name;}
	char*	GetFullIP()						{return ipfull;}
	uint16	GetPort()						{return port;}
	bool	ServerHasName()					{return name != 0;}
	void	FillWindowTags(CTreeCtrl* wnd,HTREEITEM rootitem);
	bool	AddTagFromFile(FILE* servermet);
	void	SetListName(char* newname);
	uint32	GetIP()			{return ip;}
	void	SetUserCount(uint32 in_users)	{users = in_users;}
	void	SetFileCount(uint32 in_files)	{files = in_files;}

private:
	uint32		files;
	uint32		users;
	uint32		preferences;
	uint32		ping;
	char*		description;
	char*		name;
	char*		listname;
	uint32		tagcount;
	char		ipfull[17];
	uint32		ip;
	uint16		port;
	CTypedPtrList<CPtrList, CTag*>*	taglist;
};