//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#include "stdafx.h"
#include "server.h"
#include "opcodes.h"
#include "emule.h"


CServer::CServer(ServerMet_Struct* in_data){
	taglist = new CTypedPtrList<CPtrList, CTag*>;
	port = in_data->port;
	tagcount = 0;
	ip = in_data->ip;
	in_addr host;
	host.S_un.S_addr = ip;
	strcpy(ipfull,inet_ntoa(host));
	files = 0;
	users = 0;
	preferences = 0;
	ping = 0;
	description = 0;
	name = 0;
	listname = 0;
}
CServer::CServer(uint16 in_port, uint32 in_ip){
	taglist = new CTypedPtrList<CPtrList, CTag*>;
	port = in_port;
	tagcount = 0;
	ip = in_ip;
	in_addr host;
	host.S_un.S_addr = ip;
	strcpy(ipfull,inet_ntoa(host));
	files = 0;
	users = 0;
	preferences = 0;
	ping = 0;
	description = 0;
	name = 0;
	listname = 0;
}


CServer::~CServer(){
	if (description)
		delete[] description;
	if (name)
		delete[] name;
	if (listname)
		delete[] listname;
	for(POSITION pos = taglist->GetHeadPosition(); pos != NULL; taglist->GetNext(pos))
		delete taglist->GetAt(pos);
	taglist->RemoveAll();
	delete taglist;
}

bool CServer::AddTagFromFile(FILE* servermet){
	if (servermet == 0)
		return false;
	CTag* tag = new CTag(servermet);
	switch(tag->tag->specialtag){		
					case ST_SERVERNAME:
						name = strdup(tag->tag->stringvalue);
						delete tag;
						break;
					case ST_DESCRIPTION:
						description = strdup(tag->tag->stringvalue);
						delete tag;
						break;
					case ST_PREFERENCE:
						preferences =tag->tag->intvalue;
						delete tag;
						break;
					case ST_PING:
						ping = tag->tag->intvalue;
						delete tag;
						break;
					default:
						if (tag->tag->specialtag){
							tag->tag->tagname = strdup("Unknown");
							AddTag(tag);
						}
						else if (!strcmp(tag->tag->tagname,"files")){
							files = tag->tag->intvalue;
							delete tag;
						}
						else if (!strcmp(tag->tag->tagname,"users")){
							users = tag->tag->intvalue;
							delete tag;
						}
						else
							AddTag(tag);
	}
	return !ferror(servermet);
}

void CServer::SetListName(char* newname){
	if (listname)
		delete[] listname;
	listname = newname;
}

void CServer::FillWindowTags(CTreeCtrl* wnd,HTREEITEM rootitem){
	POSITION pos;
	char buffer[255];
	if (description) {
		sprintf(buffer,"Description: %s",description);
		wnd->InsertItem(buffer,-1,-1,rootitem);
	}
	sprintf(buffer,"IP: %s",ipfull);
	wnd->InsertItem(buffer,-1,-1,rootitem);
	sprintf(buffer,"Port: %i",port);
	wnd->InsertItem(buffer,-1,-1,rootitem);
	if (ping) {
		sprintf(buffer,"Ping: %i",ping);
		wnd->InsertItem(buffer,-1,-1,rootitem);
	}
	if (users) {
		sprintf(buffer,"Users: %i",users);
		wnd->InsertItem(buffer,-1,-1,rootitem);
	}
	if (files) {
		sprintf(buffer,"Files: %i",files);
		wnd->InsertItem(buffer,-1,-1,rootitem);
	}
	CTag* cur_tag;
	for(int i = 0; i != taglist->GetCount();i++) {
		pos = taglist->FindIndex(i);
		cur_tag = taglist->GetAt(pos);
		if (cur_tag->tag->specialtag)
			continue;
		if (cur_tag->tag->type == 2)
			sprintf(buffer,"%s: %s",cur_tag->tag->tagname,cur_tag->tag->stringvalue);
		else if (cur_tag->tag->type == 3)
			sprintf(buffer,"%s: %i",cur_tag->tag->tagname,cur_tag->tag->intvalue);
		else
			continue;
		wnd->InsertItem(buffer,-1,-1,rootitem);
   }
}



	
	
