//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once
#ifndef _DUMP
	#define CURRENT_VERSION_LONG	"0.18a"
#else
	#define CURRENT_VERSION_LONG	"0.18a DEBUG"
#endif
#define CURRENT_VERSION_SHORT	0x18
#define	EMULE_PROTOCOL_VERSION	0x01
#define	EDONKEYVERSION			0x3c
#define PREFFILE_VERSION		0x04
#define PARTFILE_VERSION		0xe0
#define COMPILE_DATE			__DATE__
#define COMPILE_TIME			__TIME__

#define UDPSEARCHSPEED			1000	// if this value is too low you will miss sources
#define MAX_RESULTS				100 // max global search results
#define MAX_CLIENTCONNECTIONTRY	3
#define CONNECTION_TIMEOUT		100000	//set his lower if you want less connections at once, set it higher if you have enough sockets (edonkey has its own timout too, so a very high value won't effect this)
#define	FILEREASKTIME			1100000	//**
#define SERVERREASKTIME			800000  // don't set this too low, it wont speed up anything, but it could kill emule or your internetconnection
#define UDPSERVERREASKTIME		1300000 //***
#define	UDPSERVERPORT			4665

#define	UPLOAD_CLIENT_DATARATE	3000 // uploadspeed per client in bytes - you may want to adjust this if you have a slow connection or T1-T3 ;)
#define	MIN_UP_CLIENTS_ALLOWED	3	//min. clients allowed to download regardless UPLOAD_CLIENT_DATARATE or any other factors. Don't set this too high
#define	MAX_UP_CLIENTS_ALLOWED	20	//max. clients allowed regardless UPLOAD_CLIENT_DATARATE or any other factors. Don't set this too low, use DATARATE to adjust uploadspeed per client

#define DOWNLOADTIMEOUT			80000

// you shouldn't change anything here if you are not really sure, or emule will probaly not work
#define	PARTSIZE			9728000
#define BLOCKSIZE			184320
#define OP_EDONKEYHEADER	0xE3
#define OP_EDONKEYPROT		OP_EDONKEYHEADER
#define OP_EXTENDEDPROT		0xD4
#define OP_EMULEPROT		0xC5
#define OP_MLDONKEYPROT		0x00
#define	MET_HEADER			0x0E

#define UNLIMITED			0xFFFF

// client <-> server
#define OP_LOGINREQUEST		0x01
#define OP_SERVERMESSAGE	0x38
#define OP_IDCHANGE			0x40
#define	OP_OFFERFILES		0x15
#define OP_SEARCHREQUEST	0x16
#define OP_SEARCHRESULT		0x33
#define OP_GETSOURCES		0x19
#define OP_FOUNDSOURCES		0x42
#define OP_CALLBACKREQUEST	0x1C
#define	OP_SERVERSTATUS		0x34

//client <-> UDP server
#define OP_GLOBSEARCHREQ	0x98
#define OP_GLOBSEARCHRES	0x99
#define OP_GLOBGETSOURCES	0x9A
#define OP_GLOBFOUNDSORUCES	0x9B
#define OP_GLOBCALLBACKREQ	0x9C

// client <-> client
#define	OP_HELLO			0x01
#define	OP_HELLOANSWER		0x4c
#define OP_FILEREQUEST		0x58
#define OP_FILEREQANSWER	0x59
#define	OP_FILESTATUS		0x50
#define	OP_STARTUPLOADREQ	0x54
#define	OP_ACCEPTUPLOADREQ	0x55
#define	OP_CANCELTRANSFER	0x56
#define OP_OUTOFPARTREQS	0x57
#define	OP_REQUESTPARTS		0x47
#define OP_SENDINGPART		0x46
#define OP_SETREQFILEID		0x4f // ?
#define OP_HASHSETREQUEST	0x51
#define OP_HASHSETANSWER	0x52
#define	OP_MESSAGE			0x4E

// extened prot client <-> extened prot client
#define	OP_EMULEINFO		0x01
#define	OP_EMULEINFOANSWER	0x02
#define OP_COMPRESSEDPART	0x40
#define OP_QUEUERANKING		0x60

// server.met
#define ST_SERVERNAME		0x01
#define ST_DESCRIPTION		0x0B
#define ST_PING				0x0C
#define ST_PREFERENCE		0x0D

//file tags
#define FT_FILENAME			0x01
#define FT_FILESIZE			0x02
#define FT_FILETYPE			0x03
#define FT_FILEFORMAT		0x04

#define FT_SOURCES			0x15

#define FT_TRANSFERED		0x08
#define FT_GAPSTART			0x09
#define FT_GAPEND			0x0A
#define FT_PRIORITY			0x13
#define FT_STATUS			0x14
#define FT_PARTFILENAME		0x12

#define CT_NAME				0x01
#define CT_VERSION			0x11
#define	CT_PORT				0x0f

#define MP_MESSAGE			10102
#define MP_DETAIL			10103
#define MP_CANCEL			10201
#define MP_STOP				10202
#define MP_RESUME			10204
#define MP_PAUSE			10203
#define	MP_CLEARCOMPLETED	10205
#define MP_PRIOLOW			10300
#define MP_PRIONORMAL		10301
#define MP_PRIOHIGH			10302

// emule tagnames
#define ET_COMPRESSION		0x20


// emuleapp <-> emuleapp
#define OP_ED2KLINK			12000

//thread messages
#define	TM_FINISHEDHASHING	WM_USER+1450
