//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// emuleDlg.h : Headerdatei
//
#pragma once
#include "sockets.h"
#include "afxcmn.h"
#include "afxwin.h"
#include "serverlistctrl.h"
#include "knownfilelist.h"
#include "TransferWnd.h"
#include "ServerWnd.h"
#include "PreferencesWnd.h"
#include "SharedFilesWnd.h"
#include "SearchDlg.h"
#include "ChatWnd.h"
#include "traydialog.h"

class CKnownFileList; 
// CemuleDlg Dialogfeld
class CemuleDlg : public CTrayDialog
{
// Konstruktion
public:
	CemuleDlg(CWnd* pParent = NULL);	// Standardkonstruktor
	~CemuleDlg();
	enum { IDD = IDD_EMULE_DIALOG };

	void			AddLogLine(bool addtostatusbar,char* line,...);
	void			AddServerMessageLine(char* line,...);
	void			ShowConnectionState(bool connected);
	void			ShowTransferRate();
	void			ShowUserCount(uint32 toshow);
	void			ShowMessageState(uint8 iconnr);
	CListCtrl		PageBox;
	CTransferWnd	transferwnd;
	CServerWnd		serverwnd;
	CPreferencesWnd	preferenceswnd;
	CSharedFilesWnd	sharedfileswnd;
	CSearchDlg		searchwnd;
	CChatWnd		chatwnd;
	CStatusBarCtrl  statusbar;
	CDialog*		activewnd;
	void			SetActiveDialog(CDialog* dlg);

protected:
	HICON m_hIcon;
	virtual void DoDataExchange(CDataExchange* pDX);
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	afx_msg void OnBnClickedButton2();
	afx_msg void OnNMClickList3(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg LRESULT OnWMData(WPARAM wParam,LPARAM lParam);
	afx_msg LRESULT OnFileHashed(WPARAM wParam,LPARAM lParam);
	virtual void OnSize(UINT nType,int cx,int cy);
	void		 OnOK()			{}
	void		 OnCancel();
	DECLARE_MESSAGE_MAP()
private:
	CString			logtext;
	bool			ready;	
	HICON			connicons[3];
	HICON			transicons[4];
	HICON			imicons[3];
	uint32			lastuprate;
	uint32			lastdownrate;
	CImageList		imagelist;
};

