//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// emuleDlg.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "emule.h"
#include "emuleDlg.h"
#include "sockets.h"
#include "knownfilelist.h"
#include "knownfile.h"
#include "serverlist.h"
#include "opcodes.h"
#include "sharedfilelist.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung

protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CemuleDlg Dialog



CemuleDlg::CemuleDlg(CWnd* pParent /*=NULL*/)
	: CTrayDialog(CemuleDlg::IDD, pParent){
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	ready = false;
	lastuprate = 0;
	lastdownrate = 0;
	connicons[0] = (HICON)::LoadImage(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_NOTCONNECTED),IMAGE_ICON,16,16,0);
	connicons[1] = (HICON)::LoadImage(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_CONNECTED),IMAGE_ICON,16,16,0);
	connicons[2] = (HICON)::LoadImage(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_CONNECTEDHIGH),IMAGE_ICON,16,16,0);
	transicons[0] = (HICON)::LoadImage(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_UPDOWN),IMAGE_ICON,16,16,0);
	transicons[1] = (HICON)::LoadImage(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_UP0DOWN1),IMAGE_ICON,16,16,0);
	transicons[2] = (HICON)::LoadImage(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_UP1DOWN0),IMAGE_ICON,16,16,0);
	transicons[3] = (HICON)::LoadImage(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_UP1DOWN1),IMAGE_ICON,16,16,0);
	imicons[1] = 0;
	imicons[1] = (HICON)::LoadImage(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_MESSAGE),IMAGE_ICON,16,16,0);
	imicons[2] = (HICON)::LoadImage(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_MPENDING),IMAGE_ICON,16,16,0);
}
CemuleDlg::~CemuleDlg(){
}
void CemuleDlg::DoDataExchange(CDataExchange* pDX){
	CTrayDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST3, PageBox);
}

BEGIN_MESSAGE_MAP(CemuleDlg, CTrayDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON2, OnBnClickedButton2)
	ON_NOTIFY(NM_CLICK, IDC_LIST3, OnNMClickList3)
	ON_WM_SIZE()
	ON_MESSAGE(WM_COPYDATA, OnWMData)
	ON_MESSAGE(TM_FINISHEDHASHING,OnFileHashed)
END_MESSAGE_MAP()

// CemuleDlg eventhandler

BOOL CemuleDlg::OnInitDialog()
{
	CTrayDialog::OnInitDialog();

	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);
	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL){
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty()){
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}
	SetIcon(m_hIcon, TRUE);			
	SetIcon(m_hIcon, FALSE);
	//set title
	char buffer[50];
	sprintf(buffer,"eMule V%s",CURRENT_VERSION_LONG);
	SetWindowText(buffer);

	// set statusbar
	statusbar.Create(WS_CHILD|WS_VISIBLE|CCS_BOTTOM,CRect(0,0,0,0), this, IDC_STATUSBAR) ;
	CRect rect;
	statusbar.GetClientRect(&rect);
	int widths[5] = { rect.right-375, rect.right-275, rect.right-135,rect.right-25, -1 };
	statusbar.SetParts(5, widths);
	statusbar.SetIcon(2,transicons[0]);
	statusbar.SetText("Up: 0.0  Down: 0.0",2,0);
	statusbar.SetText("Users: 0",1,0);
	ShowConnectionState(false);
	
	// create dialog pages
	serverwnd.Create(IDD_SERVER);
	transferwnd.Create(IDD_TRANSFER);
	sharedfileswnd.Create(IDD_FILES);
	searchwnd.Create(IDD_SEARCH);
	chatwnd.Create(IDD_CHAT);
	preferenceswnd.Create(IDD_PREFERENCES,theApp.glob_prefs);
	activewnd = &transferwnd;
	
	// anchors
	AddAnchor(IDC_LIST3, TOP_RIGHT);
	AddAnchor(serverwnd,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(transferwnd,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(sharedfileswnd,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(searchwnd,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(chatwnd,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(preferenceswnd,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(statusbar,BOTTOM_LEFT,BOTTOM_RIGHT);

	this->SetMinTrackSize(CSize(730,500));
	// tray icon
	TraySetIcon(IDR_MAINFRAME);
	TraySetToolTip("Up: 0.0 Down: 0.0");
	TraySetMinimizeToTray(theApp.glob_prefs->GetMinTrayPTR());

	imagelist.Create(24,24,ILC_COLOR16,0,10);
	imagelist.SetBkColor(RGB(255,255,255));
	imagelist.Add(theApp.LoadIcon(IDI_TRANSFER));
	imagelist.Add(theApp.LoadIcon(IDI_SERVER));
	imagelist.Add(theApp.LoadIcon(IDI_SEARCH));
	imagelist.Add(theApp.LoadIcon(IDI_SHARED));
	imagelist.Add(theApp.LoadIcon(IDI_PREFERENCES));
	imagelist.Add(theApp.LoadIcon(IDI_MESSAGE));
	PageBox.SetImageList(&imagelist,LVSIL_NORMAL);
	PageBox.InsertItem(0,"Download",0);
	PageBox.InsertItem(1,"Server",1);
	PageBox.InsertItem(2,"Search",2);
	PageBox.InsertItem(3,"Files",3);
	PageBox.InsertItem(4,"Preferences",4);
	PageBox.InsertItem(5,"Messages",5);
	
	serverwnd.ShowWindow(SW_SHOW);
	activewnd = &serverwnd;

	theApp.serverlist->Init();
	ready = true;

	// start listining on edonkeyport
	if (!theApp.listensocket->StartListening())
		AddLogLine(false,"Fatal Error: Unable to create socket on port %i",theApp.glob_prefs->GetPort());
	// ini. downloadqueue
	theApp.downloadqueue->Init();

	AddLogLine(true,"eMule Version %s ready",CURRENT_VERSION_LONG);

	if (theApp.pendinglink){
		theApp.downloadqueue->AddSearchToDownload(*theApp.pendinglink);
		delete theApp.pendinglink;
	}

	if (theApp.glob_prefs->DoAutoConnect())
		OnBnClickedButton2();
	return TRUE;
}

void CemuleDlg::OnSysCommand(UINT nID, LPARAM lParam){
	if ((nID & 0xFFF0) == IDM_ABOUTBOX){
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else{
		CTrayDialog::OnSysCommand(nID, lParam);
	}
}

void CemuleDlg::OnPaint() {
	if (IsIconic()){
		CPaintDC dc(this);

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		dc.DrawIcon(x, y, m_hIcon);
	}
	else{
		CTrayDialog::OnPaint();
	}
}


HCURSOR CemuleDlg::OnQueryDragIcon(){
	return static_cast<HCURSOR>(m_hIcon);
}

void CemuleDlg::OnBnClickedButton2(){
	//connect
	theApp.serverconnect->ConnectToAnyServer();
}

void CemuleDlg::AddLogLine(bool addtostatusbar,char* line,...){
	va_list argptr;
	char bufferline[500];
	va_start(argptr, line);
	_vsnprintf(bufferline, 500, line, argptr);
	va_end(argptr);
	logtext += bufferline;
	logtext += "\r\n";
	if (ready){
		serverwnd.logbox.SetWindowText(logtext);
		serverwnd.logbox.LineScroll(serverwnd.logbox.GetLineCount());
	if (addtostatusbar)
		statusbar.SetText(bufferline,0,0);
	}

}
void CemuleDlg::AddServerMessageLine(char* line,...){
	CString content;
	va_list argptr;
	char bufferline[500];
	va_start(argptr, line);
	_vsnprintf(bufferline, 500, line, argptr);
	va_end(argptr);
	serverwnd.servermsgbox.AppendText(CString(bufferline)+CString("\n"));
}

void CemuleDlg::OnNMClickList3(NMHDR *pNMHDR, LRESULT *pResult){
	CDialog* newwnd;
	switch(PageBox.GetSelectionMark()){
		case 0:
			newwnd = &transferwnd;
			break;
		case 1:
			newwnd = &serverwnd;
			break;
		case 2:
			newwnd = &searchwnd;
			break;
		case 3:
			newwnd = &sharedfileswnd;
			break;
		case 4:
			newwnd = &preferenceswnd;
			break;
		case 5:
			newwnd = &chatwnd;
			break;
		default:
			newwnd = 0;
	}
	if (newwnd && newwnd != activewnd){
		activewnd->ShowWindow(SW_HIDE);
		newwnd->ShowWindow(SW_SHOW);
		activewnd = newwnd;
	}
	*pResult = 0;
}

void CemuleDlg::ShowConnectionState(bool connected){
	if (connected){
		if (theApp.serverconnect->IsLowID())
			statusbar.SetIcon(3,connicons[1]);
		else
			statusbar.SetIcon(3,connicons[2]);
		statusbar.SetText("Connected",3,0);
	}
	else{
		statusbar.SetIcon(3,connicons[0]);
		statusbar.SetText("Not Connected",3,0);
		ShowUserCount(0);
	}
	
}

void CemuleDlg::ShowUserCount(uint32 toshow){
	char buffer[30];
	sprintf(buffer,"User: %i",toshow);
	statusbar.SetText(buffer,1,0);
}

void CemuleDlg::ShowMessageState(uint8 iconnr){
	statusbar.SetIcon(4,imicons[iconnr]);
}

void CemuleDlg::ShowTransferRate(){
	lastuprate = theApp.uploadqueue->GetDatarate();
	lastdownrate= theApp.downloadqueue->GetDatarate();
	char buffer[100];
	sprintf(buffer,"Up: %.1f  Down: %.1f",(float)lastuprate/1024,(float)lastdownrate/1024);
	TraySetToolTip(buffer);
	statusbar.SetText(buffer,2,0);
	if (lastuprate && lastdownrate)
		statusbar.SetIcon(2,transicons[3]);
	else if (lastuprate)
		statusbar.SetIcon(2,transicons[2]);
	else if (lastdownrate)
		statusbar.SetIcon(2,transicons[1]);
	else
		statusbar.SetIcon(2,transicons[0]);
}

void CemuleDlg::OnCancel(){
	theApp.knownfiles->Save();
	transferwnd.downloadlistctrl.DeleteAllItems();
	chatwnd.chatselector.DeleteAllItems();
	theApp.clientlist->DeleteAll();
	// saving stuff etc
	delete theApp.listensocket;
	delete theApp.sharedfiles;
	delete theApp.serverconnect;
	delete theApp.serverlist;
	delete theApp.knownfiles;
	delete theApp.searchlist;
	delete theApp.glob_prefs;
	delete theApp.downloadqueue;
	delete theApp.uploadqueue;
	delete theApp.clientlist;
	CTrayDialog::OnCancel();
};

void CemuleDlg::SetActiveDialog(CDialog* dlg){
	uint8 sel;
	if (dlg == &transferwnd)
		sel = 0;
	else if (dlg == &serverwnd)
		sel = 1;
	else if (dlg == &searchwnd)
		sel = 2;
	else if (dlg == &sharedfileswnd)
		sel = 3;
	else if (dlg == &preferenceswnd)
		sel = 4;
	else if (dlg == &chatwnd)
		sel = 5;
	PageBox.SetSelectionMark(sel);
	PageBox.SetItemState(sel,LVIS_SELECTED,LVIS_SELECTED);
	activewnd->ShowWindow(SW_HIDE);
	dlg->ShowWindow(SW_SHOW);
	activewnd = dlg;
}

void CemuleDlg::OnSize(UINT nType,int cx,int cy){
	CTrayDialog::OnSize(nType,cx,cy);
	CRect rect;
	statusbar.GetClientRect(&rect);
	int widths[5] = { rect.right-375, rect.right-275, rect.right-135,rect.right-25, -1 };
	statusbar.SetParts(5, widths);
}

LRESULT CemuleDlg::OnWMData(WPARAM wParam,LPARAM lParam){
	tagCOPYDATASTRUCT* data = (tagCOPYDATASTRUCT*)lParam;
	if (data->dwData == OP_ED2KLINK){
		FlashWindow(true);
		if (IsIconic())
			ShowWindow(SW_SHOWNORMAL);
		else if (TrayHide()){
			ShowWindow(SW_SHOW);
		}
		else
			SetForegroundWindow();
		CString link;
		link = (char*)data->lpData;
		theApp.downloadqueue->AddSearchToDownload(link);
	}
	return true;
}

LRESULT CemuleDlg::OnFileHashed(WPARAM wParam,LPARAM lParam){
	CKnownFile* result = (CKnownFile*)lParam;
	if (wParam){
		CPartFile* requester = (CPartFile*)wParam;
		requester->PartFileHashFinished(result);
	}
	else{
		theApp.sharedfiles->filelist->SafeAddKFile(result);
		theApp.sharedfiles->SafeAddKFile(result);	
	}
	return true;
}
