//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"
#include "emuleDlg.h"
#include "knownfilelist.h"
#include "preferences.h"
#include "sockets.h"
#include "serverlist.h"
#include "sharedfilelist.h"
#include "searchlist.h"
#include "listensocket.h"
#include "uploadqueue.h"
#include "downloadqueue.h"
#include "clientlist.h"
#include <afxmt.h>

class CSearchList;
class CUploadQueue;
class CListenSocket;
class CDownloadQueue;

class CemuleApp : public CWinApp
{
public:
	CemuleApp();
	CemuleDlg*			emuledlg;
	CClientList*		clientlist;
	CKnownFileList*		knownfiles;
	CPreferences*		glob_prefs;
	CServerConnect*		serverconnect;
	CServerList*		serverlist;	
	CSharedFileList*	sharedfiles;
	CSearchList*		searchlist;
	CListenSocket*		listensocket;
	CUploadQueue*		uploadqueue;
	CDownloadQueue*		downloadqueue;
	CMutex			hashing_mut;
	virtual BOOL InitInstance();
	CString*			pendinglink;
// Implementierung

	DECLARE_MESSAGE_MAP()
protected:
	bool ProcessCommandline();
};
extern CemuleApp theApp;