//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "stdafx.h"
#include "emule.h"
#include "emuleDlg.h"
#include "opcodes.h"
#include "mdump.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CemuleApp

BEGIN_MESSAGE_MAP(CemuleApp, CWinApp)
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()


CemuleApp::CemuleApp(){

}



CemuleApp theApp;


// CemuleApp Initialisierung

BOOL CemuleApp::InitInstance()
{
#ifdef _DUMP
	MiniDumper dumper(CURRENT_VERSION_LONG);
#endif

	pendinglink = 0;
	if (ProcessCommandline())
		return false;
	// InitCommonControls() ist fr Windows XP erforderlich, wenn ein Anwendungsmanifest
	// die Verwendung von ComCtl32.dll Version 6 oder hher zum Aktivieren
	// von visuellen Stilen angibt. Ansonsten treten beim Erstellen von Fenstern Fehler auf.
	InitCommonControls();

	CWinApp::InitInstance();

	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();
	AfxSocketInit();
	CemuleDlg dlg;
	emuledlg = &dlg;
	m_pMainWnd = &dlg;

	// create & initalize all the important stuff 
	glob_prefs = new CPreferences();
	clientlist = new CClientList();
	searchlist = new CSearchList();
	knownfiles = new CKnownFileList(glob_prefs->GetAppDir());
	serverlist = new CServerList(glob_prefs);
	serverconnect = new CServerConnect(serverlist,theApp.glob_prefs);	
	sharedfiles = new CSharedFileList(glob_prefs,serverconnect,knownfiles);
	listensocket = new CListenSocket(glob_prefs);
	uploadqueue = new CUploadQueue(glob_prefs);
	downloadqueue = new CDownloadQueue(glob_prefs,sharedfiles);
	INT_PTR nResponse = dlg.DoModal();

	return FALSE;
}

bool CemuleApp::ProcessCommandline(){
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);
	
	char buffer[50];
	sprintf(buffer,"eMule V%s",CURRENT_VERSION_LONG);	
	HWND maininst = FindWindow(0,buffer);
	if (cmdInfo.m_nShellCommand == CCommandLineInfo::FileOpen) {
		CString command = cmdInfo.m_strFileName;
	
		if (maininst){
			tagCOPYDATASTRUCT sendstruct;
			sendstruct.cbData = command.GetLength()+1;
			sendstruct.dwData  = OP_ED2KLINK;
			sendstruct.lpData = command.GetBuffer();
			SendMessage(maininst,WM_COPYDATA,(WPARAM)0,(LPARAM) (PCOPYDATASTRUCT) &sendstruct);
			return true;
		}
		else
			pendinglink = new CString(command);
	}
	return maininst;
}
