//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "StdAfx.h"
#include "uploadqueue.h"
#include "packets.h"
#include "emule.h"
#include "knownfile.h"
#include "listensocket.h"



CUploadQueue::CUploadQueue(CPreferences* in_prefs){
	app_prefs = in_prefs;
	h_timer = SetTimer(0,141,100,*TimerProc);
	if (!h_timer)
		theApp.emuledlg->AddLogLine(false,"Fatal Error: Failed to create Timer");
	estadatarate = 2000;
	datarate = 0;
	dataratems = 0;
	datarateave = 0;
	for (int i = 0;i != 400;i++)
		avarage_dr_list.AddHead((uint32)0);

}

void CUploadQueue::AddUpNextClient(CUpDownClient* directadd){
	POSITION toadd = 0;
	uint32	bestscore = 0;
	CUpDownClient* newclient;
	// select next client or use given client
	if (!directadd){
		for (POSITION pos = waitinglist.GetHeadPosition();pos != 0;waitinglist.GetNext(pos)){
			if (waitinglist.GetAt(pos)->GetScore() > bestscore){
				bestscore = waitinglist.GetAt(pos)->GetScore();
				toadd = pos;
			}
		}
		if (!toadd)
			return;
		newclient = waitinglist.GetAt(toadd);
		waitinglist.RemoveAt(toadd);
		theApp.emuledlg->transferwnd.ShowQueueCount(waitinglist.GetCount());
		
	}
	else
		newclient = directadd;

	if (IsDownloading(newclient)){
		return;
	}
	// tell the client that we are now ready to upload
	if (!newclient->socket->IsConnected()){
		newclient->SetUploadState(US_CONNECTING);
		newclient->TryToConnect();
	}
	else{
		Packet* packet = new Packet(OP_ACCEPTUPLOADREQ,0);
		newclient->socket->SendPacket(packet,true);
		newclient->SetUploadState(US_UPLOADING);
	}
	newclient->SetUpStartTime();
	uploadinglist.AddTail(newclient);
	theApp.emuledlg->transferwnd.uploadlistctrl.AddClient(newclient);
}

void CUploadQueue::Process(){
	avarage_dr_list.RemoveHead();
	avarage_dr_list.AddTail(dataratems);
	datarate = 0;
	for (POSITION pos = avarage_dr_list.GetHeadPosition();pos != 0;avarage_dr_list.GetNext(pos))
		datarate += avarage_dr_list.GetAt(pos);
	datarate /= (avarage_dr_list.GetCount()/10);

	dataratems = 0;
	if (AcceptNewClient() && waitinglist.GetCount())
		AddUpNextClient();
	if (!uploadinglist.GetCount())
		return;

	int16 clientsrdy = 0;
	for (POSITION pos = uploadinglist.GetHeadPosition();pos != 0;uploadinglist.GetNext(pos)){
		if ((!uploadinglist.GetAt(pos)->socket->IsBusy()) && uploadinglist.GetAt(pos)->HasBlocks())
			clientsrdy++;
	}
	if (!clientsrdy){
		estadatarate -= 200;
		if (estadatarate < 100)
			estadatarate = 100;
		clientsrdy++;
	}
	else{
		estadatarate += 210;
		if (estadatarate > app_prefs->GetMaxUpload()*102)
			estadatarate = app_prefs->GetMaxUpload()*102;
	}
	uint32 sendperclient = estadatarate/clientsrdy;
	POSITION pos1,pos2;
	for (pos1 = uploadinglist.GetHeadPosition();( pos2 = pos1 ) != NULL; ){
		uploadinglist.GetNext(pos1);
		CUpDownClient* cur_client = uploadinglist.GetAt(pos2);
		dataratems += cur_client->SendBlockData(sendperclient);
	}
};

bool CUploadQueue::AcceptNewClient(){
	// check if we can allow a new client to start downloading form us
	if (uploadinglist.GetCount() < MIN_UP_CLIENTS_ALLOWED)
		return true;
	else if (uploadinglist.GetCount() >= MAX_UP_CLIENTS_ALLOWED)
		return false;

	//now the final check
	if (uploadinglist.GetCount() < (datarate/UPLOAD_CLIENT_DATARATE))
		return true;
	//nope
	return false;
}

CUploadQueue::~CUploadQueue(){
	KillTimer(0,141);
}

POSITION CUploadQueue::GetWaitingClient(CUpDownClient* client){
	for (POSITION pos = waitinglist.GetHeadPosition();pos != 0;waitinglist.GetNext(pos)){
		if (client == waitinglist.GetAt(pos))
			return pos;
	}
	return 0;
}

POSITION CUploadQueue::GetWaitingClientByID(CUpDownClient* client){
	for (POSITION pos = waitinglist.GetHeadPosition();pos != 0;waitinglist.GetNext(pos)){
		if (client->Compare(waitinglist.GetAt(pos)))
			return pos;
	}
	return 0;
}

POSITION CUploadQueue::GetDownloadingClient(CUpDownClient* client){
	for (POSITION pos = uploadinglist.GetHeadPosition();pos != 0;uploadinglist.GetNext(pos)){
		if (client == uploadinglist.GetAt(pos))
			return pos;
	}
	return 0;
}

void CUploadQueue::AddClientToQueue(CUpDownClient* client){
	if (IsOnUploadQueue(client)){
		client->SendRankingInfo();
		return;					//already on queue
	}

	// TODO find better ways to cap the list
	if (waitinglist.GetCount() > 2000)
		return;
	if(POSITION pos = GetWaitingClientByID(client)){
		//should never happen
		//Beep(800,500);
	}
	if (client->IsDownloading()){
		// he's already downloading and wants probably only another file
		Packet* packet = new Packet(OP_ACCEPTUPLOADREQ,0);
		client->socket->SendPacket(packet,true);
		return;
	}
	if (waitinglist.IsEmpty() && AcceptNewClient())
		AddUpNextClient(client);
	else{
		waitinglist.AddTail(client);
		client->SetUploadState(US_ONUPLOADQUEUE);
		client->SendRankingInfo();

		theApp.emuledlg->transferwnd.ShowQueueCount(waitinglist.GetCount());
	}
}
bool CUploadQueue::RemoveFromUploadQueue(CUpDownClient* client, bool updatewindow){
	for (POSITION pos = uploadinglist.GetHeadPosition();pos != 0;uploadinglist.GetNext(pos)){
		if (client == uploadinglist.GetAt(pos)){
			if (updatewindow)
				theApp.emuledlg->transferwnd.uploadlistctrl.RemoveClient(uploadinglist.GetAt(pos));
			uploadinglist.RemoveAt(pos);
			client->SetUploadState(US_NONE);
			client->ClearUploadBlockRequests();
			return true;
		}
	}
	return false;
}

bool CUploadQueue::RemoveFromWaitingQueue(CUpDownClient* client, bool updatewindow){
	for (POSITION pos = waitinglist.GetHeadPosition();pos != 0;waitinglist.GetNext(pos)){
		if (client == waitinglist.GetAt(pos)){
			waitinglist.RemoveAt(pos);
			client->SetUploadState(US_NONE);
			if (updatewindow)
				theApp.emuledlg->transferwnd.ShowQueueCount(waitinglist.GetCount());
			return true;
		}
	}
	return false;
}


bool CUploadQueue::CheckForTimeOver(CUpDownClient* client){
	for (POSITION pos = waitinglist.GetHeadPosition();pos != 0;waitinglist.GetNext(pos)){
		if (client->GetScore(true) < waitinglist.GetAt(pos)->GetScore(false))
			return true;
	}
	return false;
}

void CUploadQueue::DeleteAll(){
	waitinglist.RemoveAll();
	uploadinglist.RemoveAll();
}

uint16 CUploadQueue::GetWaitingPosition(CUpDownClient* client){
	if (!IsOnUploadQueue(client))
		return 0;
	uint16 rank = 1;
	uint32 myscore = client->GetScore();
	for (POSITION pos = waitinglist.GetHeadPosition();pos != 0;waitinglist.GetNext(pos)){
		if (waitinglist.GetAt(pos)->GetScore() > myscore)
			rank++;
	}
	return rank;
}

VOID CALLBACK TimerProc(HWND hwnd, UINT uMsg,UINT_PTR idEvent,DWORD dwTime){
	theApp.uploadqueue->Process();
	theApp.downloadqueue->Process();
	i++;
	if (i == 50){
		i = 0;
		theApp.emuledlg->ShowTransferRate();
		theApp.listensocket->Process();
	}
}
