//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// UploadListCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "UploadListCtrl.h"
#include "otherfunctions.h"
#include "opcodes.h"
#include "ClientDetailDialog.h"

// CUploadListCtrl

IMPLEMENT_DYNAMIC(CUploadListCtrl, CListCtrl)
CUploadListCtrl::CUploadListCtrl(){
}

void CUploadListCtrl::Init(){
	SetExtendedStyle(LVS_EX_FULLROWSELECT);
	InsertColumn(0,"Username",LVCFMT_LEFT,150,0);
	InsertColumn(1,"File",LVCFMT_LEFT,275,1);
	InsertColumn(2,"Speed",LVCFMT_LEFT,60,2);
	InsertColumn(3,"Transfered",LVCFMT_LEFT,65,3);
	InsertColumn(4,"Waited",LVCFMT_LEFT,60,4);
	InsertColumn(5,"Status",LVCFMT_LEFT,110,5);
	imagelist.Create(16,16,ILC_COLOR,0,10);
	imagelist.SetBkColor(RGB(255,255,255));
	imagelist.Add(theApp.LoadIcon(IDI_USER0));
	imagelist.Add(theApp.LoadIcon(IDI_COMPPROT));
	SetImageList(&imagelist,LVSIL_SMALL);

	m_ClientMenu.CreatePopupMenu();
	m_ClientMenu.AddMenuTitle("Clients");
	m_ClientMenu.AppendMenu(MF_STRING,MP_DETAIL, (LPCTSTR)"Show Details");
	m_ClientMenu.AppendMenu(MF_STRING,MP_MESSAGE, (LPCTSTR)"Send Message");
	SetMenu(&m_ClientMenu);
}

CUploadListCtrl::~CUploadListCtrl(){
}

void CUploadListCtrl::AddClient(CUpDownClient* client){
	uint32 itemnr = GetItemCount();
	char buffer[100];
	itemnr = InsertItem(LVIF_TEXT|LVIF_PARAM,itemnr,client->GetUserName(),0,0,1,(LPARAM)client);
	sprintf(buffer,"%i min",(client->GetWaitTime())/60000);
	SetItemText(itemnr,4,buffer);
	RefreshClient(client);
}

void CUploadListCtrl::RemoveClient(CUpDownClient* client){
	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)client;
	sint32 result = FindItem(&find);
	if (result != (-1) )
		DeleteItem(result);
}

void CUploadListCtrl::RefreshClient(CUpDownClient* client){
	LVFINDINFO find;
	find.flags = LVFI_PARAM;
	find.lParam = (LPARAM)client;
	sint32 itemnr = FindItem(&find);
	if (itemnr == (-1))
		return;
	SetItem(itemnr,0,LVIF_IMAGE,0,(client->ExtProtocolAvailable() ? 1 :0 ),0,0,0,0);
	char buffer[100];
	CKnownFile* file = theApp.sharedfiles->GetFileByID(client->reqfileid);
	if (file)
		SetItemText(itemnr,1,file->GetFileName());
	else
		SetItemText(itemnr,1,"?");
	sprintf(buffer,"%.1f KB/s",(float)client->GetDatarate()/1024);
	SetItemText(itemnr,2,buffer);
	CastItoXBytes(client->GetTransferedUp(),buffer);
	SetItemText(itemnr,3,buffer);
	char* status;
	switch (client->GetUploadState()){
		case US_CONNECTING:
			status = "Connecting";
			break;
		case US_WAITCALLBACK:
			status = "Connecting via server";
			break;
		case US_UPLOADING:
			status = "Transfering";
			break;
		default:
			status = "Unknown";
	}
	SetItemText(itemnr,5,status);
}

BEGIN_MESSAGE_MAP(CUploadListCtrl, CListCtrl)
	ON_NOTIFY_REFLECT (NM_RCLICK, OnNMRclick)
END_MESSAGE_MAP()



// CUploadListCtrl message handlers
void CUploadListCtrl::OnNMRclick(NMHDR *pNMHDR, LRESULT *pResult){	
	POINT point;
	::GetCursorPos(&point);	
	m_ClientMenu.TrackPopupMenu(TPM_LEFTALIGN |TPM_RIGHTBUTTON, point.x, point.y, this);
	*pResult = 0;
}

BOOL CUploadListCtrl::OnCommand(WPARAM wParam,LPARAM lParam ){
	if (GetSelectionMark() != (-1)){
		CUpDownClient* client = (CUpDownClient*)GetItemData(GetSelectionMark());
		switch (wParam){
			case MP_MESSAGE:{
				theApp.emuledlg->chatwnd.StartSession(client);
			}
			case MP_DETAIL:
				CClientDetailDialog dialog(client);
				dialog.DoModal();
				break;

		}
	}
	return true;
}