//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "StdAfx.h"
#include "zlib/zlib.h"
#include "UpDownClient.h"
#include "opcodes.h"
#include "packets.h"
#include "emule.h"
#include "uploadqueue.h"
#include "otherstructs.h"


//	members of CUpDownClient
//	which are mainly used for uploading functions 

uint32 CUpDownClient::GetScore(bool isdownloading, bool onlybasevalue){
	//TODO: complete this (friends, uploadspeed, emuleuser etc etc)
	if (!username)
		return 0;
	isbotuser = strstr(username,"finder") && strstr(username,"com");
	isfriend = false;
	isemuleclient = false;
	filepriority = 10; // standart	
	// calculate score, based on waitingtime and other factors
	float basevalue;
	if (onlybasevalue)
		basevalue = 100;
	else if (!isdownloading)
		basevalue = (float)(::GetTickCount()-starttime)/1000;
	else{
		// we dont want one client to download forever
		// the first 15 min downloadtime counts as 15 min waitingtime and you get a 15 min bonus while you are in the first 15 min :)
		// (to avoid 20 sec downloads) after this the score won't raise anymore 
		basevalue = (float)(upstarttime-starttime);
		basevalue += (float)(::GetTickCount() - upstarttime > 900000)? 900000:1800000;
		basevalue /= 1000;
	}	
	if (isbotuser)
		basevalue *= 0.9f;
	if (HasLowID())
		basevalue *= 0.8f;
	if (GetDownloadState() == DS_DOWNLOADING)
		basevalue *= 3.0f;
	if (isfriend)
		basevalue *= 2.0f;

	if (!onlybasevalue)
		basevalue *= ((float)filepriority/10);
	return (uint32)basevalue;
}

bool CUpDownClient::CreateNextBlockPackage(){
	// time critical
	// check if we should kick this client
	if (theApp.uploadqueue->CheckForTimeOver(this)){
		// back on the waitqueue
		SetWaitStartTime();
		theApp.uploadqueue->RemoveFromUploadQueue(this);
		theApp.uploadqueue->AddClientToQueue(this);
		return false;
	}
	if (blockreqlist.IsEmpty())
		return false;
	CFile file;
	byte* filedata = 0;
	char* fullname = 0;
	try{
		while (!blockreqlist.IsEmpty()){
			Requested_Block_Struct* currentblock = blockreqlist.GetHead();
			CKnownFile* srcfile = theApp.sharedfiles->GetFileByID(currentblock->FileID);
			if (!srcfile)
				throw "requested file not found";

			if (srcfile->IsPartFile() && ((CPartFile*)srcfile)->GetStatus() != PS_COMPLETE){
				fullname = strdup(((CPartFile*)srcfile)->GetFullName());
				fullname[strlen(fullname)-4] = 0;			
			}
			else{
				fullname = new char[strlen(srcfile->GetPath())+strlen(srcfile->GetFileName())+10];
				sprintf(fullname,"%s\\%s",srcfile->GetPath(),srcfile->GetFileName());
			}
		
			uint32 togo;
			if (currentblock->StartOffset > currentblock->EndOffset){
				togo = currentblock->EndOffset + (srcfile->GetFileSize() - currentblock->StartOffset);
			}
			else{
				togo = currentblock->EndOffset - currentblock->StartOffset;
				if (srcfile->IsPartFile() && !((CPartFile*)srcfile)->IsComplete(currentblock->StartOffset,currentblock->EndOffset-1))
					throw "asked for incomplete block ";
			}
			
			if (!file.Open(fullname,CFile::modeRead|CFile::osSequentialScan|CFile::shareDenyWrite))
					throw "failed to open requested file";
			delete[] fullname;
			fullname = 0;
			file.Seek(currentblock->StartOffset,0);
			
			filedata = new byte[togo+500];
			if (uint32 done = file.Read(filedata,togo) != togo){
				file.SeekToBegin();
				file.Read(filedata + done,togo-done);
			}
			file.Close();
			memcpy(reqfileid,currentblock->FileID,16);
			if (datacompression == 1 && (!strstr(srcfile->GetFileName(),".zip")) && (!strstr(srcfile->GetFileName(),".rar")) && (!strstr(srcfile->GetFileName(),".ace")))
				CreatePackedPackets(filedata,togo,currentblock);
			else
				CreateStandartPackets(filedata,togo,currentblock);
			
			doneblocklist.AddHead(blockreqlist.RemoveHead());
			delete[] filedata;
			filedata = 0;
		}
	}
	catch(char* error){
		theApp.emuledlg->AddLogLine(false,"Client '%s' caused error while creating package (%s) - disconnecting client",GetUserName(),error);
		theApp.uploadqueue->RemoveFromUploadQueue(this);
		if (filedata)
			delete filedata;
		if (fullname)
			delete[] fullname;
		return false;
	}
	//theApp.emuledlg->AddLogLine(false,"Debug: Packet done. Size: %i",blockpack->GetLength());
	return true;
}

void CUpDownClient::CreateStandartPackets(byte* data,uint32 togo, Requested_Block_Struct* currentblock){
	uint32 packetsize;
	CMemFile memfile((BYTE*)data,togo);
	if (togo > 10240) 
		packetsize = togo/(uint32)(togo/10240);
	else
		packetsize = togo;
	while (togo){
		if (togo < packetsize*2)
			packetsize = togo;
		togo -= packetsize;
		Packet* packet = new Packet(OP_SENDINGPART,packetsize+24);
		memcpy(&packet->pBuffer[0],reqfileid,16);
		uint32 statpos = (currentblock->EndOffset - togo) - packetsize;
		memcpy(&packet->pBuffer[16],&statpos,4);
		uint32 endpos = (currentblock->EndOffset - togo);
		memcpy(&packet->pBuffer[20],&endpos,4);
		memfile.Read(&packet->pBuffer[24],packetsize);
		blocksend_queue.AddTail(packet);
	}
}

void CUpDownClient::CreatePackedPackets(byte* data,uint32 togo, Requested_Block_Struct* currentblock){
	BYTE* output = new BYTE[togo+300];
	uLongf newsize;
	uint16 result = compress2(output,&newsize,data,togo,9);
	if (result != Z_OK || togo <= newsize){
		delete[] output;
		CreateStandartPackets(data,togo,currentblock);
		return;
	}
	usedcompressionup = true;
	CMemFile memfile(output,newsize);
	togo = newsize;
	uint32 packetsize;
	if (togo > 10240) 
		packetsize = togo/(uint32)(togo/10240);
	else
		packetsize = togo;
	while (togo){
		if (togo < packetsize*2)
			packetsize = togo;
		togo -= packetsize;
		Packet* packet = new Packet(OP_COMPRESSEDPART,packetsize+24,OP_EMULEPROT);
		memcpy(&packet->pBuffer[0],reqfileid,16);
		uint32 statpos = currentblock->StartOffset;
		memcpy(&packet->pBuffer[16],&statpos,4);
		memcpy(&packet->pBuffer[20],&newsize,4);
		memfile.Read(&packet->pBuffer[24],packetsize);
		blocksend_queue.AddTail(packet);
	}
	delete[] output;
}


void CUpDownClient::AddReqBlock(Requested_Block_Struct* reqblock){

	for (POSITION pos = doneblocklist.GetHeadPosition();pos != 0;doneblocklist.GetNext(pos)){
		if (reqblock->StartOffset == doneblocklist.GetAt(pos)->StartOffset && reqblock->EndOffset == doneblocklist.GetAt(pos)->EndOffset){
			delete reqblock;
			return;
		}
	}
	for (POSITION pos = blockreqlist.GetHeadPosition();pos != 0;blockreqlist.GetNext(pos)){
		if (reqblock->StartOffset == blockreqlist.GetAt(pos)->StartOffset && reqblock->EndOffset == blockreqlist.GetAt(pos)->EndOffset){
			delete reqblock;
			return;
		}
	}
	blockreqlist.AddTail(reqblock);

}

void CUpDownClient::SetUpStartTime(uint32 time){
	if (time)
		upstarttime = time;
	else
		upstarttime = ::GetTickCount();
}

void CUpDownClient::SetWaitStartTime(uint32 time){
	if (time)
		starttime = time;
	else
		starttime = ::GetTickCount();
}

uint32 CUpDownClient::SendBlockData(uint32 maxammount){
	avarage_udr_list.RemoveAt(avarage_udr_list.GetHeadPosition());
	avarage_udr_list.AddTail(dataratems);
	datarate = 0;
	for (POSITION pos = avarage_udr_list.GetHeadPosition();pos != 0;avarage_udr_list.GetNext(pos))
		datarate += avarage_udr_list.GetAt(pos);
	datarate /= (avarage_udr_list.GetCount()/10);
	count++;
	if (count == 30){
		count = 0;
		theApp.emuledlg->transferwnd.uploadlistctrl.RefreshClient(this);
	}
	dataratems = 0;
	
	if (!socket->IsBusy()){
		maxsendallowed += maxammount;
		if (blocksend_queue.IsEmpty()){
			if (!CreateNextBlockPackage())
				return 0;
		}
		while (!blocksend_queue.IsEmpty()
			&& blocksend_queue.GetHead()->size +6 <= maxsendallowed){
			
			Packet* tosend = blocksend_queue.RemoveHead();
			uint32 blocksize = tosend->size +6;
			maxsendallowed -= blocksize;
			socket->SendPacket(tosend,true,false);
			transfered += blocksize;
			dataratems += blocksize;
			if (blocksend_queue.IsEmpty())
				CreateNextBlockPackage();
		}
		return maxammount;
	}
	return 0;
}

void CUpDownClient::SendHashsetPacket(char* forfileid){
	CKnownFile* file = theApp.sharedfiles->GetFileByID((uchar*)forfileid);
	if (!file)
		throw "requested file not found (SendHashsetPacket)";

	CMemFile* data = new CMemFile();
	data->Write(file->GetFileHash(),16);
	uint16 parts = file->GetHashCount();
	data->Write(&parts,2);
	for (int i = 0; i != parts; i++)
		data->Write(file->GetPartHash(i),16);
	Packet* packet = new Packet(data);
	packet->opcode = OP_HASHSETANSWER;
	delete data;
	socket->SendPacket(packet,true,true);
}

void CUpDownClient::ClearUploadBlockRequests(){
	for (POSITION pos = blockreqlist.GetHeadPosition();pos != 0;blockreqlist.GetNext(pos))
		delete blockreqlist.GetAt(pos);
	blockreqlist.RemoveAll();
	
	for (POSITION pos = doneblocklist.GetHeadPosition();pos != 0;doneblocklist.GetNext(pos))
		delete doneblocklist.GetAt(pos);
	doneblocklist.RemoveAll();
	
	for (POSITION pos = blocksend_queue.GetHeadPosition();pos != 0;blocksend_queue.GetNext(pos))
		delete blocksend_queue.GetAt(pos);
	blocksend_queue.RemoveAll();
}

void CUpDownClient::SendRankingInfo(){
	if (!ExtProtocolAvailable())
		return;
	uint16 rank = theApp.uploadqueue->GetWaitingPosition(this);
	if (!rank)
		return;
	Packet* packet = new Packet(OP_QUEUERANKING,12,OP_EMULEPROT);
	memset(packet->pBuffer,0,12);
	memcpy(packet->pBuffer+0,&rank,2);
	socket->SendPacket(packet,true,true);
}