//this file is part of eMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://emule.sf.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


// TransferWnd.cpp : implementation file
//

#include "stdafx.h"
#include "emule.h"
#include "TransferWnd.h"



// CTransferWnd dialog

IMPLEMENT_DYNAMIC(CTransferWnd, CDialog)
CTransferWnd::CTransferWnd(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CTransferWnd::IDD, pParent)
{

}

CTransferWnd::~CTransferWnd()
{
}

BOOL CTransferWnd::OnInitDialog(){
	CResizableDialog::OnInitDialog();
	uploadlistctrl.Init();
	downloadlistctrl.Init();

	ShowSizeGrip(FALSE);
	AddAnchor(IDC_DOWNLOADLIST,TOP_LEFT,CSize(100,50));
	AddAnchor(IDC_TRAFFIC_TEXT2,CSize(0,50));
	AddAnchor(IDC_LIST1,CSize(0,50),BOTTOM_RIGHT);
	AddAnchor(IDC_QUEUECOUNT,BOTTOM_LEFT);
	AddAnchor(IDC_TSTATIC1,BOTTOM_LEFT);
	return true;
}
void CTransferWnd::ShowQueueCount(uint32 number){
	char buffer[100];
	itoa(number,buffer,10);
	this->GetDlgItem(IDC_QUEUECOUNT)->SetWindowText(buffer);
}

void CTransferWnd::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, uploadlistctrl);
	DDX_Control(pDX, IDC_DOWNLOADLIST, downloadlistctrl);
}


BEGIN_MESSAGE_MAP(CTransferWnd, CResizableDialog)
	
END_MESSAGE_MAP()


// CTransferWnd message handlers
